/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.UIArb;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.dialogs.ExceptionDialog;

public class DDLPanel
extends DefaultTraversablePanel
implements ActionListener,
SchemaObjectListener {
    public static final String DDL_GENERATOR = "DDlGenerator";
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIArb.getString((int)545), ".sql");
    private JButton m_btnSave;
    private final JTextArea m_txtSQL = new JTextArea();
    private boolean m_showRadio;
    private ButtonGroup m_btnGrp;
    private JRadioButton m_rdbCreate;
    private JRadioButton m_rdbUpdate;
    private TraversableContext m_data;

    public DDLPanel() {
        this(false);
    }

    public DDLPanel(boolean bl) {
        this.m_showRadio = bl;
        this.setHelpID("f1_odbviddl_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        SchemaObject schemaObject;
        if (this.m_data == null) {
            this.m_data = traversableContext;
            schemaObject = (SchemaObject)traversableContext.get("OriginalObject");
            this.getComponent();
            if (this.m_rdbUpdate != null) {
                if (schemaObject == null) {
                    this.m_rdbUpdate.setEnabled(false);
                    this.m_rdbCreate.setSelected(true);
                } else {
                    this.m_rdbUpdate.setEnabled(true);
                    this.m_rdbUpdate.setSelected(true);
                }
            }
        }
        schemaObject = (SchemaObject)traversableContext.get("NewObject");
        schemaObject.addObjectListener((SchemaObjectListener)this);
        this.updateSQL();
    }

    private void updateSQL() {
        String string = this.getSQL(this.m_data);
        this.m_txtSQL.setText(string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        schemaObject.removeObjectListener((SchemaObjectListener)this);
    }

    public static DDLGenerator getDDLGenerator(TraversableContext traversableContext) {
        DDLGenerator dDLGenerator = (DDLGenerator)traversableContext.get(DDL_GENERATOR);
        if (dDLGenerator == null) {
            DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
            dDLGenerator = ((AbstractDatabase)dBObjectProvider).getDDLGenerator();
        }
        return dDLGenerator;
    }

    protected String getSQL(TraversableContext traversableContext) {
        int n;
        Ddl[] ddlArray;
        Object object;
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        SchemaObject[] schemaObjectArray = (SchemaObject[])traversableContext.get("NewSecondaryDBObjects");
        DDLGenerator dDLGenerator = DDLPanel.getDDLGenerator(traversableContext);
        if (schemaObject2 == null || this.m_rdbCreate != null && this.m_rdbCreate.isSelected()) {
            if (schemaObjectArray != null && schemaObjectArray.length > 0) {
                object = new SchemaObject[schemaObjectArray.length + 1];
                object[0] = schemaObject;
                System.arraycopy(schemaObjectArray, 0, object, 1, schemaObjectArray.length);
                ddlArray = new Ddl[]{dDLGenerator.getCreateDDL((SchemaObject[])object, false, false)};
            } else {
                ddlArray = new Ddl[]{dDLGenerator.getCreateDDL(schemaObject, false, false)};
            }
        } else if (schemaObjectArray != null && schemaObjectArray.length > 0) {
            object = new SchemaObject[schemaObjectArray.length];
            n = 0;
            for (SchemaObject schemaObject3 : schemaObjectArray) {
                try {
                    object[n++] = dBObjectProvider.getObject(schemaObject3.getType(), schemaObject3.getSchema(), schemaObject3.getName());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            SchemaObject[] schemaObjectArray2 = dDLGenerator.getUpdateDDL((SchemaObject[])object, schemaObjectArray);
            Ddl[] ddlArray2 = dDLGenerator.getUpdateDDL(schemaObject2, schemaObject);
            ddlArray = new Ddl[]{new Ddl()};
            for (Ddl ddl : ddlArray2) {
                ddlArray[0].append(ddl);
            }
            for (Ddl ddl : schemaObjectArray2) {
                ddlArray[0].append(ddl);
            }
        } else {
            ddlArray = dDLGenerator.getUpdateDDL(schemaObject2, schemaObject);
        }
        object = new StringBuffer();
        if (ddlArray != null) {
            for (n = 0; n < ddlArray.length; ++n) {
                ((StringBuffer)object).append(ddlArray[n].getDdl());
            }
        }
        return ((StringBuffer)object).toString();
    }

    public Component getComponent() {
        if (this.getComponentCount() == 0) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_txtSQL, (String)UIArb.getString((int)290));
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this.m_btnSave, (String)UIArb.getString((int)557));
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.m_txtSQL);
            int n = 0;
            this.add(jLabel, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_showRadio) {
                this.m_rdbCreate = new JRadioButton();
                this.m_rdbCreate.addActionListener(this);
                ResourceUtils.resButton((AbstractButton)this.m_rdbCreate, (String)UIArb.getString((int)494));
                this.m_rdbUpdate = new JRadioButton();
                this.m_rdbUpdate.addActionListener(this);
                ResourceUtils.resButton((AbstractButton)this.m_rdbUpdate, (String)UIArb.getString((int)742));
                this.m_btnGrp = new ButtonGroup();
                this.m_btnGrp.add(this.m_rdbCreate);
                this.m_btnGrp.add(this.m_rdbUpdate);
                this.add(this.m_rdbCreate, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
                this.add(this.m_rdbUpdate, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            this.add(jScrollPane, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_btnSave, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIArb.getString((int)332), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)iOException, (String)UIArb.getString((int)388), (String)UIArb.getString((int)406), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
        this.updateSQL();
    }
}

