/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.Translate;

public class AgingAttributes
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(AgingAttributes.class.getPackage().getName());

    protected final String GetPurposeTxt() {
        return Translate.translate((String)"aging attributes");
    }

    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private List<Object[]> theRows = new ArrayList<Object[]>(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process " + AgingAttributes.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            Connection connection = AgingAttributes.this._dbObject.getConnection();
            String string = AgingAttributes.this._dbObject.getSchemaName();
            String string2 = AgingAttributes.this._dbObject.getObjectName();
            Statement statement = connection.createStatement();
            String[] stringArray = this.getRootTable(connection, statement, string, string2);
            if (stringArray == null) {
                stringArray = new String[]{string, string2};
            }
            try {
                ResultSet resultSet = statement.executeQuery("select T.SYS25, T.SYS47, T.SYS48, T.SYS49, T.SYS50, RTRIM(C.colname) FROM SYS.TABLES T, SYS.COLUMNS C where T.tblid = C.id AND (T.sys45 = C.colnum or T.sys45 = 0) AND rtrim(T.TBLOWNER) = '" + stringArray[0] + "' AND rtrim(T.TBLNAME) = '" + stringArray[1] + "'");
                boolean bl = resultSet.next();
                if (!bl) {
                    return;
                }
                this.theRows.clear();
                int n = resultSet.getInt(1);
                String string3 = Translate.translate((String)"Type");
                String string4 = Translate.translate((String)"State");
                if ((n & 0x800) != 0) {
                    this.theRows.add(new Object[]{string3, Translate.translate((String)"Usage-based")});
                    this.theRows.add(new Object[]{string4, Translate.translate((String)this.getState(resultSet))});
                    this.handleUsageBased(statement);
                } else if ((n & 0x1000) != 0) {
                    this.theRows.add(new Object[]{string3, Translate.translate((String)"Time-based")});
                    this.theRows.add(new Object[]{string4, Translate.translate((String)this.getState(resultSet))});
                    this.handleTimeBased(statement, resultSet);
                } else {
                    this.theRows.add(new Object[]{string3, Translate.translate((String)"No aging criterion specified")});
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, Translate.translate((String)"Generating ") + AgingAttributes.this.GetPurposeTxt() + Translate.translate((String)" failed"), exception);
                throw exception;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        private void handleUsageBased(Statement statement) throws Exception {
            ResultSet resultSet = statement.executeQuery("CALL ttAgingLRUConfig()");
            if (resultSet.next()) {
                this.theRows.add(new Object[]{Translate.translate((String)"Low usage threshold"), Float.toString(resultSet.getFloat(1))});
                this.theRows.add(new Object[]{Translate.translate((String)"High usage threshold"), Float.toString(resultSet.getFloat(2))});
                this.theRows.add(new Object[]{Translate.translate((String)"Cycle"), Integer.toString(resultSet.getInt(3)) + " minute(s)"});
            }
            resultSet.close();
        }

        private void handleTimeBased(Statement statement, ResultSet resultSet) throws Exception {
            this.theRows.add(new Object[]{Translate.translate((String)"Timestamp column"), resultSet.getString(6)});
            this.theRows.add(new Object[]{Translate.translate((String)"Lifetime"), Integer.toString(resultSet.getInt(2)) + this.dayHourMinute(resultSet.getInt(4))});
            this.theRows.add(new Object[]{Translate.translate((String)"Cycle"), Integer.toString(resultSet.getInt(3)) + this.dayHourMinute(resultSet.getInt(5))});
        }

        private String dayHourMinute(int n) {
            if (n == 0) {
                return " day(s)";
            }
            if (n == 1) {
                return " hour(s)";
            }
            if (n == 2) {
                return " minute(s)";
            }
            return "";
        }

        private String[] getRootTable(Connection connection, Statement statement, String string, String string2) throws Exception {
            ResultSet resultSet = statement.executeQuery("SELECT ROOT FROM SYS.CACHE_GROUP WHERE CGOWNER='" + string + "' AND CGNAME='" + string2 + "'");
            if (!resultSet.next()) {
                return null;
            }
            long l = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                resultSet.close();
                return null;
            }
            resultSet = statement.executeQuery("SELECT TBLOWNER,TBLNAME FROM SYS.TABLES WHERE TBLID = " + l);
            if (!resultSet.next()) {
                return null;
            }
            String[] stringArray = new String[]{resultSet.getString(1).trim(), resultSet.getString(2).trim()};
            resultSet.close();
            return stringArray;
        }

        private String getState(ResultSet resultSet) throws Exception {
            int n = resultSet.getInt(1);
            String string = "";
            if ((n & 0x1800) != 0) {
                string = (n & 0x4000) != 0 ? "on" : "off";
            }
            return string;
        }

        public final int getColumnCount() {
            return 2;
        }

        public final int getRowCount() {
            return this.theRows.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return Translate.translate((String)"Attribute");
            }
            if (n == 1) {
                return Translate.translate((String)"Value");
            }
            return null;
        }
    }
}

