/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.AgingAttributes;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.Translate;

public class CacheDetails
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(AgingAttributes.class.getPackage().getName());

    protected final String GetPurposeTxt() {
        return Translate.translate((String)"cache details");
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        Hashtable<String, String> hash;

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process " + CacheDetails.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            this.hash = this.getCGInfo();
            this.theRows.clear();
            this.handleNameType();
            this.handleAutoRefresh();
            this.handleAutoload();
            this.handleRootTable();
        }

        private final void addRow(String string, String string2) {
            this.theRows.add(new Object[]{Translate.translate((String)string), this.hash.get(string2)});
        }

        private void handleNameType() {
            this.addRow("Cache group name", "CACHE GROUP NAME");
            this.addRow("Cache group type", "CACHE GROUP TYPE");
        }

        private void handleAutoRefresh() {
            this.addRow("AutoRefresh Enabled", "AUTOREFRESH ENABLED");
            if (this.hash.containsKey("AUTOREFRESH MODE")) {
                this.addRow("AutoRefresh Mode", "AUTOREFRESH MODE");
                this.addRow("AutoRefresh State", "AUTOREFRESH STATE");
                this.addRow("AutoRefresh Interval", "AUTOREFRESH INTERVAL");
                this.addRow("AutoRefresh Limit", "AUTOREFRESH LIMIT");
            }
        }

        private void handleAutoload() {
            this.addRow("Autoload on create", "AUTOLOAD ON CREATE ENABLED");
            this.addRow("Autoload on demand", "AUTOLOAD ON DEMAND ENABLED");
        }

        private void handleRootTable() {
            this.addRow("Root table name", "ROOT TABLE NAME");
            this.addRow("Number of tables in cache group", "NUMBER OF TABLES IN CACHE GROUP");
        }

        private Hashtable<String, String> getCGInfo() throws Exception {
            Statement statement = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String string = CacheDetails.this._dbObject.getObjectName();
                Connection connection = CacheDetails.this._dbObject.getConnection();
                String string2 = CacheDetails.this._dbObject.getSchemaName();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT CGOWNER,CGNAME,CGID,ROOT,TBLCNT, REFRESH_MODE, REFRESH_STATE, REFRESH_INTERVAL, CGATTRIBUTES, REFRESH_WITH_LIMIT FROM SYS.CACHE_GROUP WHERE rtrim(CGOWNER) = '" + string2 + "' AND rtrim(CGNAME) = '" + string + "'");
                boolean bl = resultSet.next();
                if (bl) {
                    boolean bl2;
                    hashtable.put("CACHE GROUP NAME", resultSet.getString(1).trim() + '.' + resultSet.getString(2).trim());
                    byte[] byArray = resultSet.getBytes(9);
                    boolean bl3 = (byArray[0] & 1) == 1;
                    boolean bl4 = (byArray[0] & 2) == 2;
                    boolean bl5 = (byArray[0] & 4) == 4;
                    boolean bl6 = (byArray[1] & 1) == 1;
                    boolean bl7 = (byArray[1] & 2) == 2;
                    boolean bl8 = bl2 = (byArray[2] & 1) == 1;
                    String string3 = bl3 ? "READONLY" : (bl4 && !bl2 ? "SYNCHRONOUS WRITETHROUGH" : (bl4 && bl2 ? "ASYNCHRONOUS WRITETHROUGH" : ((byArray[0] & 4) == 4 ? "USER MANAGED" : ((byArray[0] & 8) == 8 ? "USER MANAGED (Restricted)" : ((byArray[0] & 0) == 0 ? "USER MANAGED" : "UNKNOWN")))));
                    hashtable.put("CACHE GROUP TYPE", string3);
                    if (!bl5) {
                        hashtable.put("AUTOREFRESH ENABLED", "No");
                    } else {
                        hashtable.put("AUTOREFRESH ENABLED", "Yes");
                        String string4 = resultSet.getString(6);
                        if (string4.equals("N")) {
                            string3 = "No auto refresh";
                        } else if (string4.equals("I")) {
                            string3 = "Incremental auto refresh";
                        } else if (string4.equals("F")) {
                            string3 = "Full auto refresh";
                        }
                        hashtable.put("AUTOREFRESH MODE", string3);
                        String string5 = resultSet.getString(7);
                        if (string5.equals("N")) {
                            string3 = "Off";
                        } else if (string5.equals("Y")) {
                            string3 = "On";
                        } else if (string5.equals("P")) {
                            string3 = "Paused";
                        }
                        hashtable.put("AUTOREFRESH STATE", string3);
                        hashtable.put("AUTOREFRESH INTERVAL", resultSet.getLong(8) + " ms");
                        hashtable.put("AUTOREFRESH LIMIT", Long.toString(resultSet.getLong(10)));
                    }
                    hashtable.put("AUTOLOAD ON CREATE ENABLED", bl6 ? "Enabled" : "Not enabled");
                    hashtable.put("AUTOLOAD ON DEMAND ENABLED", bl7 ? "Enabled" : "Not enabled");
                    int n = resultSet.getInt(4);
                    short s = resultSet.getShort(5);
                    resultSet.close();
                    resultSet = statement.executeQuery("SELECT TBLOWNER,TBLNAME FROM SYS.TABLES WHERE TBLID=" + n);
                    bl = resultSet.next();
                    if (bl) {
                        hashtable.put("ROOT TABLE NAME", resultSet.getString(1).trim() + "." + resultSet.getString(2).trim());
                    }
                    hashtable.put("NUMBER OF TABLES IN CACHE GROUP", Short.toString(s));
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Generating " + CacheDetails.this.GetPurposeTxt() + " failed", exception);
                throw exception;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
            return hashtable;
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Translate.translate((String)"Attribute");
            }
            if (n == 1) {
                return Translate.translate((String)"Value");
            }
            return null;
        }
    }
}

