/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.Translate;

public class ReplicationSubscriberDetails
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(ReplicationSubscriberDetails.class.getPackage().getName());

    protected final String GetPurposeTxt() {
        return Translate.translate((String)"replication master details");
    }

    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private Vector<Object[]> theRows = new Vector(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process " + ReplicationSubscriberDetails.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                MasterDetails masterDetails;
                Iterator iterator;
                Set set;
                Connection connection = ReplicationSubscriberDetails.this._dbObject.getConnection();
                String string = ReplicationSubscriberDetails.this._dbObject.getSchemaName();
                String string2 = ReplicationSubscriberDetails.this._dbObject.getObjectName();
                statement = connection.createStatement();
                HashMap hashMap = new HashMap(8);
                HashMap<Long, Object> hashMap2 = new HashMap<Long, Object>(32);
                resultSet = statement.executeQuery("select element_type, master_id, is_propagator, is_master_propagator from ttrep.repelements where owned_by_system = 0x00 and rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "'");
                boolean bl = false;
                while (resultSet.next()) {
                    bl = true;
                    set = new MasterDetails();
                    ((MasterDetails)((Object)set))._id = resultSet.getLong(2);
                    iterator = resultSet.getString(1).trim();
                    ((MasterDetails)set)._replicatedObjectType = ReplicatedObjectType.UNDEFINED;
                    if (((String)((Object)iterator)).equalsIgnoreCase("D")) {
                        ((MasterDetails)set)._replicatedObjectType = ReplicatedObjectType.DATASTORE;
                    } else if (((String)((Object)iterator)).equalsIgnoreCase("T")) {
                        ((MasterDetails)set)._replicatedObjectType = ReplicatedObjectType.TABLE;
                    } else if (((String)((Object)iterator)).equalsIgnoreCase("S")) {
                        ((MasterDetails)set)._replicatedObjectType = ReplicatedObjectType.SEQUENCE;
                    }
                    byte[] byArray = resultSet.getBytes(4);
                    byte[] byArray2 = resultSet.getBytes(3);
                    ((MasterDetails)set)._masterType = MasterType.UNDEFINED;
                    if (byArray[0] == 1) {
                        ((MasterDetails)set)._masterType = MasterType.MASTER_PROPAGATOR;
                    } else if (byArray2[0] == 0) {
                        ((MasterDetails)set)._masterType = MasterType.MASTER;
                    } else if (byArray2[0] == 1) {
                        ((MasterDetails)set)._masterType = MasterType.PROPAGATOR;
                    }
                    hashMap.put(((MasterDetails)set)._id, set);
                }
                resultSet.close();
                set = hashMap.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    resultSet = statement.executeQuery("select rtrim(host_name), rtrim(tt_store_name) from ttrep.ttstores where tt_store_id = " + l);
                    bl = resultSet.next();
                    if (!bl) {
                        statement.close();
                        return;
                    }
                    masterDetails = (MasterDetails)hashMap.get(l);
                    masterDetails._hostName = resultSet.getString(1);
                    masterDetails._dataStore = resultSet.getString(2);
                    resultSet.close();
                }
                set = hashMap.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    masterDetails = (MasterDetails)hashMap.get(l);
                    String string3 = masterDetails._replicatedObjectType == ReplicatedObjectType.DATASTORE ? "0x01" : "0x00";
                    resultSet = statement.executeQuery("select rtrim(ds_obj_owner), rtrim(ds_obj_name), durable_transmit, conflict_checks, rtrim(ts_column_name), ts_exception_action, ts_update_rule, report_format, ts_report_file from ttrep.repelements where rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "' and " + " owned_by_system = " + string3 + " and master_id = " + l);
                    object4 = null;
                    while (resultSet.next()) {
                        object4 = new ReplicationElement();
                        ((ReplicationElement)object4).objectOwner = resultSet.getString(1);
                        ((ReplicationElement)object4).objectName = resultSet.getString(2);
                        object3 = resultSet.getBytes(3);
                        if (object3[0] == false) {
                            ((ReplicationElement)object4).transmitDurable = true;
                        } else {
                            ((ReplicationElement)object4).transmitDurable = false;
                        }
                        object2 = resultSet.getBytes(4);
                        if ((object2[7] & 1) == 1) {
                            ((ReplicationElement)object4).conflictCheckFlag = true;
                        } else {
                            ((ReplicationElement)object4).conflictCheckFlag = false;
                        }
                        ((ReplicationElement)object4).timestampColumn = resultSet.getString(5);
                        object = resultSet.getString(6);
                        ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.UNDEFINED;
                        if (((String)object).equalsIgnoreCase("N")) {
                            ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.NO_ACTION;
                        } else if (((String)object).equalsIgnoreCase("R")) {
                            ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.ROLLBACK;
                        }
                        String string4 = resultSet.getString(7);
                        ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.UNDEFINED;
                        if (string4.equalsIgnoreCase("U")) {
                            ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.USER;
                        } else if (string4.equalsIgnoreCase("S")) {
                            ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.SYSTEM;
                        }
                        String string5 = resultSet.getString(8);
                        ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.UNDEFINED;
                        if (string5 == null) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.UNDEFINED;
                        } else if (string5.equalsIgnoreCase("S")) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.STANDARD;
                        } else if (string5.equalsIgnoreCase("X")) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.XML;
                        }
                        ((ReplicationElement)object4).conflictReportFile = resultSet.getString(9);
                        masterDetails._replicatedObjects.add(object4);
                    }
                    resultSet.close();
                }
                resultSet = statement.executeQuery("select host_name, tt_store_name, subscriber_id from ttrep.reppeers p, ttrep.ttstores s where rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "' and s.tt_store_id=p.subscriber_id");
                while (resultSet.next()) {
                    object4 = new SubscriberDetails();
                    ((SubscriberDetails)object4).subscriberId = resultSet.getLong(3);
                    hashMap2.put(((SubscriberDetails)object4).subscriberId, object4);
                    ((SubscriberDetails)object4).hostName = resultSet.getString(1);
                    ((SubscriberDetails)object4).dataStore = resultSet.getString(2);
                }
                resultSet.close();
                object4 = hashMap2.keySet();
                iterator = object4.iterator();
                object3 = null;
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    object3 = (SubscriberDetails)hashMap2.get(l);
                    resultSet = statement.executeQuery("select rtrim(e.element_name), return_service, return_by_request, master_id from ttrep.repsubscriptions b, ttrep.repelements e where b.subscriber_id=" + l + " and e.element_name=b.element_name and e.owned_by_system = 0x00");
                    bl = resultSet.next();
                    if (bl) {
                        ((SubscriberDetails)object3).elementName = resultSet.getString(1);
                        ((SubscriberDetails)object3).masterId = resultSet.getLong(4);
                        object2 = resultSet.getString(2);
                        ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.UNDEFINED;
                        if (((String)object2).equalsIgnoreCase("C")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_COMMIT;
                        } else if (((String)object2).equalsIgnoreCase("R")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_RECEIPT;
                        } else if (((String)object2).equalsIgnoreCase("2")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_TWOSAFE;
                        }
                        object = resultSet.getBytes(3);
                        if (object[0] == 0) {
                            ((SubscriberDetails)object3).returnByRequestFlag = false;
                        } else if (object[0] == 1) {
                            ((SubscriberDetails)object3).returnByRequestFlag = true;
                        }
                    }
                    resultSet.close();
                    ((SubscriberDetails)object3).printDetails();
                    this.theRows.add(new Object[]{"", ""});
                    this.theRows.add(new Object[]{Translate.translate((String)"Master details"), ""});
                    masterDetails = (MasterDetails)hashMap.get(((SubscriberDetails)object3).masterId);
                    masterDetails.printDetails();
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, Translate.translate((String)"Generating ") + ReplicationSubscriberDetails.this.GetPurposeTxt() + Translate.translate((String)" failed"), exception);
                throw exception;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public final int getColumnCount() {
            return 2;
        }

        public final int getRowCount() {
            return this.theRows.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return Translate.translate((String)"Attribute");
            }
            if (n == 1) {
                return Translate.translate((String)"Value");
            }
            return null;
        }

        private class SubscriberDetails {
            private long subscriberId;
            private long masterId;
            private String dataStore;
            private String hostName;
            private String elementName;
            private ReturnServiceType returnServiceType;
            private boolean returnByRequestFlag;

            private SubscriberDetails() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Subscriber datastore"), this.dataStore});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Subscriber hostname"), this.hostName});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Return service type"), this.returnServiceType.getTag()});
                if (this.returnServiceType != ReturnServiceType.UNDEFINED) {
                    MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Return service"), Translate.translate((String)(this.returnByRequestFlag ? "By request only" : "Return service unconditional"))});
                }
            }
        }

        private class ReplicationElement {
            private String objectOwner;
            private String objectName;
            private boolean transmitDurable;
            private boolean conflictCheckFlag;
            private String timestampColumn;
            private ConflictExceptionAction conflictExceptionAction;
            private TimestampUpdateRule tsUpdateOwner;
            private ConflictReportFormat conflictReportFormat;
            private String conflictReportFile;

            private ReplicationElement() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Replicated object"), this.objectOwner + "." + this.objectName});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Transmit type"), Translate.translate((String)(this.transmitDurable ? "DURABLE" : "NON DURABLE"))});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Conflict check enabled"), Translate.translate((String)(this.conflictCheckFlag ? "Yes" : "No"))});
                if (!this.conflictCheckFlag) {
                    return;
                }
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Timestamp column"), this.timestampColumn});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Conflict exception action"), this.conflictExceptionAction.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Timestamp updated by"), this.tsUpdateOwner.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Conflict report format"), this.conflictReportFormat.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Conflict report file"), this.conflictReportFile});
            }
        }

        private class MasterDetails {
            private long _id;
            private ReplicatedObjectType _replicatedObjectType;
            private MasterType _masterType;
            private String _dataStore;
            private String _hostName;
            private List<ReplicationElement> _replicatedObjects = new ArrayList<ReplicationElement>(32);

            private MasterDetails() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Master data store"), this._dataStore});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Host name"), this._hostName});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Master/Propagator"), this._masterType.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Translate.translate((String)"Replicated object type"), this._replicatedObjectType.getTag()});
                for (int i = 0; i < this._replicatedObjects.size(); ++i) {
                    this._replicatedObjects.get(i).printDetails();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReturnServiceType {
        UNDEFINED("No return service"),
        RETURN_COMMIT("RETURN COMMIT"),
        RETURN_RECEIPT("RETURN RECEIPT"),
        RETURN_TWOSAFE("RETURN TWOSAFE");

        private String _tag;

        private ReturnServiceType(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConflictReportFormat {
        UNDEFINED("No report file specified"),
        STANDARD("Standard"),
        XML("XML");

        private String _tag;

        private ConflictReportFormat(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimestampUpdateRule {
        UNDEFINED("Rule not defined"),
        USER("User"),
        SYSTEM("System");

        private String _tag;

        private TimestampUpdateRule(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConflictExceptionAction {
        UNDEFINED("Action not defined"),
        NO_ACTION("No action"),
        ROLLBACK("Roll back");

        private String _tag;

        private ConflictExceptionAction(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MasterType {
        UNDEFINED("UNDEFINED"),
        MASTER("MASTER"),
        PROPAGATOR("PROPAGATOR"),
        MASTER_PROPAGATOR("MASTER_PROPAGATOR");

        private String _tag;

        private MasterType(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReplicatedObjectType {
        UNDEFINED("UNDEFINED"),
        DATASTORE("DATASTORE"),
        TABLE("TABLE"),
        SEQUENCE("SEQUENCE");

        private String _tag;

        protected String getTag() {
            return this._tag;
        }

        private ReplicatedObjectType(String string2) {
            this._tag = string2;
        }
    }
}

