/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.table.DDLViewer;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.commands.TTSchema;
import oracle.dbtools.raptor.utils.Connections;

public class TTSchemaSQLTab
extends DDLViewer {
    private static Logger theLogger = Logger.getLogger(TTSchemaSQLTab.class.getPackage().getName());

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            try {
                String string = this._dbObject.getConnection().getMetaData().getURL().toString();
                String string2 = string.substring(string.indexOf("DSN=") + 4);
                if (string2.indexOf(";") > 0) {
                    string2 = string2.substring(0, string2.indexOf(";"));
                }
                boolean bl2 = string.indexOf(":client:") != -1;
                TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
                String string3 = this._dbObject.getConnectionName();
                Connections connections = Connections.getInstance();
                Properties properties = connections.getConnectionInfo(string3);
                String string4 = properties.getProperty("user");
                String string5 = properties.getProperty("password");
                String string6 = this.getCurrentUserName();
                if (tTInstanceInformation.accessControlEnabled() && tTInstanceInformation.isInstanceAdministrator(string6)) {
                    string4 = null;
                    string5 = null;
                }
                if (string4 != null) {
                    string2 = string2 + ";UID=" + string4;
                }
                StringBuffer stringBuffer = new StringBuffer(string2);
                boolean bl3 = false;
                if (!bl2 && tTInstanceInformation.accessControlEnabled()) {
                    if (string4 != null && string6.equals(string4)) {
                        string5 = null;
                    } else {
                        bl3 = true;
                    }
                }
                String string7 = TTSchema.getDDL(stringBuffer.toString(), this._dbObject.getSchemaName(), this._dbObject.getObjectName(), bl2, bl3, string5);
                this.getCodeArea().setEditable(true);
                this.getCodeArea().setText(string7);
                this.getCodeArea().setEditable(false);
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    private String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
            theLogger.info("Current user name " + string);
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot get login name", exception);
        }
        return string;
    }
}

