/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.editors.TimesTenViewerContextMenu;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

abstract class TTTableViewer
extends ViewerEditor {
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private static final Logger __logger = Logger.getLogger(TTTableViewer.class.getPackage().getName());
    protected JTable _table;

    TTTableViewer() {
    }

    protected abstract String GetPurposeTxt();

    protected void createTable() {
        this._table = new JTable();
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(true);
        this.postCreateHook();
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(0);
        TimesTenViewerContextMenu.attachMenu(this._table);
    }

    public void packColumns(int n) {
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            this.packColumn(i, 2);
        }
    }

    public void packColumn(int n, int n2) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this._table.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this._table.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this._table, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            tableCellRenderer = this._table.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent(this._table, this._table.getValueAt(i, n), false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n3 += 2 * n2);
    }

    protected abstract void createTableModel() throws Exception;

    protected JComponent createViewerUI() {
        this.createTable();
        JScrollPane jScrollPane = new JScrollPane(this._table, 22, 32);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)373), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TTTableViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
        return jScrollPane;
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            ProgressRunnable progressRunnable = new ProgressRunnable(){

                protected void doCancel() {
                    __logger.log(Level.INFO, TTTableViewer.this.GetPurposeTxt() + " cancelled");
                    super.doCancel();
                }

                protected Object doWork() throws Exception {
                    TTTableViewer.this.createTableModel();
                    return Boolean.TRUE;
                }

                protected void finish(Object object) {
                }
            };
            IProgressFeedback iProgressFeedback = new IProgressFeedback(){

                public void feedback(String string) {
                    Log.status((String)string);
                }
            };
            progressRunnable.setTitle(Translate.translate((String)"Generating ") + this.GetPurposeTxt() + "...");
            progressRunnable.setCancelable(true);
            try {
                progressRunnable.start(true);
            }
            catch (ProgressException progressException) {
                // empty catch block
            }
            this._lastdbObject = this._dbObject;
        }
    }

    public Object getPrintable() {
        return this._table;
    }

    protected void cleanUp() {
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }
}

