/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;

public class TableIndexViewer
extends TTTableViewer {
    private MyTableModel _model;
    protected static Logger _logger = Logger.getLogger(TableIndexViewer.class.getPackage().getName());

    protected final String GetPurposeTxt() {
        return Translate.translate((String)"index details");
    }

    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theIndexInfoColumnNames;
        private int theNoColumnsInIndexInfo;
        private String[] theTableColumNames;

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                int n;
                int n2;
                int n3;
                String string = null;
                String string2 = null;
                String string3 = TableIndexViewer.this._dbObject.getSchemaName();
                String string4 = TableIndexViewer.this._dbObject.getObjectName();
                String string5 = TableIndexViewer.this._dbObject.getObjectType();
                this.theRows.clear();
                Connection connection = TableIndexViewer.this._dbObject.getConnection();
                statement = connection.createStatement();
                if (string5.equalsIgnoreCase("TABLE") || string5.equalsIgnoreCase("MATERIALIZED VIEW")) {
                    resultSet = statement.executeQuery("SELECT tblid, numcols from sys.tables where rtrim(tblname) ='" + string4 + "' and rtrim(tblowner) = '" + string3 + "'");
                    resultSet.next();
                    n3 = resultSet.getInt(1);
                    n2 = resultSet.getInt(2);
                    resultSet.close();
                    string = " where tblid = " + n3;
                    string2 = "select rtrim(IXOWNER) \"Index Owner\", rtrim(IXNAME) \"Index Name\", IXTYPE \"Index Type\", ISUNIQUE Uniqueness, ISPRIMARY \"Primary\", KEYCNT \"Column Count\", KEYCOLS Columns, PAGESPARAM Pages, NLSSORTSTR from sys.indexes " + string + " order by ixname, ixtype, isprimary asc";
                } else if (string5.equalsIgnoreCase("INDEX")) {
                    resultSet = statement.executeQuery("SELECT t.tblid, i.tblid, numcols, ixid from sys.tables t, sys.indexes i where rtrim(ixname) ='" + string4 + "' and rtrim(ixowner) = '" + string3 + "' and t.tblid = i.tblid");
                    resultSet.next();
                    n3 = resultSet.getInt(1);
                    int n4 = resultSet.getInt(4);
                    n2 = resultSet.getInt(3);
                    resultSet.close();
                    string = " where t.tblid = " + n3 + " and ixid = " + n4;
                    string2 = "select rtrim(TBLOWNER) \"Table Owner\", rtrim(TBLNAME) \"Table Name\", IXTYPE \"Index Type\", ISUNIQUE Uniqueness, ISPRIMARY \"Primary\", KEYCNT \"Column Count\", KEYCOLS Columns, PAGESPARAM Pages, NLSSORTSTR from sys.tables t, sys.indexes i " + string + " order by ixname, ixtype, isprimary asc";
                } else {
                    _logger.log(Level.WARNING, "Index information not supported for " + string4);
                    return;
                }
                this.theTableColumNames = new String[n2];
                resultSet = statement.executeQuery("SELECT colnum, rtrim(COLNAME) from SYS.COLUMNS where ID= " + n3);
                while (resultSet.next()) {
                    this.theTableColumNames[resultSet.getInt((int)1) - 1] = resultSet.getString(2);
                }
                resultSet.close();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.theNoColumnsInIndexInfo = resultSetMetaData.getColumnCount();
                this.theIndexInfoColumnNames = new String[this.theNoColumnsInIndexInfo];
                for (n = 1; n <= this.theNoColumnsInIndexInfo; ++n) {
                    this.theIndexInfoColumnNames[n - 1] = resultSetMetaData.getColumnName(n);
                }
                n = 0;
                while (resultSet.next()) {
                    Object[] objectArray = new Object[this.theNoColumnsInIndexInfo];
                    int n5 = 0;
                    block24: for (int i = 1; i <= this.theNoColumnsInIndexInfo; ++i) {
                        switch (i) {
                            case 1: 
                            case 2: {
                                objectArray[i - 1] = resultSet.getString(i);
                                continue block24;
                            }
                            case 3: {
                                if (resultSet.getInt(i) == 0) {
                                    objectArray[i - 1] = "Hash";
                                    continue block24;
                                }
                                if (resultSet.getInt(i) == 1) {
                                    objectArray[i - 1] = "T-tree";
                                    continue block24;
                                }
                                objectArray[i - 1] = "Unknown";
                                continue block24;
                            }
                            case 4: {
                                byte[] byArray = resultSet.getBytes(i);
                                if (byArray[0] == 0) {
                                    objectArray[i - 1] = "Non-unique";
                                    continue block24;
                                }
                                objectArray[i - 1] = "Unique";
                                continue block24;
                            }
                            case 5: {
                                byte[] byArray = resultSet.getBytes(i);
                                if (byArray[0] == 0) {
                                    objectArray[i - 1] = "No";
                                    continue block24;
                                }
                                objectArray[i - 1] = "Yes";
                                continue block24;
                            }
                            case 6: {
                                n5 = resultSet.getInt(i);
                                objectArray[i - 1] = Integer.toString(n5);
                                continue block24;
                            }
                            case 7: {
                                byte[] byArray = resultSet.getBytes(i);
                                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                                byteBuffer.order(ByteOrder.nativeOrder());
                                StringBuffer stringBuffer = new StringBuffer(128);
                                for (int j = 0; j < n5 - 1; ++j) {
                                    stringBuffer.append(this.theTableColumNames[byteBuffer.getShort() - 1]);
                                    stringBuffer.append(",");
                                }
                                stringBuffer.append(this.theTableColumNames[byteBuffer.getShort() - 1]);
                                objectArray[i - 1] = stringBuffer;
                                continue block24;
                            }
                            case 8: 
                            case 9: {
                                objectArray[i - 1] = resultSet.getObject(i);
                            }
                        }
                    }
                    this.theRows.add(objectArray);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        public final int getColumnCount() {
            return this.theIndexInfoColumnNames.length;
        }

        public final int getRowCount() {
            return this.theRows.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumnsInIndexInfo) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        public final String getColumnName(int n) {
            return this.theIndexInfoColumnNames[n];
        }
    }
}

