/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.format;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;

public abstract class GenericResultsFormatter
extends ResultsFormatter {
    private ResultSet theResultSet;
    private boolean theInterruptFlag;
    private int theMaxRowsAllowed = -1;
    private String theConnectionName;
    private boolean isOracle = false;
    private boolean isTimesTen = false;

    public GenericResultsFormatter(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setEncode("UTF-8");
    }

    public void interrupt() {
        super.interrupt();
        this.theInterruptFlag = true;
    }

    protected Object getValue(Object object) {
        if (this.isOracle) {
            return super.getValue(object);
        }
        String string = null;
        if (object instanceof Timestamp) {
            string = GenericResultsFormatter.convertToOracleTimestamp((Timestamp)object, true);
        } else if (object instanceof Date) {
            string = GenericResultsFormatter.convertToOracleDate((Date)object);
        } else if (object instanceof byte[]) {
            string = GenericResultsFormatter.convertBinaryField((byte[])object);
        } else {
            return super.getValue(object);
        }
        return string;
    }

    public static String convertToOracleDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        long l = date.getTime();
        calendar.clear();
        calendar.setTimeInMillis(l);
        StringBuffer stringBuffer = new StringBuffer(128);
        if (calendar.get(0) == 0) {
            stringBuffer.append("-");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(calendar.getTime());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String convertToOracleTimestamp(Timestamp timestamp, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        long l = timestamp.getTime();
        int n = timestamp.getNanos();
        calendar.clear();
        calendar.setTimeInMillis(l);
        calendar.set(14, n / 1000000);
        StringBuffer stringBuffer = new StringBuffer(128);
        if (calendar.get(0) == 0) {
            stringBuffer.append("-");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:");
        String string = simpleDateFormat.format(calendar.getTime());
        stringBuffer.append(string);
        int n2 = calendar.get(13);
        if (bl) {
            double d = (double)n2 * 1.0 + (double)n / 1.0E9;
            DecimalFormat decimalFormat = new DecimalFormat("00.#########");
            stringBuffer.append(decimalFormat.format(d));
        } else {
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isTimesTen() {
        return this.isTimesTen;
    }

    private static String convertBinaryField(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{");
        stringBuffer.append(BuiltInProcedure.toHexString(byArray));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

