/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;
import oracle.dbtools.raptor.timesten.format.GenericResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimesTenLoaderFormatter
extends GenericResultsFormatter {
    public TimesTenLoaderFormatter() {
        super("TTBULKCP", Translate.translate((String)"Loader File"), "dump");
        this.setEncode("UTF-8");
    }

    public void setTableName(String string) {
    }

    public void start() throws IOException {
        if (this.isTimesTen()) {
            this.write("##ttBulkCp:FSEP=,:QUOTES=1" + this.getLineTerminator());
            this.write("##ttBulkCp:CHARACTERSET=AL32UTF8" + this.getLineTerminator());
        } else if (this.isOracle()) {
            this.write("##ttBulkCp:FSEP=,:QUOTES=1:TSFORMAT=Oracle" + this.getLineTerminator());
            this.write("##ttBulkCp:CHARACTERSET=AL32UTF8" + this.getLineTerminator());
        }
        this.write("# Generated at : " + new Timestamp(System.currentTimeMillis()).toString() + this.getLineTerminator());
        this.printColumnData();
    }

    public void startRow() throws IOException {
    }

    public void printColumnWithDoubleQuotes(Object object, int n, int n2) throws IOException {
        String string = "";
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            string = "\"" + this.cleanString(this.getValue(object).toString()) + "\"";
        } else if (object != null || n != 1) {
            if (object != null && n > 1) {
                string = ",\"" + this.cleanString(this.getValue(object).toString()) + "\"";
            } else if (object == null && n > 1) {
                string = ",";
            }
        }
        this.write(string);
    }

    public void printColumnWithoutQuotes(Object object, int n, int n2) throws IOException {
        String string = "";
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            string = this.getValue(object).toString();
        } else if (object != null || n != 1) {
            if (object != null && n > 1) {
                string = "," + this.getValue(object).toString();
            } else if (object == null && n > 1) {
                string = ",";
            }
        }
        this.write(string);
    }

    public void printBinaryColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            string = "{" + this.cleanString(this.getValue(object).toString()) + "}";
        } else if (object != null || n != 1) {
            if (object != null && n > 1) {
                string = ",{" + this.cleanString(this.getValue(object).toString()) + "}";
            } else if (object == null && n > 1) {
                string = ",";
            }
        }
        this.write(string);
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        switch (this.getDataType(n)) {
            case -1: 
            case 1: 
            case 12: {
                this.printColumnWithDoubleQuotes(object, n, n2);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.printBinaryColumn(object, n, n2);
                return;
            }
        }
        this.printColumnWithoutQuotes(object, n, n2);
    }

    public String cleanString(String string) {
        return string.replaceAll("\"", "\\\\\"");
    }

    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    protected void printColumnData() throws IOException {
        List<String> list = this.getColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) continue;
            this.write("# " + i + ". " + list.get(i) + " " + this.getLineTerminator());
        }
    }

    private List<String> getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getColumnName(i));
        }
        return arrayList;
    }

    public void end() throws IOException {
    }

    private String getBinaryValue(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{");
        stringBuffer.append(BuiltInProcedure.toHexString(byArray));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setEncode(String string) {
        super.setEncode("UTF-8");
    }

    public void setOutputStream(OutputStream outputStream) {
        this.setEncode("UTF-8");
        super.setOutputStream(outputStream);
    }

    public void setOutWriter(OutputStreamWriter outputStreamWriter) {
    }
}

