/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.snippet.Resources;
import oracle.dbtools.raptor.snippet.SaxHandler;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetPanel;
import oracle.dbtools.raptor.snippet.SnippetWindow;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetAddin
implements DockableFactory,
Addin {
    static final String VIEW_TYPE = "SNIPPET_VIEW_TYPE";
    private SnippetWindow _snippetWindow;
    private HashMap<String, HashMap<String, List<Snippet>>> _languages;
    private File _snippetFile;
    private final ArrayList<ChangeListener> _changeListeners = new ArrayList();
    private int _viewSnippetActionId;
    private HashMap<String, Long> _modifed = new HashMap();
    private SAXParser parser;
    private long _lastFileChanged;
    private boolean _reloadBase = true;
    private boolean _loadingInProgress = false;
    private static ArrayList<URL> _registeredSnippets = new ArrayList();
    public static final String encoding = "UTF-8";

    public static synchronized void registerSnippet(URL uRL) {
        _registeredSnippets.add(uRL);
    }

    public void initialize() {
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory(VIEW_TYPE, (DockableFactory)this);
        }
        catch (Exception exception) {
            System.err.print("Snippet Dockable failed");
            exception.printStackTrace();
        }
        try {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new EditorL());
        }
        catch (Exception exception) {
            System.err.print("Snippet Editor Listener failed");
            exception.printStackTrace();
        }
        try {
            this.createActions();
        }
        catch (Exception exception) {
            System.err.print("Snippet Actions failed");
            exception.printStackTrace();
        }
    }

    private void createActions() {
        this._viewSnippetActionId = Ide.findOrCreateCmdID((String)"ViewSnippet");
        String string = Resources.getString(1);
        IdeAction ideAction = IdeAction.get((int)this._viewSnippetActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ArrayResourceBundle)Resources.getInstance(), (int)2, null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.increment((float)MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE));
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"), MenuConstants.SECTION_VIEW_PALETTE);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(1);
            DockStation dockStation = DockStation.getDockStation();
            SnippetWindow snippetWindow = this.getSnippetWindow();
            dockStation.dock((Dockable)snippetWindow, dockingParam);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getSnippetWindow();
    }

    private SnippetWindow getSnippetWindow() {
        if (this._snippetWindow == null) {
            this._snippetWindow = new SnippetWindow();
        }
        return this._snippetWindow;
    }

    public long lastFileLoad() {
        return this._lastFileChanged;
    }

    public String[] getCategories(String string) {
        this.load();
        HashMap<String, List<Snippet>> hashMap = this._languages.get(string);
        Set<String> set = hashMap != null ? hashMap.keySet() : Collections.EMPTY_SET;
        return set.toArray(new String[set.size()]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    void load(File file, boolean bl) {
        if (bl || this._modifed.get(file.getAbsolutePath()) == null || file.lastModified() != this._modifed.get(file.getAbsolutePath()).longValue()) {
            this._lastFileChanged = System.currentTimeMillis();
            this._modifed.put(file.getAbsolutePath(), file.lastModified());
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encoding);
                this.load(inputStreamReader);
                this._reloadBase = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Reader reader) {
        try {
            if (this.parser == null) {
                this.parser = new SAXParser();
            }
            SaxHandler saxHandler = new SaxHandler(this._languages);
            this.parser.setValidationMode(0);
            this.parser.setContentHandler((ContentHandler)saxHandler);
            this.parser.setEntityResolver((EntityResolver)saxHandler);
            this.parser.setDTDHandler((DTDHandler)saxHandler);
            this.parser.setErrorHandler((ErrorHandler)saxHandler);
            this.parser.setPreserveWhitespace(false);
            this.parser.parse(reader);
            this._lastFileChanged = System.currentTimeMillis();
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void load() {
        this.load(false);
    }

    public void load(boolean bl) {
        Object object;
        Object object3;
        if (this._languages == null || bl) {
            object3 = new HashMap();
            this._languages = object3;
        }
        if (System.getProperty("raptor.user.snippets") != null) {
            char c = ':';
            if (System.getProperty("os.name").startsWith("Windows")) {
                c = ';';
            }
            String[] object22 = System.getProperty("raptor.user.snippets").split("[" + c + "]");
            object = null;
            for (int i = 0; i < object22.length; ++i) {
                object = new File(object22[i]);
                if (!((File)object).exists()) continue;
                this.load((File)object, bl);
            }
        }
        if (this._reloadBase || bl) {
            try {
                for (URL uRL : _registeredSnippets) {
                    try {
                        object = new FileInputStream(uRL.getFile());
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, encoding);
                        this.load(inputStreamReader);
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                object3 = Resource.getResourceAsStream(this.getClass(), (String)"snippets.xml");
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object3, encoding);
                this.load(inputStreamReader);
                inputStreamReader.close();
                this._reloadBase = false;
            }
            catch (Exception exception) {
                System.err.print("Could not load base snippet file:" + exception.getMessage());
            }
            this.fireChangeEvent();
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListenerArray = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            try {
                changeListener.stateChanged(changeEvent);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public List<Snippet> getSnippets(String string, String string2) {
        HashMap<String, List<Snippet>> hashMap = this._languages.get(string);
        List<Snippet> list = hashMap.get(string2);
        return new ArrayList<Snippet>(list);
    }

    private class EditorL
    implements EditorListener {
        private EditorL() {
        }

        public void editorOpened(Editor editor) {
        }

        public void editorActivated(Editor editor) {
            CodeEditor codeEditor;
            Context context;
            Node node;
            if (editor instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)editor).getContext()).getNode()) instanceof PlSqlNode) {
                SnippetPanel snippetPanel = (SnippetPanel)SnippetAddin.this.getSnippetWindow().getGUI();
                snippetPanel.setLanguage("PLSQL");
            }
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != SnippetAddin.this._viewSnippetActionId) {
                return false;
            }
            DockUtil.smartToggleDockableWindow((DockableView)SnippetAddin.this.getSnippetWindow(), (Context)context);
            return true;
        }
    }
}

