/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.snippet.Resources;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetDialog;
import oracle.dbtools.raptor.snippet.UserSnippetDialog;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.util.Resource;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.ArrayResourceBundle;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetController
implements Controller,
ContextMenuListener {
    public static int SAVE_SNIPPET = Ide.findOrCreateCmdID((String)"save_snippet");
    public static int EDIT_SNIPPETS = Ide.findOrCreateCmdID((String)"edit_snippets");
    public static int ADD_SNIPPET = Ide.findOrCreateCmdID((String)"add_snippet");
    public static File snippetFile = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "UserSnippets.xml");
    private static SnippetController _instance;
    IdeAction saveSnippet;
    IdeAction editSnippets;
    private IdeAction addSnippets;
    private boolean replaceSnippet = false;

    private SnippetController() {
    }

    public static synchronized SnippetController getInstance() {
        if (_instance == null) {
            _instance = new SnippetController();
        }
        return _instance;
    }

    void createAction() {
        this.saveSnippet = IdeAction.get((int)SAVE_SNIPPET, null, (String)"Save Snippet", null, null, null, null, (boolean)true);
        this.saveSnippet.addController((Controller)this);
        this.addSnippets = IdeAction.get((int)ADD_SNIPPET, null, (String)"Add Snippet", (ArrayResourceBundle)Resources.getInstance(), (int)4);
        this.addSnippets.setEnabled(true);
        this.addSnippets.addController((Controller)this);
        this.editSnippets = IdeAction.get((int)EDIT_SNIPPETS, null, (String)"Edit Snippets", null, null, (ResourceBundle)RaptorImage.getInstance(), (String)"edit_code.png", null, (boolean)true);
        this.editSnippets.putValue("SmallIcon", (Object)RaptorImage.getIcon((String)"edit_code.png"));
        this.editSnippets.putValue("ShortDescription", (Object)"Edit User Snippets");
        this.editSnippets.setEnabled(true);
        this.editSnippets.addController((Controller)this);
    }

    public void installToolbar(Toolbar toolbar) {
        if (this.editSnippets == null) {
            this.createAction();
        }
        toolbar.add((ToggleAction)this.addSnippets);
        toolbar.add((ToggleAction)this.editSnippets);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == SAVE_SNIPPET) {
            SqlEditor sqlEditor = (SqlEditor)context.getView();
            String string = sqlEditor.getView().getSQLEditorPane().getSelectedText();
            SnippetDialog.saveSnippet(string, snippetFile);
            SnippetAddin snippetAddin = (SnippetAddin)AddinManager.getAddinManager().getAddin(SnippetAddin.class);
            snippetAddin.load(true);
            return true;
        }
        if (ideAction.getCommandId() == ADD_SNIPPET) {
            SnippetDialog.saveSnippet("", snippetFile);
            SnippetAddin snippetAddin = (SnippetAddin)AddinManager.getAddinManager().getAddin(SnippetAddin.class);
            snippetAddin.load(true);
            return true;
        }
        if (ideAction.getCommandId() == EDIT_SNIPPETS) {
            UserSnippetDialog userSnippetDialog = new UserSnippetDialog();
            userSnippetDialog.show();
            SnippetAddin snippetAddin = (SnippetAddin)AddinManager.getAddinManager().getAddin(SnippetAddin.class);
            snippetAddin.load(true);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        SqlEditor sqlEditor;
        if (this.saveSnippet == null) {
            this.createAction();
        }
        if (contextMenu.getContext().getView() instanceof SqlEditor && (sqlEditor = (SqlEditor)contextMenu.getContext().getView()).getView().getSQLEditorPane().hasSelection()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.saveSnippet));
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void saveSnippet(Snippet snippet, File file, boolean bl) {
        this.saveSnippet(snippet.getCode(), snippet.getName(), snippet.getDescription(), snippet.getCategory(), file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnippet(String string, String string2, String string3, String string4, File file, boolean bl) {
        InputStreamReader inputStreamReader = null;
        try {
            Element element;
            Object object;
            boolean bl2 = false;
            if (file == null) {
                file = snippetFile;
            }
            if (bl) {
                bl2 = file.delete();
            }
            XMLDocument xMLDocument = null;
            NodeFactory nodeFactory = new NodeFactory();
            if (file.exists()) {
                object = new DOMParser();
                object.setPreserveWhitespace(false);
                object.retainCDATASection(true);
                if (bl && !bl2) {
                    xMLDocument = null;
                } else {
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                        object.parse((Reader)inputStreamReader);
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    xMLDocument = object.getDocument();
                    if (xMLDocument != null) {
                        xMLDocument.setEncoding("UTF-8");
                    }
                }
            } else {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (xMLDocument == null || !xMLDocument.hasChildNodes()) {
                xMLDocument = nodeFactory.createDocument();
                xMLDocument.setEncoding("UTF-8");
                xMLDocument.appendChild((Node)nodeFactory.createElement("snippets"));
            }
            object = this.getCategory((Document)xMLDocument, string4);
            NodeList nodeList = object.getChildNodes();
            boolean bl3 = true;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element) || !(element = (Element)nodeList.item(i)).getAttribute("name").equals(string2)) continue;
                bl3 = false;
                if (!this.canReplaceSnippet(element, string, string2, string3, string4)) continue;
                element.setAttribute("description", string3);
                if (element.getFirstChild() == null) continue;
                Node node = element.getFirstChild();
                XMLElement xMLElement = nodeFactory.createElement("code");
                xMLElement.appendChild((Node)nodeFactory.createCDATASection(string));
                element.replaceChild((Node)xMLElement, node);
            }
            if (bl3) {
                XMLElement xMLElement = nodeFactory.createElement("snippet");
                xMLElement.setAttribute("name", string2);
                xMLElement.setAttribute("description", string3);
                element = nodeFactory.createElement("code");
                element.appendChild(xMLDocument.createCDATASection(string));
                xMLElement.appendChild(element);
                object.appendChild((Node)xMLElement);
            }
            SnippetController.writeXmlFile(xMLDocument, file);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean canReplaceSnippet(Element element, String string, String string2, String string3, String string4) {
        PropertyPanel propertyPanel = new PropertyPanel();
        JLabel jLabel = new JLabel(Translate.translate((String)"Existing Snippet"));
        JLabel jLabel2 = new JLabel(Translate.translate((String)"New Snippet"));
        propertyPanel.setLayout((LayoutManager)new BorderLayout());
        SnippetDialog snippetDialog = new SnippetDialog();
        SnippetDialog snippetDialog2 = new SnippetDialog();
        snippetDialog.initDialog();
        snippetDialog2.initDialog();
        PropertyPanel propertyPanel2 = new PropertyPanel();
        propertyPanel2.setLayout((LayoutManager)new BorderLayout());
        PropertyPanel propertyPanel3 = new PropertyPanel();
        propertyPanel3.setLayout((LayoutManager)new BorderLayout());
        propertyPanel2.add((Component)jLabel, (Object)"North");
        propertyPanel2.add((Component)snippetDialog, (Object)"South");
        propertyPanel3.add((Component)jLabel2, (Object)"North");
        propertyPanel3.add((Component)snippetDialog2, (Object)"South");
        String string5 = element.getFirstChild().getTextContent();
        snippetDialog.setName(element.getAttribute("name"));
        snippetDialog2.setName(string2);
        snippetDialog.setTip(element.getAttribute("description"));
        snippetDialog2.setTip(string3);
        snippetDialog.setSnippet(string5);
        snippetDialog2.setSnippet(string);
        snippetDialog2.setCat(string4);
        snippetDialog.setCat(string4);
        propertyPanel.add((Component)propertyPanel2, (Object)"West");
        propertyPanel.add((Component)propertyPanel3, (Object)"East");
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        snippetDialog.setEnabled(false);
        snippetDialog2.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JEWTDialog)actionEvent.getSource()).isCancelled()) {
                    SnippetController.this.replaceSnippet = false;
                } else {
                    SnippetController.this.replaceSnippet = true;
                }
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
            }
        };
        UIUtils.showPanelAsDialog((JPanel)propertyPanel, (String)Translate.translate((String)"A snippet with same name exists. Replace Snippet ?"), (ActionListener)actionListener, (int)10);
        return this.replaceSnippet;
    }

    public static void writeXmlFile(XMLDocument xMLDocument, File file) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            XMLPrintDriver xMLPrintDriver = new XMLPrintDriver((Writer)outputStreamWriter);
            xMLPrintDriver.setFormatPrettyPrint(true);
            xMLDocument.print((PrintDriver)xMLPrintDriver);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Element getCategory(Document document, String string) {
        NodeList nodeList;
        Object object = null;
        if (document.hasChildNodes() && (nodeList = document.getFirstChild().getChildNodes()).getLength() > 0) {
            for (int i = 0; object == null && i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element) || ((Element)nodeList.item(i)).getAttribute("category") == null || !((Element)nodeList.item(i)).getAttribute("category").equals(string)) continue;
                object = (Element)nodeList.item(i);
            }
        }
        if (object == null) {
            nodeList = new NodeFactory();
            XMLElement xMLElement = nodeList.createElement("group");
            xMLElement.setAttribute("category", string);
            xMLElement.setAttribute("language", "PLSQL");
            document.getFirstChild().appendChild((Node)xMLElement);
            object = xMLElement;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Snippet> getSnippets() {
        Vector<Snippet> vector = new Vector<Snippet>();
        BufferedReader bufferedReader = null;
        if (snippetFile.exists()) {
            try {
                DOMParser dOMParser = new DOMParser();
                bufferedReader = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(snippetFile), "UTF8")));
                dOMParser.setPreserveWhitespace(false);
                dOMParser.retainCDATASection(true);
                dOMParser.parse((Reader)bufferedReader);
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getElementsByTagName("snippet");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = ((Element)element.getParentNode()).getAttribute("category");
                    String string2 = element.getAttribute("name");
                    String string3 = element.getAttribute("description");
                    Node node = element.getFirstChild();
                    String string4 = node.getTextContent();
                    vector.add(new Snippet(string2, string4, string3, string));
                }
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return vector;
    }

    public static void saveSnippets(ArrayList<Snippet> arrayList) {
        boolean bl = true;
        if (arrayList.size() == 0) {
            snippetFile.delete();
        }
        for (Snippet snippet : arrayList) {
            SnippetController.getInstance().saveSnippet(snippet, null, bl);
            bl = false;
        }
    }
}

