/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetController;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.AddinManager;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class SnippetDialog
extends JPanel
implements ActionListener {
    private JTextField _nameField;
    private JTextField _tipField;
    private File _xmlFile;
    private String _snippet;
    private JComboBox _catField;
    private BasicEditorPane _snippetEditor;
    private String _name;
    private String _cat;
    private String _tip;
    private boolean _cancel = true;

    public static void saveSnippet(String string, File file) {
        SnippetDialog snippetDialog = new SnippetDialog();
        snippetDialog.initDialog();
        snippetDialog.setXmlFile(file);
        snippetDialog.setSnippet(string);
        HelpSystem.getHelpSystem().registerTopic((JComponent)snippetDialog, "f1_savesnippet_html");
        UIUtils.showPanelAsDialog((JPanel)snippetDialog, (String)"Save Snippet", (ActionListener)snippetDialog);
    }

    public static Snippet editSnippet(Snippet snippet) {
        final SnippetDialog snippetDialog = new SnippetDialog();
        snippetDialog.initDialog();
        snippetDialog.setName(snippet.getName());
        snippetDialog.setCat(snippet.getCategory());
        snippetDialog.setTip(snippet.getDescription());
        snippetDialog.setSnippet(snippet.getCode());
        HelpSystem.getHelpSystem().registerTopic((JComponent)snippetDialog, "f1_savesnippet_html");
        UIUtils.showPanelAsDialog((JPanel)snippetDialog, (String)"Save Snippet", (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    snippetDialog._cancel = false;
                    if (actionEvent.getSource() instanceof JEWTDialog) {
                        ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                    }
                }
            }
        });
        if (snippetDialog.isCanceled()) {
            return null;
        }
        return new Snippet(snippetDialog.getName(), snippetDialog.getSnippet(), snippetDialog.getTip(), snippetDialog.getCat());
    }

    public boolean isCanceled() {
        return this._cancel;
    }

    public void initDialog() {
        this.setLayout(new GridBagLayout());
        Object[] objectArray = ((SnippetAddin)AddinManager.getAddinManager().getAddin(SnippetAddin.class)).getCategories("PLSQL");
        Arrays.sort(objectArray);
        this._catField = new JComboBox<Object>(objectArray);
        this._catField.setEditable(true);
        this.add((Component)new JLabel("Category"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._catField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Name"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._nameField = new JTextField(20);
        this.add((Component)this._nameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("ToolTip"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._tipField = new JTextField(20);
        this.add((Component)this._tipField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Snippet"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this._snippetEditor = EditorFactory.createIdeEditorPane();
        JScrollPane jScrollPane = new JScrollPane((Component)this._snippetEditor, 20, 30);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._snippetEditor.setMinimumSize(new Dimension(100, 100));
        this._snippetEditor.setPreferredSize(this._snippetEditor.getMinimumSize());
        this._snippetEditor.setText("");
        this._snippetEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this._snippetEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
    }

    public void cancel() {
        this._cancel = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SnippetController.getInstance().saveSnippet(this._snippetEditor.getText(), this._nameField.getText(), this._tipField.getText(), this._catField.getModel().getSelectedItem().toString(), this._xmlFile, false);
        ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
    }

    public void setXmlFile(File file) {
        this._xmlFile = file;
    }

    public void setSnippet(String string) {
        this._snippet = string;
        if (this._snippetEditor != null) {
            this._snippetEditor.setText(this._snippet);
        }
    }

    public String getSnippet() {
        if (this._snippetEditor != null) {
            return this._snippetEditor.getText();
        }
        return this._snippet;
    }

    public void setName(String string) {
        this._name = string;
        this._nameField.setText(this._name);
    }

    public String getName() {
        if (this._nameField != null) {
            return this._nameField.getText();
        }
        return this._name;
    }

    public void setCat(String string) {
        this._cat = string;
        this._catField.setSelectedItem(this._cat);
    }

    public String getCat() {
        if (this._catField != null) {
            return (String)this._catField.getSelectedItem();
        }
        return this._cat;
    }

    public void setTip(String string) {
        this._tip = string;
        this._tipField.setText(this._tip);
    }

    public String getTip() {
        if (this._tipField != null) {
            return this._tipField.getText();
        }
        return this._tip;
    }

    public static void main(String[] stringArray) {
        SnippetDialog snippetDialog = new SnippetDialog();
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 1; ++j) {
                SnippetController.getInstance().saveSnippet("select '<&xx>z" + i + "." + j + "' num from dual", i + "." + j, "Tip:" + i + "." + j, "Custom" + i, new File("C:\\test.xml"), false);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this._nameField.setEnabled(bl);
        this._tipField.setEnabled(bl);
        this._catField.setEnabled(bl);
        this._snippetEditor.setEnabled(bl);
    }
}

