/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.snippet.InsertSnippetCommand;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetRenderer;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;

public class SnippetPanel
extends JPanel
implements DragGestureListener,
DragSourceListener,
ItemListener,
ChangeListener,
MouseListener,
KeyListener {
    private JComboBox _categories;
    private JList _snippets;
    private DefaultListModel _snippetListModel;
    private DragSource _dragSource;
    private DefaultComboBoxModel _categoryModel;
    private String _language = "PLSQL";
    private long _lastFileProcessed = 0L;
    private Toolbar _toolbar;

    public SnippetPanel() {
        super(new GridBagLayout());
        SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
        snippetAddin.addChangeListener(this);
        this._categoryModel = new DefaultComboBoxModel();
        this._categories = new JComboBox(this._categoryModel);
        this._categories.addItemListener(this);
        this._snippetListModel = new DefaultListModel();
        this._snippets = new JList(this._snippetListModel);
        this._snippets.setSelectionMode(0);
        this._snippets.setCellRenderer(new SnippetRenderer());
        this._snippets.addMouseListener(this);
        this._snippets.addKeyListener(this);
        this._dragSource = new DragSource();
        this._dragSource.createDefaultDragGestureRecognizer(this._snippets, 1, this);
        JScrollPane jScrollPane = new JScrollPane(this._snippets);
        this._toolbar = new Toolbar();
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._categories, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fillCategories();
        if (this._categoryModel.getSize() > 0) {
            this._categories.setSelectedIndex(0);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_dbsnippets_html");
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void fillCategories() {
        SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
        Object[] objectArray = snippetAddin.getCategories(this._language);
        if (this._lastFileProcessed < snippetAddin.lastFileLoad()) {
            this._categoryModel.removeAllElements();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this._categoryModel.addElement(object);
            }
            this._lastFileProcessed = snippetAddin.lastFileLoad();
        }
    }

    private static SnippetAddin getSnippetAddin() {
        AddinManager addinManager = AddinManager.getAddinManager();
        SnippetAddin snippetAddin = (SnippetAddin)addinManager.getAddin(SnippetAddin.class);
        return snippetAddin;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Snippet snippet = (Snippet)this._snippets.getSelectedValue();
        String string = snippet.getCode();
        StringSelection stringSelection = new StringSelection(string);
        this._dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this._categories.equals(object)) {
            this.whenCategoryChanged();
        }
    }

    private void whenCategoryChanged() {
        this._snippetListModel.removeAllElements();
        String string = (String)this._categories.getSelectedItem();
        if (string != null) {
            SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
            List<Snippet> list = snippetAddin.getSnippets(this._language, string);
            for (int i = 0; i < list.size(); ++i) {
                Snippet snippet = list.get(i);
                this._snippetListModel.addElement(snippet);
            }
        }
    }

    public void setLanguage(String string) {
        this._language = string;
        this.fillCategories();
    }

    private void insertSelectedSnippet() {
        CodeEditor codeEditor;
        Context context;
        Node node;
        EditorManager editorManager;
        Editor editor;
        Snippet snippet = (Snippet)this._snippets.getSelectedValue();
        if (snippet != null && (editor = (editorManager = EditorManager.getEditorManager()).getCurrentEditor()) instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)editor).getContext()).getNode()) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            int n = codeEditor.getCaretPosition();
            InsertSnippetCommand insertSnippetCommand = new InsertSnippetCommand(context, textNode, n, snippet.getCode());
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                commandProcessor.invoke((Command)insertSnippetCommand);
                editorManager.openEditor(new OpenEditorOptions(context));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SnippetAddin snippetAddin;
        Object object = changeEvent.getSource();
        if (object == (snippetAddin = SnippetPanel.getSnippetAddin())) {
            String string = String.valueOf(this._categories.getSelectedItem());
            Snippet snippet = (Snippet)this._snippets.getSelectedValue();
            this.fillCategories();
            this._categories.setSelectedItem(string);
            if (snippet != null) {
                String string2 = snippet.getName();
                int n = this._snippetListModel.getSize();
                for (int i = 0; i < n; ++i) {
                    Snippet snippet2 = (Snippet)this._snippetListModel.getElementAt(i);
                    if (!string2.equals(snippet2.getName())) continue;
                    this._snippets.setSelectedValue(snippet2, true);
                    break;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.insertSelectedSnippet();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.insertSelectedSnippet();
        }
    }
}

