/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import oracle.security.misc.BadPaddingException;
import oracle.security.misc.CipherSpi;
import oracle.security.misc.IllegalBlockSizeException;
import oracle.security.misc.NoSuchPaddingException;
import oracle.security.misc.ShortBufferException;

abstract class BlockCipher
extends CipherSpi {
    protected int _blockLen = 8;
    protected byte[] _myIV;
    protected boolean _needIV = true;
    protected Random _rand;
    protected AlgorithmParameterSpec _params;
    private int _opm;
    private int _mode = 0;
    private int _padding = 1;
    private byte[] _remainBuffer;
    private int _remainLen;
    private byte[] _previous;
    private byte[] _chainBlock;
    private static final int MODE_CBC = 0;
    private static final int MODE_ECB = 1;
    private static final int MODE_CFB = 2;
    private static final int PADDING_NONE = 0;
    private static final int PADDING_ZEROES = 1;
    private static final int PADDING_PKCS5 = 2;
    private static final int PADDING_ORACLE = 3;

    protected abstract void cipherInit(Key var1, AlgorithmParameterSpec var2, boolean var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void cipherInit(Key var1, AlgorithmParameters var2, boolean var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract String cipherName();

    protected abstract void encryptBlk(byte[] var1, byte[] var2);

    protected abstract void decryptBlk(byte[] var1, byte[] var2);

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string.equals("CBC")) {
            this._mode = 0;
            this._needIV = true;
        } else if (string.equals("ECB")) {
            this._mode = 1;
            this._needIV = false;
        } else if (string.equals("CFB")) {
            this._mode = 2;
            this._needIV = true;
        } else {
            throw new NoSuchAlgorithmException("Mode " + string + " is unsupported");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equals("PKCS5Padding")) {
            this._padding = 2;
        } else if (string.equals("NoPadding")) {
            this._padding = 0;
        } else if (string.equals("ZeroesPadding")) {
            this._padding = 1;
        } else if (string.equals("Zeroes")) {
            this._padding = 1;
        } else if (string.equals("OraclePadding")) {
            this._padding = 3;
        } else {
            throw new NoSuchPaddingException("Padding " + string + " is unsupported");
        }
    }

    protected int engineGetBlockSize() {
        return this._blockLen;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = n + this._remainLen;
        if (this._opm == 1) {
            n2 += this._blockLen - n2 % this._blockLen;
            if (this._padding == 3) {
                ++n2;
            }
        }
        return n2;
    }

    protected byte[] engineGetIV() {
        if (this._myIV == null) {
            return null;
        }
        byte[] byArray = new byte[this._myIV.length];
        System.arraycopy(this._myIV, 0, byArray, 0, this._myIV.length);
        return byArray;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this._params == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.cipherName());
            algorithmParameters.init(this._params);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new InternalError("Unsupport AlgorithmParameters");
        }
    }

    protected void engineInit(int n, Key key, Random random) throws InvalidKeyException {
        try {
            this._params = null;
            this.engineInit(n, key, this._params, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Algorithm Parameter needed for this cipher");
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.bcinit(n, random, algorithmParameterSpec == null);
        this.cipherInit(key, algorithmParameterSpec, this._mode == 2 ? true : this._opm == 1);
        this.reset();
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.bcinit(n, random, algorithmParameters == null);
        this.cipherInit(key, algorithmParameters, this._mode == 2 ? true : this._opm == 1);
        this.reset();
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineUpdate(byArray, n, n2, byArray3, 0);
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace();
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4;
        if (n2 == 0 || byArray == null || byArray2 == null) {
            return 0;
        }
        if (n2 + n > byArray.length || n3 > byArray2.length) {
            throw new ShortBufferException("Invalid input from the parameters");
        }
        if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
            throw new ShortBufferException("Output buffer is too short for this operation");
        }
        if (n2 > this._blockLen && this.checkDoubleEncryption(byArray, n, n2)) {
            throw new ShortBufferException("Illegal operation - double encryption detected");
        }
        int n5 = n2 + this._remainLen;
        int n6 = this._blockLen;
        if (this._opm == 2 && this._padding != 0 && this._padding != 3) {
            ++n6;
        }
        if (n5 < n6) {
            System.arraycopy(byArray, n, this._remainBuffer, this._remainLen, n2);
            this._remainLen += n2;
            return 0;
        }
        byte[] byArray3 = new byte[n5];
        System.arraycopy(this._remainBuffer, 0, byArray3, 0, this._remainLen);
        System.arraycopy(byArray, n, byArray3, this._remainLen, n2);
        for (n4 = 0; n4 <= n5 - this._blockLen; n4 += this._blockLen) {
            byte[] byArray4 = new byte[this._blockLen];
            System.arraycopy(byArray3, n4, byArray4, 0, this._blockLen);
            this._remainLen = 0;
            if (this._opm == 1) {
                this.encryptBlock(byArray4, this._mode, byArray2, n3 + n4);
                continue;
            }
            if (this._padding != 0 && this._padding != 3 && n2 == n4 + this._blockLen) {
                System.arraycopy(byArray3, n4, this._remainBuffer, 0, this._blockLen);
                this._remainLen = this._blockLen;
                return n4;
            }
            this.decryptBlock(byArray4, this._mode, byArray2, n3 + n4);
        }
        this._previous = new byte[n4];
        System.arraycopy(byArray2, n3, this._previous, 0, n4);
        this._remainLen = n5 % this._blockLen;
        if (this._remainLen > 0) {
            System.arraycopy(byArray3, n4, this._remainBuffer, 0, this._remainLen);
        }
        return n4;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (n2 > 0 && (n > byArray.length || n + n2 > byArray.length || n3 > byArray2.length)) {
            throw new ShortBufferException("Invalid input from the parameters");
        }
        if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
            throw new ShortBufferException("Output buffer is too short for this operation");
        }
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        if (this._padding == 0 && this._remainLen > 0 && this._opm == 1) {
            throw new IllegalBlockSizeException("Padding not required but the buffer still remains");
        }
        if (this._remainLen == 0 && (this._padding == 1 || this._padding == 0 || this._padding == 3)) {
            if (this._padding == 3 && this._opm == 1) {
                byArray2[n4++] = 1;
            }
            this.reset();
            return n4;
        }
        if (this._opm == 1) {
            int n5 = this.doPadding(this._remainBuffer);
            this.encryptBlock(this._remainBuffer, this._mode, byArray2, n3 + n4);
            if (this._padding == 3) {
                byArray2[n4++ + this._blockLen] = (byte)(n5 + 1);
            }
            this.reset();
            return n4 + this._blockLen;
        }
        if (this._padding == 3) {
            if (this._remainLen != 1) {
                throw new IllegalBlockSizeException("Decrypted data length is not 1+ multiple of 8");
            }
            byte by = this._remainBuffer[0];
            this.reset();
            return n4 + 1 - by;
        }
        if (this._remainLen != 0 && this._remainLen != this._blockLen) {
            throw new BadPaddingException("Decrypted data length is not multiple of 8");
        }
        if (this._remainLen == 0) {
            return n4;
        }
        this.decryptBlock(this._remainBuffer, this._mode, byArray2, n3 + n4);
        if ((n4 += this._blockLen) > 0) {
            int n6 = this.doUnPadding(byArray2, n3 + n4);
            this.reset();
            return n4 - n6;
        }
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineDoFinal(byArray, n, n2, byArray3, 0);
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalBlockSizeException(shortBufferException.toString());
        }
        return byArray2;
    }

    private void bcinit(int n, Random random, boolean bl) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2) {
            throw new InvalidKeyException("operation is not supported");
        }
        this._opm = n;
        this._rand = random;
        if (this._needIV) {
            if (bl && n == 2) {
                throw new InvalidAlgorithmParameterException("Parameters is required for this mode");
            }
            if (random == null) {
                try {
                    this._rand = new Random();
                }
                catch (Exception exception) {
                    throw new InternalError("Cannot find Random");
                }
            }
        }
    }

    private void reset() {
        this._remainBuffer = new byte[this._blockLen];
        this._remainLen = 0;
        if (this._needIV) {
            this._chainBlock = new byte[this._blockLen];
            if (this._myIV == null) {
                throw new InternalError("IV is required but not initialized");
            }
            System.arraycopy(this._myIV, 0, this._chainBlock, 0, this._blockLen);
        }
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[this._blockLen];
        switch (n) {
            case 0: {
                this.byteXOR(byArray, this._chainBlock, byArray, 0);
                this.encryptBlk(byArray, this._chainBlock);
                break;
            }
            case 2: {
                this.encryptBlk(this._chainBlock, byArray3);
                this.byteXOR(byArray, byArray3, this._chainBlock, 0);
                break;
            }
            default: {
                this.encryptBlk(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this._blockLen);
                return;
            }
        }
        System.arraycopy(this._chainBlock, 0, byArray2, n2, this._blockLen);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[this._blockLen];
        switch (n) {
            case 0: {
                this.decryptBlk(byArray, byArray3);
                this.byteXOR(this._chainBlock, byArray3, byArray2, n2);
                System.arraycopy(byArray, 0, this._chainBlock, 0, this._blockLen);
                break;
            }
            case 1: {
                this.decryptBlk(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this._blockLen);
                break;
            }
            case 2: {
                this.encryptBlk(this._chainBlock, byArray3);
                this.byteXOR(byArray, byArray3, byArray2, n2);
                System.arraycopy(byArray, 0, this._chainBlock, 0, this._blockLen);
                break;
            }
            default: {
                this.decryptBlk(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this._blockLen);
            }
        }
    }

    private void byteXOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        for (int i = 0; i < this._blockLen; ++i) {
            byArray3[i + n] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private int doPadding(byte[] byArray) {
        int n = 0;
        switch (this._padding) {
            case 0: {
                break;
            }
            case 2: {
                n = this._blockLen - this._remainLen;
                for (int i = 0; i < n; ++i) {
                    byArray[this._remainLen + i] = (byte)n;
                }
                break;
            }
            default: {
                n = this._remainLen == 0 ? 0 : this._blockLen - this._remainLen;
                for (int i = 0; i < n; ++i) {
                    byArray[this._remainLen + i] = 0;
                }
            }
        }
        return n;
    }

    private int doUnPadding(byte[] byArray, int n) throws BadPaddingException {
        int n2 = 0;
        switch (this._padding) {
            case 0: {
                break;
            }
            case 1: {
                n2 = byArray[n - 1];
                if (n2 != 0) {
                    return 0;
                }
                while (n > 0 && byArray[--n] == 0) {
                    ++n2;
                }
                if (n2 < this._blockLen) break;
                throw new BadPaddingException("Invalid padding pattern");
            }
            case 2: {
                n2 = byArray[n - 1];
                if (n2 < 1 || n2 > this._blockLen) {
                    throw new BadPaddingException("Invalid padding - pad exceeds blocksize");
                }
                n -= n2;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[n + i] == n2) continue;
                    throw new BadPaddingException("Invalid pattern in PKCS5Padding");
                }
                break;
            }
            default: {
                throw new BadPaddingException("Unsupported padding mode");
            }
        }
        return n2;
    }

    private boolean checkDoubleEncryption(byte[] byArray, int n, int n2) {
        if (this._previous == null) {
            return false;
        }
        int n3 = n2 > this._previous.length ? this._previous.length : n2;
        for (int i = 0; i < n3; ++i) {
            if (this._previous[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }
}

