/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import oracle.security.misc.BadPaddingException;
import oracle.security.misc.CipherSpi;
import oracle.security.misc.DES;
import oracle.security.misc.DESede;
import oracle.security.misc.IllegalBlockSizeException;
import oracle.security.misc.NoSuchPaddingException;
import oracle.security.misc.PBEwMD5aDES;
import oracle.security.misc.PBEwSHA1aDESedecbc;
import oracle.security.misc.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int PRIVATE_KEY = 3;
    public static final int PUBLIC_KEY = 4;
    public static final int SECRET_KEY = 5;
    public static final int UNWRAP_MODE = 6;
    public static final int WRAP_MODE = 7;
    private static final String DEFAULT_PROVIDER = "Oracle";
    private final CipherSpi _spi;
    private boolean _init = false;
    private String _algorithm;

    protected Cipher(CipherSpi cipherSpi, String string) {
        this._spi = cipherSpi;
        this._algorithm = string;
    }

    public String toString() {
        return "Cipher object:" + this._algorithm;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public String getProvider() {
        return DEFAULT_PROVIDER;
    }

    public static Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return Cipher.getInstance(string, DEFAULT_PROVIDER);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + string + "]");
        }
    }

    public static Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        CipherSpi cipherSpi = Cipher.getImplementation(string);
        if (cipherSpi != null) {
            return new Cipher(cipherSpi, string);
        }
        throw new NoSuchAlgorithmException("Unknown algorithm");
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        return this._spi.engineUnwrap(byArray, string, n);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        return this._spi.engineWrap(key);
    }

    public final int getBlockSize() {
        return this._spi.engineGetBlockSize();
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (!this._init) {
            throw new IllegalStateException("Object has not been initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Input size must be >= 0");
        }
        return this._spi.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        return this._spi.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this._spi.engineGetParameters();
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this._spi.engineInit(n, key, new Random());
        this._init = true;
    }

    public final void init(int n, Key key, Random random) throws InvalidKeyException {
        this._spi.engineInit(n, key, random);
        this._init = true;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._spi.engineInit(n, key, algorithmParameterSpec, new Random());
        this._init = true;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._spi.engineInit(n, key, algorithmParameterSpec, random);
        this._init = true;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._spi.engineInit(n, key, algorithmParameters, new Random());
        this._init = true;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._spi.engineInit(n, key, algorithmParameters, random);
        this._init = true;
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, new Random());
        this._init = true;
    }

    public final void init(int n, Certificate certificate, Random random) throws InvalidKeyException {
        boolean[] blArray;
        if (certificate instanceof X509Certificate && (blArray = ((X509Certificate)certificate).getKeyUsage()) != null) {
            if (blArray[7] && n == 2) {
                throw new InvalidKeyException("Certificate key usage is encipherOnly");
            }
            if (blArray[8] && n == 1) {
                throw new InvalidKeyException("Certificate key usage is decipherOnly");
            }
        }
        this._spi.engineInit(n, certificate.getPublicKey(), random);
        this._init = true;
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this._init) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this._spi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    private static CipherSpi getImplementation(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        CipherSpi cipherSpi = (CipherSpi)Cipher.getCipherSpi(string);
        if (cipherSpi == null) {
            throw new NoSuchAlgorithmException("Only DES, DESede, PBE are supported");
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(47, n + 1);
        if (n == -1) {
            return cipherSpi;
        }
        if (n2 == -1) {
            throw new NoSuchAlgorithmException(string + "is not supported");
        }
        try {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1);
            cipherSpi.engineSetMode(string3);
            cipherSpi.engineSetPadding(string4);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException("Unknown padding from " + string);
        }
        return cipherSpi;
    }

    private static Object getCipherSpi(String string) {
        if (string.startsWith("PBEwSH") || string.startsWith("hash")) {
            return new PBEwSHA1aDESedecbc();
        }
        if (string.startsWith("PBE")) {
            return new PBEwMD5aDES();
        }
        if (string.startsWith("DESede") || string.startsWith("TripleDES") || string.startsWith("3DES")) {
            return new DESede();
        }
        if (string.startsWith("DES")) {
            return new DES();
        }
        return null;
    }
}

