/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.Key;

public class DESSecretKey
implements Key {
    private static final int DES_40 = 40;
    protected static final int KEYLEN = 8;
    private byte[] _myKey = new byte[8];

    public DESSecretKey(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public DESSecretKey(byte[] byArray, int n) {
        if (byArray.length < 8) {
            throw new InternalError("DESKey must be longer than 8 bytes");
        }
        System.arraycopy(byArray, 0, this._myKey, 0, 8);
    }

    public DESSecretKey(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            throw new InternalError("DES requires key longer than 8 bytes");
        }
        System.arraycopy(byArray, n, this._myKey, 0, 8);
    }

    public String getAlgorithm() {
        return new String("DES");
    }

    public String getFormat() {
        return new String("RAW");
    }

    public byte[] getEncoded() {
        if (this._myKey == null) {
            return null;
        }
        byte[] byArray = new byte[this._myKey.length];
        System.arraycopy(this._myKey, 0, byArray, 0, this._myKey.length);
        return byArray;
    }
}

