/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import oracle.security.misc.DES;
import oracle.security.misc.DESSecretKey;
import oracle.security.misc.IvParameterSpec;

class DESede
extends DES {
    private int[] _keys1;
    private int[] _keys2;
    private int[] _keys3;
    private boolean _is3keyed = true;

    protected String cipherName() {
        return "DESede";
    }

    protected void cipherInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, boolean bl) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this._needIV) {
            if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Invalid parameter. Expecting IvParameterSpec");
            }
            if (algorithmParameterSpec != null) {
                this._params = algorithmParameterSpec;
                this._myIV = ((IvParameterSpec)algorithmParameterSpec).getIV();
            }
            if (algorithmParameterSpec == null || this._myIV == null) {
                this.genIVSpec();
            }
        }
        this.init3Key(key, bl);
    }

    protected void cipherInit(Key key, AlgorithmParameters algorithmParameters, boolean bl) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this._needIV) {
            if (algorithmParameters != null && !algorithmParameters.getAlgorithm().equals("DESede")) {
                throw new InvalidAlgorithmParameterException("Invalid parameter. Expecting DESede AlgorithmParameters");
            }
            if (algorithmParameters != null) {
                try {
                    this._params = algorithmParameters.getParameterSpec(Class.forName("javax.crypto.spec.IvParameterSpec"));
                    this._myIV = ((IvParameterSpec)this._params).getIV();
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException("IvParameterSpec not from the specified parameters");
                }
            }
            if (algorithmParameters == null || this._myIV == null) {
                this.genIVSpec();
            }
        }
        this.init3Key(key, bl);
    }

    protected void encryptBlk(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        this.des_blk(byArray2, this._keys1);
        this.des_blk(byArray2, this._keys2);
        if (this._is3keyed) {
            this.des_blk(byArray2, this._keys3);
        } else {
            this.des_blk(byArray2, this._keys1);
        }
    }

    protected void decryptBlk(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        if (this._is3keyed) {
            this.des_blk(byArray2, this._keys3);
        } else {
            this.des_blk(byArray2, this._keys1);
        }
        this.des_blk(byArray2, this._keys2);
        this.des_blk(byArray2, this._keys1);
    }

    private void genIVSpec() {
        this._myIV = new byte[this._blockLen];
        this._rand.nextBytes(this._myIV);
        this._params = new IvParameterSpec(this._myIV);
    }

    private void init3Key(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray.length < 16) {
            throw new InvalidKeyException("Invalid key length. DESede requires 24 byte key");
        }
        this._is3keyed = byArray.length >= 24;
        int n = 8;
        this._keys1 = this.initKey(new DESSecretKey(byArray, 0, n), bl);
        this._keys2 = this.initKey(new DESSecretKey(byArray, n, n), !bl);
        if (this._is3keyed) {
            this._keys3 = this.initKey(new DESSecretKey(byArray, 2 * n, n), bl);
        }
    }
}

