/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;
import oracle.security.misc.BadPaddingException;
import oracle.security.misc.Cipher;
import oracle.security.misc.CipherSpi;
import oracle.security.misc.DESSecretKey;
import oracle.security.misc.IllegalBlockSizeException;
import oracle.security.misc.IvParameterSpec;
import oracle.security.misc.PBEParameterSpec;
import oracle.security.misc.ShortBufferException;

class PBEwMD5aDES
extends CipherSpi {
    private Cipher _cipher;
    private MessageDigest _hash;
    private AlgorithmParameters _pbeParams;
    private static int KEYLEN = 8;

    PBEwMD5aDES() {
    }

    protected void engineSetMode(String string) {
    }

    protected void engineSetPadding(String string) {
    }

    protected int engineGetBlockSize() {
        return this._cipher.getBlockSize();
    }

    protected int engineGetOutputSize(int n) {
        return this._cipher.getOutputSize(n);
    }

    protected byte[] engineGetIV() {
        return this._cipher.getIV();
    }

    protected AlgorithmParameters engineGetParameters() {
        return this._cipher.getParameters();
    }

    protected void engineInit(int n, Key key, Random random) throws InvalidKeyException {
        throw new InvalidKeyException("AlgorithmParameter is required.");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || !(key instanceof DESSecretKey)) {
            throw new InvalidKeyException("Missing password");
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter is not PBEParameterSpec");
        }
        try {
            byte[] byArray;
            this._hash = MessageDigest.getInstance("MD5");
            this._cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            if (algorithmParameterSpec == null) {
                if (random == null) {
                    random = new Random();
                }
                byArray = new byte[this._cipher.getBlockSize()];
                random.nextBytes(byArray);
                algorithmParameterSpec = new PBEParameterSpec(byArray, 12);
            }
            if (this._pbeParams == null) {
                this._pbeParams = AlgorithmParameters.getInstance("PBE");
                this._pbeParams.init(algorithmParameterSpec);
            }
            byArray = this.generateKey(key, (PBEParameterSpec)algorithmParameterSpec);
            IvParameterSpec ivParameterSpec = this.getIV(byArray);
            DESSecretKey dESSecretKey = this.getKey(byArray);
            this._cipher.init(n, (Key)dESSecretKey, ivParameterSpec, random);
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("cannot initialize PBE");
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null && !algorithmParameters.getAlgorithm().equals("PBE")) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        try {
            this._pbeParams = algorithmParameters;
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (algorithmParameters != null) {
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(Class.forName("javax.crypto.spec.PBEParameterSpec"));
            }
            this.engineInit(n, key, algorithmParameterSpec, random);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("PBEParameterSpec is not found");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this._cipher.update(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this._cipher.update(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this._cipher.doFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this._cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    private byte[] generateKey(Key key, PBEParameterSpec pBEParameterSpec) {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = pBEParameterSpec.getSalt();
        int n = pBEParameterSpec.getIterationCount();
        int n2 = this._hash.getDigestLength();
        n2 = n2 > byArray.length + byArray2.length ? n2 : byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this._hash.reset();
        for (int i = 0; i < n; ++i) {
            byArray3 = this._hash.digest(byArray3);
        }
        return byArray3;
    }

    private DESSecretKey getKey(byte[] byArray) {
        byte[] byArray2 = new byte[KEYLEN];
        System.arraycopy(byArray, 0, byArray2, 0, KEYLEN);
        return new DESSecretKey(byArray2);
    }

    private IvParameterSpec getIV(byte[] byArray) {
        return new IvParameterSpec(byArray, byArray.length - KEYLEN, KEYLEN);
    }
}

