/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.misc;

import java.security.Key;
import java.util.Random;
import oracle.security.misc.Checksum;
import oracle.security.misc.Cipher;
import oracle.security.misc.DESSecretKey;
import oracle.security.misc.IvParameterSpec;
import oracle.security.misc.PBEKey;
import oracle.security.misc.PBEParameterSpec;
import oracle.security.misc.PBEwSHA1aDESedecbc;

public class Ztcs {
    private static final int SALT_LEN = 16;
    private static final int WORST_EXPANSION = 8;
    private static final byte VERSION;
    private static final int COUNT = 5000;
    private static final byte[] DEFAULT_KEY;
    private static final int KEY_LEN = 8;
    private static final IvParameterSpec THE_IV;
    private static boolean libloaded;

    static int ztcsl(int n) {
        return n + 8 + 8 + 1;
    }

    static byte[] ztcsh(byte[] byArray, byte[] byArray2) throws Exception {
        int n;
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        Random random = new Random();
        byte[] byArray3 = new byte[8];
        random.nextBytes(byArray3);
        cipher.init(1, (Key)new DESSecretKey(byArray3), THE_IV, random);
        byte[] byArray4 = cipher.doFinal(byArray);
        byte[] byArray5 = new byte[byArray4.length + byArray3.length + 1];
        int n2 = 0;
        byArray5[n2++] = VERSION;
        for (n = 0; n < byArray3.length; ++n) {
            byArray5[n2++] = byArray3[n];
        }
        for (n = 0; n < byArray4.length; ++n) {
            byArray5[n2++] = byArray4[n];
        }
        return byArray5;
    }

    static byte[] ztcsr(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        int n;
        byte by = byArray[0];
        Random random = new Random();
        if (by == 5) {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 1, byArray4, 0, 8);
            cipher.init(2, (Key)new DESSecretKey(byArray4), THE_IV, random);
            int n2 = 9;
            return cipher.doFinal(byArray, n2, byArray.length - n2);
        }
        if (!libloaded) {
            if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
                System.loadLibrary("orajmisc");
            } else {
                System.loadLibrary("jmisc");
            }
            libloaded = true;
        }
        if (by != 3 && (by != 4 || Checksum.obc() != 1)) {
            throw new Exception("Version mismatch!");
        }
        if (byArray.length < 17) {
            throw new Exception("Message too short!");
        }
        byArray2 = byArray2 == null ? DEFAULT_KEY : Ztcs.stretchKey(byArray2);
        Cipher cipher = Cipher.getInstance("hash");
        byte[] byArray5 = new byte[16];
        for (n = 0; n < 16; ++n) {
            byArray5[n] = byArray[n + 1];
        }
        byte[] byArray6 = new byte[byArray.length - 16 - 1];
        for (n = 0; n < byArray6.length; ++n) {
            byArray6[n] = byArray[17 + n];
        }
        cipher.init(2, (Key)new PBEKey(PBEwSHA1aDESedecbc.hmac(byArray2, Checksum.opd(by, byArray3))), new PBEParameterSpec(byArray5, 5000), random);
        return cipher.doFinal(byArray6);
    }

    private static byte[] stretchKey(byte[] byArray) {
        int n;
        if (byArray.length >= 20) {
            return byArray;
        }
        byte[] byArray2 = new byte[20];
        for (n = 0; n < byArray.length; ++n) {
            byArray2[n] = byArray[n];
        }
        while (n < 20) {
            byArray2[n++] = 90;
        }
        return byArray2;
    }

    static {
        libloaded = false;
        DEFAULT_KEY = new byte[20];
        for (int i = 0; i < 20; ++i) {
            Ztcs.DEFAULT_KEY[i] = 0;
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = 0;
        }
        THE_IV = new IvParameterSpec(byArray);
        VERSION = (byte)5;
    }
}

