/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class VariableLengthIntArrayFactory
extends ObjectFactory {
    public static final VariableLengthIntArrayFactory VARIABLE_LENGTH_INT_ARRAY_FACTORY = new VariableLengthIntArrayFactory();
    private static final byte OBJECT_CODE = -118;

    private VariableLengthIntArrayFactory() {
    }

    public byte getObjectCode() {
        return -118;
    }

    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = VariableLengthIntArrayFactory.readVariableLengthInt(input);
        int[] array = new int[len];
        int i = 0;
        while (i < len) {
            array[i] = VariableLengthIntArrayFactory.readVariableLengthInt(input);
            ++i;
        }
        return array;
    }

    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        int[] array = (int[])object;
        int len = array.length;
        VariableLengthIntArrayFactory.writeVariableLengthInt(output, len);
        int i = 0;
        while (i < len) {
            VariableLengthIntArrayFactory.writeVariableLengthInt(output, array[i]);
            ++i;
        }
    }

    public static final void writeVariableLengthInt(DataOutput output, int value) throws IOException {
        boolean shouldWrite = false;
        int i = 0;
        while (i < 5) {
            byte b = (byte)(0x7F & value >>> 7 * (4 - i));
            if (i != 4) {
                b = (byte)(b | 0xFFFFFF80);
            }
            if (b != -128) {
                shouldWrite = true;
            }
            if (shouldWrite) {
                output.writeByte(b);
            }
            ++i;
        }
    }

    public static final int readVariableLengthInt(DataInput input) throws IOException {
        byte b;
        int result = 0;
        do {
            b = input.readByte();
            result = result << 7 | b & 0x7F;
        } while ((b & 0xFFFFFF80) != 0);
        return result;
    }
}

