/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.border;

import java.awt.Color;
import javax.swing.border.Border;
import oracle.javatools.border.BottomBorder;
import oracle.javatools.border.LeftBorder;
import oracle.javatools.border.LeftRightBorder;
import oracle.javatools.border.RightBorder;
import oracle.javatools.border.TopBorder;
import oracle.javatools.border.TopBottomBorder;

public final class JavatoolsBorderFactory {
    private JavatoolsBorderFactory() {
    }

    public static Border createTopBorder(Color color) {
        return new TopBorder(color, 1);
    }

    public static Border createTopBorder(Color color, int thickness) {
        return new TopBorder(color, thickness);
    }

    public static Border createBottomBorder(Color color) {
        return new BottomBorder(color, 1);
    }

    public static Border createBottomBorder(Color color, int thickness) {
        return new BottomBorder(color, thickness);
    }

    public static Border createTopBottomBorder(Color color) {
        return new TopBottomBorder(color, 1, color, 1);
    }

    public static Border createTopBottomBorder(Color topColor, Color bottomColor) {
        return new TopBottomBorder(topColor, 1, bottomColor, 1);
    }

    public static Border createTopBottomBorder(Color color, int thickness) {
        return new TopBottomBorder(color, thickness, color, thickness);
    }

    public static Border createTopBottomBorder(Color topColor, int topThickness, Color bottomColor, int bottomThickness) {
        return new TopBottomBorder(topColor, topThickness, bottomColor, bottomThickness);
    }

    public static Border createLeftBorder(Color color) {
        return new LeftBorder(color, 1);
    }

    public static Border createLeftBorder(Color color, int thickness) {
        return new LeftBorder(color, thickness);
    }

    public static Border createRightBorder(Color color) {
        return new RightBorder(color, 1);
    }

    public static Border createRightBorder(Color color, int thickness) {
        return new RightBorder(color, thickness);
    }

    public static Border createLeftRightBorder(Color color) {
        return new LeftRightBorder(color, 1, color, 1);
    }

    public static Border createLeftRightBorder(Color leftColor, Color rightColor) {
        return new LeftRightBorder(leftColor, 1, rightColor, 1);
    }

    public static Border createLeftRightBorder(Color color, int thickness) {
        return new LeftRightBorder(color, thickness, color, thickness);
    }

    public static Border createLeftRightBorder(Color leftColor, int leftThickness, Color rightColor, int rightThickness) {
        return new LeftRightBorder(leftColor, leftThickness, rightColor, rightThickness);
    }
}

