/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

abstract class MultiSideBorder
extends AbstractBorder {
    protected final Color topColor;
    protected final int topThickness;
    protected final Color leftColor;
    protected final int leftThickness;
    protected final Color bottomColor;
    protected final int bottomThickness;
    protected final Color rightColor;
    protected final int rightThickness;

    protected abstract void setInsets(Insets var1);

    MultiSideBorder(Color topColor, int topThickness, Color leftColor, int leftThickness, Color bottomColor, int bottomThickness, Color rightColor, int rightThickness) {
        this.topColor = topColor;
        this.topThickness = topThickness;
        this.leftColor = leftColor;
        this.leftThickness = leftThickness;
        this.bottomColor = bottomColor;
        this.bottomThickness = bottomThickness;
        this.rightColor = rightColor;
        this.rightThickness = rightThickness;
    }

    protected void drawTopBorder(Graphics g, int width, int height) {
    }

    protected void drawLeftBorder(Graphics g, int width, int height) {
    }

    protected void drawBottomBorder(Graphics g, int width, int height) {
    }

    protected void drawRightBorder(Graphics g, int width, int height) {
    }

    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(this.topColor);
        this.drawTopBorder(g, width, height);
        g.setColor(this.leftColor);
        this.drawLeftBorder(g, width, height);
        g.setColor(this.bottomColor);
        this.drawBottomBorder(g, width, height);
        g.setColor(this.rightColor);
        this.drawRightBorder(g, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public final Insets getBorderInsets(Component c) {
        return this.getBorderInsets(null, new Insets(0, 0, 0, 0));
    }

    public final Insets getBorderInsets(Component c, Insets insets) {
        this.setInsets(insets);
        return insets;
    }

    public final boolean isBorderOpaque() {
        return true;
    }
}

