/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import oracle.javatools.clipboard.ClipboardStackDialog;
import oracle.javatools.clipboard.StackedTransferable;
import oracle.javatools.util.Pair;

public class ClipboardStack {
    private static final int DEFAULT_MAX_ITEMS = 10;
    private LinkedList _stack = new LinkedList();
    private int _maxItems = 10;
    private static ClipboardStack _ccStack;

    private ClipboardStack() {
    }

    public static ClipboardStack getClipboardStack() {
        if (_ccStack == null) {
            _ccStack = new ClipboardStack();
        }
        return _ccStack;
    }

    private static Transferable getCurrentTransferable() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(StackedTransferable.BUFFER_NAME_FLAVOR)) {
                    Transferable transferable2 = transferable;
                    return transferable2;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Transferable transferable3 = transferable;
                    return transferable3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Transferable addTransferableDescription(Transferable tr, String name, String description) {
        return new StackedTransferable(tr, name, description);
    }

    private void pushObj(Object o) {
        this._stack.addFirst(o);
        while (this._stack.size() > this._maxItems) {
            this._stack.removeLast();
        }
    }

    public static void pushCurrentClipboard() {
        Transferable tsf = ClipboardStack.getCurrentTransferable();
        if (tsf != null) {
            ClipboardStack cstack = ClipboardStack.getClipboardStack();
            cstack.pushObj(tsf);
        }
    }

    public static boolean adjustCurrentClipboard() {
        ClipboardStackDialog dialog = new ClipboardStackDialog();
        Transferable tr = (Transferable)dialog.runDialog();
        if (tr != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (ClipboardStack._ccStack._stack.remove(tr)) {
                ClipboardStack.pushCurrentClipboard();
            }
            clipboard.setContents(tr, null);
            return true;
        }
        return false;
    }

    public static int getSize() {
        return ClipboardStack.getClipboardStack()._stack.size();
    }

    private static void addTransferableToList(Transferable tt, ArrayList li) {
        if (tt != null) {
            try {
                String name = "";
                if (tt.isDataFlavorSupported(StackedTransferable.BUFFER_NAME_FLAVOR)) {
                    name = (String)tt.getTransferData(StackedTransferable.BUFFER_NAME_FLAVOR);
                } else {
                    String value = (String)tt.getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer tokenizer = new StringTokenizer(value, "\n");
                    while (tokenizer.hasMoreTokens()) {
                        String line = tokenizer.nextToken();
                        String trimmedLine = line.trim();
                        if (trimmedLine.length() <= 0) continue;
                        name = trimmedLine;
                        break;
                    }
                }
                li.add(new Pair<String, Transferable>(name, tt));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Object[] getContent() {
        ArrayList li = new ArrayList();
        LinkedList ct = ClipboardStack.getClipboardStack()._stack;
        ClipboardStack.addTransferableToList(ClipboardStack.getCurrentTransferable(), li);
        for (Transferable tt : ct) {
            ClipboardStack.addTransferableToList(tt, li);
        }
        Pair[] res = new Pair[li.size()];
        return li.toArray(res);
    }
}

