/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.codeex;

import java.io.ByteArrayOutputStream;

public class Base64 {
    private static char[] sCharLookup = new char[64];
    private static byte[] sByteLookup = new byte[127];

    static {
        int i = 0;
        int c = 65;
        while (c <= 90) {
            Base64.sCharLookup[i] = c;
            i = (byte)(i + 1);
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            Base64.sCharLookup[i] = c;
            i = (byte)(i + 1);
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            Base64.sCharLookup[i] = c;
            i = (byte)(i + 1);
            c = (char)(c + 1);
        }
        Base64.sCharLookup[i] = 43;
        i = (byte)(i + 1);
        Base64.sCharLookup[i] = 47;
        Base64.sByteLookup[47] = i;
        Base64.sByteLookup[61] = -1;
    }

    public static String base64Encode(byte[] bytes) {
        int i = 0;
        int bytesToWrite = bytes.length;
        StringBuffer buff = new StringBuffer(bytes.length * 4 / 3);
        while (bytesToWrite >= 3) {
            buff.append(sCharLookup[bytes[i] >>> 2 & 0x3F]);
            buff.append(sCharLookup[((bytes[i] & 3) << 4) + (bytes[i + 1] >>> 4 & 0xF)]);
            buff.append(sCharLookup[((bytes[i + 1] & 0xF) << 2) + (bytes[i + 2] >>> 6 & 3)]);
            buff.append(sCharLookup[bytes[i + 2] & 0x3F]);
            bytesToWrite -= 3;
            i += 3;
        }
        switch (bytesToWrite) {
            case 2: {
                buff.append(sCharLookup[bytes[i] >>> 2 & 0x3F]);
                buff.append(sCharLookup[((bytes[i] & 3) << 4) + (bytes[i + 1] >>> 4 & 0xF)]);
                buff.append(sCharLookup[(bytes[i + 1] & 0xF) << 2]);
                buff.append('=');
                break;
            }
            case 1: {
                buff.append(sCharLookup[bytes[i] >> 2 & 0x3F]);
                buff.append(sCharLookup[(bytes[i] & 3) << 4]);
                buff.append('=');
                buff.append('=');
            }
        }
        return buff.toString();
    }

    public static byte[] base64Decode(String string) {
        int charsToWrite;
        string = Base64.globalReplace(string, "\n", "");
        string = Base64.globalReplace(string, "\r", "");
        char[] chars = string.toCharArray();
        int i = 0;
        ByteArrayOutputStream buff = new ByteArrayOutputStream(chars.length);
        byte[] b = new byte[4];
        for (charsToWrite = chars.length; charsToWrite >= 4; charsToWrite -= 4) {
            try {
                b[0] = sByteLookup[chars[i++]];
                if (b[0] == -1 || (b[1] = sByteLookup[chars[i++]]) == -1) {
                    throw new IllegalArgumentException(string);
                }
                buff.write(b[0] << 2 | b[1] >>> 4);
                b[2] = sByteLookup[chars[i++]];
                if (b[2] == -1) {
                    charsToWrite -= 4;
                    break;
                }
                buff.write(b[1] << 4 | b[2] >>> 2);
                b[3] = sByteLookup[chars[i++]];
                if (b[3] == -1) {
                    charsToWrite -= 4;
                    break;
                }
                buff.write(b[2] << 6 | b[3]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                throw new IllegalArgumentException(string);
            }
        }
        if (charsToWrite > 0) {
            throw new IllegalArgumentException(string);
        }
        return buff.toByteArray();
    }

    private static final String globalReplace(String orig, String search, String replace) {
        int searchLen = search.length();
        if (searchLen == 0) {
            return orig;
        }
        int nextPos = orig.indexOf(search);
        if (nextPos == -1) {
            return orig;
        }
        int origLen = orig.length();
        int startPos = 0;
        StringBuffer result = new StringBuffer(origLen + 100);
        do {
            if (nextPos > startPos) {
                result.append(orig.substring(startPos, nextPos));
            }
            result.append(replace);
        } while ((startPos = nextPos + searchLen) < origLen && (nextPos = orig.indexOf(search, startPos)) != -1);
        if (startPos < origLen) {
            result.append(orig.substring(startPos));
        }
        return result.toString();
    }
}

