/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Container;
import java.util.ArrayList;
import oracle.javatools.columnlayout.LayoutComponent;

public class LayoutRow
implements LayoutComponent {
    private int m_totalRows;
    private int m_totalColumns;
    private ArrayList m_columns;

    private void $init$() {
        this.m_totalRows = 0;
        this.m_totalColumns = 0;
        this.m_columns = new ArrayList();
    }

    public void addToPanel(Container container, int baseRow, int baseColumn, boolean[] rowConstraints, boolean[] columnConstraints, int rowSpan) {
        int columnCount = this.m_columns.size();
        int i = 0;
        while (i < columnCount) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.addToPanel(container, baseRow, baseColumn, rowConstraints, columnConstraints, rowSpan);
            baseColumn += lc.getColumnCount();
            ++i;
        }
    }

    public void areRowsResizable(boolean[] rowConstraints, int baseRow, int rowSpan) {
        int i = this.m_columns.size() - 1;
        while (i >= 0) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.areRowsResizable(rowConstraints, baseRow, rowSpan);
            --i;
        }
    }

    public void areColumnsResizable(boolean[] columnConstraints, int baseColumn) {
        baseColumn += this.m_totalColumns;
        int i = this.m_columns.size() - 1;
        while (i >= 0) {
            LayoutComponent lc = (LayoutComponent)this.m_columns.get(i);
            lc.areColumnsResizable(columnConstraints, baseColumn -= lc.getColumnCount());
            --i;
        }
    }

    public int getRowCount() {
        return this.m_totalRows;
    }

    public int getColumnCount() {
        return this.m_totalColumns;
    }

    public void add(LayoutComponent lc) {
        if (lc == null) {
            throw new IllegalArgumentException("Layout component was null");
        }
        this.m_columns.add(lc);
        int newRows = lc.getRowCount();
        if (newRows > this.m_totalRows) {
            this.m_totalRows = newRows;
        }
        this.m_totalColumns += lc.getColumnCount();
    }

    public LayoutRow() {
        this.$init$();
    }
}

