/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.compare.view.wedge.WedgeCompareView;

public final class CompareViewFactory {
    private static final Map<CompareType, Class> _views = new HashMap<CompareType, Class>();

    private CompareViewFactory() {
    }

    static {
        CompareViewFactory.registerCompareView(CompareType.TEXT, WedgeCompareView.class);
        CompareViewFactory.registerCompareView(CompareType.DIRECTORY, ListCompareView.class);
    }

    public static final void registerCompareViewType(Class modelType, Class compareViewType) {
    }

    public static final void registerCompareView(CompareType type, Class viewClass) {
        _views.put(type, viewClass);
    }

    public static CompareView createCompareView(CompareModel model) {
        return CompareViewFactory.createView(model, CompareMode.TWO_WAY_COMPARE, _views.get(model.getType()));
    }

    public static CompareView createCompareView(CompareModel model, CompareViewBias bias) {
        return CompareViewFactory.createView(model, CompareMode.TWO_WAY_COMPARE, bias, _views.get(model.getType()));
    }

    public static CompareView createMergeView(CompareModel model) {
        return CompareViewFactory.createView(model, CompareMode.THREE_WAY_MERGE, _views.get(model.getType()));
    }

    public static CompareView createView(CompareModel model, CompareMode mode, Class viewClass) {
        return CompareViewFactory.createView(model, mode, CompareViewBias.RIGHT, viewClass);
    }

    private static CompareView createView(CompareModel model, CompareMode mode, CompareViewBias bias, Class viewClass) {
        if (mode == CompareMode.THREE_WAY_MERGE && model.getContributor(ContributorKind.ANCESTOR) == null) {
            throw new IllegalArgumentException("merge view requires ancestor contributor kind");
        }
        CompareView compareView = null;
        if (viewClass != null) {
            try {
                compareView = (CompareView)viewClass.getConstructor(CompareMode.class, CompareViewBias.class).newInstance(mode, bias);
            }
            catch (NoSuchMethodException nsme) {
                if (bias != CompareViewBias.RIGHT) {
                    throw new IllegalArgumentException("CompareViewBias.LEFT not supported by view type: " + viewClass.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (viewClass != null && compareView == null) {
            try {
                compareView = (CompareView)viewClass.getConstructor(CompareMode.class).newInstance(mode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (compareView != null) {
            compareView.setModel(model);
            return compareView;
        }
        throw new IllegalArgumentException("cannot create compare view with " + model + " and " + mode);
    }
}

