/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.UIManager;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.resource.CompareResource;

public class ColorConstants {
    public static final Color COLOR_CHANGED = new Color(206, 206, 255);
    public static final Color COLOR_REMOVED = new Color(255, 206, 206);
    public static final Color COLOR_ADDED = new Color(206, 255, 206);
    public static final Color COLOR_INLINE_CHANGED = new Color(255, 255, 255);
    public static final Color COLOR_INLINE_REMOVED = new Color(255, 156, 156);
    public static final Color COLOR_INLINE_ADDED = new Color(156, 255, 156);
    public static final Color COLOR_CONFLICT = new Color(255, 206, 206);
    public static final Color COLOR_RESOLVED = new Color(206, 255, 206);
    public static final Color COLOR_UNCHOSEN = new Color(206, 206, 206);
    public static final Color COLOR_ABSENT = new Color(232, 232, 232);
    public static final Color COLOR_REMOVED_PALE = new Color(255, 235, 235);
    public static final Color COLOR_ADDED_PALE = new Color(235, 255, 235);
    public static final Color COLOR_CHANGED_PALE = new Color(235, 235, 255);
    public static final Color COLOR_CONFLICT_PALE = new Color(255, 235, 235);
    public static final Color COLOR_SEPARATOR = Color.black;
    public static final Color COLOR_ADDED_CHARACTER_SEPARATOR = Color.GREEN;
    public static final Color COLOR_REMOVED_CHARACTER_SEPARATOR = Color.RED;
    private static final int PRIORITY = 20;
    private static final int INLINE_PRIORITY = 105;
    private static final int PALE_PRIORITY = 50;
    public static final String ADDITION_STYLE = "inline-compare-addition";
    public static final String DELETION_STYLE = "inline-compare-deletion";
    public static final String CHANGE_STYLE = "inline-compare-update";
    public static final String CHARACTER_ADDITION_STYLE = "inline-character-compare-addition";
    public static final String CHARACTER_DELETION_STYLE = "inline-character-compare-deletion";
    public static final String CHARACTER_CHANGE_STYLE = "inline-character-compare-update";
    public static final String CONFLICT_STYLE = "inline-compare-conflict";
    public static final String RESOLVED_STYLE = "inline-compare-resolved";
    public static final String UNCHOSEN_STYLE = "inline-compare-unchosen";
    public static final String BLOCK_SEPARATOR_STYLE = "inline-block-highlight-style";
    public static final String SELECTED_BLOCK_SEPARATOR_STYLE = "inline-selected-block-highlight-style";
    public static final String CHARACTER_ADD_SEPARATOR_STYLE = "inline-character-add-highlight-style";
    public static final String CHARACTER_DELETE_SEPARATOR_STYLE = "inline-character-delete_highlight-style";

    static {
        ColorConstants.registerHighlights();
    }

    public static void registerHighlights() {
        HighlightStyle unchosenStyle;
        HighlightStyle resolvedStyle;
        HighlightStyle conflictStyle;
        HighlightStyle updateInlineStyle;
        HighlightStyle deletionInlineStyle;
        HighlightStyle additionInlineStyle;
        HighlightStyle updateStyle;
        HighlightStyle deletionStyle;
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle additionStyle = highlightRegistry.lookupStyle(ADDITION_STYLE);
        if (additionStyle == null) {
            highlightRegistry.createStyle(ADDITION_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_ADDED"), 20, Color.BLACK, COLOR_ADDED);
        }
        if ((deletionStyle = highlightRegistry.lookupStyle(DELETION_STYLE)) == null) {
            highlightRegistry.createStyle(DELETION_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_DELETED"), 20, Color.BLACK, COLOR_REMOVED);
        }
        if ((updateStyle = highlightRegistry.lookupStyle(CHANGE_STYLE)) == null) {
            highlightRegistry.createStyle(CHANGE_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_CHANGED"), 20, Color.BLACK, COLOR_CHANGED);
        }
        if ((additionInlineStyle = highlightRegistry.lookupStyle(CHARACTER_ADDITION_STYLE)) == null) {
            highlightRegistry.createStyle(CHARACTER_ADDITION_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_CHARACTER_ADDED"), 105, Color.BLACK, COLOR_INLINE_ADDED);
        }
        if ((deletionInlineStyle = highlightRegistry.lookupStyle(CHARACTER_DELETION_STYLE)) == null) {
            highlightRegistry.createStyle(CHARACTER_DELETION_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_CHARACTER_DELETED"), 105, Color.BLACK, COLOR_INLINE_REMOVED);
        }
        if ((updateInlineStyle = highlightRegistry.lookupStyle(CHARACTER_CHANGE_STYLE)) == null) {
            highlightRegistry.createStyle(CHARACTER_CHANGE_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_CHARACTER_CHANGED"), 105, Color.BLACK, COLOR_INLINE_CHANGED);
        }
        if ((conflictStyle = highlightRegistry.lookupStyle(CONFLICT_STYLE)) == null) {
            highlightRegistry.createStyle(CONFLICT_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_CONFLICT"), 20, Color.BLACK, COLOR_CONFLICT);
        }
        if ((resolvedStyle = highlightRegistry.lookupStyle(RESOLVED_STYLE)) == null) {
            highlightRegistry.createStyle(RESOLVED_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_MERGED"), 20, Color.BLACK, COLOR_RESOLVED);
        }
        if ((unchosenStyle = highlightRegistry.lookupStyle(UNCHOSEN_STYLE)) == null) {
            highlightRegistry.createStyle(UNCHOSEN_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_UNCHOSEN"), 20, Color.BLACK, COLOR_UNCHOSEN);
        }
        highlightRegistry.createStyle(BLOCK_SEPARATOR_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_BLOCK_SEPARATOR_UNSELECTED"), true, 50, 9, UIManager.getColor("controlShadow"));
        highlightRegistry.createStyle(SELECTED_BLOCK_SEPARATOR_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_BLOCK_SEPARATOR"), true, 20, 5, COLOR_SEPARATOR);
        highlightRegistry.createStyle(CHARACTER_ADD_SEPARATOR_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_ADDED_MARKER"), true, 20, 0, COLOR_ADDED_CHARACTER_SEPARATOR);
        highlightRegistry.modifyStyleUnderline(CHARACTER_ADD_SEPARATOR_STYLE, new CharacterSeparatorPainter(null), COLOR_ADDED_CHARACTER_SEPARATOR);
        highlightRegistry.createStyle(CHARACTER_DELETE_SEPARATOR_STYLE, CompareResource.getBundle().getString("HIGHLIGHT_DELETION_MARKER"), true, 20, 0, COLOR_REMOVED_CHARACTER_SEPARATOR);
        highlightRegistry.modifyStyleUnderline(CHARACTER_DELETE_SEPARATOR_STYLE, new CharacterSeparatorPainter(null), COLOR_REMOVED_CHARACTER_SEPARATOR);
    }

    private static class CharacterSeparatorPainter
    implements UnderlinePainter {
        private static int separatorWidth = 4;

        public void paintUnderline(Graphics graphics, Color color, int xPos, int width, int yTop, int yBaseline, int descent) {
            graphics.setColor(color);
            Graphics2D g2 = (Graphics2D)graphics;
            Composite composite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            graphics.fillRect((xPos -= separatorWidth) - 1 + width / 2, yTop, separatorWidth, yBaseline - yTop + descent);
            g2.setComposite(composite);
        }

        public int getUnderlineType() {
            return 0;
        }

        private CharacterSeparatorPainter() {
        }

        CharacterSeparatorPainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

