/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.BaseCompareView;

public abstract class DiffGutter
extends JComponent {
    protected final ContributorKind _leftContributorKind;
    protected final ContributorKind _rightContributorKind;
    protected final BaseCompareView _baseCompareView;

    protected DiffGutter(BaseCompareView baseCompareView, ContributorKind leftContributor, ContributorKind rightContributor) {
        this._leftContributorKind = leftContributor;
        this._rightContributorKind = rightContributor;
        this._baseCompareView = baseCompareView;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private ContributorKind getLeftContributor() {
        return this._leftContributorKind;
    }

    private ContributorKind getRightContributor() {
        return this._rightContributorKind;
    }

    protected abstract ContributorKind getContributorAtPoint(Point var1);

    protected abstract CompareDifference getBlockAtPoint(Point var1);

    public String getToolTipText(MouseEvent event) {
        ContributorKind adjacentContributor;
        ContributorKind contributor;
        Action defaultAction;
        CompareDifference block = this.getBlockAtPoint(event.getPoint());
        if (block != null && (defaultAction = this._baseCompareView.getDefaultEditAction(block, contributor = this.getContributorAtPoint(event.getPoint()), adjacentContributor = this.getOtherContributorKind(contributor))) != null) {
            String name = (String)defaultAction.getValue("Name");
            return "<html><p>Click to " + name + "<br>Right click for other editing options</p></html>";
        }
        return null;
    }

    public ContributorKind getOtherContributorKind(ContributorKind whichContributor) {
        return whichContributor == this._leftContributorKind ? this._rightContributorKind : this._leftContributorKind;
    }
}

