/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SplitPanelLayout
implements LayoutManager {
    public static final String LEFT_OVERVIEW = "leftOverview";
    public static final String LEFT_GUTTER = "leftGutter";
    public static final String LEFT_TITLE = "leftTitle";
    public static final String LEFT_EDITOR = "leftEditor";
    public static final String LEFT_SPLIT_TOP = "leftSplitTop";
    public static final String LEFT_SPLIT = "leftSplit";
    public static final String CENTER_GUTTER = "centerGutter";
    public static final String CENTER_TITLE = "centerTitle";
    public static final String CENTER_EDITOR = "centerEditor";
    public static final String CENTER_SPLIT_TOP = "centerSplitTop";
    public static final String CENTER_SPLIT = "centerSplit";
    public static final String RIGHT_TITLE = "rightTitle";
    public static final String RIGHT_EDITOR = "rightEditor";
    public static final String RIGHT_GUTTER = "rightGutter";
    public static final String RIGHT_SCROLLBAR = "rightScrollbar";
    public static final String RIGHT_OVERVIEW = "rightOverview";
    public static final String SPLITTER_LOCATION_PROPERTY = "lastSplitterLocation";
    private static final Dimension DIM_ZERO = new Dimension(0, 0);
    private final Map _componentMap;
    private float _leftEditorWeight;
    private float _centerEditorWeight;
    private float _rightEditorWeight;
    private int _rightGutterAlignment;
    private boolean _isThreePaneMode;

    private void $init$() {
        this._componentMap = new HashMap();
        this._rightGutterAlignment = 4;
    }

    public SplitPanelLayout() {
        this.$init$();
        this.setThreePaneMode(false);
    }

    void resetSplitters() {
        this.setThreePaneMode(this.isThreePaneMode());
    }

    boolean isThreePaneMode() {
        return this._isThreePaneMode;
    }

    public void setRightGutterAlignment(int alignment) {
        if (alignment != 2 && alignment != 4) {
            throw new IllegalArgumentException("setRightGutterAlignment requires SwingConstants.LEFT, or SwingConstants.RIGHT, recieved: " + alignment);
        }
        this._rightGutterAlignment = alignment;
    }

    public int getRightGutterAlignment() {
        return this._rightGutterAlignment;
    }

    public void setThreePaneMode(boolean isThreePaneMode) {
        if (isThreePaneMode) {
            this._leftEditorWeight = 0.33333334f;
            this._centerEditorWeight = 0.33333334f;
            this._rightEditorWeight = 0.33333334f;
        } else {
            this._leftEditorWeight = 0.5f;
            this._rightEditorWeight = 0.5f;
            this._centerEditorWeight = 0.0f;
        }
        this.setComponentVisible(CENTER_GUTTER, isThreePaneMode);
        this.setComponentVisible(CENTER_EDITOR, isThreePaneMode);
        this.setComponentVisible(CENTER_TITLE, isThreePaneMode);
        this.setComponentVisible(CENTER_SPLIT_TOP, isThreePaneMode);
        this.setComponentVisible(CENTER_SPLIT, isThreePaneMode);
        this._isThreePaneMode = isThreePaneMode;
    }

    boolean isEven() {
        return this._leftEditorWeight == this._rightEditorWeight && (!this._isThreePaneMode || this._rightEditorWeight == this._centerEditorWeight);
    }

    private void setComponentVisible(String constraint, boolean isVisible) {
        Component c = this.getComponent(constraint);
        if (c != null) {
            c.setVisible(isVisible);
        }
    }

    void moveSplitter(Component splitter, Point splitCenter, boolean center) {
        int screenXCenter = splitter.getLocationOnScreen().x + splitCenter.x;
        int screenX = screenXCenter - splitter.getWidth() / 2;
        int x = screenX - splitter.getParent().getLocationOnScreen().x;
        this._moveSplitter(splitter, x, center);
    }

    void moveSplitter(Component splitter, int x, boolean center) {
        this._moveSplitter(splitter, x -= splitter.getWidth() / 2, center);
    }

    private void _moveSplitter(Component splitter, int x, boolean center) {
        String leftOfSplitEditor;
        int totalEditorWidth = this.getTotalEditorWidth(splitter.getParent().getSize(), new Sizes(null));
        String string = leftOfSplitEditor = center ? CENTER_EDITOR : LEFT_EDITOR;
        String lockedWidthEditor = center ? LEFT_EDITOR : (this.isThreePaneMode() ? RIGHT_EDITOR : CENTER_EDITOR);
        Point leftOfSplitPos = this.getLocation(leftOfSplitEditor);
        Dimension leftOfSplitSize = this.getSize(leftOfSplitEditor);
        int leftWidthDelta = x - (leftOfSplitPos.x + leftOfSplitSize.width);
        int leftWidth = Math.max(0, leftOfSplitSize.width + leftWidthDelta);
        int rightWidth = totalEditorWidth - leftWidth - this.getSize((String)lockedWidthEditor).width;
        if (rightWidth < 0) {
            leftWidth -= Math.abs(rightWidth);
            rightWidth = 0;
        }
        float leftWeight = (float)leftWidth / (float)totalEditorWidth;
        float rightWeight = (float)rightWidth / (float)totalEditorWidth;
        if (this.isThreePaneMode()) {
            if (center) {
                this._centerEditorWeight = leftWeight;
                this._rightEditorWeight = rightWeight;
            } else {
                this._leftEditorWeight = leftWeight;
                this._centerEditorWeight = rightWeight;
            }
        } else {
            this._leftEditorWeight = leftWeight;
            this._rightEditorWeight = rightWeight;
        }
    }

    private Point getLocation(String constraint) {
        Component c = this.getComponent(constraint);
        if (c == null || !c.isVisible()) {
            return new Point(0, 0);
        }
        return c.getLocation();
    }

    private Dimension getSize(String constraint) {
        Component c = this.getComponent(constraint);
        if (c == null || !c.isVisible()) {
            return DIM_ZERO;
        }
        return c.getSize();
    }

    public Component getComponent(String key) {
        return (Component)this._componentMap.get(key);
    }

    private Dimension getPreferredSize(String key) {
        Component c = this.getComponent(key);
        if (c == null || !c.isVisible()) {
            return DIM_ZERO;
        }
        return c.getPreferredSize();
    }

    public void addLayoutComponent(String name, Component comp) {
        this._componentMap.put(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        Iterator i = this._componentMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Component thisComponent = (Component)this._componentMap.get(key);
            if (thisComponent != comp) continue;
            i.remove();
            return;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return DIM_ZERO;
    }

    private static int max(int[] values) {
        int max = 0;
        int i = 0;
        while (i < values.length) {
            max = Math.max(max, values[i]);
            ++i;
        }
        return max;
    }

    private static final void setBounds(Component c, int x, int y, int width, int height) {
        if (c != null && c.isVisible()) {
            c.setBounds(x, y, width, height);
        }
    }

    private int getTopHeight(Sizes s) {
        return SplitPanelLayout.max(new int[]{s.leftTitleSize.height, s.leftSplitTopSize.height, s.centerTitleSize.height, s.centerSplitTopSize.height, s.rightTitleSize.height});
    }

    public Dimension preferredLayoutSize(Container parent) {
        Sizes s = new Sizes(null);
        int width = s.leftGutterSize.width + s.leftOverviewSize.width + Math.max(s.leftTitleSize.width, s.leftEditorSize.width) + Math.max(s.leftSplitTopSize.width, s.leftSplitSize.width) + s.centerGutterSize.width + Math.max(s.centerTitleSize.width, s.centerEditorSize.width) + Math.max(s.centerSplitTopSize.width, s.centerSplitSize.width) + Math.max(s.rightTitleSize.width, s.rightEditorSize.width) + s.rightGutterSize.width + s.rightScrollbarSize.width + s.rightOverviewSize.width;
        int height = this.getTopHeight(s) + SplitPanelLayout.max(new int[]{s.leftOverviewSize.height, s.leftGutterSize.height, s.leftEditorSize.height, s.leftSplitSize.height, s.centerGutterSize.height, s.centerEditorSize.height, s.centerSplitSize.height, s.rightEditorSize.height, s.rightGutterSize.height, s.rightScrollbarSize.height, s.rightOverviewSize.height});
        return new Dimension(width, height);
    }

    private int getTotalEditorWidth(Dimension parentSize, Sizes s) {
        return parentSize.width - (s.leftOverviewSize.width + s.leftGutterSize.width + this.getLeftSplitWidth(s) + s.centerGutterSize.width + this.getCenterSplitWidth(s) + s.rightGutterSize.width + s.rightScrollbarSize.width + s.rightOverviewSize.width);
    }

    private int getLeftSplitWidth(Sizes s) {
        return Math.max(s.leftSplitTopSize.width, s.leftSplitSize.width);
    }

    private int getCenterSplitWidth(Sizes s) {
        return Math.max(s.centerSplitTopSize.width, s.centerSplitSize.width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Sizes s = new Sizes(null);
            Dimension size = parent.getSize();
            int leftSplitWidth = this.getLeftSplitWidth(s);
            int centerSplitWidth = this.getCenterSplitWidth(s);
            int totalEditorWidth = this.getTotalEditorWidth(size, s);
            float fTotalEditorWidth = totalEditorWidth;
            int leftEditorWidth = (int)(this._leftEditorWeight * fTotalEditorWidth);
            int centerEditorWidth = (int)(this._centerEditorWeight * fTotalEditorWidth);
            int rightEditorWidth = (int)(this._rightEditorWeight * fTotalEditorWidth);
            int titleHeight = this.getTopHeight(s);
            int editorHeight = size.height - titleHeight;
            int x = 0;
            SplitPanelLayout.setBounds(this.getComponent(LEFT_OVERVIEW), x, titleHeight, s.leftOverviewSize.width, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_GUTTER), x += s.leftOverviewSize.width, titleHeight, s.leftGutterSize.width, editorHeight);
            int adjust = 0;
            if (size.width > s.leftGutterSize.width + leftEditorWidth + leftSplitWidth + s.centerGutterSize.width + centerEditorWidth + centerSplitWidth + rightEditorWidth + s.rightGutterSize.width + s.rightScrollbarSize.width + s.rightOverviewSize.width) {
                adjust = 1;
            }
            SplitPanelLayout.setBounds(this.getComponent(LEFT_TITLE), x += s.leftGutterSize.width, 0, leftEditorWidth, titleHeight);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_EDITOR), x, titleHeight, leftEditorWidth + adjust, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_SPLIT_TOP), x += leftEditorWidth + adjust, 0, leftSplitWidth, titleHeight);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_SPLIT), x, titleHeight, leftSplitWidth, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_GUTTER), x += leftSplitWidth, titleHeight, s.centerGutterSize.width, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_TITLE), x += s.centerGutterSize.width, 0, centerEditorWidth, titleHeight);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_EDITOR), x, titleHeight, centerEditorWidth, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_SPLIT_TOP), x += centerEditorWidth, 0, centerSplitWidth, titleHeight);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_SPLIT), x, titleHeight, centerSplitWidth, editorHeight);
            x += centerSplitWidth;
            if (this._rightGutterAlignment == 2) {
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_GUTTER), x, titleHeight, s.rightGutterSize.width, editorHeight);
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_EDITOR), x += s.rightGutterSize.width, titleHeight, rightEditorWidth, editorHeight);
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_TITLE), x, 0, rightEditorWidth, titleHeight);
                x += rightEditorWidth;
            } else {
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_EDITOR), x, titleHeight, rightEditorWidth, editorHeight);
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_TITLE), x, 0, rightEditorWidth, titleHeight);
                SplitPanelLayout.setBounds(this.getComponent(RIGHT_GUTTER), x += rightEditorWidth, titleHeight, s.rightGutterSize.width, editorHeight);
                x += s.rightGutterSize.width;
            }
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_SCROLLBAR), x, titleHeight, s.rightScrollbarSize.width, editorHeight);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_OVERVIEW), x += s.rightScrollbarSize.width, titleHeight, s.rightOverviewSize.width, editorHeight);
            this.fireSplitterLocationChanged(this.getComponent(LEFT_SPLIT_TOP));
            this.fireSplitterLocationChanged(this.getComponent(CENTER_SPLIT_TOP));
        }
    }

    private void fireSplitterLocationChanged(Component splitter) {
        if (!(splitter instanceof JComponent)) {
            return;
        }
        JComponent splitter0 = (JComponent)splitter;
        Object o = splitter0.getClientProperty(SPLITTER_LOCATION_PROPERTY);
        int newDividerLocation = splitter0.getLocation().x + splitter0.getWidth() / 2;
        int oldDividerLocation = o != null ? (Integer)o : 0;
        splitter0.firePropertyChange(SPLITTER_LOCATION_PROPERTY, oldDividerLocation, newDividerLocation);
    }

    public static void main(String[] args) {
        JPanel p = new JPanel();
        SplitPanelLayout layout = new SplitPanelLayout();
        p.setLayout(layout);
        SplitPanelLayout.addLabel(p, LEFT_OVERVIEW, Color.MAGENTA);
        SplitPanelLayout.addLabel(p, LEFT_GUTTER, Color.RED);
        SplitPanelLayout.addLabel(p, LEFT_TITLE, Color.GREEN);
        SplitPanelLayout.addLabel(p, LEFT_EDITOR, Color.BLUE);
        SplitPanelLayout.addLabel(p, LEFT_SPLIT_TOP, Color.CYAN);
        SplitPanelLayout.addLabel(p, LEFT_SPLIT, Color.MAGENTA);
        SplitPanelLayout.addLabel(p, CENTER_TITLE, Color.YELLOW);
        SplitPanelLayout.addLabel(p, CENTER_GUTTER, Color.RED);
        SplitPanelLayout.addLabel(p, CENTER_EDITOR, Color.GRAY);
        SplitPanelLayout.addLabel(p, CENTER_SPLIT_TOP, Color.ORANGE);
        SplitPanelLayout.addLabel(p, CENTER_SPLIT, Color.PINK);
        SplitPanelLayout.addLabel(p, RIGHT_TITLE, Color.RED);
        SplitPanelLayout.addLabel(p, RIGHT_EDITOR, Color.GREEN);
        SplitPanelLayout.addLabel(p, RIGHT_GUTTER, Color.BLUE);
        SplitPanelLayout.addLabel(p, RIGHT_SCROLLBAR, Color.CYAN);
        SplitPanelLayout.addLabel(p, RIGHT_OVERVIEW, Color.MAGENTA);
        JFrame f = new JFrame();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
    }

    private static void addLabel(Container c, String constraint, Color color) {
        JLabel l = new JLabel();
        l.setOpaque(true);
        l.setBackground(color);
        l.setText(constraint);
        c.add((Component)l, constraint);
    }

    static Dimension mav$getPreferredSize(SplitPanelLayout splitPanelLayout, String string) {
        return splitPanelLayout.getPreferredSize(string);
    }

    private class Sizes {
        Dimension leftOverviewSize;
        Dimension leftGutterSize;
        Dimension leftTitleSize;
        Dimension leftEditorSize;
        Dimension leftSplitTopSize;
        Dimension leftSplitSize;
        Dimension centerTitleSize;
        Dimension centerGutterSize;
        Dimension centerEditorSize;
        Dimension centerSplitTopSize;
        Dimension centerSplitSize;
        Dimension rightTitleSize;
        Dimension rightEditorSize;
        Dimension rightGutterSize;
        Dimension rightScrollbarSize;
        Dimension rightOverviewSize;

        private void $init$() {
            this.leftOverviewSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_OVERVIEW);
            this.leftGutterSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_GUTTER);
            this.leftTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_TITLE);
            this.leftEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_EDITOR);
            this.leftSplitTopSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_SPLIT_TOP);
            this.leftSplitSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_SPLIT);
            this.centerTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_TITLE);
            this.centerGutterSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_GUTTER);
            this.centerEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_EDITOR);
            this.centerSplitTopSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_SPLIT_TOP);
            this.centerSplitSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_SPLIT_TOP);
            this.rightTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_TITLE);
            this.rightEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_EDITOR);
            this.rightGutterSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_GUTTER);
            this.rightScrollbarSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_SCROLLBAR);
            this.rightOverviewSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_OVERVIEW);
        }

        private Sizes() {
            this.$init$();
        }

        Sizes(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

