/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.compare.view.EditableView;
import oracle.javatools.compare.view.ViewMemento;

public class ViewEdit
extends AbstractUndoableEdit {
    private final String _presentationName;
    private final UndoableEdit _undoableEdit;
    private final EditableView _compareView;
    private final ViewMemento _undoMemento;
    private final ViewMemento _redoMemento;

    public ViewEdit(UndoableEdit undoableEdit, EditableView compareView, ViewMemento undoMemento, ViewMemento redoMemento) {
        this(undoableEdit, null, compareView, undoMemento, redoMemento);
    }

    public ViewEdit(UndoableEdit undoableEdit, String presentationName, EditableView compareView, ViewMemento undoMemento, ViewMemento redoMemento) {
        this._presentationName = presentationName;
        this._undoableEdit = undoableEdit;
        this._compareView = compareView;
        this._undoMemento = undoMemento;
        this._redoMemento = redoMemento;
    }

    public void undo() throws CannotUndoException {
        try {
            super.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        if (this._undoableEdit != null) {
            this._undoableEdit.undo();
        }
        if (this._undoMemento != null) {
            this._compareView.setMemento(this._undoMemento);
        }
    }

    public boolean canUndo() {
        return super.canUndo() && (this._undoableEdit == null || this._undoableEdit.canUndo());
    }

    public void redo() throws CannotRedoException {
        try {
            super.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
        if (this._undoableEdit != null) {
            this._undoableEdit.redo();
        }
        if (this._redoMemento != null) {
            this._compareView.setMemento(this._redoMemento);
        }
    }

    public boolean canRedo() {
        return super.canRedo() && (this._undoableEdit == null || this._undoableEdit.canRedo());
    }

    public String getPresentationName() {
        return this._presentationName != null ? this._presentationName : this._undoableEdit.getPresentationName();
    }
}

