/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.view.ActionMenuView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.CompareViewUtil;
import oracle.javatools.compare.view.DiffGutter;
import oracle.javatools.compare.view.SequenceCompareView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewMemento;
import oracle.javatools.icons.OracleIcons;

public class ListCompareView
extends SequenceCompareView
implements ActionMenuView {
    private static final Color COLOR_UNCHANGED;
    private CompareList _leftCompareList;
    private CompareList _rightCompareList;
    private CompareList _centerCompareList;
    private boolean _verticalScrollLock;
    private JList _currentList;
    private ComparePopupManager _popupManager;
    private Collection<ActionListener> _defaultActionListeners;
    private final int _cellHeight;
    private AutoScrollChangeListener _autoScrollChangeListener;
    private UniqueSelectionListener _uniqueSelectionListener;
    private PositionListenerImpl _positionListener;
    private BaseCompareView.CentralGutterMouseHandler _gutterHandler;
    private ListMouseHandler _listMouseHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._defaultActionListeners = new ArrayList<ActionListener>();
        Cell cell = new Cell();
        cell.getLabel().setText("this is a dummy cell");
        cell.setEntryIcon(this.getIcon("SPACER"));
        this._cellHeight = cell.getPreferredSize().height;
    }

    public ListCompareView() {
        this.$init$();
    }

    public ListCompareView(CompareMode compareMode) {
        super(compareMode);
        this.$init$();
        this._leftCompareList = new CompareList(ContributorKind.FIRST);
        this._rightCompareList = new CompareList(ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this._centerCompareList = new CompareList(ContributorKind.ANCESTOR);
        }
    }

    static {
        $assertionsDisabled = ListCompareView.class.desiredAssertionStatus() ^ true;
        COLOR_UNCHANGED = UIManager.getColor("List.background");
    }

    protected void initializeView(CompareModel compareModel) {
        if (compareModel == null) {
            return;
        }
        if (!$assertionsDisabled && compareModel.getType() != CompareType.DIRECTORY) {
            throw new AssertionError();
        }
        this.setSplitPanel(null);
        this.getSplitPanel().setThreePaneMode(this.getCompareMode() == CompareMode.THREE_WAY_MERGE);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.setLeftDiffGutter(new ListDiffGutter(ContributorKind.FIRST, ContributorKind.ANCESTOR));
        } else {
            this.setLeftDiffGutter(new ListDiffGutter(ContributorKind.FIRST, ContributorKind.SECOND));
        }
        this.setLeftScrollPane(this.createHorizontalScrollPane(this._leftCompareList.getGUI()));
        this.setRightScrollPane(this.createHorizontalScrollPane(this._rightCompareList.getGUI()));
        this.getSplitPanel().add((Component)this.getLeftScrollPane(), "leftEditor");
        this.getSplitPanel().add((Component)this.getRightScrollPane(), "rightEditor");
        this.getSplitPanel().add((Component)this.getLeftTitle(), "leftTitle");
        this.getSplitPanel().add((Component)this.getCenterTitle(), "centerTitle");
        this.getSplitPanel().add((Component)this.getRightTitle(), "rightTitle");
        this.getSplitPanel().add((Component)this.getLeftDiffGutter(), "leftSplit");
        this.getSplitPanel().add((Component)this.getLeftOverview(), "leftOverview");
        this.getSplitPanel().add((Component)this.getRightOverview(), "rightOverview");
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.setCenterScrollPane(this.createHorizontalScrollPane(this._centerCompareList.getGUI()));
            this.getSplitPanel().add((Component)this.getCenterScrollPane(), "centerEditor");
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.setRightDiffGutter(new ListDiffGutter(ContributorKind.ANCESTOR, ContributorKind.SECOND));
            this.getSplitPanel().add((Component)this.getRightDiffGutter(), "centerSplit");
        }
        this.getSplitPanel().add((Component)this.getVerticalScrollPanel(), "rightScrollbar");
        if (this._autoScrollChangeListener == null) {
            this._autoScrollChangeListener = new AutoScrollChangeListener(null);
        }
        this.installAutoScrollListener(this.getLeftScrollPane());
        this.installAutoScrollListener(this.getRightScrollPane());
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.installAutoScrollListener(this.getCenterScrollPane());
        }
        if (this._uniqueSelectionListener == null) {
            this._uniqueSelectionListener = new UniqueSelectionListener(null);
        }
        this.installUniqueSelectionListener(this._leftCompareList);
        this.installUniqueSelectionListener(this._rightCompareList);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.installUniqueSelectionListener(this._centerCompareList);
        }
        if (this._positionListener == null) {
            this._positionListener = new PositionListenerImpl(null);
        }
        this.installPositionListener(this._leftCompareList);
        this.installPositionListener(this._rightCompareList);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.installPositionListener(this._centerCompareList);
        }
        if (this._gutterHandler == null) {
            this._gutterHandler = new BaseCompareView.CentralGutterMouseHandler();
        }
        this.installCentralGutterMouseHandler(this.getLeftDiffGutter());
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.installCentralGutterMouseHandler(this.getRightDiffGutter());
        }
        if (this._listMouseHandler == null) {
            this._listMouseHandler = new ListMouseHandler(null);
        }
        this.installListMouseHandler(this._leftCompareList);
        this.installListMouseHandler(this._rightCompareList);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.installListMouseHandler(this._centerCompareList);
        }
        this.updateListModel();
        this.updateVerticalScrollbar();
        this.getVerticalScrollBar().setValue(0);
        this._currentList = this._leftCompareList.getList();
    }

    private void installAutoScrollListener(JScrollPane scrollPane) {
        scrollPane.getViewport().removeChangeListener(this._autoScrollChangeListener);
        scrollPane.getViewport().removeComponentListener(this._autoScrollChangeListener);
        scrollPane.getViewport().addChangeListener(this._autoScrollChangeListener);
        scrollPane.getViewport().addComponentListener(this._autoScrollChangeListener);
    }

    private void installUniqueSelectionListener(CompareList compareList) {
        compareList.getList().removeFocusListener(this._uniqueSelectionListener);
        compareList.getList().addFocusListener(this._uniqueSelectionListener);
    }

    private void installPositionListener(CompareList compareList) {
        compareList.getList().removeFocusListener(this._positionListener);
        compareList.getList().removeListSelectionListener(this._positionListener);
        compareList.getList().addFocusListener(this._positionListener);
        compareList.getList().addListSelectionListener(this._positionListener);
    }

    private void installCentralGutterMouseHandler(DiffGutter diffGutter) {
        diffGutter.removeMouseListener(this._gutterHandler);
        diffGutter.addMouseListener(this._gutterHandler);
    }

    private void installListMouseHandler(CompareList compareList) {
        compareList.getList().removeMouseListener(this._listMouseHandler);
        compareList.getList().addMouseListener(this._listMouseHandler);
    }

    protected void updateModelImpl() {
        this.updateListModel();
    }

    protected JScrollPane createHorizontalScrollPane(Component view) {
        JScrollPane scrollPane = super.createHorizontalScrollPane(view);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    protected Color getOverviewDifferenceColor(SequenceCompareDifference differenceBlock, boolean isLeft, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
        Color color = this.getColorForDiffState(DiffState.UNCHANGED);
        DiffState diffState = this.getDiffStateForDifference(differenceBlock, null, isLeft ? secondContributorKind : firstContributorKind, isLeft ? firstContributorKind : secondContributorKind);
        if (this.isOverviewState(diffState)) {
            color = this.getColorForDiffState(diffState);
        }
        return color;
    }

    protected int getVirtualHeightLines(ContributorKind contributor) {
        return super.getVirtualHeightLines(null);
    }

    private boolean isOverviewState(DiffState diffState) {
        return diffState == DiffState.ADDED || diffState == DiffState.REMOVED || diffState == DiffState.CHANGED || diffState == DiffState.CONFLICT || diffState == DiffState.RESOLVED;
    }

    private void updateVerticalScrollbar() {
        this.getVerticalScrollBar().setMinimum(0);
        int virtualHeight = this.getVirtualHeightLines(null);
        this.getVerticalScrollBar().setMaximum(virtualHeight);
        int visibleLineCount = (int)Math.floor((float)this._leftCompareList.getList().getVisibleRect().height / (float)this._cellHeight);
        this.getVerticalScrollBar().setVisibleAmount(visibleLineCount);
        this.getVerticalScrollBar().setUnitIncrement(1);
        this.getVerticalScrollBar().setBlockIncrement(5);
        if (visibleLineCount < this.getVerticalScrollBar().getMaximum()) {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalScrollbar");
        } else {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalSpacer");
        }
        boolean masked = this.getCompareModel().getDifferenceCount() == 0 || visibleLineCount >= virtualHeight;
        this.getLeftOverview().setMasked(masked);
        this.getRightOverview().setMasked(masked);
    }

    protected void verticalScrollTo(int virtualLine) {
        if (this._verticalScrollLock) {
            return;
        }
        this._verticalScrollLock = true;
        try {
            this.setScrollPaneViewPosition(this.getLeftScrollPane(), virtualLine);
            this.setScrollPaneViewPosition(this.getRightScrollPane(), virtualLine);
            if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                this.setScrollPaneViewPosition(this.getCenterScrollPane(), virtualLine);
            }
        }
        finally {
            this._verticalScrollLock = false;
        }
    }

    private void setScrollPaneViewPosition(JScrollPane scrollPane, int virtualLine) {
        int y = virtualLine * this._cellHeight;
        int delta = y + scrollPane.getViewport().getVisibleRect().height - scrollPane.getViewport().getView().getHeight();
        y = Math.min(y, y - delta);
        scrollPane.getViewport().setViewPosition(new Point(scrollPane.getViewport().getViewPosition().x, y));
    }

    private void updateListModel() {
        JList currentList = this._currentList;
        int index = currentList != null ? this._currentList.getSelectedIndex() : -1;
        this._verticalScrollLock = true;
        this.updateListModel(ContributorKind.FIRST);
        this.updateListModel(ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.updateListModel(ContributorKind.ANCESTOR);
        }
        this._verticalScrollLock = false;
        if (currentList != null) {
            currentList.setSelectedIndex(index);
        }
        this._leftCompareList.getList().repaint();
        this._rightCompareList.getList().repaint();
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this._centerCompareList.getList().repaint();
        }
    }

    private void updateListModel(ContributorKind contributorKind) {
        this.getCompareList(contributorKind).getModel().clear();
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            this.getCompareList(contributorKind).getModel().addElement(((DirectoryCompareContributor)this.getContributor(contributorKind)).getElement((SequenceCompareDifference)itr.next(), contributorKind));
        }
    }

    protected Iterator getDiffBlockIterator() {
        return new 1ListEntryIterator(super.getDiffBlockIterator());
    }

    protected CompareDifference getPreviousDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int index = this.getCurrentIndex(contributorKind);
        if (index < 0) {
            return null;
        }
        SequenceCompareDifference changeDifferenceBlock = null;
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            SequenceCompareDifference differenceBlock = (SequenceCompareDifference)itr.next();
            if (index == 0) {
                return changeDifferenceBlock;
            }
            if (differenceBlock.getKind() == 2) {
                changeDifferenceBlock = differenceBlock;
            }
            --index;
        }
        return null;
    }

    protected CompareDifference getNextDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int index = this.getCurrentIndex(contributorKind);
        if (index < 0) {
            return null;
        }
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            itr.next();
            if (index == 0) break;
            --index;
        }
        while (itr.hasNext()) {
            SequenceCompareDifference differenceBlock = (SequenceCompareDifference)itr.next();
            if (differenceBlock.getKind() != 2) continue;
            return differenceBlock;
        }
        return null;
    }

    protected CompareDifference getPreviousConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int index = this.getCurrentIndex(contributorKind);
        if (index < 0) {
            return null;
        }
        SequenceCompareDifference changeDifferenceBlock = null;
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            SequenceCompareDifference differenceBlock = (SequenceCompareDifference)itr.next();
            if (index == 0) {
                return changeDifferenceBlock;
            }
            if (differenceBlock.getKind() == 2 && differenceBlock.isConflict() && !differenceBlock.isResolved()) {
                changeDifferenceBlock = differenceBlock;
            }
            --index;
        }
        return null;
    }

    protected CompareDifference getNextConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int index = this.getCurrentIndex(contributorKind);
        if (index < 0) {
            return null;
        }
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            itr.next();
            if (index == 0) break;
            --index;
        }
        while (itr.hasNext()) {
            SequenceCompareDifference differenceBlock = (SequenceCompareDifference)itr.next();
            if (differenceBlock.getKind() != 2 || !differenceBlock.isConflict() || differenceBlock.isResolved()) continue;
            return differenceBlock;
        }
        return null;
    }

    protected CompareDifference getCurrentDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int index = this.getCurrentIndex(contributorKind);
        if (index < 0) {
            return null;
        }
        SequenceCompareDifference differenceBlock = this.getDifferenceBlockForVirtualIndex(index);
        return differenceBlock.getKind() == 2 ? differenceBlock : null;
    }

    protected ContributorKind getCurrentContributorKind() {
        if (this._currentList == null) {
            return null;
        }
        return this.getContributorForList(this._currentList);
    }

    private ContributorKind getContributorForList(JList list) {
        if (list == this._leftCompareList.getList()) {
            return ContributorKind.FIRST;
        }
        if (list == this._rightCompareList.getList()) {
            return ContributorKind.SECOND;
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && list == this._centerCompareList.getList()) {
            return ContributorKind.ANCESTOR;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private int getCurrentIndex(ContributorKind contributorKind) {
        return this.getCompareList(contributorKind).getList().getSelectedIndex();
    }

    protected void goToDifference(CompareDifference difference, boolean requestFocus) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            contributorKind = ContributorKind.FIRST;
        }
        int index = this.getVirtualIndexForDifferenceBlock(differenceBlock);
        this.getCompareList(contributorKind).getList().setSelectedIndex(index);
        this.getCompareList(contributorKind).getList().ensureIndexIsVisible(index);
        if (requestFocus) {
            this.getCompareList(contributorKind).getGUI().requestFocus();
        }
    }

    private CompareList getCompareList(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.FIRST) {
            return this._leftCompareList;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._rightCompareList;
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._centerCompareList;
        }
        return null;
    }

    private DiffState getDiffStateForDifference(SequenceCompareDifference differenceBlock, ContributorKind contributorKind) {
        return this.getDiffStateForDifference(differenceBlock, contributorKind, ContributorKind.FIRST, ContributorKind.SECOND);
    }

    private DiffState getDiffStateForDifference(SequenceCompareDifference differenceBlock, ContributorKind primaryContributorKind, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
        if (differenceBlock == null || differenceBlock.getKind() == 0) {
            return DiffState.UNCHANGED;
        }
        if (primaryContributorKind != null && differenceBlock.getLength(primaryContributorKind) <= 0) {
            return DiffState.ABSENT;
        }
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            if (differenceBlock.isChange(firstContributorKind, secondContributorKind)) {
                return DiffState.CHANGED;
            }
            if (this.isRemoval((BaseCompareDifference)differenceBlock, firstContributorKind, secondContributorKind)) {
                return DiffState.REMOVED;
            }
            if (this.isAddition((BaseCompareDifference)differenceBlock, firstContributorKind, secondContributorKind)) {
                return DiffState.ADDED;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        if (differenceBlock.isResolved()) {
            if (primaryContributorKind != null && primaryContributorKind != ContributorKind.ANCESTOR && !CompareViewUtil.equal(this.getCompareModel(), differenceBlock, primaryContributorKind, ContributorKind.ANCESTOR)) {
                return DiffState.UNCHOSEN;
            }
            return DiffState.RESOLVED;
        }
        return DiffState.CONFLICT;
    }

    private Color getColorForDiffState(DiffState state) {
        if (state == DiffState.CHANGED) {
            return ColorConstants.COLOR_CHANGED;
        }
        if (state == DiffState.REMOVED) {
            return ColorConstants.COLOR_REMOVED;
        }
        if (state == DiffState.ADDED) {
            return ColorConstants.COLOR_ADDED;
        }
        if (state == DiffState.ABSENT) {
            return ColorConstants.COLOR_ABSENT;
        }
        if (state == DiffState.CONFLICT) {
            return ColorConstants.COLOR_CONFLICT;
        }
        if (state == DiffState.RESOLVED) {
            return ColorConstants.COLOR_RESOLVED;
        }
        if (state == DiffState.UNCHANGED) {
            return COLOR_UNCHANGED;
        }
        if (state == DiffState.UNCHOSEN) {
            return ColorConstants.COLOR_UNCHOSEN;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private SequenceCompareDifference getDifferenceBlockForVirtualIndex(int index) {
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            if (index == 0) {
                return (SequenceCompareDifference)itr.next();
            }
            itr.next();
            --index;
        }
        return null;
    }

    private int getVirtualIndexForDifferenceBlock(SequenceCompareDifference difference) {
        int index = 0;
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext()) {
            if (itr.next() == difference) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private ImageIcon getIcon(String name) {
        return new ImageIcon(Object.class.getResource(this.getBundle().getString(name)));
    }

    protected boolean isViewFocusOwner() {
        if (this._leftCompareList.getList().isFocusOwner() || this._rightCompareList.getList().isFocusOwner()) {
            return true;
        }
        return this.getCompareMode() == CompareMode.THREE_WAY_MERGE && this._centerCompareList.getList().isFocusOwner();
    }

    protected Action createInsertBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        Action insertBlockAction = super.createInsertBlockAction(difference, contributor, adjacentContributor);
        insertBlockAction.putValue("Name", this.getBundle().getString("INSERT_AT_ACTION_NAME"));
        return insertBlockAction;
    }

    protected void replaceBlock(BaseCompareDifference difference, ContributorKind fromContributorKind, ContributorKind toContributorKind) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        int line = this.getVirtualIndexForDifferenceBlock(differenceBlock);
        UndoableEdit undoableEdit = null;
        ViewMemento undoMemento = null;
        ViewMemento redoMemento = null;
        try {
            undoMemento = this.createMemento();
            undoableEdit = ((DirectoryCompareContributor)this.getContributor(toContributorKind)).replaceElement(differenceBlock.getStart(toContributorKind), differenceBlock.getStart(toContributorKind) + differenceBlock.getLength(toContributorKind) - 1, ((DirectoryCompareContributor)this.getContributor(fromContributorKind)).getElement(differenceBlock, fromContributorKind));
            this.adjustDifferenceLength(differenceBlock, toContributorKind, differenceBlock.getLength(fromContributorKind));
            differenceBlock.setResolved(true);
            redoMemento = this.createMemento();
        }
        catch (Throwable throwable) {
            if (undoableEdit != null) {
                this.fireViewEditEvent(new ViewEditEvent(this, 1, toContributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("REPLACE_ACTION_NAME"), this, undoMemento, redoMemento)));
                this.goToVirtualIndex(line, toContributorKind);
            }
            throw throwable;
        }
        if (undoableEdit != null) {
            this.fireViewEditEvent(new ViewEditEvent(this, 1, toContributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("REPLACE_ACTION_NAME"), this, undoMemento, redoMemento)));
            this.goToVirtualIndex(line, toContributorKind);
        }
    }

    protected void insertBlockCopy(BaseCompareDifference difference, ContributorKind fromContributorKind, ContributorKind toContributorKind) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        int line = this.getVirtualIndexForDifferenceBlock(differenceBlock);
        UndoableEdit undoableEdit = null;
        ViewMemento undoMemento = null;
        ViewMemento redoMemento = null;
        try {
            boolean after;
            int index;
            undoMemento = this.createMemento();
            if (differenceBlock.getLength(toContributorKind) == 0) {
                index = differenceBlock.getStart(toContributorKind);
                after = false;
            } else {
                index = differenceBlock.getStart(toContributorKind) + differenceBlock.getLength(toContributorKind) - 1;
                after = true;
            }
            undoableEdit = ((DirectoryCompareContributor)this.getContributor(toContributorKind)).insertElement(index, after, ((DirectoryCompareContributor)this.getContributor(fromContributorKind)).getElement(differenceBlock, fromContributorKind));
            this.adjustDifferenceLength(differenceBlock, toContributorKind, differenceBlock.getLength(toContributorKind) + differenceBlock.getLength(fromContributorKind));
            differenceBlock.setResolved(true);
            redoMemento = this.createMemento();
        }
        catch (Throwable throwable) {
            if (undoableEdit != null) {
                this.fireViewEditEvent(new ViewEditEvent(this, 1, toContributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("INSERT_AT_ACTION_NAME"), this, undoMemento, redoMemento)));
                this.goToVirtualIndex(line, toContributorKind);
            }
            throw throwable;
        }
        if (undoableEdit != null) {
            this.fireViewEditEvent(new ViewEditEvent(this, 1, toContributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("INSERT_AT_ACTION_NAME"), this, undoMemento, redoMemento)));
            this.goToVirtualIndex(line, toContributorKind);
        }
    }

    protected void deleteBlock(BaseCompareDifference difference, ContributorKind contributorKind) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        UndoableEdit undoableEdit = null;
        ViewMemento undoMemento = null;
        ViewMemento redoMemento = null;
        try {
            undoMemento = this.createMemento();
            undoableEdit = ((DirectoryCompareContributor)this.getContributor(contributorKind)).deleteElement(differenceBlock.getStart(contributorKind), differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) - 1);
            this.adjustDifferenceLength(differenceBlock, contributorKind, 0);
            differenceBlock.setResolved(true);
            redoMemento = this.createMemento();
        }
        catch (Throwable throwable) {
            if (undoableEdit != null) {
                this.fireViewEditEvent(new ViewEditEvent(this, 1, contributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("REMOVE_ACTION_NAME"), this, undoMemento, redoMemento)));
                this.goToVirtualIndex(this.getVirtualIndexForDifferenceBlock(differenceBlock), contributorKind);
            }
            throw throwable;
        }
        if (undoableEdit != null) {
            this.fireViewEditEvent(new ViewEditEvent(this, 1, contributorKind, new ViewEdit(undoableEdit, this.getBundle().getString("REMOVE_ACTION_NAME"), this, undoMemento, redoMemento)));
            this.goToVirtualIndex(this.getVirtualIndexForDifferenceBlock(differenceBlock), contributorKind);
        }
    }

    private void adjustDifferenceLength(SequenceCompareDifference difference, ContributorKind contributorKind, int length) {
        Iterator itr = this.getDiffBlockIterator();
        while (itr.hasNext() && itr.next() != difference) {
        }
        int delta = length - difference.getLength(contributorKind);
        if (contributorKind == ContributorKind.FIRST) {
            difference.setFirstLength(length);
        }
        if (contributorKind == ContributorKind.SECOND) {
            difference.setSecondLength(length);
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            difference.setAncestorLength(length);
        }
        while (itr.hasNext()) {
            SequenceCompareDifference currentDifference = (SequenceCompareDifference)itr.next();
            if (currentDifference.getKind() == 0) continue;
            if (contributorKind == ContributorKind.FIRST) {
                currentDifference.setFirstStart(currentDifference.getStart(contributorKind) + delta);
            }
            if (contributorKind == ContributorKind.SECOND) {
                currentDifference.setSecondStart(currentDifference.getStart(contributorKind) + delta);
            }
            if (contributorKind != ContributorKind.ANCESTOR) continue;
            currentDifference.setAncestorStart(currentDifference.getStart(contributorKind) + delta);
        }
    }

    private void goToVirtualIndex(int index, ContributorKind contributorKind) {
        EventQueue.invokeLater(new 1(this, contributorKind, index));
    }

    public void addPopupManager(ComparePopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public void removePopupManager(ComparePopupManager popupManager) {
        this._popupManager = null;
    }

    protected boolean canReadElement(CompareDifference difference, ContributorKind contributorKind) {
        DirectoryFile directoryFile = (DirectoryFile)((DirectoryCompareContributor)this.getContributor(contributorKind)).getElement((SequenceCompareDifference)difference, contributorKind);
        return directoryFile == null || directoryFile.canRead();
    }

    protected boolean canWriteElement(CompareDifference difference, ContributorKind contributorKind) {
        DirectoryFile directoryFile = (DirectoryFile)((DirectoryCompareContributor)this.getContributor(contributorKind)).getElement((SequenceCompareDifference)difference, contributorKind);
        return directoryFile == null || directoryFile.canWrite();
    }

    public boolean isSelectionComparable() {
        if (this.getCompareMode() != CompareMode.TWO_WAY_COMPARE) {
            return false;
        }
        SequenceCompareDifference currentDifference = (SequenceCompareDifference)this.getCurrentDifference();
        return currentDifference != null && currentDifference.isChange(ContributorKind.FIRST, ContributorKind.SECOND);
    }

    public Object[] getSelectionForCompare() {
        if (!this.isSelectionComparable()) {
            return null;
        }
        int i = this.getCurrentIndex(this.getCurrentContributorKind());
        if (i < 0) {
            return null;
        }
        return new Object[]{this._leftCompareList.getList().getModel().getElementAt(i), this._rightCompareList.getList().getModel().getElementAt(i)};
    }

    public void addDefaultActionListener(ActionListener l) {
        this._defaultActionListeners.add(l);
    }

    public void removeDefaultActionListener(ActionListener l) {
        this._defaultActionListeners.remove(l);
    }

    private void fireDefaultAction() {
        ActionListener[] l = this._defaultActionListeners.toArray(new ActionListener[0]);
        ActionEvent ae = new ActionEvent(this, 1001, null);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].actionPerformed(ae);
            --i;
        }
    }

    static Color mav$getColorForDiffState(ListCompareView listCompareView, DiffState diffState) {
        return listCompareView.getColorForDiffState(diffState);
    }

    static int ra$_cellHeight(ListCompareView listCompareView) {
        return listCompareView._cellHeight;
    }

    static DiffState mav$getDiffStateForDifference(ListCompareView listCompareView, SequenceCompareDifference sequenceCompareDifference, ContributorKind contributorKind) {
        return listCompareView.getDiffStateForDifference(sequenceCompareDifference, contributorKind);
    }

    static JList ra$_currentList(ListCompareView listCompareView) {
        return listCompareView._currentList;
    }

    static Color ra$COLOR_UNCHANGED() {
        return COLOR_UNCHANGED;
    }

    static SequenceCompareDifference mav$getDifferenceBlockForVirtualIndex(ListCompareView listCompareView, int n) {
        return listCompareView.getDifferenceBlockForVirtualIndex(n);
    }

    static CompareList ra$_leftCompareList(ListCompareView listCompareView) {
        return listCompareView._leftCompareList;
    }

    static CompareList ra$_rightCompareList(ListCompareView listCompareView) {
        return listCompareView._rightCompareList;
    }

    static CompareList ra$_centerCompareList(ListCompareView listCompareView) {
        return listCompareView._centerCompareList;
    }

    static DiffGutter mav$getRightDiffGutter(ListCompareView listCompareView) {
        return listCompareView.getRightDiffGutter();
    }

    static void mav$repaintDiffGutters(ListCompareView listCompareView) {
        listCompareView.repaintDiffGutters();
    }

    static boolean ra$_verticalScrollLock(ListCompareView listCompareView) {
        return listCompareView._verticalScrollLock;
    }

    static void wa$_verticalScrollLock(ListCompareView listCompareView, boolean bl) {
        listCompareView._verticalScrollLock = bl;
    }

    static JScrollPane mav$getLeftScrollPane(ListCompareView listCompareView) {
        return listCompareView.getLeftScrollPane();
    }

    static JScrollPane mav$getRightScrollPane(ListCompareView listCompareView) {
        return listCompareView.getRightScrollPane();
    }

    static JScrollPane mav$getCenterScrollPane(ListCompareView listCompareView) {
        return listCompareView.getCenterScrollPane();
    }

    static void mav$updateVerticalScrollbar(ListCompareView listCompareView) {
        listCompareView.updateVerticalScrollbar();
    }

    static JScrollBar mav$getVerticalScrollBar(ListCompareView listCompareView) {
        return listCompareView.getVerticalScrollBar();
    }

    static void wa$_currentList(ListCompareView listCompareView, JList jList) {
        listCompareView._currentList = jList;
    }

    static ComparePopupManager ra$_popupManager(ListCompareView listCompareView) {
        return listCompareView._popupManager;
    }

    static void mav$fireDefaultAction(ListCompareView listCompareView) {
        listCompareView.fireDefaultAction();
    }

    static CompareList mav$getCompareList(ListCompareView listCompareView, ContributorKind contributorKind) {
        return listCompareView.getCompareList(contributorKind);
    }

    static ImageIcon mav$getIcon(ListCompareView listCompareView, String string) {
        return listCompareView.getIcon(string);
    }

    static CompareToolTipProvider mav$getToolTipProvider(ListCompareView listCompareView) {
        return listCompareView.getToolTipProvider();
    }

    static void mav$firePositionChanged(ListCompareView listCompareView) {
        listCompareView.firePositionChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DiffState
    extends Enum<DiffState> {
        private static final /* synthetic */ DiffState[] $v;
        public static final /* enum */ DiffState CHANGED;
        public static final /* enum */ DiffState REMOVED;
        public static final /* enum */ DiffState ADDED;
        public static final /* enum */ DiffState ABSENT;
        public static final /* enum */ DiffState CONFLICT;
        public static final /* enum */ DiffState RESOLVED;
        public static final /* enum */ DiffState UNCHANGED;
        public static final /* enum */ DiffState UNCHOSEN;

        public static DiffState valueOf(String string) {
            return Enum.valueOf(DiffState.class, string);
        }

        public static final DiffState[] values() {
            return (DiffState[])$v.clone();
        }

        static {
            DiffState[] diffStateArray = new DiffState[8];
            diffStateArray[7] = UNCHOSEN = new DiffState("UNCHOSEN", 7);
            diffStateArray[6] = UNCHANGED = new DiffState("UNCHANGED", 6);
            diffStateArray[5] = RESOLVED = new DiffState("RESOLVED", 5);
            diffStateArray[4] = CONFLICT = new DiffState("CONFLICT", 4);
            diffStateArray[3] = ABSENT = new DiffState("ABSENT", 3);
            diffStateArray[2] = ADDED = new DiffState("ADDED", 2);
            diffStateArray[1] = REMOVED = new DiffState("REMOVED", 1);
            diffStateArray[0] = CHANGED = new DiffState("CHANGED", 0);
            $v = diffStateArray;
        }

        private DiffState(String string2, int n2) {
        }
    }

    class Cell
    extends JComponent {
        private final JLabel _label;
        private Icon _entryIcon;
        private boolean _selected;
        private boolean _outlined;
        private DiffState _state;
        private Icon _rightIcon;
        private Container _container;

        private void $init$() {
            this._label = new JLabel();
            this._label.setOpaque(false);
            this._label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this._entryIcon = null;
            this._container = new Container();
        }

        public Dimension getPreferredSize() {
            int height = 0;
            height += this._label.isVisible() ? this._label.getPreferredSize().height : 0;
            height = Math.max(height, this._entryIcon.getIconHeight());
            height += 2;
            int width = 0;
            width += this._entryIcon.getIconWidth();
            width += 2;
            return new Dimension(width += this._label.isVisible() ? this._label.getPreferredSize().width : 0, height += 2);
        }

        Component getGUI() {
            return this;
        }

        JLabel getLabel() {
            return this._label;
        }

        void setEntryIcon(Icon icon) {
            this._entryIcon = icon;
        }

        void setSelected(boolean selected) {
            this._selected = selected;
        }

        void setOutlined(boolean outlined) {
            this._outlined = outlined;
        }

        void setState(DiffState state) {
            this._state = state;
        }

        void setRightIcon(Icon icon) {
            this._rightIcon = icon;
        }

        public void paintComponent(Graphics g) {
            int yDelta;
            g.setColor(ListCompareView.mav$getColorForDiffState(ListCompareView.this, this._state));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int x = 0;
            if (this._entryIcon != null) {
                yDelta = this.getPreferredSize().height - this._entryIcon.getIconHeight();
                g.drawImage(((ImageIcon)this._entryIcon).getImage(), x, yDelta / 2, this);
                x += this._entryIcon.getIconWidth();
                x += 2;
            }
            this._label.setOpaque(this._selected);
            this._label.setForeground(UIManager.getColor(this._selected ? "List.selectionForeground" : "List.foreground"));
            this._label.setBackground(UIManager.getColor(this._selected ? "List.selectionBackground" : "List.background"));
            if (this._outlined) {
                g.setColor(ColorConstants.COLOR_SEPARATOR);
            }
            g.drawLine(0, 0, this.getWidth(), 0);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            if (this._label.isVisible()) {
                yDelta = this.getPreferredSize().height - this._label.getPreferredSize().height;
                Dimension d = this._label.getPreferredSize();
                SwingUtilities.paintComponent(g, this._label, this._container, new Rectangle(x, yDelta / 2, (int)d.getWidth(), (int)d.getHeight()));
            }
            if (this._rightIcon != null) {
                yDelta = this.getPreferredSize().height - this._rightIcon.getIconHeight();
                x = this.getWidth() - this._rightIcon.getIconWidth() - 2;
                g.drawImage(((ImageIcon)this._rightIcon).getImage(), x, yDelta / 2, this);
            }
        }

        Cell() {
            this.$init$();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 1ListEntryIterator
    implements Iterator {
        private final Iterator _diffBlockIterator;
        private SequenceCompareDifference _noChangeBlock;

        private void $init$() {
            this._noChangeBlock = null;
        }

        1ListEntryIterator(Iterator diffBlockIterator) {
            this.$init$();
            this._diffBlockIterator = diffBlockIterator;
        }

        @Override
        public boolean hasNext() {
            return this._diffBlockIterator.hasNext() || this._noChangeBlock != null && this.hasLength(this._noChangeBlock);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this._noChangeBlock == null) {
                SequenceCompareDifference differenceBlock = (SequenceCompareDifference)this._diffBlockIterator.next();
                if (differenceBlock.getKind() == 2) {
                    return differenceBlock;
                }
                this._noChangeBlock = differenceBlock;
            }
            SequenceCompareDifference entryGapBlock = new SequenceCompareDifference(0);
            entryGapBlock.setFirstStart(this._noChangeBlock.getStart(ContributorKind.FIRST));
            entryGapBlock.setSecondStart(this._noChangeBlock.getStart(ContributorKind.SECOND));
            entryGapBlock.setAncestorStart(this._noChangeBlock.getStart(ContributorKind.ANCESTOR));
            int gapFirstLength = Math.min(1, this._noChangeBlock.getLength(ContributorKind.FIRST));
            int gapSecondLength = Math.min(1, this._noChangeBlock.getLength(ContributorKind.SECOND));
            int gapAncestorLength = Math.min(1, this._noChangeBlock.getLength(ContributorKind.ANCESTOR));
            entryGapBlock.setFirstLength(gapFirstLength);
            entryGapBlock.setSecondLength(gapSecondLength);
            entryGapBlock.setAncestorLength(gapAncestorLength);
            this._noChangeBlock.setFirstStart(this._noChangeBlock.getStart(ContributorKind.FIRST) + gapFirstLength);
            this._noChangeBlock.setSecondStart(this._noChangeBlock.getStart(ContributorKind.SECOND) + gapSecondLength);
            this._noChangeBlock.setAncestorStart(this._noChangeBlock.getStart(ContributorKind.ANCESTOR) + gapAncestorLength);
            this._noChangeBlock.setFirstLength(this._noChangeBlock.getLength(ContributorKind.FIRST) - gapFirstLength);
            this._noChangeBlock.setSecondLength(this._noChangeBlock.getLength(ContributorKind.SECOND) - gapSecondLength);
            this._noChangeBlock.setAncestorLength(this._noChangeBlock.getLength(ContributorKind.ANCESTOR) - gapAncestorLength);
            if (!this.hasLength(this._noChangeBlock)) {
                this._noChangeBlock = null;
            }
            return entryGapBlock;
        }

        private boolean hasLength(SequenceCompareDifference differenceBlock) {
            return differenceBlock.getLength(ContributorKind.FIRST) > 0 || differenceBlock.getLength(ContributorKind.SECOND) > 0 || differenceBlock.getLength(ContributorKind.ANCESTOR) > 0;
        }
    }

    private class CompareList {
        private final ContributorKind _contributorKind;
        private final JList _list;

        private void $init$() {
            this._list = new JList(new DefaultListModel());
        }

        CompareList(ContributorKind contributorKind) {
            this.$init$();
            this._contributorKind = contributorKind;
            this._list.setSelectionMode(0);
            this._list.setCellRenderer(new 1());
            this._list.setFixedCellHeight(ListCompareView.ra$_cellHeight(ListCompareView.this));
        }

        Component getGUI() {
            return this._list;
        }

        JList getList() {
            return this._list;
        }

        DefaultListModel getModel() {
            return (DefaultListModel)this._list.getModel();
        }

        static ContributorKind ra$_contributorKind(CompareList compareList) {
            return compareList._contributorKind;
        }

        final class 1
        implements ListCellRenderer {
            private final Cell _cell;
            private final Cell _nullCell;

            private void $init$() {
                this._cell = new Cell();
                this._nullCell = new Cell();
                this._nullCell.getLabel().setOpaque(false);
                this._nullCell.setState(DiffState.ABSENT);
                this._nullCell.setEntryIcon(ListCompareView.mav$getIcon(ListCompareView.this, "SPACER"));
                this._nullCell.getLabel().setVisible(false);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SequenceCompareDifference differenceBlock = ListCompareView.mav$getDifferenceBlockForVirtualIndex(ListCompareView.this, index);
                if (value == null) {
                    this._nullCell.setOutlined(ListCompareView.ra$_currentList(ListCompareView.this).isSelectedIndex(index));
                    return this._nullCell.getGUI();
                }
                DirectoryFile directoryFile = (DirectoryFile)value;
                this._cell.getLabel().setText(directoryFile.getName());
                this._cell.setSelected(isSelected);
                this._cell.setOutlined(differenceBlock != null && differenceBlock.getKind() == 2 && ListCompareView.ra$_currentList(ListCompareView.this).isSelectedIndex(index));
                this._cell.setEntryIcon(ListCompareView.mav$getIcon(ListCompareView.this, directoryFile.isDirectory() ? "DIRECTORY_ICON" : "FILE_ICON"));
                this._cell.setState(ListCompareView.mav$getDiffStateForDifference(ListCompareView.this, differenceBlock, CompareList.ra$_contributorKind(CompareList.this)));
                if (!directoryFile.canRead()) {
                    this._cell.setToolTipText(ListCompareView.this.getBundle().getString("INACCESSIBLE_FILE_WARNING"));
                } else {
                    this._cell.setToolTipText(differenceBlock != null && ListCompareView.mav$getToolTipProvider(ListCompareView.this) != null ? ListCompareView.mav$getToolTipProvider(ListCompareView.this).getToolTipText(CompareList.ra$_contributorKind(CompareList.this), (CompareDifference)differenceBlock) : null);
                }
                this._cell.setRightIcon(directoryFile.canRead() ? null : OracleIcons.getIcon((String)"warning.png"));
                return this._cell.getGUI();
            }

            public 1() {
                this.$init$();
            }
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ ContributorKind v$contributorKind;
        private final /* synthetic */ int v$index;
        final /* synthetic */ ListCompareView this$0;

        public void run() {
            ListCompareView.mav$getCompareList(this.this$0, this.v$contributorKind).getGUI().requestFocus();
            ListCompareView.mav$getCompareList(this.this$0, this.v$contributorKind).getList().setSelectedIndex(this.v$index);
            ListCompareView.mav$getCompareList(this.this$0, this.v$contributorKind).getList().ensureIndexIsVisible(this.v$index);
        }

        public 1(ListCompareView listCompareView, ContributorKind contributorKind, int n) {
            this.v$index = n;
            this.v$contributorKind = contributorKind;
            this.this$0 = listCompareView;
        }
    }

    private class ListDiffGutter
    extends DiffGutter {
        private int _viewportY;

        ListDiffGutter(ContributorKind leftContributorKind, ContributorKind rightContributorKind) {
            super(ListCompareView.this, leftContributorKind, rightContributorKind);
        }

        protected ContributorKind getContributorAtPoint(Point p) {
            return p.x < this.getWidth() / 2 ? this._leftContributorKind : this._rightContributorKind;
        }

        protected CompareDifference getBlockAtPoint(Point p) {
            return ListCompareView.mav$getDifferenceBlockForVirtualIndex(ListCompareView.this, (this._viewportY + p.y) / ListCompareView.ra$_cellHeight(ListCompareView.this));
        }

        void setViewportY(int viewportY) {
            this._viewportY = viewportY;
        }

        public void paint(Graphics g) {
            if (ListCompareView.this.getCompareModel() == null) {
                return;
            }
            Rectangle clipRect = g.getClipBounds();
            int x2 = this.getWidth() / 2;
            Rectangle lRect = new Rectangle(0, 0, x2, ListCompareView.ra$_cellHeight(ListCompareView.this));
            Rectangle rRect = new Rectangle(x2, 0, this.getWidth() - x2, ListCompareView.ra$_cellHeight(ListCompareView.this));
            lRect.translate(0, 0 - this._viewportY);
            rRect.translate(0, 0 - this._viewportY);
            int index = 0;
            Iterator itr = ListCompareView.this.getDiffBlockIterator();
            while (itr.hasNext()) {
                SequenceCompareDifference differenceBlock = (SequenceCompareDifference)itr.next();
                if (clipRect.intersects(lRect)) {
                    g.setColor(ListCompareView.mav$getColorForDiffState(ListCompareView.this, ListCompareView.mav$getDiffStateForDifference(ListCompareView.this, differenceBlock, this._leftContributorKind)));
                    g.fillRect(lRect.x, lRect.y, lRect.width, lRect.height);
                    Icon editIcon = ListCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)differenceBlock, this._leftContributorKind, this._rightContributorKind, true);
                    if (editIcon != null) {
                        editIcon.paintIcon(this, g, (lRect.width - editIcon.getIconWidth()) / 2, lRect.y + (ListCompareView.ra$_cellHeight(ListCompareView.this) - editIcon.getIconHeight()) / 2);
                    }
                }
                if (clipRect.intersects(rRect)) {
                    g.setColor(ListCompareView.mav$getColorForDiffState(ListCompareView.this, ListCompareView.mav$getDiffStateForDifference(ListCompareView.this, differenceBlock, this._rightContributorKind)));
                    g.fillRect(rRect.x, rRect.y, rRect.width, rRect.height);
                    Icon editIcon = ListCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)differenceBlock, this._rightContributorKind, this._leftContributorKind, false);
                    if (editIcon != null) {
                        editIcon.paintIcon(this, g, rRect.x + (rRect.width - editIcon.getIconWidth()) / 2, rRect.y + (ListCompareView.ra$_cellHeight(ListCompareView.this) - editIcon.getIconHeight()) / 2);
                    }
                }
                if (ListCompareView.ra$_currentList(ListCompareView.this).isSelectedIndex(index) && differenceBlock.getKind() == 2) {
                    g.setColor(ColorConstants.COLOR_SEPARATOR);
                    g.drawLine(lRect.x, lRect.y, rRect.x + rRect.width, lRect.y);
                    g.drawLine(lRect.x, lRect.y + lRect.height - 1, rRect.x + rRect.width, lRect.y + lRect.height - 1);
                }
                lRect.translate(0, ListCompareView.ra$_cellHeight(ListCompareView.this));
                rRect.translate(0, ListCompareView.ra$_cellHeight(ListCompareView.this));
                ++index;
            }
            lRect.width = this.getWidth();
            lRect.height = this.getHeight() - lRect.y;
            if (clipRect.intersects(lRect)) {
                g.setColor(ListCompareView.ra$COLOR_UNCHANGED());
                g.fillRect(lRect.x, lRect.y, lRect.width, lRect.height);
            }
        }
    }

    private class AutoScrollChangeListener
    extends ComponentAdapter
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            JViewport viewport = (JViewport)ce.getSource();
            ((ListDiffGutter)ListCompareView.this.getLeftDiffGutter()).setViewportY(viewport.getViewPosition().y);
            if (ListCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                ((ListDiffGutter)ListCompareView.mav$getRightDiffGutter(ListCompareView.this)).setViewportY(viewport.getViewPosition().y);
            }
            ListCompareView.mav$repaintDiffGutters(ListCompareView.this);
            if (ListCompareView.ra$_verticalScrollLock(ListCompareView.this)) {
                return;
            }
            int topLine = (int)Math.ceil((float)viewport.getViewPosition().y / (float)ListCompareView.ra$_cellHeight(ListCompareView.this));
            ContributorKind contributorKind = this.getContributorForViewPort(viewport);
            viewport.removeChangeListener(this);
            ListCompareView.wa$_verticalScrollLock(ListCompareView.this, true);
            try {
                if (contributorKind != ContributorKind.FIRST) {
                    ListCompareView.mav$getLeftScrollPane(ListCompareView.this).getViewport().setViewPosition(new Point(ListCompareView.mav$getLeftScrollPane((ListCompareView)ListCompareView.this).getViewport().getViewPosition().x, viewport.getViewPosition().y));
                }
                if (contributorKind != ContributorKind.SECOND) {
                    ListCompareView.mav$getRightScrollPane(ListCompareView.this).getViewport().setViewPosition(new Point(ListCompareView.mav$getRightScrollPane((ListCompareView)ListCompareView.this).getViewport().getViewPosition().x, viewport.getViewPosition().y));
                }
                if (ListCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE && contributorKind != ContributorKind.ANCESTOR) {
                    ListCompareView.mav$getCenterScrollPane(ListCompareView.this).getViewport().setViewPosition(new Point(ListCompareView.mav$getCenterScrollPane((ListCompareView)ListCompareView.this).getViewport().getViewPosition().x, viewport.getViewPosition().y));
                }
            }
            finally {
                ListCompareView.wa$_verticalScrollLock(ListCompareView.this, false);
            }
            viewport.addChangeListener(this);
            ListCompareView.mav$updateVerticalScrollbar(ListCompareView.this);
            ListCompareView.mav$getVerticalScrollBar(ListCompareView.this).setValue(topLine);
        }

        private ContributorKind getContributorForViewPort(JViewport viewport) {
            if (viewport.getView() == ListCompareView.ra$_leftCompareList(ListCompareView.this).getList()) {
                return ContributorKind.FIRST;
            }
            if (viewport.getView() == ListCompareView.ra$_rightCompareList(ListCompareView.this).getList()) {
                return ContributorKind.SECOND;
            }
            if (ListCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE && viewport.getView() == ListCompareView.ra$_centerCompareList(ListCompareView.this).getList()) {
                return ContributorKind.ANCESTOR;
            }
            return null;
        }

        public void componentResized(ComponentEvent ce) {
            EventQueue.invokeLater(new 1());
        }

        private AutoScrollChangeListener() {
        }

        AutoScrollChangeListener(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            public void run() {
                if (!ListCompareView.ra$_verticalScrollLock(ListCompareView.this)) {
                    ListCompareView.mav$updateVerticalScrollbar(ListCompareView.this);
                }
            }
        }
    }

    private class UniqueSelectionListener
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            JList nextList = (JList)e.getSource();
            boolean clearSelection = nextList != ListCompareView.ra$_currentList(ListCompareView.this);
            ListCompareView.wa$_currentList(ListCompareView.this, nextList);
            if (!clearSelection) {
                return;
            }
            if (ListCompareView.ra$_currentList(ListCompareView.this) != ListCompareView.ra$_leftCompareList(ListCompareView.this).getList()) {
                this.clearSelection(ListCompareView.ra$_leftCompareList(ListCompareView.this));
            }
            if (ListCompareView.ra$_currentList(ListCompareView.this) != ListCompareView.ra$_rightCompareList(ListCompareView.this).getList()) {
                this.clearSelection(ListCompareView.ra$_rightCompareList(ListCompareView.this));
            }
            if (ListCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE && ListCompareView.ra$_currentList(ListCompareView.this) != ListCompareView.ra$_centerCompareList(ListCompareView.this).getList()) {
                this.clearSelection(ListCompareView.ra$_centerCompareList(ListCompareView.this));
            }
        }

        private void clearSelection(CompareList compareList) {
            compareList.getList().clearSelection();
        }

        private UniqueSelectionListener() {
        }

        UniqueSelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PositionListenerImpl
    extends BaseCompareView.PositionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            this.resetTimer();
            int first = lse.getFirstIndex();
            int last = lse.getLastIndex();
            Rectangle r = ListCompareView.ra$_leftCompareList(ListCompareView.this).getList().getCellBounds(first, last);
            if (r != null) {
                ListCompareView.ra$_leftCompareList(ListCompareView.this).getList().repaint(r);
            }
            if ((r = ListCompareView.ra$_rightCompareList(ListCompareView.this).getList().getCellBounds(first, last)) != null) {
                ListCompareView.ra$_rightCompareList(ListCompareView.this).getList().repaint(r);
            }
            if (ListCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE && (r = ListCompareView.ra$_centerCompareList(ListCompareView.this).getList().getCellBounds(first, last)) != null) {
                ListCompareView.ra$_centerCompareList(ListCompareView.this).getList().repaint(r);
            }
            ListCompareView.mav$repaintDiffGutters(ListCompareView.this);
        }

        private PositionListenerImpl() {
        }

        PositionListenerImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (me.getSource() == ListCompareView.ra$_currentList(ListCompareView.this) && me.getButton() == 1 && me.getClickCount() == 2) {
                ListCompareView.mav$fireDefaultAction(ListCompareView.this);
            }
            this.handleMouseEvent(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.handleMouseEvent(me);
        }

        private void handleMouseEvent(MouseEvent me) {
            if (!me.isPopupTrigger() || ListCompareView.ra$_popupManager(ListCompareView.this) == null) {
                return;
            }
            JList list = (JList)me.getSource();
            int index = me.getPoint().y / ListCompareView.ra$_cellHeight(ListCompareView.this);
            if (index < list.getModel().getSize()) {
                list.requestFocus();
                list.setSelectedIndex(index);
                EventQueue.invokeLater(new 1());
            }
            EventQueue.invokeLater(new 2(this, me));
        }

        private ListMouseHandler() {
        }

        ListMouseHandler(2 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            public void run() {
                ListCompareView.mav$firePositionChanged(ListCompareView.this);
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ MouseEvent v$me;
            final /* synthetic */ ListMouseHandler this$0;

            public void run() {
                ListCompareView.ra$_popupManager(this.this$0.ListCompareView.this).showPopup(this.v$me);
            }

            public 2(ListMouseHandler listMouseHandler, MouseEvent mouseEvent) {
                this.v$me = mouseEvent;
                this.this$0 = listMouseHandler;
            }
        }
    }
}

