/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.wedge.EditorHighlighter;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;

class TextPane
extends BasicEditorPane
implements PropertyChangeListener {
    private SequenceCompareModel _model;
    private final ContributorKind _contributor;
    private ContributorKind _adjacentContributor;
    private EditorHighlighter _highlightPlugin;
    private boolean _reverseHighlight;
    private SequenceCompareDifference _currentBlock;
    private final CompareViewBias _bias;

    protected TextPane(ContributorKind contributor, CompareViewBias bias) {
        this._contributor = contributor;
        this._bias = bias;
        this.setEditorKit(new BasicEditorKit());
        if (contributor == ContributorKind.FIRST) {
            this.setMargin(new Insets(0, 2, 2, 0));
        } else {
            this.setMargin(new Insets(0, 0, 2, 2));
        }
        this.setThreePaneMode(false);
        this.addPropertyChangeListener(this);
        this.setBorder(null);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("style-registry")) {
            this.setStyleRegistry(EditorProperties.getProperties().getStyleRegistry());
            this.updateColors();
        }
    }

    EditorHighlighter getBlockHighlighter() {
        return this._highlightPlugin;
    }

    void setThreePaneMode(boolean threePaneMode) {
        if (threePaneMode) {
            boolean bl = this._reverseHighlight = this._contributor == ContributorKind.ANCESTOR;
            this._adjacentContributor = this._contributor == ContributorKind.FIRST ? ContributorKind.ANCESTOR : (this._contributor == ContributorKind.SECOND ? ContributorKind.ANCESTOR : null);
        } else {
            this._reverseHighlight = this._contributor == ContributorKind.FIRST;
            ContributorKind contributorKind = this._adjacentContributor = this._contributor == ContributorKind.FIRST ? ContributorKind.SECOND : ContributorKind.FIRST;
        }
        if (this._model != null) {
            this.updateModel(this._model);
        }
    }

    void setCurrentBlock(SequenceCompareDifference block) {
        if (this._currentBlock != null && this._highlightPlugin != null) {
            this._highlightPlugin.updateBlockBorders(this._currentBlock, this._contributor, false);
        }
        this._currentBlock = block;
        if (block != null && this._highlightPlugin != null) {
            this._highlightPlugin.updateBlockBorders(block, this._contributor, true);
        }
    }

    protected final TextCompareContributor getContributor() {
        return (TextCompareContributor)this._model.getContributor(this._contributor);
    }

    protected final ContributorKind getContributorKind() {
        return this._contributor;
    }

    protected final SequenceCompareModel getModel() {
        return this._model;
    }

    final void setModel(SequenceCompareModel model) {
        if (model == null || this._model != model) {
            this.cleanUp();
        }
        if (model != null) {
            this._model = model;
            this.installModel();
        }
    }

    final void updateModel(SequenceCompareModel model) {
        this._model = model;
        if (this._highlightPlugin != null) {
            this._highlightPlugin.setDifferences(model, this._currentBlock, this.getContributorKind(), this._adjacentContributor, this._reverseHighlight, this._bias);
        }
    }

    protected void installHighlights() {
        this._highlightPlugin = this.createBlockHighlighter();
        this.installPlugin(this._highlightPlugin);
        this._highlightPlugin.setDifferences(this.getModel(), this._currentBlock, this.getContributorKind(), this._adjacentContributor, this._reverseHighlight, this._bias);
    }

    protected void cleanUp() {
        if (this._highlightPlugin != null) {
            this.deinstallPlugin(this._highlightPlugin);
            this._highlightPlugin = null;
        }
        this._model = null;
    }

    protected BasicDocument createDocument(TextBuffer buffer) {
        StringBuffer name = new StringBuffer();
        name.append("x.");
        name.append(this.getContributor().getType());
        return new BasicDocument(name.toString(), buffer);
    }

    protected void installModel() {
        if (this.getContributor() != null) {
            this.setDocument(this.createDocument(this.getContributor().getTextBuffer()));
            this.installHighlights();
        }
    }

    protected EditorHighlighter createBlockHighlighter() {
        return new EditorHighlighter();
    }
}

