/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareHintListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.DiffGutter;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.SequenceCompareView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.ViewMemento;
import oracle.javatools.compare.view.wedge.EditorHighlighter;
import oracle.javatools.compare.view.wedge.InlineCompareModel;
import oracle.javatools.compare.view.wedge.InlineDiffHighlighter;
import oracle.javatools.compare.view.wedge.OffsetDifferenceBlock;
import oracle.javatools.compare.view.wedge.TextPane;
import oracle.javatools.controls.EditorPeekPopup;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class WedgeCompareView
extends SequenceCompareView
implements EditorPaneView,
ToolTipProvider {
    private static final int WEDGE_EDGE_SIZE = 16;
    private static final String PROPERTY_UNDO_MOMENTO = "wedgeCompareUndoMemento";
    private static final String PROPERTY_REDO_MOMENTO = "wedgeCompareRedoMemento";
    private final CustomViewport _leftGutter;
    private final CustomViewport _rightGutter;
    private final CustomViewport _leftEditor;
    private final CustomViewport _rightEditor;
    private CustomViewport _centerEditor;
    private CompareHintListener _compareHintListener;
    private final TextPane _leftPane;
    private final TextPane _rightPane;
    private TextPane _centerPane;
    private InlineDiffHighlighter _leftInlineHilite;
    private InlineDiffHighlighter _rightInlineHilite;
    private InlineDiffHighlighter _centerInlineHilite;
    private final LineGutterPlugin _leftGutterPlugin;
    private final LineGutterPlugin _rightGutterPlugin;
    private int _textPaneFontHeight;
    private boolean _verticalScrollLock;
    private Boolean _showInlineCharDiffs;
    private TextBufferListener _resolveOnEditListener;
    private SequenceCompareDifference _currentBlock;
    private TextPane _currentTextPane;
    private final BlockActivationListener _activationListener;
    private final PositionListenerImpl _positionListener;
    private final AutoScrollChangeListener _cl;
    private final BaseCompareView.CentralGutterMouseHandler _gutterHandler;
    private ViewMemento _currentMemento;
    private OffsetsMemento _currentOffsetsMemento;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._leftGutter = new CustomViewport();
        this._rightGutter = new CustomViewport();
        this._leftEditor = new CustomViewport(ContributorKind.FIRST);
        this._rightEditor = new CustomViewport(ContributorKind.SECOND);
        this._compareHintListener = null;
        this._leftInlineHilite = null;
        this._rightInlineHilite = null;
        this._centerInlineHilite = null;
        this._leftGutterPlugin = new LineGutterPlugin();
        this._rightGutterPlugin = new LineGutterPlugin();
        this._verticalScrollLock = false;
    }

    public WedgeCompareView() {
        this(CompareMode.TWO_WAY_COMPARE);
    }

    public WedgeCompareView(CompareMode mode) {
        this(mode, CompareViewBias.RIGHT);
    }

    public WedgeCompareView(CompareMode mode, CompareViewBias bias) {
        super(mode, bias);
        this.$init$();
        this._leftPane = new TextPane(ContributorKind.FIRST, bias);
        this._rightPane = new TextPane(ContributorKind.SECOND, bias);
        if (mode == CompareMode.TWO_WAY_COMPARE) {
            this.setLeftDiffGutter(new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.SECOND));
            this.setRightDiffGutter(null);
            this._centerEditor = null;
            this._centerPane = null;
            this.setThreePaneMode(false);
        }
        if (mode == CompareMode.THREE_WAY_MERGE) {
            this.setLeftDiffGutter(new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.ANCESTOR));
            this.setRightDiffGutter(new WedgeDiffGutter(ContributorKind.ANCESTOR, ContributorKind.SECOND));
            this._centerEditor = new CustomViewport(ContributorKind.ANCESTOR);
            this._centerPane = new TextPane(ContributorKind.ANCESTOR, bias);
            this.setThreePaneMode(true);
        }
        this.setLeftScrollPane(this.createHorizontalScrollPane(this._leftEditor));
        this.setRightScrollPane(this.createHorizontalScrollPane(this._rightEditor));
        if (this._centerEditor != null) {
            this.setCenterScrollPane(this.createHorizontalScrollPane(this._centerEditor));
        }
        this.getSplitPanel().add((Component)this._leftGutter, "leftGutter");
        this.getSplitPanel().add((Component)this._rightGutter, "rightGutter");
        this.getSplitPanel().add((Component)this.getLeftScrollPane(), "leftEditor");
        this.getSplitPanel().add((Component)this.getRightScrollPane(), "rightEditor");
        this.getSplitPanel().add((Component)this.getLeftTitle(), "leftTitle");
        this.getSplitPanel().add((Component)this.getCenterTitle(), "centerTitle");
        if (this._centerEditor != null) {
            this.getSplitPanel().add((Component)this.getCenterScrollPane(), "centerEditor");
        }
        this.getSplitPanel().add((Component)this.getRightTitle(), "rightTitle");
        this.getSplitPanel().add((Component)this.getLeftDiffGutter(), "leftSplit");
        if (this.getRightDiffGutter() != null) {
            this.getSplitPanel().add((Component)this.getRightDiffGutter(), "centerSplit");
        }
        this.getSplitPanel().add((Component)this.getLeftOverview(), "leftOverview");
        this.getSplitPanel().add((Component)this.getRightOverview(), "rightOverview");
        this.getSplitPanel().add((Component)this.getVerticalScrollPanel(), "rightScrollbar");
        this._leftGutter.setView(this._leftGutterPlugin);
        this._rightGutter.setView(this._rightGutterPlugin);
        this._leftEditor.setView(this._leftPane);
        this._rightEditor.setView(this._rightPane);
        if (this._centerEditor != null) {
            this._centerEditor.setView(this._centerPane);
        }
        this._leftEditor.setBackground(this._leftPane.getBackground());
        this._rightEditor.setBackground(this._leftEditor.getBackground());
        if (this._centerEditor != null) {
            this._centerEditor.setBackground(this._leftEditor.getBackground());
        }
        this._rightGutterPlugin.setLocation(4);
        this.updateFontMetrics();
        this._cl = new AutoScrollChangeListener(null);
        this._gutterHandler = new BaseCompareView.CentralGutterMouseHandler();
        this._activationListener = new BlockActivationListener(null);
        this._positionListener = new PositionListenerImpl(null);
        this.install();
        if (mode == CompareMode.THREE_WAY_MERGE) {
            this._resolveOnEditListener = new ResolveOnEditTextBufferListener(null);
        }
        this._currentTextPane = this._leftPane;
    }

    private void install() {
        this._leftEditor.addChangeListener(this._cl);
        this._rightEditor.addChangeListener(this._cl);
        this._leftPane.addFocusListener(this._activationListener);
        this._leftPane.addCaretListener(this._activationListener);
        this._rightPane.addFocusListener(this._activationListener);
        this._rightPane.addCaretListener(this._activationListener);
        this._leftPane.addToolTipProvider(this);
        this._rightPane.addToolTipProvider(this);
        this._leftPane.addFocusListener(this._positionListener);
        this._leftPane.addCaretListener(this._positionListener);
        this._rightPane.addFocusListener(this._positionListener);
        this._rightPane.addCaretListener(this._positionListener);
        this.getLeftDiffGutter().addMouseListener(this._gutterHandler);
        if (this.getRightDiffGutter() != null) {
            this.getRightDiffGutter().addMouseListener(this._gutterHandler);
        }
        if (this._centerEditor == null) {
            return;
        }
        this._centerEditor.addChangeListener(this._cl);
        this._centerPane.addFocusListener(this._activationListener);
        this._centerPane.addCaretListener(this._activationListener);
        this._centerPane.addToolTipProvider(this);
        this._centerPane.addFocusListener(this._positionListener);
        this._centerPane.addCaretListener(this._positionListener);
    }

    public void dispose() {
        this._leftEditor.removeChangeListener(this._cl);
        this._rightEditor.removeChangeListener(this._cl);
        this._leftPane.removeFocusListener(this._activationListener);
        this._leftPane.removeCaretListener(this._activationListener);
        this._rightPane.removeFocusListener(this._activationListener);
        this._rightPane.removeCaretListener(this._activationListener);
        this._leftPane.removeToolTipProvider(this);
        this._rightPane.removeToolTipProvider(this);
        this._leftPane.removeFocusListener(this._positionListener);
        this._leftPane.removeCaretListener(this._positionListener);
        this._rightPane.removeFocusListener(this._positionListener);
        this._rightPane.removeCaretListener(this._positionListener);
        this.getLeftDiffGutter().removeMouseListener(this._gutterHandler);
        if (this.getRightDiffGutter() != null) {
            this.getRightDiffGutter().removeMouseListener(this._gutterHandler);
        }
        if (this._centerEditor != null) {
            this._centerEditor.removeChangeListener(this._cl);
            this._centerPane.removeFocusListener(this._activationListener);
            this._centerPane.removeCaretListener(this._activationListener);
            this._centerPane.removeToolTipProvider(this);
            this._centerPane.removeFocusListener(this._positionListener);
            this._centerPane.removeCaretListener(this._positionListener);
        }
        super.dispose();
    }

    protected void createOverviews() {
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            this._leftOverview = new WedgeOverviewComponent(ContributorKind.FIRST, ContributorKind.SECOND);
            this._rightOverview = new WedgeOverviewComponent(ContributorKind.SECOND, ContributorKind.FIRST);
        } else {
            this._leftOverview = new WedgeOverviewComponent(ContributorKind.FIRST, ContributorKind.ANCESTOR);
            this._rightOverview = new WedgeOverviewComponent(ContributorKind.SECOND, ContributorKind.ANCESTOR);
        }
        this.initializeOverview(this._leftOverview);
        this.initializeOverview(this._rightOverview);
    }

    private void evaluateOffsets(CompareModel compareModel) {
        int i = 0;
        while (i < compareModel.getDifferences().length) {
            if (compareModel.getDifferences()[i] instanceof OffsetDifferenceBlock) {
                ((OffsetDifferenceBlock)compareModel.getDifferences()[i]).evaluateOffsets();
            }
            ++i;
        }
    }

    protected Color getOverviewDifferenceColor(SequenceCompareDifference differenceBlock, boolean isLeft, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
        HighlightStyle style;
        if (isLeft) {
            ContributorKind tempKind = firstContributorKind;
            firstContributorKind = secondContributorKind;
            secondContributorKind = tempKind;
        }
        if ((style = EditorHighlighter.getStyle((SequenceCompareModel)this.getCompareModel(), differenceBlock, firstContributorKind, secondContributorKind, secondContributorKind, this.getBias())) != null && style.getEnabled()) {
            return style.getBackgroundColor();
        }
        return null;
    }

    private void clearInlineHighLighters() {
        if (this._leftInlineHilite != null) {
            this._leftPane.deinstallPlugin(this._leftInlineHilite);
            this._rightPane.deinstallPlugin(this._rightInlineHilite);
            this._leftInlineHilite = null;
            this._rightInlineHilite = null;
        }
    }

    private void repaintEditors() {
        EventQueue.invokeLater(new 1());
    }

    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        if (this.getToolTipProvider() == null) {
            return null;
        }
        TextPane textPane = (TextPane)editorPane;
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        SequenceCompareDifference difference = this.getBlockAtRealLine(textPane, this.getTextContributor(contributorKind).getTextBuffer().getLineMap().getLineFromOffset(offset));
        return difference != null ? this.getToolTipProvider().getToolTipText(contributorKind, (CompareDifference)difference) : null;
    }

    public void addViewEditListener(ViewEditListener l) {
        EditListenerAdapter editListener = new EditListenerAdapter(l);
        this.addViewEditListener(editListener, ContributorKind.FIRST);
        this.addViewEditListener(editListener, ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.addViewEditListener(editListener, ContributorKind.ANCESTOR);
        }
        this.getUndoableEditListeners().add(editListener);
    }

    private void addViewEditListener(EditListenerAdapter l, ContributorKind contributorKind) {
        Document jdkDoc = this.getDocument(contributorKind);
        if (!(jdkDoc instanceof BasicDocument)) {
            return;
        }
        BasicDocument basicDoc = (BasicDocument)jdkDoc;
        basicDoc.addUndoableEditListener(l);
    }

    public void removeViewEditListener(ViewEditListener l) {
        EditListenerAdapter editListener = null;
        for (EditListenerAdapter currentEditListener : this.getUndoableEditListeners()) {
            if (currentEditListener.getViewEditListener() != l) continue;
            editListener = currentEditListener;
            break;
        }
        if (editListener == null) {
            return;
        }
        this.removeViewEditListener(editListener, ContributorKind.FIRST);
        this.removeViewEditListener(editListener, ContributorKind.SECOND);
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            this.removeViewEditListener(editListener, ContributorKind.ANCESTOR);
        }
        this.getUndoableEditListeners().remove(editListener);
    }

    private void removeViewEditListener(EditListenerAdapter l, ContributorKind contributorKind) {
        Document jdkDoc = this.getDocument(contributorKind);
        if (!(jdkDoc instanceof BasicDocument)) {
            return;
        }
        BasicDocument basicDoc = (BasicDocument)jdkDoc;
        basicDoc.removeUndoableEditListener(l);
    }

    protected ViewEditListener[] getViewEditListeners() {
        ArrayList<ViewEditListener> viewEditListeners = new ArrayList<ViewEditListener>();
        Iterator itr = this.getUndoableEditListeners().iterator();
        while (itr.hasNext()) {
            viewEditListeners.add(((EditListenerAdapter)itr.next()).getViewEditListener());
        }
        return viewEditListeners.toArray(new ViewEditListener[0]);
    }

    private ContributorKind getTextContributor(Document jdkDoc) {
        if (jdkDoc == this.getDocument(ContributorKind.FIRST)) {
            return ContributorKind.FIRST;
        }
        if (jdkDoc == this.getDocument(ContributorKind.SECOND)) {
            return ContributorKind.SECOND;
        }
        if (jdkDoc == this.getDocument(ContributorKind.ANCESTOR)) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    protected CompareModel createModel(CompareModel compareModel, CompareDifference[] differences) {
        compareModel = super.createModel(compareModel, differences);
        this.evaluateOffsets(compareModel);
        return compareModel;
    }

    private void setThreePaneMode(boolean threePanes) {
        this._leftPane.setThreePaneMode(threePanes);
        this._rightPane.setThreePaneMode(threePanes);
        if (this._centerPane != null) {
            this._centerPane.setThreePaneMode(threePanes);
        }
        this.getSplitPanel().setThreePaneMode(threePanes);
    }

    private void setCurrentBlock(SequenceCompareDifference block) {
        if (this._currentBlock != block) {
            this._currentBlock = block;
            this._leftPane.setCurrentBlock(block);
            this._rightPane.setCurrentBlock(block);
            if (this._centerPane != null) {
                this._centerPane.setCurrentBlock(block);
            }
            this.repaintDiffGutters();
            if (this.isShowInlineCharDiffs()) {
                this.clearInlineHighLighters();
                if (this._centerPane != null && this._centerInlineHilite != null) {
                    this._centerPane.deinstallPlugin(this._centerInlineHilite);
                    this._centerInlineHilite = null;
                }
                if (block != null && block.getKind() == 2) {
                    this.showInlineDifferences(block);
                }
            }
        }
    }

    private void showInlineDifferences(SequenceCompareDifference block) {
        try {
            InlineCompareModel inlineDiffs = InlineCompareModel.buildModel((SequenceCompareModel)this.getCompareModel(), block);
            this._leftInlineHilite = new InlineDiffHighlighter(ContributorKind.FIRST, this.getBias());
            this._rightInlineHilite = new InlineDiffHighlighter(ContributorKind.SECOND, this.getBias());
            if (this._centerPane != null) {
                this._centerInlineHilite = new InlineDiffHighlighter(ContributorKind.ANCESTOR, this.getBias());
            }
            this._leftPane.installPlugin(this._leftInlineHilite);
            this._rightPane.installPlugin(this._rightInlineHilite);
            if (this._centerInlineHilite != null) {
                this._centerPane.installPlugin(this._centerInlineHilite);
            }
            this._leftInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.FIRST).getTextBuffer());
            this._rightInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.SECOND).getTextBuffer());
            if (this._centerInlineHilite != null) {
                this._centerInlineHilite.setModel(inlineDiffs, this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer());
            }
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
        }
    }

    private SequenceCompareDifference getBlockAtRealLine(TextPane textPane, int line) {
        ContributorKind contributor = this.getContributorForPane(textPane);
        Iterator i = this.getDiffBlockIterator();
        while (i.hasNext()) {
            SequenceCompareDifference block = (SequenceCompareDifference)i.next();
            if (line < block.getStart(contributor) || line >= block.getStart(contributor) + Math.max(1, block.getLength(contributor))) continue;
            if (block.getKind() == 0) {
                return null;
            }
            return block;
        }
        return null;
    }

    private void updateCurrentBlock() {
        int maxLine;
        if (this._currentTextPane == null) {
            return;
        }
        LineMap lineMap = this.getTextContributor(this.getContributorForPane(this._currentTextPane)).getTextBuffer().getLineMap();
        int minLine = lineMap.getLineFromOffset(this._currentTextPane.getSelectionStart());
        if (minLine == (maxLine = lineMap.getLineFromOffset(this._currentTextPane.getSelectionEnd()))) {
            this.setCurrentBlock(this.getBlockAtRealLine(this._currentTextPane, minLine));
        } else {
            SequenceCompareDifference maxDiffererenceBlock;
            SequenceCompareDifference minDiffererenceBlock;
            if (lineMap.getLineStartOffset(maxLine) == this._currentTextPane.getSelectionEnd()) {
                maxLine = Math.max(minLine, maxLine - 1);
            }
            this.setCurrentBlock((SequenceCompareDifference)((minDiffererenceBlock = this.getBlockAtRealLine(this._currentTextPane, minLine)) == (maxDiffererenceBlock = this.getBlockAtRealLine(this._currentTextPane, maxLine)) ? minDiffererenceBlock : null));
        }
    }

    public void setEditLocked(boolean isLocked) {
        super.setEditLocked(isLocked);
        this._leftPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.FIRST) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.FIRST)).isEditable());
        this._rightPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.SECOND) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.SECOND)).isEditable());
        if (this._centerPane == null) {
            return;
        }
        if (this.getTextContributor(ContributorKind.ANCESTOR) == null) {
            this._centerPane.setEditable(false);
        } else {
            this._centerPane.setEditable(isLocked ? false : this.getTextContributor(ContributorKind.ANCESTOR) instanceof EditableContributor && ((EditableContributor)this.getTextContributor(ContributorKind.ANCESTOR)).isEditable());
        }
    }

    private void updateFontMetrics() {
        this._textPaneFontHeight = this._leftPane.getFontMetrics(this._leftPane.getFont()).getHeight();
    }

    private void moveCaretToBlock(SequenceCompareDifference block, ContributorKind contributor) {
        TextCompareContributor textCompareContributor = this.getTextContributor(contributor);
        if (textCompareContributor == null) {
            return;
        }
        if (block.getStart(contributor) < 0 || block.getLength(contributor) < 0) {
            return;
        }
        LineMap lineMap = textCompareContributor.getTextBuffer().getLineMap();
        if (this.canSelectBlockOnMoveCaret(block, contributor)) {
            int lineEndOffset = lineMap.getLineEndOffset(block.getStart(contributor) + block.getLength(contributor) - 1);
            int lineStartOffset = lineMap.getLineStartOffset(block.getStart(contributor));
            this.getTextPane(contributor).setCaretPosition(lineEndOffset);
            this.getTextPane(contributor).moveCaretPosition(lineStartOffset);
        } else {
            this.getTextPane(contributor).setCaretPosition(lineMap.getLineStartOffset(block.getStart(contributor)));
        }
    }

    private boolean canSelectBlockOnMoveCaret(SequenceCompareDifference block, ContributorKind contributor) {
        if (this.isShowInlineCharDiffs() || block.getLength(contributor) <= 0) {
            return false;
        }
        return this.getTextPane(contributor) == this._currentTextPane;
    }

    private boolean isTextPaneFocusOwner() {
        return this._leftPane.isFocusOwner() || this._rightPane.isFocusOwner() || this._centerPane != null && this._centerPane.isFocusOwner();
    }

    private TextPane getTextPane(ContributorKind contributor) {
        if (contributor == ContributorKind.FIRST) {
            return this._leftPane;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._rightPane;
        }
        if (contributor == ContributorKind.ANCESTOR) {
            return this._centerPane;
        }
        return null;
    }

    private CustomViewport getViewPort(ContributorKind contributor) {
        if (contributor == ContributorKind.FIRST) {
            return this._leftEditor;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._rightEditor;
        }
        if (contributor == ContributorKind.ANCESTOR) {
            return this._centerEditor;
        }
        return null;
    }

    private CustomViewport getGutterViewportFor(JViewport editorViewport) {
        if (editorViewport == this._leftEditor) {
            return this._leftGutter;
        }
        if (editorViewport == this._rightEditor) {
            return this._rightGutter;
        }
        return null;
    }

    private ContributorKind getContributorForViewPort(JViewport viewPort) {
        if (viewPort == this._leftEditor) {
            return ContributorKind.FIRST;
        }
        if (viewPort == this._rightEditor) {
            return ContributorKind.SECOND;
        }
        if (this._centerEditor != null && viewPort == this._centerEditor) {
            return ContributorKind.ANCESTOR;
        }
        return null;
    }

    protected void verticalScrollTo(int virtualLine) {
        if (this._verticalScrollLock) {
            return;
        }
        try {
            this._verticalScrollLock = true;
            int leftRealLine = 0;
            int rightRealLine = 0;
            int ancestorRealLine = 0;
            int virtualHeight = 0;
            Iterator i = this.getDiffBlockIterator();
            while (i.hasNext()) {
                SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                int distance = thisBlock.getMaxLength();
                leftRealLine += thisBlock.getLength(ContributorKind.FIRST);
                rightRealLine += thisBlock.getLength(ContributorKind.SECOND);
                ancestorRealLine += thisBlock.getLength(ContributorKind.ANCESTOR);
                if ((virtualHeight += distance) < virtualLine) continue;
                int adjust = virtualHeight - virtualLine;
                leftRealLine -= Math.min(thisBlock.getLength(ContributorKind.FIRST), adjust);
                rightRealLine -= Math.min(thisBlock.getLength(ContributorKind.SECOND), adjust);
                ancestorRealLine -= Math.min(thisBlock.getLength(ContributorKind.ANCESTOR), adjust);
                break;
            }
            int pixelPosLeft = leftRealLine * this._textPaneFontHeight;
            int pixelPosRight = rightRealLine * this._textPaneFontHeight;
            int pixelPosAncestor = ancestorRealLine * this._textPaneFontHeight;
            CustomViewport leftEditor = this.getViewPort(ContributorKind.FIRST);
            CustomViewport rightEditor = this.getViewPort(ContributorKind.SECOND);
            CustomViewport ancestorEditor = this.getViewPort(ContributorKind.ANCESTOR);
            leftEditor.setViewPositionImpl(new Point(leftEditor.getViewPosition().x, pixelPosLeft));
            rightEditor.setViewPositionImpl(new Point(rightEditor.getViewPosition().x, pixelPosRight));
            if (ancestorEditor != null) {
                ancestorEditor.setViewPositionImpl(new Point(ancestorEditor.getViewPosition().x, pixelPosAncestor));
            }
            this.repaintDiffGutters();
            this.getVerticalScrollBar().setValue(virtualLine);
        }
        finally {
            this._verticalScrollLock = false;
        }
    }

    protected void updateCurrentMemento() {
        this._currentMemento = this.createMemento();
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return;
        }
        this._currentOffsetsMemento = new OffsetsMemento(null);
        CompareDifference[] compareDifferenceArray = this.getCompareModel().getDifferences();
        int n = 0;
        while (n < compareDifferenceArray.length) {
            CompareDifference compareDifference = compareDifferenceArray[n];
            SequenceCompareDifference block = (SequenceCompareDifference)compareDifference;
            TextBuffer textBuffer = this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            this._currentOffsetsMemento.setStartOffset(compareDifference, lineMap.getLineStartOffset(block.getStart(ContributorKind.ANCESTOR)));
            int endOffset = lineMap.getLineStartOffset(block.getStart(ContributorKind.ANCESTOR) + Math.max(1, block.getLength(ContributorKind.ANCESTOR)));
            this._currentOffsetsMemento.setEndOffset(compareDifference, endOffset >= 0 ? endOffset : textBuffer.getLength());
            ++n;
        }
    }

    protected void updateModelImpl() {
        this._currentBlock = null;
        this.updateTextPaneModel(this._leftPane);
        this.updateTextPaneModel(this._rightPane);
        if (this._centerPane != null) {
            this.updateTextPaneModel(this._centerPane);
        }
        this.updateCurrentBlock();
        this.updateCurrentMemento();
    }

    private void updateTextPaneModel(TextPane textPane) {
        int caretPos = textPane.getCaret().getDot();
        int selectionStart = textPane.getSelectionStart();
        int selectionEnd = textPane.getSelectionEnd();
        this._verticalScrollLock = true;
        if (selectionEnd <= selectionStart) {
            textPane.setSelectionStart(caretPos);
            textPane.setSelectionEnd(caretPos);
        } else {
            textPane.setSelectionStart(selectionStart);
            textPane.setSelectionEnd(selectionEnd);
        }
        this._verticalScrollLock = false;
        textPane.updateModel((SequenceCompareModel)this.getCompareModel());
    }

    static {
        $assertionsDisabled = WedgeCompareView.class.desiredAssertionStatus() ^ true;
    }

    protected void initializeView(CompareModel model) {
        if (model != null && !$assertionsDisabled && model.getType() != CompareType.TEXT && model.getType() != CompareType.DIRECTORY) {
            throw new AssertionError();
        }
        if (this.getCompareModel() == null && model != null) {
            2 fontUpdatePlugin = new 2();
            this._leftPane.installPlugin(fontUpdatePlugin);
            this.addCompareHintListener();
        }
        if (this.getCompareModel() != null) {
            this._leftPane.deinstallPlugin(this._leftGutterPlugin);
            this._rightPane.deinstallPlugin(this._rightGutterPlugin);
        }
        this._currentBlock = null;
        this.setCompareModel(model);
        this._leftPane.setModel((SequenceCompareModel)this.getCompareModel());
        this._rightPane.setModel((SequenceCompareModel)this.getCompareModel());
        if (this._centerPane != null) {
            if (this._resolveOnEditListener != null) {
                this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer().removeTextBufferListener(this._resolveOnEditListener);
            }
            this._centerPane.setModel((SequenceCompareModel)this.getCompareModel());
            if (this._resolveOnEditListener != null) {
                this.getTextContributor(ContributorKind.ANCESTOR).getTextBuffer().addTextBufferListener(this._resolveOnEditListener);
            }
        }
        if (model != null) {
            this._leftPane.installPlugin(this._leftGutterPlugin);
            this._rightPane.installPlugin(this._rightGutterPlugin);
            this.setEditLocked(false);
            this.repaintDiffGutters();
        }
        if (model == null) {
            CompareHints.removeListener((CompareHintListener)this._compareHintListener);
            this._compareHintListener = null;
        }
        if (model != null && model.getType() == CompareType.DIRECTORY) {
            this._leftGutterPlugin.setShowLineNumbers(2);
            this._rightGutterPlugin.setShowLineNumbers(2);
            this._leftPane.setEditable(false);
            this._rightPane.setEditable(false);
            if (this._centerPane != null) {
                this._centerPane.setEditable(false);
            }
            this._leftPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            this._rightPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            if (this._centerPane != null) {
                this._centerPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            }
        }
        this.updateCurrentMemento();
    }

    protected CompareModel createMutableModel(CompareModel compareModel) {
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
            compareModel = ((SequenceCompareModel)compareModel).createInstance((CompareDifference[])OffsetDifferenceBlock.createOffsetDifferenceBlocks(((SequenceCompareModel)compareModel).getDifferenceBlocks(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.FIRST)).getTextBuffer(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.SECOND)).getTextBuffer(), ((TextCompareContributor)compareModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer()));
            this.evaluateOffsets(compareModel);
        }
        return compareModel;
    }

    private void addCompareHintListener() {
        if (this._compareHintListener == null) {
            this._compareHintListener = new HintListener(null);
        }
        CompareHints.addListener((CompareHintListener)this._compareHintListener);
    }

    private TextCompareContributor getTextContributor(ContributorKind contrib) {
        return (TextCompareContributor)this.getContributor(contrib);
    }

    public Document getDocument(ContributorKind contrib) {
        return this.getTextPane(contrib).getDocument();
    }

    private void updateVerticalScrollbar() {
        int virtualHeight = this.getVirtualHeightLines(null);
        this.getVerticalScrollBar().setMaximum(virtualHeight);
        int visibleLineCount = this.getLeftScrollPane().getViewport().getViewRect().height / this._textPaneFontHeight;
        this.getVerticalScrollBar().setVisibleAmount(visibleLineCount);
        this.getVerticalScrollBar().setBlockIncrement(visibleLineCount - 1);
        if (visibleLineCount < virtualHeight) {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalScrollbar");
        } else {
            this.getVerticalScrollCardLayout().show(this.getVerticalScrollPanel(), "verticalSpacer");
        }
    }

    protected boolean isViewFocusOwner() {
        return this.isTextPaneFocusOwner();
    }

    protected void deleteBlock(BaseCompareDifference difference, ContributorKind contributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        TextCompareContributor tcc = this.getTextContributor(contributor);
        TextPane pane = this.getTextPane(contributor);
        UndoableEdit contributorEdit = null;
        try {
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("REMOVE_ACTION_NAME")));
            TextBuffer buffer = tcc.getTextBuffer();
            int start = block.getStart(contributor);
            int end = block.getStart(contributor) + block.getLength(contributor) - 1;
            int startCaretPos = buffer.getLineMap().getLineStartOffset(start);
            MergeEditState mergeEditState = this.mergePreEdit(block, contributor, 0);
            contributorEdit = tcc.deleteElement(start, end);
            this.mergePostEdit(block, contributor, mergeEditState);
            this.getTextPane(contributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(contributor).setCaretPosition(startCaretPos);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, contributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, contributor);
    }

    protected void insertBlockCopy(BaseCompareDifference difference, ContributorKind fromContributor, ContributorKind toContributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        TextCompareContributor tcc = this.getTextContributor(toContributor);
        TextPane pane = this.getTextPane(toContributor);
        SequenceCompareElement element = this.getTextContributor(fromContributor).getElement(block, fromContributor);
        UndoableEdit contributorEdit = null;
        try {
            boolean after;
            int index;
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("INSERT_ACTION_NAME")));
            TextBuffer toBuffer = tcc.getTextBuffer();
            if (block.getLength(toContributor) == 0) {
                index = block.getStart(toContributor);
                after = false;
            } else {
                index = block.getStart(toContributor) + block.getLength(toContributor) - 1;
                after = true;
            }
            int indexCaretPos = !after ? toBuffer.getLineMap().getLineStartOffset(index) : toBuffer.getLineMap().getLineEndOffset(index);
            MergeEditState mergeEditState = this.mergePreEdit(block, toContributor, block.getLength(fromContributor) + block.getLength(toContributor));
            contributorEdit = tcc.insertElement(index, after, element);
            this.mergePostEdit(block, toContributor, mergeEditState);
            this.getTextPane(toContributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(toContributor).setCaretPosition(indexCaretPos);
            this.getTextPane(toContributor).moveCaretPosition(indexCaretPos + ((char[])element.getData()).length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, toContributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, toContributor);
    }

    protected void replaceBlock(BaseCompareDifference difference, ContributorKind fromContributor, ContributorKind toContributor) {
        SequenceCompareDifference block = (SequenceCompareDifference)difference;
        TextCompareContributor tcc = this.getTextContributor(toContributor);
        TextPane pane = this.getTextPane(toContributor);
        SequenceCompareElement element = this.getTextContributor(fromContributor).getElement(block, fromContributor);
        UndoableEdit contributorEdit = null;
        try {
            pane.beginEdit(new EditDescriptor(this.getBundle().getString("REPLACE_ACTION_NAME")));
            TextBuffer toBuffer = tcc.getTextBuffer();
            int start = block.getStart(toContributor);
            int end = block.getStart(toContributor) + block.getLength(toContributor) - 1;
            int startCaretPos = toBuffer.getLineMap().getLineStartOffset(start);
            MergeEditState mergeEditState = this.mergePreEdit(block, toContributor, block.getLength(fromContributor));
            contributorEdit = tcc.replaceElement(start, end, element);
            this.mergePostEdit(block, toContributor, mergeEditState);
            this.getTextPane(toContributor).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(toContributor).setCaretPosition(startCaretPos);
            this.getTextPane(toContributor).moveCaretPosition(startCaretPos + ((char[])element.getData()).length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            pane.endEdit(false, contributorEdit);
            this.mergeEndEdit(block, toContributor);
            throw throwable;
        }
        pane.endEdit(false, contributorEdit);
        this.mergeEndEdit(block, toContributor);
    }

    private MergeEditState mergePreEdit(SequenceCompareDifference block, ContributorKind toContributor, int length) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return null;
        }
        OffsetDifferenceBlock offsetBlock = (OffsetDifferenceBlock)block;
        MergeEditState mergeEditState = new MergeEditState(offsetBlock.getStart(toContributor), length);
        this.getTextPane(toContributor).putClientProperty(PROPERTY_UNDO_MOMENTO, this.createMemento());
        offsetBlock.resetStart(toContributor);
        offsetBlock.resetLength(toContributor);
        return mergeEditState;
    }

    private void mergePostEdit(SequenceCompareDifference block, ContributorKind toContributor, MergeEditState mergeEditState) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return;
        }
        OffsetDifferenceBlock offsetBlock = (OffsetDifferenceBlock)block;
        offsetBlock.setStart(toContributor, mergeEditState.getStartLine());
        offsetBlock.setLength(toContributor, mergeEditState.getLength());
        offsetBlock.evaluateOffsets();
        offsetBlock.setResolved(true);
        this.getTextPane(toContributor).putClientProperty(PROPERTY_REDO_MOMENTO, this.createMemento());
    }

    private void mergeEndEdit(SequenceCompareDifference block, ContributorKind toContributor) {
        if (!(block instanceof OffsetDifferenceBlock)) {
            return;
        }
        this.updateCurrentMemento();
        EventQueue.invokeLater(new 3(this, toContributor));
    }

    protected CompareDifference getPreviousDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        int i = this.getCompareModel().getDifferences().length - 1;
        while (i >= 0) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.getStart(contributorKind) != caretLine && block.getStart(contributorKind) + block.getLength(contributorKind) <= caretLine) {
                return block;
            }
            --i;
        }
        return null;
    }

    protected CompareDifference getNextDifference() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        int i = 0;
        while (i < this.getCompareModel().getDifferences().length) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.getStart(contributorKind) > caretLine) {
                return block;
            }
            ++i;
        }
        return null;
    }

    protected CompareDifference getPreviousConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        int i = this.getCompareModel().getDifferences().length - 1;
        while (i >= 0) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.isConflict() && !block.isResolved() && block.getStart(contributorKind) != caretLine && block.getStart(contributorKind) + block.getLength(contributorKind) <= caretLine) {
                return block;
            }
            --i;
        }
        return null;
    }

    protected CompareDifference getNextConflict() {
        ContributorKind contributorKind = this.getCurrentContributorKind();
        if (contributorKind == null) {
            return null;
        }
        int caretLine = this.getCurrentCaretLine(contributorKind);
        int i = 0;
        while (i < this.getCompareModel().getDifferences().length) {
            SequenceCompareDifference block = (SequenceCompareDifference)this.getCompareModel().getDifferences()[i];
            if (block.isConflict() && !block.isResolved() && block.getStart(contributorKind) > caretLine) {
                return block;
            }
            ++i;
        }
        return null;
    }

    protected CompareDifference getCurrentDifference() {
        return this._currentBlock;
    }

    protected ContributorKind getCurrentContributorKind() {
        TextPane currentTextPane = this.getCurrentTextPane();
        if (currentTextPane == null) {
            return null;
        }
        return this.getContributorForPane(currentTextPane);
    }

    protected void goToDifference(CompareDifference difference, boolean requestFocus) {
        SequenceCompareDifference differenceBlock = (SequenceCompareDifference)difference;
        int leftLine = Math.max(0, differenceBlock.getStart(ContributorKind.FIRST));
        int virtualLine = this.getVirtualLineForReal(leftLine, ContributorKind.FIRST);
        if (this.getVerticalScrollBar().isVisible()) {
            this.verticalScrollTo(virtualLine);
        }
        this.moveCaretToBlock(differenceBlock, ContributorKind.FIRST);
        this.moveCaretToBlock(differenceBlock, ContributorKind.SECOND);
        this.moveCaretToBlock(differenceBlock, ContributorKind.ANCESTOR);
    }

    public void setShowInlineDiffs(boolean showInlineDiffs) {
        this._showInlineCharDiffs = showInlineDiffs;
    }

    public boolean isShowInlineCharDiffs() {
        if (this._showInlineCharDiffs == null) {
            return CompareHints.isShowCharDifferences();
        }
        return this._showInlineCharDiffs;
    }

    private int getCurrentCaretLine(ContributorKind contributor) {
        TextPane pane = this.getTextPane(contributor);
        return this.getTextContributor(contributor).getTextBuffer().getLineMap().getLineFromOffset(pane.getCaretPosition());
    }

    private TextPane getCurrentTextPane() {
        return this._currentTextPane;
    }

    private ContributorKind getContributorForPane(TextPane pane) {
        if (pane == this._leftPane) {
            return ContributorKind.FIRST;
        }
        if (pane == this._rightPane) {
            return ContributorKind.SECOND;
        }
        if (pane == this._centerPane && this._centerPane != null) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    public void addPopupManager(ComparePopupManager manager) {
        PopupManagerAdapter popupManager = new PopupManagerAdapter(manager);
        this._leftPane.addPopupManager(popupManager);
        this._rightPane.addPopupManager(popupManager);
        if (this._centerPane != null) {
            this._centerPane.addPopupManager(popupManager);
        }
    }

    public void removePopupManager(ComparePopupManager manager) {
        this.removePopupManager(manager, this._leftPane);
        this.removePopupManager(manager, this._rightPane);
        if (this._centerPane != null) {
            this.removePopupManager(manager, this._centerPane);
        }
    }

    public void removePopupManager(ComparePopupManager manager, BasicEditorPane editorPane) {
        if (editorPane.getPopupManager() != null && ((PopupManagerAdapter)editorPane.getPopupManager()).getManager() == manager) {
            editorPane.removePopupManager(editorPane.getPopupManager());
        }
    }

    public BasicEditorPane[] getEditorPanes() {
        if (this._centerPane == null) {
            return new BasicEditorPane[]{this._leftPane, this._rightPane};
        }
        return new BasicEditorPane[]{this._leftPane, this._rightPane, this._centerPane};
    }

    public BasicEditorPane getCurrentEditorPane() {
        return this.getCurrentTextPane();
    }

    static TextPane mav$getTextPane(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getTextPane(contributorKind);
    }

    static int ra$_textPaneFontHeight(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._textPaneFontHeight;
    }

    static int mav$getVirtualLineForReal(WedgeCompareView wedgeCompareView, int n, ContributorKind contributorKind) {
        return wedgeCompareView.getVirtualLineForReal(n, contributorKind);
    }

    static void mav$horizontalScrollTo(WedgeCompareView wedgeCompareView, Object object, int n) {
        wedgeCompareView.horizontalScrollTo(object, n);
    }

    static ContributorKind mav$getTextContributor(WedgeCompareView wedgeCompareView, Document document) {
        return wedgeCompareView.getTextContributor(document);
    }

    static ViewMemento ra$_currentMemento(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentMemento;
    }

    static ViewMemento mav$createMemento(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.createMemento();
    }

    static void mav$fireStatusChanged(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.fireStatusChanged();
    }

    static void mav$updateCurrentBlock(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateCurrentBlock();
    }

    static void mav$setCurrentBlock(WedgeCompareView wedgeCompareView, SequenceCompareDifference sequenceCompareDifference) {
        wedgeCompareView.setCurrentBlock(sequenceCompareDifference);
    }

    static TextPane ra$_currentTextPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentTextPane;
    }

    static void wa$_currentTextPane(WedgeCompareView wedgeCompareView, TextPane textPane) {
        wedgeCompareView._currentTextPane = textPane;
    }

    static TextPane ra$_leftPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._leftPane;
    }

    static TextPane ra$_centerPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._centerPane;
    }

    static TextPane ra$_rightPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._rightPane;
    }

    static OffsetsMemento ra$_currentOffsetsMemento(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentOffsetsMemento;
    }

    static boolean ra$_verticalScrollLock(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._verticalScrollLock;
    }

    static ContributorKind mav$getContributorForViewPort(WedgeCompareView wedgeCompareView, JViewport jViewport) {
        return wedgeCompareView.getContributorForViewPort(jViewport);
    }

    static void mav$updateVerticalScrollbar(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateVerticalScrollbar();
    }

    static CustomViewport mav$getGutterViewportFor(WedgeCompareView wedgeCompareView, JViewport jViewport) {
        return wedgeCompareView.getGutterViewportFor(jViewport);
    }

    static void mav$clearInlineHighLighters(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.clearInlineHighLighters();
    }

    static SequenceCompareDifference ra$_currentBlock(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentBlock;
    }

    static void wa$_currentBlock(WedgeCompareView wedgeCompareView, SequenceCompareDifference sequenceCompareDifference) {
        wedgeCompareView._currentBlock = sequenceCompareDifference;
    }

    static void mav$repaintEditors(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.repaintEditors();
    }

    static CustomViewport ra$_leftEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._leftEditor;
    }

    static CustomViewport mav$getViewPort(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getViewPort(contributorKind);
    }

    static CompareViewBias mav$getBias(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.getBias();
    }

    static Iterator mav$getDiffBlockIterator(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.getDiffBlockIterator();
    }

    static boolean mav$isAddition(WedgeCompareView wedgeCompareView, BaseCompareDifference baseCompareDifference, ContributorKind contributorKind, ContributorKind contributorKind2) {
        return wedgeCompareView.isAddition(baseCompareDifference, contributorKind, contributorKind2);
    }

    static boolean mav$isRemoval(WedgeCompareView wedgeCompareView, BaseCompareDifference baseCompareDifference, ContributorKind contributorKind, ContributorKind contributorKind2) {
        return wedgeCompareView.isRemoval(baseCompareDifference, contributorKind, contributorKind2);
    }

    static void mav$updateFontMetrics(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateFontMetrics();
    }

    static CustomViewport ra$_rightEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._rightEditor;
    }

    static CustomViewport ra$_centerEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._centerEditor;
    }

    private class CustomViewport
    extends JViewport {
        private final ContributorKind _contributorKind;

        CustomViewport() {
            this(null);
        }

        CustomViewport(ContributorKind contributorKind) {
            this._contributorKind = contributorKind;
        }

        public void setViewPosition(Point p) {
            p.y = this.getViewPosition().y;
            super.setViewPosition(p);
        }

        public void scrollRectToVisible(Rectangle contentRect) {
            super.scrollRectToVisible(contentRect);
            if (this._contributorKind == null) {
                return;
            }
            TextPane textPane = WedgeCompareView.mav$getTextPane(WedgeCompareView.this, this._contributorKind);
            Rectangle caretRectangle = null;
            try {
                caretRectangle = textPane.modelToView(textPane.getCaret().getDot());
            }
            catch (BadLocationException ble) {
                return;
            }
            Rectangle visibleRectangle = textPane.getVisibleRect();
            if (caretRectangle == null || visibleRectangle.contains(caretRectangle)) {
                return;
            }
            if (caretRectangle.y < visibleRectangle.y || caretRectangle.y > visibleRectangle.y + visibleRectangle.height) {
                int topLine = caretRectangle.y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                int virtualLine = WedgeCompareView.mav$getVirtualLineForReal(WedgeCompareView.this, topLine, this._contributorKind);
                WedgeCompareView.this.verticalScrollTo(virtualLine);
            }
            if (caretRectangle.x < visibleRectangle.x || caretRectangle.x > visibleRectangle.x + visibleRectangle.width) {
                WedgeCompareView.mav$horizontalScrollTo(WedgeCompareView.this, null, caretRectangle.x);
            }
        }

        void setViewPositionImpl(Point p) {
            super.setViewPosition(p);
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            WedgeCompareView.ra$_leftEditor(WedgeCompareView.this).repaint();
            WedgeCompareView.ra$_rightEditor(WedgeCompareView.this).repaint();
            if (WedgeCompareView.ra$_centerEditor(WedgeCompareView.this) != null) {
                WedgeCompareView.ra$_centerEditor(WedgeCompareView.this).repaint();
            }
        }
    }

    private class EditListenerAdapter
    implements UndoableEditListener {
        private final ViewEditListener _l;

        EditListenerAdapter(ViewEditListener l) {
            this._l = l;
        }

        ViewEditListener getViewEditListener() {
            return this._l;
        }

        public void undoableEditHappened(UndoableEditEvent event) {
            if (!event.getEdit().isSignificant()) {
                return;
            }
            ContributorKind contributor = WedgeCompareView.mav$getTextContributor(WedgeCompareView.this, (Document)event.getSource());
            ViewMemento undoMemento = (ViewMemento)WedgeCompareView.mav$getTextPane(WedgeCompareView.this, contributor).getClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO);
            ViewMemento redoMemento = (ViewMemento)WedgeCompareView.mav$getTextPane(WedgeCompareView.this, contributor).getClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO);
            if (undoMemento == null) {
                undoMemento = WedgeCompareView.ra$_currentMemento(WedgeCompareView.this);
            }
            if (redoMemento == null) {
                redoMemento = WedgeCompareView.mav$createMemento(WedgeCompareView.this);
            }
            WedgeCompareView.this.updateCurrentMemento();
            this._l.viewEditHappened(new ViewEditEvent(WedgeCompareView.this, 1, contributor, new ViewEdit(event.getEdit(), WedgeCompareView.this, undoMemento, redoMemento)));
            WedgeCompareView.mav$fireStatusChanged(WedgeCompareView.this);
        }
    }

    private class BlockActivationListener
    implements FocusListener,
    CaretListener {
        public void focusGained(FocusEvent e) {
            TextPane nextTextPane = (TextPane)e.getSource();
            boolean clearSelection = nextTextPane != WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this);
            WedgeCompareView.wa$_currentTextPane(WedgeCompareView.this, nextTextPane);
            WedgeCompareView.mav$updateCurrentBlock(WedgeCompareView.this);
            if (!clearSelection) {
                return;
            }
            if (WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_leftPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_leftPane(WedgeCompareView.this));
            }
            if (WedgeCompareView.ra$_centerPane(WedgeCompareView.this) != null && WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_centerPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_centerPane(WedgeCompareView.this));
            }
            if (WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_rightPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_rightPane(WedgeCompareView.this));
            }
        }

        private void clearSelection(TextPane textPane) {
            textPane.select(textPane.getCaretPosition(), textPane.getCaretPosition());
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && !(e.getOppositeComponent() instanceof TextPane)) {
                WedgeCompareView.mav$setCurrentBlock(WedgeCompareView.this, null);
            }
        }

        public void caretUpdate(CaretEvent ce) {
            WedgeCompareView.mav$updateCurrentBlock(WedgeCompareView.this);
        }

        private BlockActivationListener() {
        }

        BlockActivationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PositionListenerImpl
    extends BaseCompareView.PositionListener
    implements CaretListener {
        public void caretUpdate(CaretEvent ce) {
            this.resetTimer();
        }

        private PositionListenerImpl() {
        }

        PositionListenerImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveOnEditTextBufferListener
    implements TextBufferListener {
        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            this.resolveOnEdit(offset, count);
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            this.resolveOnEdit(offset, count);
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void resolveOnEdit(int offset, int count) {
            for (CompareDifference compareDifference : this.getBlocksFromMemento(offset, count)) {
                compareDifference.setResolved(true);
            }
        }

        private Collection<CompareDifference> getBlocksFromMemento(int offset, int count) {
            ArrayList<CompareDifference> compareDifferences = new ArrayList<CompareDifference>();
            if (WedgeCompareView.ra$_currentMemento(WedgeCompareView.this) == null) {
                return compareDifferences;
            }
            CompareDifference[] compareDifferenceArray = WedgeCompareView.this.getCompareModel().getDifferences();
            int n = 0;
            while (n < compareDifferenceArray.length) {
                CompareDifference compareDifference = compareDifferenceArray[n];
                if (WedgeCompareView.ra$_currentOffsetsMemento(WedgeCompareView.this).getStartOffset(compareDifference) < offset + count && WedgeCompareView.ra$_currentOffsetsMemento(WedgeCompareView.this).getEndOffset(compareDifference) > offset) {
                    compareDifferences.add(compareDifference);
                }
                ++n;
            }
            return compareDifferences;
        }

        private ResolveOnEditTextBufferListener() {
        }

        ResolveOnEditTextBufferListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AutoScrollChangeListener
    implements ChangeListener {
        private final Point _scratchPoint;

        private void $init$() {
            this._scratchPoint = new Point();
        }

        public void stateChanged(ChangeEvent ce) {
            CustomViewport viewport = (CustomViewport)ce.getSource();
            if (!WedgeCompareView.ra$_verticalScrollLock(WedgeCompareView.this)) {
                int mod = viewport.getViewPosition().y % WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                if (mod != 0) {
                    this._scratchPoint.x = viewport.getViewPosition().x;
                    this._scratchPoint.y = viewport.getViewPosition().y + (WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this) - mod);
                    viewport.setViewPositionImpl(this._scratchPoint);
                    return;
                }
                int topLine = viewport.getViewPosition().y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                int virtualPos = WedgeCompareView.mav$getVirtualLineForReal(WedgeCompareView.this, topLine, WedgeCompareView.mav$getContributorForViewPort(WedgeCompareView.this, viewport));
                WedgeCompareView.this.verticalScrollTo(virtualPos);
            }
            WedgeCompareView.mav$updateVerticalScrollbar(WedgeCompareView.this);
            CustomViewport gutter = WedgeCompareView.mav$getGutterViewportFor(WedgeCompareView.this, viewport);
            if (gutter != null) {
                this._scratchPoint.x = 0;
                this._scratchPoint.y = viewport.getViewPosition().y;
                gutter.setViewPositionImpl(this._scratchPoint);
            }
        }

        private AutoScrollChangeListener() {
            this.$init$();
        }

        AutoScrollChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class OffsetsMemento {
        private final Map<CompareDifference, Integer> _offsets1;
        private final Map<CompareDifference, Integer> _offsets2;

        private void $init$() {
            this._offsets1 = new HashMap<CompareDifference, Integer>();
            this._offsets2 = new HashMap<CompareDifference, Integer>();
        }

        void setStartOffset(CompareDifference compareDifference, int offset) {
            this._offsets1.put(compareDifference, offset);
        }

        void setEndOffset(CompareDifference compareDifference, int offset) {
            this._offsets2.put(compareDifference, offset);
        }

        int getStartOffset(CompareDifference compareDifference) {
            return this._offsets1.get(compareDifference);
        }

        int getEndOffset(CompareDifference compareDifference) {
            return this._offsets2.get(compareDifference);
        }

        private OffsetsMemento() {
            this.$init$();
        }

        OffsetsMemento(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 2
    implements EditorPlugin {
        public void install(BasicEditorPane bep) {
        }

        public void deinstall(BasicEditorPane bep) {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("editor-font")) {
                WedgeCompareView.mav$updateFontMetrics(WedgeCompareView.this);
                WedgeCompareView.this.getGUI().repaint();
            }
        }
    }

    private class HintListener
    implements CompareHintListener {
        public void CompareHintUpdated(String key) {
            if (!WedgeCompareView.this.isShowInlineCharDiffs()) {
                WedgeCompareView.mav$clearInlineHighLighters(WedgeCompareView.this);
            }
            SequenceCompareDifference tBlock = WedgeCompareView.ra$_currentBlock(WedgeCompareView.this);
            WedgeCompareView.wa$_currentBlock(WedgeCompareView.this, null);
            WedgeCompareView.mav$setCurrentBlock(WedgeCompareView.this, tBlock);
            WedgeCompareView.mav$repaintEditors(WedgeCompareView.this);
        }

        private HintListener() {
        }

        HintListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WedgeDiffGutter
    extends DiffGutter {
        private Rectangle _gutterBounds;

        private void $init$() {
            this._gutterBounds = new Rectangle();
        }

        WedgeDiffGutter(ContributorKind leftContributor, ContributorKind rightContributor) {
            super(WedgeCompareView.this, leftContributor, rightContributor);
            this.$init$();
        }

        protected ContributorKind getContributorAtPoint(Point p) {
            if (p.x <= 16) {
                return this._leftContributorKind;
            }
            if (p.x >= WedgeCompareView.this.getLeftDiffGutter().getWidth() - 16) {
                return this._rightContributorKind;
            }
            return null;
        }

        protected CompareDifference getBlockAtPoint(Point p) {
            ContributorKind contributor = this.getContributorAtPoint(p);
            if (contributor == null) {
                return null;
            }
            int lineAtTop = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)contributor).getViewPosition().y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
            int mouseLine = lineAtTop + p.y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
            Iterator i = WedgeCompareView.mav$getDiffBlockIterator(WedgeCompareView.this);
            while (i.hasNext()) {
                SequenceCompareDifference diff = (SequenceCompareDifference)i.next();
                if (diff.getStart(contributor) > mouseLine || diff.getStart(contributor) + diff.getLength(contributor) <= mouseLine) continue;
                if (diff.getKind() == 2) {
                    return diff;
                }
                return null;
            }
            return null;
        }

        public void paint(Graphics g) {
            if (WedgeCompareView.this.getCompareModel() == null) {
                return;
            }
            Rectangle clipRect = g.getClipBounds();
            this._gutterBounds.x = 0;
            this._gutterBounds.y = 0;
            this._gutterBounds.width = this.getWidth();
            this._gutterBounds.height = this.getHeight();
            clipRect = clipRect.intersection(this._gutterBounds);
            g.setColor(this.getBackground());
            g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, clipRect.y, 0, clipRect.y + clipRect.height);
            g.drawLine(this.getWidth() - 1, clipRect.y, this.getWidth() - 1, clipRect.y + clipRect.height);
            SequenceCompareDifference[] diffs = ((SequenceCompareModel)WedgeCompareView.this.getCompareModel()).getDifferenceBlocks();
            int i = 0;
            while (i < diffs.length) {
                int highY;
                SequenceCompareDifference diff = diffs[i];
                g.setColor(this.getLineColor(diff));
                int leftLineStart = diff.getStart(this._leftContributorKind);
                int rightLineStart = diff.getStart(this._rightContributorKind);
                int leftY = this.getLineYPos(leftLineStart) - 1;
                int rightY = this.getLineYPos(rightLineStart) - 1;
                int leftScrollPos = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)this._leftContributorKind).getViewPosition().y;
                int rightScrollPos = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)this._rightContributorKind).getViewPosition().y;
                rightY -= rightScrollPos;
                if ((leftY -= leftScrollPos) == -1) {
                    leftY = 0;
                }
                if (rightY == -1) {
                    rightY = 0;
                }
                if (!(leftY < 0 && rightY < 0 || leftY > (highY = g.getClipBounds().height) && rightY > highY)) {
                    int leftConnectorY = leftY;
                    int rightConnectorY = rightY;
                    g.drawLine(0, leftY, 16, leftY);
                    int leftLength = diff.getLength(this._leftContributorKind);
                    if (leftLength > 0) {
                        int bottomY = this.getLineYPos(leftLineStart + leftLength) - leftScrollPos - 1;
                        leftConnectorY += (bottomY - leftY) / 2;
                        g.drawLine(0, bottomY, 16, bottomY);
                        Color oldColor = g.getColor();
                        HighlightStyle style = EditorHighlighter.getStyle((SequenceCompareModel)WedgeCompareView.this.getCompareModel(), diff, this._leftContributorKind, this._rightContributorKind, this._leftContributorKind, WedgeCompareView.mav$getBias(WedgeCompareView.this));
                        Color c = style != null && style.getEnabled() ? style.getBackgroundColor() : WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBackground();
                        g.setColor(c);
                        g.fillRect(0, leftY + 1, 16, bottomY - leftY - 1);
                        g.setColor(oldColor);
                        g.drawLine(16, leftY, 16, bottomY);
                        Icon editIcon = WedgeCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)diff, this._leftContributorKind, this._rightContributorKind, true);
                        if (editIcon != null) {
                            int x = (16 - editIcon.getIconWidth()) / 2;
                            editIcon.paintIcon(this, g, x, leftY + 3);
                        }
                    }
                    g.drawLine(this.getWidth() - 16, rightY, this.getWidth(), rightY);
                    int rightLength = diff.getLength(this._rightContributorKind);
                    if (rightLength > 0) {
                        int bottomY = this.getLineYPos(rightLineStart + rightLength) - rightScrollPos - 1;
                        rightConnectorY += (bottomY - rightY) / 2;
                        g.drawLine(this.getWidth() - 16, bottomY, this.getWidth(), bottomY);
                        Color oldColor = g.getColor();
                        HighlightStyle style = EditorHighlighter.getStyle((SequenceCompareModel)WedgeCompareView.this.getCompareModel(), diff, this._leftContributorKind, this._rightContributorKind, this._rightContributorKind, WedgeCompareView.mav$getBias(WedgeCompareView.this));
                        Color c = style != null && style.getEnabled() ? style.getBackgroundColor() : WedgeCompareView.ra$_rightPane(WedgeCompareView.this).getBackground();
                        g.setColor(c);
                        g.fillRect(this.getWidth() - 16, rightY + 1, 16, bottomY - rightY - 1);
                        g.setColor(oldColor);
                        g.drawLine(this.getWidth() - 16, rightY, this.getWidth() - 16, bottomY);
                        Icon editIcon = WedgeCompareView.this.getDefaultEditActionIcon((BaseCompareDifference)diff, this._rightContributorKind, this._leftContributorKind, false);
                        if (editIcon != null) {
                            int x = this.getWidth() - 16 + 1 + (16 - editIcon.getIconWidth()) / 2;
                            editIcon.paintIcon(this, g, x, rightY + 3);
                        }
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int curvaceousness = 12;
                    CubicCurve2D.Double curve = new CubicCurve2D.Double(16.0, leftConnectorY, 16 + curvaceousness, leftConnectorY, this.getWidth() - 16 - curvaceousness, rightConnectorY, this.getWidth() - 16, rightConnectorY);
                    ((Graphics2D)g).draw(curve);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                ++i;
            }
        }

        private int getLineYPos(int line) {
            return WedgeCompareView.ra$_leftEditor((WedgeCompareView)WedgeCompareView.this).getInsets().top - this.getInsets().top + line * WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
        }

        private Color getLineColor(SequenceCompareDifference diff) {
            Color c = UIManager.getColor("controlShadow");
            if (diff != WedgeCompareView.ra$_currentBlock(WedgeCompareView.this) || WedgeCompareView.this.getCompareModel().getType() != CompareType.TEXT) {
                return c;
            }
            if (WedgeCompareView.ra$_leftPane(WedgeCompareView.this) == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane null"));
                return c;
            }
            if (WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBlockHighlighter() == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane.getBlockHighlighter() returned null"));
                return c;
            }
            if (WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBlockHighlighter().getSeparatorStyle(true) == null) {
                Assert.fail((Exception)new IllegalStateException("_leftPane.getBlockHighlighter().getSeparatorStyle() returned null"));
                return c;
            }
            return WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBlockHighlighter().getSeparatorStyle(true).getUnderlineColor();
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ ContributorKind v$toContributor;
        final /* synthetic */ WedgeCompareView this$0;

        public void run() {
            WedgeCompareView.mav$getTextPane(this.this$0, this.v$toContributor).putClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO, null);
            WedgeCompareView.mav$getTextPane(this.this$0, this.v$toContributor).putClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO, null);
        }

        public 3(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
            this.v$toContributor = contributorKind;
            this.this$0 = wedgeCompareView;
        }
    }

    private class MergeEditState {
        private final int _startLine;
        private final int _length;

        MergeEditState(int startLine, int length) {
            this._startLine = startLine;
            this._length = length;
        }

        int getStartLine() {
            return this._startLine;
        }

        int getLength() {
            return this._length;
        }
    }

    class PopupManagerAdapter
    implements PopupManager {
        private ComparePopupManager _manager;

        PopupManagerAdapter(ComparePopupManager manager) {
            this._manager = manager;
        }

        public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
            this._manager.showPopup(mouseEvent);
        }

        public void hidePopup(BasicEditorPane editorPane) {
            this._manager.hidePopup();
        }

        ComparePopupManager getManager() {
            return this._manager;
        }
    }

    private class WedgeOverviewComponent
    extends SequenceCompareView.OverviewComponent {
        public WedgeOverviewComponent(ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
            super(firstContributorKind, secondContributorKind);
            MouseHandler mh = new MouseHandler(null);
            this.addMouseListener(mh);
            this.addMouseMotionListener(mh);
        }

        public String getToolTipText(MouseEvent me) {
            return null;
        }

        static ContributorKind ra$_firstContributorKind(WedgeOverviewComponent wedgeOverviewComponent) {
            return wedgeOverviewComponent._firstContributorKind;
        }

        static ContributorKind ra$_secondContributorKind(WedgeOverviewComponent wedgeOverviewComponent) {
            return wedgeOverviewComponent._secondContributorKind;
        }

        static SequenceCompareDifference mav$getDifferenceForPosition(WedgeOverviewComponent wedgeOverviewComponent, Point point) {
            return wedgeOverviewComponent.getDifferenceForPosition(point);
        }

        private class MouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            public void mouseClicked(MouseEvent e) {
                EditorPeekPopup.hidePopup(true);
            }

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                SequenceCompareDifference diff = WedgeOverviewComponent.mav$getDifferenceForPosition(WedgeOverviewComponent.this, e.getPoint());
                if (diff != null) {
                    TextPane pane = WedgeCompareView.mav$getTextPane(WedgeCompareView.this, WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this));
                    boolean isLeft = WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this) == ContributorKind.FIRST;
                    Insets insets = WedgeOverviewComponent.this.getInsets();
                    int height = WedgeOverviewComponent.this.getHeight() - insets.top - insets.bottom;
                    int virtualHeight = pane.getLineCount();
                    float vPixelsPerLine = (float)height / (float)virtualHeight;
                    int blockHeight = diff.getLength(WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this));
                    if (diff.getKind() == 2) {
                        int y = (int)((float)this._getBlockY(diff) * vPixelsPerLine) + insets.top;
                        int h = Math.max((int)((float)blockHeight * vPixelsPerLine), 1);
                        Point topPoint = new Point(insets.left, y);
                        SwingUtilities.convertPointToScreen(topPoint, WedgeOverviewComponent.this);
                        Rectangle sourceRect = new Rectangle(topPoint.x, topPoint.y, WedgeOverviewComponent.this.getWidth() - insets.right - insets.left, h);
                        int lineStart = diff.getStart(WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this));
                        int lineEnd = lineStart + diff.getLength(WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this));
                        String text = this.getDescription(diff, lineStart + 1, lineEnd - lineStart);
                        EditorPeekPopup.showPopup((Object)diff, (BasicEditorPane)pane, text, sourceRect, lineStart - 1, lineEnd - 1, WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this), WedgeCompareView.this.getOverviewDifferenceColor(diff, isLeft, WedgeOverviewComponent.ra$_secondContributorKind(WedgeOverviewComponent.this), WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this)), (int)((float)WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this) * 0.2f), -1);
                    }
                } else {
                    WedgeOverviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    EditorPeekPopup.hidePopup(false);
                }
            }

            private String getDescription(SequenceCompareDifference diff, int line, int lineCount) {
                ContributorKind secondKind;
                if (WedgeCompareView.this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                    return null;
                }
                String type = "";
                ContributorKind firstKind = WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this) == ContributorKind.FIRST ? WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this) : WedgeOverviewComponent.ra$_secondContributorKind(WedgeOverviewComponent.this);
                ContributorKind contributorKind = secondKind = WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this) == ContributorKind.FIRST ? WedgeOverviewComponent.ra$_secondContributorKind(WedgeOverviewComponent.this) : WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this);
                if (WedgeCompareView.mav$isAddition(WedgeCompareView.this, (BaseCompareDifference)diff, firstKind, secondKind)) {
                    type = WedgeCompareView.this.getBundle().getString("ADDITION");
                    lineCount = diff.getMaxLength();
                } else if (WedgeCompareView.mav$isRemoval(WedgeCompareView.this, (BaseCompareDifference)diff, firstKind, secondKind)) {
                    type = WedgeCompareView.this.getBundle().getString("DELETION");
                    lineCount = diff.getMaxLength();
                } else if (diff.isChange(firstKind, secondKind)) {
                    type = WedgeCompareView.this.getBundle().getString("CHANGE");
                }
                String desc = lineCount > 1 ? String.format(WedgeCompareView.this.getBundle().getString("TIP_FORMAT_PLURAL"), type, line, lineCount) : String.format(WedgeCompareView.this.getBundle().getString("TIP_FORMAT_SINGULAR"), type, line, lineCount);
                return desc;
            }

            private int _getBlockY(SequenceCompareDifference diff) {
                int y = 0;
                Iterator i = WedgeCompareView.mav$getDiffBlockIterator(WedgeCompareView.this);
                while (i.hasNext()) {
                    SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                    if (thisBlock == diff) {
                        return y;
                    }
                    y += thisBlock.getLength(WedgeOverviewComponent.ra$_firstContributorKind(WedgeOverviewComponent.this));
                }
                return 0;
            }

            public void mouseExited(MouseEvent e) {
                EditorPeekPopup.hidePopup(false);
            }

            private MouseHandler() {
            }

            MouseHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

