/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.dialogs.ExceptionDialog;

public class CompletionPopupHandler {
    private static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("window");
    private List _insightProviders;
    private boolean _insightActive;
    private Timer _timer;
    private JWindow _insightWindow;
    private JList _insightList;
    private JScrollPane _insightScrollPane;
    private Color _insightBackground;
    private ListDoubleClickListener _listListener;
    private FieldInsightProvider _activeProvider;
    private boolean _alignWithField;
    private boolean _widthOfField;
    private boolean _widthConstrained;
    private int _visibleRowCount;
    private Window _parentWindow;
    private ComponentListener _parentWindowListener;
    private static final String CANCEL_ACTION = "cancelInsight";
    private static final String COMPLETE_ACTION = "completeInsight";
    private Object[][] _actions;
    private static final int DEFAULT_DELAY = 750;
    private static int _delay = 750;
    public static final String SHOW_INSIGHT_ACTION_NAME = "show_field_insight";
    private boolean _insightLock;
    private final JTextComponent _textComponent;
    private Map<Object, Action> _actionMapBackups;
    private Map<KeyStroke, Object> _inputMapBackups;

    private void $init$() {
        this._insightProviders = new ArrayList();
        this._insightActive = false;
        this._insightBackground = DEFAULT_BACKGROUND_COLOR;
        this._widthOfField = true;
        this._visibleRowCount = 8;
        this._actions = new Object[][]{{CANCEL_ACTION, KeyStroke.getKeyStroke("ESCAPE"), new CancelInsightAction(null)}, {COMPLETE_ACTION, KeyStroke.getKeyStroke("ENTER"), new CompleteInsightAction(null)}};
        this._insightLock = false;
        this._actionMapBackups = new HashMap<Object, Action>();
        this._inputMapBackups = new HashMap<KeyStroke, Object>();
    }

    public CompletionPopupHandler(JTextComponent textComponent) {
        this.$init$();
        this._textComponent = textComponent;
        DefaultCaret caret = new DefaultCaret();
        caret.setBlinkRate(UIManager.getInt("TextField.caretBlinkRate"));
        this._textComponent.setCaret(caret);
        if (_delay >= 0) {
            this._timer = new Timer(_delay, new ActionHandler(null));
            this._timer.setRepeats(false);
            this._textComponent.addCaretListener(new CaretHandler(null));
            this._textComponent.getDocument().addDocumentListener(new DocumentHandler(null));
            this._textComponent.addFocusListener(new FocusHandler(null));
        }
        this._textComponent.getInputMap(0).put(KeyStroke.getKeyStroke("control pressed SPACE"), SHOW_INSIGHT_ACTION_NAME);
        this._textComponent.getActionMap().put(SHOW_INSIGHT_ACTION_NAME, new ShowInsightAction());
    }

    public final JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public final void acquireInsightLock() {
        this._insightLock = true;
    }

    public final void yieldInsightLock() {
        this._insightLock = false;
    }

    public final Color getCompletionBackground() {
        return this._insightBackground;
    }

    public final void setCompletionBackground(Color insightBackground) {
        this._insightBackground = insightBackground;
    }

    public final void setAlignWithField(boolean isAlignWithField) {
        this._alignWithField = isAlignWithField;
    }

    public final boolean isAlignWithField() {
        return this._alignWithField;
    }

    public final void setWidthOfField(boolean isWidthOfField) {
        this._widthOfField = isWidthOfField;
    }

    public final boolean isWidthOfField() {
        return this._widthOfField;
    }

    public final void setWidthConstrained(boolean isWidthConstrained) {
        this._widthConstrained = isWidthConstrained;
    }

    public final boolean isWidthConstrained() {
        return this._widthConstrained;
    }

    public final void setVisibleRowCount(int visibleRowCount) {
        if (this._visibleRowCount <= 0) {
            throw new IllegalArgumentException();
        }
        this._visibleRowCount = visibleRowCount;
    }

    public final int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    public final void registerInsightProvider(FieldInsightProvider provider) {
        this._insightProviders.add(provider);
    }

    public final void unregisterInsightProvider(FieldInsightProvider provider) {
        this._insightProviders.remove(provider);
    }

    public final boolean isRegisteredInsightProvider(FieldInsightProvider provider) {
        return this._insightProviders.contains(provider);
    }

    public final void setInsightVisible(boolean isVisible) {
        if (isVisible) {
            this.showInsight();
        } else {
            this.hideInsight();
        }
    }

    public final boolean isInsightVisible() {
        return this._insightActive;
    }

    private FieldInsightProvider getHandlingProvider() {
        for (FieldInsightProvider provider : this._insightProviders) {
            if (!provider.handlesInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition())) continue;
            return provider;
        }
        return null;
    }

    private boolean isPopupTriggerChar(char c) {
        for (FieldInsightProvider provider : this._insightProviders) {
            if (!provider.isAutoPopupChar(c)) continue;
            return true;
        }
        return false;
    }

    private void showInsight() {
        Rectangle caretRect;
        if (this._insightActive || !this._textComponent.isShowing()) {
            return;
        }
        this.stopTimer();
        if (!this._textComponent.isEditable()) {
            return;
        }
        this._parentWindow = SwingUtilities.getWindowAncestor(this._textComponent);
        if (this._parentWindow == null) {
            return;
        }
        int caretOffset = this._textComponent.getCaretPosition();
        try {
            caretRect = this._textComponent.getUI().modelToView(this._textComponent, caretOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        FieldInsightProvider insightProvider = this.getHandlingProvider();
        if (insightProvider != null) {
            this._insightActive = true;
            Object[] items = insightProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (items == null || items.length == 0) {
                this._insightActive = false;
                return;
            }
            this._activeProvider = insightProvider;
            this._insightList = new InsightList(null);
            this._insightList.setModel(new ArrayListModel(items));
            this._insightList.setCellRenderer(insightProvider.getCellRenderer());
            this._insightList.setBackground(this._insightBackground);
            if (items.length < this._visibleRowCount) {
                this._insightList.setVisibleRowCount(items.length);
            } else {
                this._insightList.setVisibleRowCount(this._visibleRowCount);
            }
            this.redirectActions(this._textComponent);
            this._insightScrollPane = new JScrollPane(this._insightList);
            this._insightScrollPane.setBorder(UIManager.getBorder("ToolTip.border"));
            this._insightScrollPane.setHorizontalScrollBarPolicy(31);
            this._insightScrollPane.setMinimumSize(new Dimension(0, 0));
            this._insightWindow = new JWindow(this._parentWindow);
            this._insightWindow.setBackground(this._insightBackground);
            new FocusRedirector(this._insightWindow, this._textComponent, null);
            new FocusRedirector(this._insightList, this._textComponent, null);
            this.setWindowLocation(this._insightWindow, this._textComponent, caretRect);
            this._insightScrollPane.validate();
            Dimension d = this.getWindowSize();
            this._insightWindow.setSize(d);
            this._insightWindow.getContentPane().add(this._insightScrollPane);
            this._insightWindow.setVisible(true);
            this._listListener = new ListDoubleClickListener(null);
            this._insightList.addMouseListener(this._listListener);
            if (this._insightList.getModel().getSize() > 0) {
                this._insightList.setSelectedIndex(0);
            }
            FocusRedirector redirector14Hack = new FocusRedirector(null, this._textComponent, null);
            SwingUtilities.invokeLater(redirector14Hack);
            this._parentWindowListener = new 1();
            this._parentWindow.addComponentListener(this._parentWindowListener);
        }
    }

    private Dimension getWindowSize() {
        if (this._insightScrollPane == null) {
            return null;
        }
        Dimension d = this._insightScrollPane.getPreferredSize();
        if (this._widthOfField) {
            d.width = Math.max(d.width, this._textComponent.getWidth());
        }
        if (this._widthConstrained) {
            d.width = Math.min(d.width, this._textComponent.getWidth());
        }
        return d;
    }

    private void setWindowLocation(JWindow window, Component component, Rectangle location) {
        int y;
        int x;
        if (component.getParent() instanceof JViewport) {
            component = component.getParent();
        }
        Point comPos = component.getLocationOnScreen();
        if (this._alignWithField) {
            x = comPos.x;
            y = comPos.y + this.getVerticalPopupOffset(component);
        } else {
            location.x += comPos.x;
            location.y += comPos.y;
            x = location.x;
            y = location.y + this.getVerticalPopupOffset(component);
        }
        window.setLocation(x, y);
    }

    protected int getVerticalPopupOffset(Component component) {
        return component.getHeight();
    }

    private void hideInsight() {
        if (this._insightActive) {
            this._activeProvider = null;
            if (this._insightWindow != null) {
                this._insightWindow.dispose();
                this._insightList.removeMouseListener(this._listListener);
                this._listListener = null;
            }
            if (this._parentWindow != null) {
                if (this._parentWindowListener != null) {
                    this._parentWindow.removeComponentListener(this._parentWindowListener);
                    this._parentWindowListener = null;
                }
                this._parentWindow = null;
            }
            this._insightWindow = null;
            this._insightActive = false;
            this.removeActions(this._textComponent);
        }
    }

    private void updateInsight() {
        if (this._insightActive && this._activeProvider != null) {
            Object[] items = this._activeProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (items != null && items.length > 0) {
                this._insightList.setModel(new ArrayListModel(items));
                if (items.length < this._visibleRowCount) {
                    this._insightList.setVisibleRowCount(items.length);
                } else {
                    this._insightList.setVisibleRowCount(this._visibleRowCount);
                }
                Dimension newSize = this.getWindowSize();
                Dimension oldSize = this._insightWindow.getSize();
                if (!oldSize.equals(newSize)) {
                    int caretOffset = this._textComponent.getCaretPosition();
                    try {
                        Rectangle caretRect = this._textComponent.getUI().modelToView(this._textComponent, caretOffset);
                        this._insightWindow.setSize(newSize);
                        this.setWindowLocation(this._insightWindow, this._textComponent, caretRect);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                }
                this._insightWindow.validate();
                this._insightList.setSelectedIndex(0);
            } else {
                this.hideInsight();
            }
        }
    }

    private void removeActions(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        int i = 0;
        while (i < this._actions.length) {
            Object oldActionId;
            Object actionId = this._actions[i][0];
            KeyStroke keyStroke = (KeyStroke)this._actions[i][1];
            inputMap.remove(keyStroke);
            actionMap.remove(actionId);
            Action oldAction = this._actionMapBackups.get(actionId);
            if (oldAction != null) {
                actionMap.put(actionId, oldAction);
            }
            if ((oldActionId = this._inputMapBackups.get(keyStroke)) != null) {
                inputMap.put(keyStroke, oldActionId);
            }
            ++i;
        }
        inputMap.remove(KeyStroke.getKeyStroke("UP"));
        inputMap.remove(KeyStroke.getKeyStroke("DOWN"));
        this._actionMapBackups.clear();
        this._inputMapBackups.clear();
    }

    private void redirectActions(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        int i = 0;
        while (i < this._actions.length) {
            Object actionKey = this._actions[i][0];
            KeyStroke keyStroke = (KeyStroke)this._actions[i][1];
            this._actionMapBackups.put(actionKey, actionMap.get(actionKey));
            this._inputMapBackups.put(keyStroke, inputMap.get(keyStroke));
            inputMap.put(keyStroke, actionKey);
            actionMap.put(actionKey, (Action)this._actions[i][2]);
            ++i;
        }
        inputMap.put(KeyStroke.getKeyStroke("UP"), "selectPreviousRow");
        Action action = this._insightList.getActionMap().get("selectPreviousRow");
        actionMap.put("selectPreviousRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "selectNextRow");
        action = this._insightList.getActionMap().get("selectNextRow");
        actionMap.put("selectNextRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "scrollUp");
        action = this._insightList.getActionMap().get("scrollUp");
        actionMap.put("scrollUp", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "scrollDown");
        action = this._insightList.getActionMap().get("scrollDown");
        actionMap.put("scrollDown", new ActionDelegator(this._insightList, action));
    }

    private void completeInsight() {
        try {
            this._insightLock = true;
            if (this._insightList != null && this._activeProvider != null) {
                this._activeProvider.completeInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition(), this._insightList.getSelectedValue());
            }
        }
        finally {
            this._insightLock = false;
        }
    }

    private void startTimer() {
        this._timer.restart();
    }

    private void stopTimer() {
        this._timer.stop();
    }

    static void mav$hideInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.hideInsight();
    }

    static void mav$completeInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.completeInsight();
    }

    static boolean ra$_insightActive(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightActive;
    }

    static void mav$updateInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.updateInsight();
    }

    static void mav$stopTimer(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.stopTimer();
    }

    static boolean mav$isPopupTriggerChar(CompletionPopupHandler completionPopupHandler, char c) {
        return completionPopupHandler.isPopupTriggerChar(c);
    }

    static boolean ra$_insightLock(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightLock;
    }

    static void mav$startTimer(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.startTimer();
    }

    static void mav$showInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.showInsight();
    }

    static JList ra$_insightList(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightList;
    }

    static JTextComponent ra$_textComponent(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._textComponent;
    }

    static Window ra$_parentWindow(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._parentWindow;
    }

    static void wa$_parentWindowListener(CompletionPopupHandler completionPopupHandler, ComponentListener componentListener) {
        completionPopupHandler._parentWindowListener = componentListener;
    }

    final class 1
    implements ComponentListener {
        private void doit() {
            CompletionPopupHandler.ra$_parentWindow(CompletionPopupHandler.this).removeComponentListener(this);
            CompletionPopupHandler.wa$_parentWindowListener(CompletionPopupHandler.this, null);
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        public void componentHidden(ComponentEvent ce) {
            this.doit();
        }

        public void componentMoved(ComponentEvent ce) {
            this.doit();
        }

        public void componentResized(ComponentEvent ce) {
            this.doit();
        }

        public void componentShown(ComponentEvent ce) {
        }
    }

    private class CancelInsightAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        private CancelInsightAction() {
        }

        CancelInsightAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CompleteInsightAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.mav$completeInsight(CompletionPopupHandler.this);
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        private CompleteInsightAction() {
        }

        CompleteInsightAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ArrayListModel
    extends AbstractListModel {
        Object[] _array;

        public ArrayListModel(Object[] array) {
            this._array = array;
        }

        public Object getElementAt(int index) {
            return this._array[index];
        }

        public int getSize() {
            return this._array.length;
        }
    }

    private class CaretHandler
    implements CaretListener {
        public void caretUpdate(CaretEvent ce) {
            if (CompletionPopupHandler.ra$_insightActive(CompletionPopupHandler.this)) {
                CompletionPopupHandler.mav$updateInsight(CompletionPopupHandler.this);
            }
        }

        private CaretHandler() {
        }

        CaretHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent fe) {
        }

        public void focusLost(FocusEvent fe) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
            if (!fe.isTemporary()) {
                CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
            }
        }

        private FocusHandler() {
        }

        FocusHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent de) {
            if (!CompletionPopupHandler.ra$_insightActive(CompletionPopupHandler.this)) {
                int offset = de.getOffset();
                if (de.getLength() > 1) {
                    offset += de.getLength() - 1;
                }
                try {
                    char lastChar = de.getDocument().getText(offset, 1).charAt(0);
                    if (CompletionPopupHandler.mav$isPopupTriggerChar(CompletionPopupHandler.this, lastChar) && !CompletionPopupHandler.ra$_insightLock(CompletionPopupHandler.this)) {
                        CompletionPopupHandler.mav$startTimer(CompletionPopupHandler.this);
                    } else {
                        CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }

        public void changedUpdate(DocumentEvent de) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
        }

        public void removeUpdate(DocumentEvent de) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
        }

        private DocumentHandler() {
        }

        DocumentHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.mav$showInsight(CompletionPopupHandler.this);
        }

        private ActionHandler() {
        }

        ActionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class FocusRedirector
    extends FocusAdapter
    implements Runnable {
        private Component component;

        private FocusRedirector(Component window, Component component) {
            this.component = component;
            if (window != null) {
                window.addFocusListener(this);
            }
        }

        public void focusGained(FocusEvent event) {
            this.run();
        }

        public void run() {
            this.component.requestFocus();
        }

        FocusRedirector(Component component, Component component2, 1 var3_3) {
            this(component, component2);
        }

        public final class 1 {
        }
    }

    private class ActionDelegator
    extends AbstractAction {
        private JComponent _component;
        private Action _delegate;

        ActionDelegator(JComponent component, Action delegate) {
            this._component = component;
            this._delegate = delegate;
        }

        public void actionPerformed(ActionEvent ae) {
            ActionEvent newEvent = new ActionEvent(this._component, ae.getID(), ae.getActionCommand());
            this._delegate.actionPerformed(newEvent);
        }
    }

    private class ListDoubleClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            try {
                int index;
                if (me.getButton() == 1 && me.getClickCount() == 2 && (index = CompletionPopupHandler.ra$_insightList(CompletionPopupHandler.this).locationToIndex(me.getPoint())) != -1) {
                    CompletionPopupHandler.mav$completeInsight(CompletionPopupHandler.this);
                    CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
                    CompletionPopupHandler.ra$_textComponent(CompletionPopupHandler.this).requestFocus();
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog(CompletionPopupHandler.ra$_textComponent(CompletionPopupHandler.this), (Throwable)re);
            }
        }

        private ListDoubleClickListener() {
        }

        ListDoubleClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class InsightList
    extends JList {
        public void requestTemporaryFocus() {
            this.requestFocus(true);
        }

        private InsightList() {
        }

        InsightList(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ShowInsightAction
    extends AbstractAction {
        public ShowInsightAction() {
            super(CompletionPopupHandler.SHOW_INSIGHT_ACTION_NAME);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent ae) {
            CompletionPopupHandler.this.setInsightVisible(true);
        }
    }
}

