/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;

public class CompletionTextArea
extends JTextArea
implements CompletionTextComponent {
    private final CompletionPopupHandler _popupHandler;

    public CompletionTextArea() {
        this._popupHandler = new TextAreaPopupHandler(this);
    }

    public CompletionTextArea(CompletionPopupHandler popupHandler) {
        this._popupHandler = popupHandler;
    }

    public CompletionPopupHandler getPopupHandler() {
        return this._popupHandler;
    }

    public void removeNotify() {
        super.removeNotify();
        this._popupHandler.setInsightVisible(false);
    }

    public void setText(String text) {
        this._popupHandler.acquireInsightLock();
        try {
            super.setText(text);
        }
        finally {
            this._popupHandler.yieldInsightLock();
        }
    }

    private static final class TextAreaPopupHandler
    extends CompletionPopupHandler {
        TextAreaPopupHandler(JTextArea component) {
            super(component);
        }

        protected int getVerticalPopupOffset(Component component) {
            JTextArea textArea = (JTextArea)this.getTextComponent();
            int caretPos = textArea.getCaretPosition();
            try {
                Rectangle viewPos = textArea.modelToView(caretPos);
                int n = viewPos.y + viewPos.height;
                return n;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                int n = super.getVerticalPopupOffset(component);
                return n;
            }
        }
    }
}

