/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicelist;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;

public final class NiceList
extends JList {
    private final CopyOnWriteArrayList<NiceListActionListener> _listeners;
    private final CopyOnWriteArrayList<ActionListener> _doubleClickListeners;
    private boolean _checkOnSelectionChanged;
    private boolean _checkOnDoubleClick;

    private void $init$() {
        this._listeners = new CopyOnWriteArrayList();
        this._doubleClickListeners = new CopyOnWriteArrayList();
        this._checkOnSelectionChanged = false;
        this._checkOnDoubleClick = false;
    }

    public NiceList() {
        this.$init$();
        Listener.mav$attach(new Listener(null), this);
        this.setSelectionMode(0);
    }

    public void setFireCheckboxActionOnDoubleClick(boolean toggleOnDoubleClick) {
        if (this._checkOnDoubleClick != toggleOnDoubleClick) {
            this._checkOnDoubleClick = toggleOnDoubleClick;
            this.firePropertyChange("fireCheckboxActionOnDoubleClick", toggleOnDoubleClick ^ true, toggleOnDoubleClick);
        }
    }

    public boolean isFireCheckboxActionOnDoubleClick() {
        return this._checkOnDoubleClick;
    }

    public void setFireCheckboxActionOnSelectionChanged(boolean fire) {
        if (this._checkOnSelectionChanged != fire) {
            this._checkOnSelectionChanged = fire;
            this.firePropertyChange("fireCheckboxActionOnSelectionChanged", fire ^ true, fire);
        }
    }

    public boolean isFireCheckboxActionOnSelectionChanged() {
        return this._checkOnSelectionChanged;
    }

    public final void addDoubleClickActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._doubleClickListeners.add(listener);
    }

    public final void removeDoubleClickActionListener(ActionListener listener) {
        this._doubleClickListeners.remove(listener);
    }

    public final void addListActionListener(NiceListActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._listeners.add(listener);
    }

    public final void removeListActionListener(NiceListActionListener listener) {
        this._listeners.remove(listener);
    }

    private void fireListActionEvent(NiceListActionEvent lae) {
        if (!this._listeners.isEmpty()) {
            for (NiceListActionListener listener : this._listeners) {
                listener.listActionPerformed(lae);
            }
        }
    }

    protected final void fireCheckBoxAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.CHECKBOX, row));
        }
    }

    protected final void fireHyperLinkAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.HYPERLINK, row));
        }
    }

    protected final void fireSecondaryHyperLinkAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.SECONDARY_HYPERLINK, row));
        }
    }

    static CopyOnWriteArrayList ra$_doubleClickListeners(NiceList niceList) {
        return niceList._doubleClickListeners;
    }

    static boolean ra$_checkOnDoubleClick(NiceList niceList) {
        return niceList._checkOnDoubleClick;
    }

    static boolean ra$_checkOnSelectionChanged(NiceList niceList) {
        return niceList._checkOnSelectionChanged;
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener,
    MouseMotionListener {
        private int _lastCheckBoxHitRow;
        private int _lastHyperlinkHitRow;
        private int _lastSecondaryHyperlinkHitRow;

        private void $init$() {
            this._lastCheckBoxHitRow = -1;
            this._lastHyperlinkHitRow = -1;
            this._lastSecondaryHyperlinkHitRow = -1;
        }

        private void attach(JComponent c) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
            c.addKeyListener(this);
        }

        public void mousePressed(MouseEvent me) {
            ListCellRenderer renderer = NiceList.this.getCellRenderer();
            if (renderer instanceof NiceListRenderer && me.getButton() == 1) {
                int secondaryHyperlinkRow;
                int hyperlinkRow;
                NiceListRenderer ucr = (NiceListRenderer)renderer;
                int checkBoxRow = ucr.testCheckBoxHit(NiceList.this, me.getPoint());
                if (checkBoxRow >= 0) {
                    this._lastCheckBoxHitRow = checkBoxRow;
                }
                if ((hyperlinkRow = ucr.testHyperLinkHit(NiceList.this, me.getPoint())) >= 0) {
                    this._lastHyperlinkHitRow = hyperlinkRow;
                }
                if ((secondaryHyperlinkRow = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint())) >= 0) {
                    this._lastSecondaryHyperlinkHitRow = secondaryHyperlinkRow;
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            ListCellRenderer renderer = NiceList.this.getCellRenderer();
            if (renderer instanceof NiceListRenderer) {
                if (me.getButton() == 1) {
                    int hyperlinkRow;
                    int hyperlinkRow2;
                    int checkBoxRow;
                    NiceListRenderer ucr = (NiceListRenderer)renderer;
                    if (NiceList.ra$_checkOnSelectionChanged(NiceList.this)) {
                        int row = this.rowFor(me);
                        if (row != -1) {
                            NiceList.this.fireCheckBoxAction(row);
                        }
                    } else if (this._lastCheckBoxHitRow >= 0 && (checkBoxRow = ucr.testCheckBoxHit(NiceList.this, me.getPoint())) == this._lastCheckBoxHitRow) {
                        NiceList.this.fireCheckBoxAction(checkBoxRow);
                    }
                    if (this._lastHyperlinkHitRow >= 0 && (hyperlinkRow2 = ucr.testHyperLinkHit(NiceList.this, me.getPoint())) == this._lastHyperlinkHitRow) {
                        NiceList.this.fireHyperLinkAction(hyperlinkRow2);
                    }
                    if (this._lastSecondaryHyperlinkHitRow >= 0 && (hyperlinkRow = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint())) == this._lastSecondaryHyperlinkHitRow) {
                        NiceList.this.fireSecondaryHyperLinkAction(hyperlinkRow);
                    }
                }
                this._lastCheckBoxHitRow = -1;
                this._lastHyperlinkHitRow = -1;
                this._lastSecondaryHyperlinkHitRow = -1;
            }
        }

        public void keyPressed(KeyEvent ke) {
        }

        public void keyTyped(KeyEvent ke) {
        }

        public void keyReleased(KeyEvent ke) {
            int[] centers;
            if (ke.getKeyCode() == 32 && (centers = NiceList.this.getSelectedIndices()) != null && centers.length > 0) {
                int i = 0;
                while (i < centers.length) {
                    int centerIndex = centers[i];
                    NiceList.this.fireCheckBoxAction(centerIndex);
                    ++i;
                }
            }
        }

        public void mouseMoved(MouseEvent me) {
            NiceListRenderer ucr = (NiceListRenderer)NiceList.this.getCellRenderer();
            int hyperhit = ucr.testHyperLinkHit(NiceList.this, me.getPoint());
            int hyperSec = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint());
            if (hyperhit >= 0 || hyperSec >= 0) {
                NiceList.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                NiceList.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseDragged(MouseEvent me) {
        }

        private int rowFor(MouseEvent event) {
            int location = NiceList.this.locationToIndex(event.getPoint());
            if (location == -1) {
                return -1;
            }
            if (NiceList.this.getCellBounds(location, location).contains(event.getPoint())) {
                return location;
            }
            return -1;
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getButton() != 1) {
                return;
            }
            if (event.getClickCount() != 2) {
                return;
            }
            int row = this.rowFor(event);
            if (row == -1) {
                return;
            }
            this.doubleClick(row);
        }

        private void doubleClick(int row) {
            this.fireDoubleClickAction();
            if (NiceList.ra$_checkOnDoubleClick(NiceList.this)) {
                NiceList.this.fireCheckBoxAction(row);
            }
        }

        private void fireDoubleClickAction() {
            if (NiceList.ra$_doubleClickListeners(NiceList.this).isEmpty()) {
                return;
            }
            ActionEvent ae = new ActionEvent(this, 1001, "");
            for (ActionListener l : NiceList.ra$_doubleClickListeners(NiceList.this)) {
                l.actionPerformed(ae);
            }
        }

        private Listener() {
            this.$init$();
        }

        Listener(1 var2_2) {
            this();
        }

        static void mav$attach(Listener listener, JComponent jComponent) {
            listener.attach(jComponent);
        }

        public final class 1 {
        }
    }
}

