/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.themes.LinearGradientPainter;
import oracle.javatools.ui.themes.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NiceListRenderer<T>
extends JPanel
implements ListCellRenderer {
    private Color _gradientLightColor;
    private Color _gradientDarkColor;
    private Color _selectedForegroundColor;
    private Color _unselectedForegroundColor;
    private Painter _selectedPainter;
    private JToggleButton _checkBox;
    private final JLabel _titleLabel;
    private final JLabel _descriptionLabel;
    private final JLabel _descriptionLabel2;
    private final JPanel _indicatorsPanel;
    private final JLabel _indicatorLabel;
    private final HyperlinkButton _hyperlink;
    private final HyperlinkButton _secondaryHyperlink;
    private boolean _selected;
    private static final Color BACKGROUND_COLOR = new Color(251, 251, 251);
    private boolean _twoLineDescription;
    private AccessibleContext _accessibleContext;
    private boolean _layoutDone;

    private void $init$() {
        this._gradientLightColor = Colors.GRADIENT_SELECTION_LIGHT;
        this._gradientDarkColor = Colors.GRADIENT_SELECTION_DARK;
        this._selectedForegroundColor = Color.BLACK;
        this._unselectedForegroundColor = Color.BLACK;
        this._selectedPainter = this.createSelectionPainter();
        this._checkBox = new JCheckBox();
        this._titleLabel = new JLabel();
        this._descriptionLabel = new JLabel();
        this._descriptionLabel2 = new JLabel();
        this._indicatorsPanel = new JPanel();
        this._indicatorLabel = new JLabel();
        this._hyperlink = new HyperlinkButton();
        this._secondaryHyperlink = new HyperlinkButton();
        this._twoLineDescription = false;
    }

    private void layoutComponents() {
        if (!this._layoutDone) {
            this._layoutDone = true;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this._checkBox, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this._titleLabel, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this._indicatorsPanel, gbc);
            this._indicatorsPanel.setOpaque(false);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.insets = new Insets(0, 5, 0, 0);
            JPanel p = new JPanel();
            p.setOpaque(false);
            p.setPreferredSize(this._checkBox.getPreferredSize());
            this.add((Component)p, gbc);
            gbc.gridx = 1;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._descriptionLabel, gbc);
            ++gbc.gridx;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._hyperlink, gbc);
            ++gbc.gridy;
            gbc.gridx = 1;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._descriptionLabel2, gbc);
            this._descriptionLabel2.setVisible(this._twoLineDescription);
            ++gbc.gridx;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 5, 2, 5);
            this.add((Component)this._secondaryHyperlink, gbc);
            this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(1));
            this._checkBox.setOpaque(false);
            this._checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(200, 200, 200)));
            this.setOpaque(false);
            this.updateUI();
            this._indicatorsPanel.setLayout(new BoxLayout(this._indicatorsPanel, 0));
            this._indicatorsPanel.add(this._indicatorLabel);
        }
    }

    public final void setRadioButtonStyle(boolean radioButtonStyle) {
        if (this.isRadioButtonStyle() != radioButtonStyle) {
            JToggleButton jToggleButton = this._checkBox = radioButtonStyle ? new JRadioButton() : new JCheckBox();
            if (this._layoutDone) {
                this._layoutDone = false;
                this.removeAll();
            }
        }
    }

    private Painter createSelectionPainter() {
        return new LinearGradientPainter(this._gradientLightColor, this._gradientDarkColor, 1);
    }

    public final boolean isRadioButtonStyle() {
        return this._checkBox instanceof JRadioButton;
    }

    public final void setGradientColor(Color light, Color dark) {
        if (light == null) {
            throw new NullPointerException("light is null");
        }
        if (dark == null) {
            throw new NullPointerException("dark is null");
        }
        this._gradientLightColor = light;
        this._gradientDarkColor = dark;
        this._selectedPainter = this.createSelectionPainter();
    }

    public final void setSelectedForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("color must not be null");
        }
        this._selectedForegroundColor = color;
    }

    public final void setUnselectedForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("color must not be null");
        }
        this._unselectedForegroundColor = color;
    }

    public final void setTwoLineDescription(boolean twoLine) {
        this._twoLineDescription = twoLine;
        this._descriptionLabel2.setVisible(twoLine);
        this.invalidate();
        this.validate();
    }

    final int testCheckBoxHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, this._checkBox);
    }

    final int testHyperLinkHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, this._hyperlink);
    }

    final int testSecondaryHyperLinkHit(JList list, Point mousePoint) {
        return this.getRendererRow(list, mousePoint, this._secondaryHyperlink);
    }

    private int getRendererRow(JList list, Point mousePoint, Component c) {
        int row = list.locationToIndex(mousePoint);
        if (row >= 0) {
            Point rowOrigin = list.indexToLocation(row);
            Point rendererPoint = new Point(mousePoint.x - rowOrigin.x, mousePoint.y - rowOrigin.y);
            this.getListCellRendererComponent(list, list.getModel().getElementAt(row), row, false, true);
            if (c.getBounds().contains(rendererPoint)) {
                return row;
            }
        }
        return -1;
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this._selected) {
            this._selectedPainter.paint(g, 0, 0, this.getWidth(), this.getHeight());
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.layoutComponents();
        boolean bl = this._selected = list.isEnabled() && isSelected;
        Color fg = list.isEnabled() ? (this._selected ? this._selectedForegroundColor : this._unselectedForegroundColor) : UIManager.getColor("textInactiveText");
        this._titleLabel.setForeground(fg);
        this._descriptionLabel.setForeground(fg);
        Object valueT = value;
        this._titleLabel.setText(this.getTitle(valueT));
        String description = this.getDescription(valueT);
        this._descriptionLabel.setText(description == null || description.length() == 0 ? " " : description);
        this._descriptionLabel2.setText(this.getSecondDescription(valueT));
        this._checkBox.setSelected(this.isItemSelected(valueT));
        this._checkBox.setEnabled(list.isEnabled());
        this._checkBox.setVisible(this.isCheckable(valueT));
        this._hyperlink.setText(this.getHyperLinkText(valueT));
        String secondaryLink = this.getSecondaryHyperLinkText(valueT);
        if (secondaryLink != null && secondaryLink.length() > 0) {
            this._secondaryHyperlink.setVisible(true);
            this._secondaryHyperlink.setText(secondaryLink);
        } else {
            this._secondaryHyperlink.setVisible(false);
        }
        Icon indicator = this.getIndicator(valueT);
        this._indicatorLabel.setIcon(indicator);
        if (list.isEnabled()) {
            this.setBackground(this.getBackgroundColor(valueT));
        } else {
            this.setBackground(UIManager.getColor("control"));
        }
        Container parent = list.getParent();
        int preferredWidth = parent != null && parent instanceof JViewport ? ((JViewport)parent).getExtentSize().width : list.getWidth();
        this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
        return this;
    }

    protected Color getBackgroundColor(T listItem) {
        return BACKGROUND_COLOR;
    }

    public final String getText() {
        return this._titleLabel.getText();
    }

    protected abstract String getTitle(T var1);

    protected abstract String getDescription(T var1);

    protected String getSecondDescription(T listItem) {
        return null;
    }

    protected abstract boolean isItemSelected(T var1);

    protected String getHyperLinkText(T listItem) {
        return "";
    }

    protected String getSecondaryHyperLinkText(T listItem) {
        return "";
    }

    protected Icon getIndicator(T listItem) {
        return null;
    }

    protected boolean isCheckable(T listItem) {
        return true;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new AccessibleNiceListRenderer(null);
        }
        return this._accessibleContext;
    }

    public NiceListRenderer() {
        this.$init$();
    }

    static JToggleButton ra$_checkBox(NiceListRenderer niceListRenderer) {
        return niceListRenderer._checkBox;
    }

    static JLabel ra$_titleLabel(NiceListRenderer niceListRenderer) {
        return niceListRenderer._titleLabel;
    }

    static JLabel ra$_descriptionLabel(NiceListRenderer niceListRenderer) {
        return niceListRenderer._descriptionLabel;
    }

    static JLabel ra$_descriptionLabel2(NiceListRenderer niceListRenderer) {
        return niceListRenderer._descriptionLabel2;
    }

    private class AccessibleNiceListRenderer
    extends JComponent.AccessibleJComponent {
        public String getAccessibleName() {
            return NiceListRenderer.ra$_titleLabel(NiceListRenderer.this).getText() + " " + NiceListRenderer.ra$_descriptionLabel(NiceListRenderer.this).getText() + " " + NiceListRenderer.ra$_descriptionLabel2(NiceListRenderer.this).getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (NiceListRenderer.this.isFocusOwner()) {
                states.add(AccessibleState.FOCUSED);
            }
            if (NiceListRenderer.ra$_checkBox(NiceListRenderer.this).isSelected()) {
                states.add(AccessibleState.CHECKED);
            }
            return states;
        }

        private AccessibleNiceListRenderer() {
            super(NiceListRenderer.this);
        }

        AccessibleNiceListRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

