/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;

public class NiceTableHeaderRenderer
extends DefaultTableCellRenderer {
    private final DefaultTableCellRenderer _defaultRenderer;
    static final Dimension SORT_ICON_SIZE = new Dimension(9, 5);

    private void $init$() {
        this._defaultRenderer = (DefaultTableCellRenderer)new JTable().getTableHeader().getDefaultRenderer();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this._defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this._defaultRenderer.setBackground(header.getBackground());
                this._defaultRenderer.setFont(header.getFont());
                if (table.isEnabled()) {
                    this._defaultRenderer.setForeground(header.getForeground());
                } else {
                    this._defaultRenderer.setForeground(UIManager.getColor("textInactiveText"));
                }
            }
            if (table instanceof NiceTable && ((NiceTable)table).getBaseModel() instanceof NiceTableModel) {
                int modelColumn = table.convertColumnIndexToModel(column);
                NiceTableModel niceModel = (NiceTableModel)((NiceTable)table).getBaseModel();
                this._defaultRenderer.setHorizontalAlignment(niceModel.getColumnAlignment(modelColumn));
                if (table instanceof NiceTable && ((NiceTable)table).isSorted() && ((NiceTable)table).getSortColumn() == modelColumn) {
                    this._defaultRenderer.setHorizontalTextPosition(2);
                    boolean ascending = ((NiceTable)table).isSortAscending();
                    Icon i = ascending ? new SortIconUp(null) : new SortIconDown(null);
                    this._defaultRenderer.setIcon(i);
                } else {
                    this._defaultRenderer.setIcon(null);
                }
            }
        }
        this._defaultRenderer.setBorder(BorderFactory.createCompoundBorder(this._defaultRenderer.getBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        return this._defaultRenderer;
    }

    public NiceTableHeaderRenderer() {
        this.$init$();
    }

    private class SortIconDown
    implements Icon {
        public int getIconHeight() {
            return NiceTableHeaderRenderer.SORT_ICON_SIZE.height;
        }

        public int getIconWidth() {
            return NiceTableHeaderRenderer.SORT_ICON_SIZE.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 1, x + 9, y + 1);
            g.drawLine(x + 1, y + 2, x + 8, y + 2);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 4, x + 6, y + 4);
            g.drawLine(x + 4, y + 5, x + 5, y + 5);
        }

        private SortIconDown() {
        }

        SortIconDown(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SortIconUp
    implements Icon {
        public int getIconHeight() {
            return NiceTableHeaderRenderer.SORT_ICON_SIZE.height;
        }

        public int getIconWidth() {
            return NiceTableHeaderRenderer.SORT_ICON_SIZE.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 5, x + 9, y + 5);
            g.drawLine(x + 1, y + 4, x + 8, y + 4);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 2, x + 6, y + 2);
            g.drawLine(x + 4, y + 1, x + 5, y + 1);
        }

        private SortIconUp() {
        }

        SortIconUp(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

