/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import oracle.javatools.controls.nicetable.NiceTableAutoSizeModel;
import oracle.javatools.controls.nicetable.NiceTableModel;

class NiceTableSortDecorator
extends AbstractTableModel
implements TableModelListener,
NiceTableAutoSizeModel {
    private NiceTableModel m_realModel;
    private Integer[] m_indexes;
    private int[] m_reverseIndex;

    NiceTableSortDecorator(NiceTableModel realModel) {
        this.setRealModel(realModel);
    }

    void setRealModel(NiceTableModel realModel) {
        if (this.m_realModel != null) {
            this.m_realModel.removeTableModelListener(this);
        }
        this.m_realModel = realModel;
        if (realModel == null) {
            this.m_indexes = null;
            return;
        }
        this.m_realModel.addTableModelListener(this);
        this.allocate();
    }

    int getModelRow(int viewRow) {
        return this.m_indexes[viewRow];
    }

    int getViewRow(int modelRow) {
        if (this.m_reverseIndex == null) {
            this.m_reverseIndex = new int[this.m_indexes.length];
            int i = 0;
            while (i < this.m_indexes.length) {
                this.m_reverseIndex[this.m_indexes[i].intValue()] = i;
                ++i;
            }
        }
        return this.m_reverseIndex[modelRow];
    }

    private void allocate() {
        this.m_indexes = new Integer[this.m_realModel.getRowCount()];
        int i = 0;
        while (i < this.m_indexes.length) {
            this.m_indexes[i] = new Integer(i);
            ++i;
        }
        this.m_reverseIndex = null;
    }

    void sort(int column, boolean ascending) {
        this.m_reverseIndex = null;
        Comparator comp = this.getComparator(column, ascending);
        Arrays.sort(this.m_indexes, comp);
        super.fireTableChanged(new TableModelEvent(this));
    }

    private Comparator getComparator(int column, boolean ascending) {
        Comparator modelComparator = this.getRealModel().getColumnSortComparator(column);
        if (modelComparator == null) {
            modelComparator = new SafeObjectComparator(null);
        }
        return new SortComparator(modelComparator, column, ascending);
    }

    NiceTableModel getRealModel() {
        return this.m_realModel;
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.m_indexes.length || column >= this.getColumnCount()) {
            return null;
        }
        return this.m_realModel.getValueAt(this.m_indexes[row], column);
    }

    public void setValueAt(Object avalue, int row, int column) {
        this.m_realModel.setValueAt(avalue, this.m_indexes[row], column);
    }

    public int getRowCount() {
        if (this.m_indexes == null) {
            this.allocate();
        }
        return this.m_indexes.length;
    }

    public int getColumnCount() {
        return this.m_realModel.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.m_realModel.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_realModel.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int row, int column) {
        return this.m_realModel.isCellEditable(this.m_indexes[row], column);
    }

    public void addTableModelListener(TableModelListener tml) {
        this.m_realModel.addTableModelListener(tml);
    }

    public void removeTableModelListener(TableModelListener tml) {
        this.m_realModel.removeTableModelListener(tml);
    }

    public void tableChanged(TableModelEvent tme) {
        if (tme.getType() != 0 || tme.getType() == 0 && tme.getColumn() == -1) {
            this.allocate();
        }
        super.fireTableChanged(tme);
    }

    public int getColumnAutoSizeMaximum(int column) {
        if (this.m_realModel instanceof NiceTableAutoSizeModel) {
            return ((NiceTableAutoSizeModel)((Object)this.m_realModel)).getColumnAutoSizeMaximum(column);
        }
        return Integer.MAX_VALUE;
    }

    static NiceTableModel ra$m_realModel(NiceTableSortDecorator niceTableSortDecorator) {
        return niceTableSortDecorator.m_realModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SafeObjectComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
            return o1.toString().compareTo(o2.toString());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SafeObjectComparator;
        }

        private SafeObjectComparator() {
        }

        SafeObjectComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortComparator
    implements Comparator {
        private Comparator m_delegateComparator;
        private int m_column;
        private boolean m_ascending;

        SortComparator(Comparator delegate, int column, boolean ascending) {
            this.m_delegateComparator = delegate;
            this.m_column = column;
            this.m_ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer && o2 instanceof Integer && o1 != null && o2 != null) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                Object obj1 = NiceTableSortDecorator.ra$m_realModel(NiceTableSortDecorator.this).getValueAt(i1, this.m_column);
                Object obj2 = NiceTableSortDecorator.ra$m_realModel(NiceTableSortDecorator.this).getValueAt(i2, this.m_column);
                int result = this.m_delegateComparator.compare(obj1, obj2);
                if (!this.m_ascending) {
                    return -1 * result;
                }
                return result;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o instanceof SortComparator;
        }
    }
}

