/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import oracle.javatools.controls.nicetable.NiceTable;

public class NiceTableViewport
extends JViewport
implements TableColumnModelListener {
    public void setView(Component c) {
        if (!(c instanceof NiceTable)) {
            throw new IllegalArgumentException("Cannot setView() on NiceTableViewport unless view is a NiceTable");
        }
        if (this.getView() instanceof NiceTable) {
            ((NiceTable)this.getView()).getColumnModel().removeColumnModelListener(this);
        }
        super.setView(c);
        ((NiceTable)c).getColumnModel().addColumnModelListener(this);
    }

    public void setViewPosition(Point p) {
        super.setViewPosition(p);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        NiceTable nt = (NiceTable)super.getView();
        if (nt.isSorted() && nt.getTableHeader() != null && nt.getTableHeader().isVisible()) {
            int column = nt.getSortColumn();
            column = nt.convertColumnIndexToView(column);
            Rectangle rect = nt.getTableHeader().getHeaderRect(column);
            g.setColor(nt.getSortColumnBackgroundColor());
            g.fillRect(rect.x, 0, rect.width, this.getHeight());
        }
    }

    public void columnAdded(TableColumnModelEvent e) {
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent e) {
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent e) {
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        this.repaint();
    }
}

