/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPlugin;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.logging.LogUtils;

public final class DataTransferPluginRegistry {
    private final List _factories;
    private static final DataTransferPluginRegistry _sGLOBAL = new DataTransferPluginRegistry();
    private static final Logger _LOGGER = Logger.getLogger(DataTransferPluginRegistry.class.getName());

    public static DataTransferPluginRegistry getGlobalInstance() {
        return _sGLOBAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performAugmentation(AugmentableTransferable trans, Collection registries) {
        long before = System.currentTimeMillis();
        LinkedList<DataTransferPlugin> plugins = new LinkedList<DataTransferPlugin>();
        Iterator regItor = registries.iterator();
        while (regItor.hasNext()) {
            DataTransferPluginRegistry reg;
            DataTransferPluginRegistry dataTransferPluginRegistry = reg = (DataTransferPluginRegistry)regItor.next();
            synchronized (dataTransferPluginRegistry) {
                for (DataTransferPluginFactory fac : reg._factories) {
                    DataTransferPlugin plug = fac.createPlugin(trans);
                    if (plug == null) continue;
                    plugins.add(plug);
                }
            }
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "About to performAugmentation; flavors={0} plugins={1}", new Object[]{Arrays.asList(trans.getTransferDataFlavors()), plugins});
        }
        while (!plugins.isEmpty()) {
            int modCountBeforeRound = trans.getModificationCount();
            Iterator itor = plugins.iterator();
            while (itor.hasNext()) {
                boolean done;
                DataTransferPlugin plugin = (DataTransferPlugin)itor.next();
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "Running plugin {0} on {1}, modCountNow={2} modCountBeforeRound={3}", new Object[]{plugin, trans, new Integer(trans.getModificationCount()), new Integer(modCountBeforeRound)});
                }
                if (!(done = DataTransferPluginRegistry._runPlugin(plugin, trans))) continue;
                _LOGGER.log(Level.FINER, "Removing completed plugin from list: {0}", plugin);
                itor.remove();
            }
            int modCountAfterRound = trans.getModificationCount();
            if (modCountBeforeRound == modCountAfterRound) break;
        }
        long after = System.currentTimeMillis();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Augmentation done in {0} ms; flavors={1}", new Object[]{new Long(after - before), Arrays.asList(trans.getTransferDataFlavors())});
        }
    }

    public synchronized void registerFactory(DataTransferPluginFactory factory) {
        this._factories.add(factory);
    }

    public synchronized void unregisterFactory(DataTransferPluginFactory factory) {
        this._factories.remove(factory);
    }

    private static boolean _runPlugin(DataTransferPlugin plugin, AugmentableTransferable trans) {
        try {
            boolean bl = plugin.augmentIfDesired(trans);
            return bl;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Plugin threw exception: {0}", (Object)plugin, (Throwable)t);
            return true;
        }
    }

    private void $init$() {
        this._factories = new ArrayList();
    }

    public DataTransferPluginRegistry() {
        this.$init$();
    }
}

