/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPlugin;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.logging.LogUtils;

class ReflectiveDataTransferPluginFactory
implements DataTransferPluginFactory {
    private final Class _clazz;
    private static final Logger _LOGGER = Logger.getLogger(ReflectiveDataTransferPluginFactory.class.getName());

    public ReflectiveDataTransferPluginFactory(Class clazz) {
        if (clazz == null || !DataTransferPlugin.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class must be non-null and assignable to DataTransferPlugin!");
        }
        this._clazz = clazz;
    }

    public DataTransferPlugin createPlugin(AugmentableTransferable trans) {
        try {
            DataTransferPlugin dataTransferPlugin = (DataTransferPlugin)this._clazz.newInstance();
            return dataTransferPlugin;
        }
        catch (InstantiationException e) {
            this._err(e);
        }
        catch (IllegalAccessException e) {
            this._err(e);
        }
        catch (ClassCastException e) {
            this._err(e);
        }
        return null;
    }

    private void _err(Exception e) {
        LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)"Exception instantiating plugin class {0}", (Object)this._clazz, (Throwable)e);
    }
}

