/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.logging.LogUtils;

final class TransferableBackedTransferDataInfo
extends TransferDataInfo {
    private transient Object _cached;
    private final Transferable _trans;
    private final DataFlavor _flavor;
    private final float _rank;
    private boolean _allowEarlyFetch;
    private static final Logger _LOGGER = Logger.getLogger(TransferableBackedTransferDataInfo.class.getName());

    public TransferableBackedTransferDataInfo(Transferable trans, DataFlavor flavor, float rank, boolean allowEarlyFetch) {
        this.$init$();
        this._trans = trans;
        this._flavor = flavor;
        this._rank = rank;
        this._allowEarlyFetch = allowEarlyFetch;
    }

    public DataFlavor getDataFlavor() {
        return this._flavor;
    }

    public Object getData(FetchMode mode, boolean asReference) throws IOException {
        block3: {
            if (this._cached == null && (this._allowEarlyFetch || mode == FetchMode.STANDARD)) {
                try {
                    this._cached = this._trans.getTransferData(this._flavor);
                }
                catch (UnsupportedFlavorException e) {
                    if (!_LOGGER.isLoggable(Level.FINER)) break block3;
                    LogUtils.log((Logger)_LOGGER, (Level)Level.FINER, (String)"Unsupported flavor that was in the list! transferable={0} flavor={1}", (Object[])new Object[]{this._trans, this._flavor}, (Throwable)e);
                }
            }
        }
        return this._cached;
    }

    public float getSuitabilityRank() {
        return this._rank;
    }

    private void $init$() {
        this._cached = null;
    }
}

