/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.BundleLoader;

public class BaseMessageDialog
extends JEWTDialog {
    public static final int TYPE_APPLICATION_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_ALERT = 3;
    public static final int TYPE_CONFIRMATION = 4;
    public static final int TYPE_CONFIRM_OR_CANCEL = 5;
    private MessagePanel m_content;
    private JButton m_yesButton;
    private JButton m_noButton;
    private boolean m_yesClicked;
    private boolean m_noClicked;

    private void $init$() {
        this.m_yesClicked = false;
        this.m_noClicked = false;
    }

    boolean isYesClicked() {
        return this.m_yesClicked;
    }

    boolean isNoClicked() {
        return this.m_noClicked;
    }

    JButton getYesButton() {
        return this.m_yesButton;
    }

    JButton getNoButton() {
        return this.m_noButton;
    }

    protected BaseMessageDialog(Frame owner, String title, int buttonMask) {
        super(owner, title, buttonMask);
        this.$init$();
        this.initContent();
    }

    protected BaseMessageDialog(Dialog owner, String title, int buttonMask) {
        super(owner, title, buttonMask);
        this.$init$();
        this.initContent();
    }

    public static BaseMessageDialog createMessageDialogImpl(Component parent, String title, int messageType) {
        BaseMessageDialog d = null;
        while (parent != null) {
            if (parent instanceof Dialog) {
                d = new BaseMessageDialog((Dialog)parent, title, 7);
                break;
            }
            if (parent instanceof Frame) {
                d = new BaseMessageDialog((Frame)parent, title, 7);
                break;
            }
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (d == null) {
            d = new BaseMessageDialog((Frame)null, title, 7);
        }
        d.setMessageType(messageType);
        return d;
    }

    private void initContent() {
        this.m_content = new MessagePanel();
        this.setContent(this.m_content);
    }

    public void setMessage(Object msg) {
        this.m_content.setMessage(msg);
    }

    public void setMessageText(String message) {
        this.m_content.setMessageText(message);
    }

    public void setMessageText(String message, Object[] substitute) {
        this.setMessageText(MessageFormat.format(message, substitute));
    }

    public void setMessageType(int type) {
        ResourceBundle bundle = BundleLoader.getBundle((String)"oracle.javatools.resource.DialogsBundle");
        switch (type) {
            case 1: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 2: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 3: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 4: {
                this.setButtonMask(3);
                this.setOKButtonText(bundle.getString("MD_YES"));
                this.setOKButtonMnemonic(bundle.getString("MD_YES_MNEMONIC").charAt(0));
                this.setCancelButtonText(bundle.getString("MD_NO"));
                this.setCancelButtonMnemonic(bundle.getString("MD_NO_MNEMONIC").charAt(0));
                this.m_content.setMessageType(type);
                break;
            }
            case 5: {
                this.setButtonMask(2);
                this.m_yesButton = new JButton();
                this.m_yesButton.setText(bundle.getString("MD_YES"));
                this.m_yesButton.setMnemonic(bundle.getString("MD_YES_MNEMONIC").charAt(0));
                this.m_noButton = new JButton();
                this.m_noButton.setText(bundle.getString("MD_NO"));
                this.m_noButton.setMnemonic(bundle.getString("MD_NO_MNEMONIC").charAt(0));
                this.m_yesClicked = false;
                this.m_noClicked = false;
                1 al = new 1();
                this.m_yesButton.addActionListener(al);
                this.m_noButton.addActionListener(al);
                this.addCustomButton(this.m_yesButton);
                this.addCustomButton(this.m_noButton);
                this.m_content.setMessageType(4);
                break;
            }
        }
    }

    void setDefaultButton(JButton button) {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.setDefaultCapable(false);
        }
        this.getRootPane().setDefaultButton(button);
        if (button != null) {
            button.setDefaultCapable(true);
        }
    }

    public void setHelpTopic(String id) {
        HelpUtils.setHelpID((JComponent)this.m_content, (String)id);
    }

    protected boolean runActualDialog() {
        char c = (char)this.getOKButtonMnemonic();
        this.getContent().addKeyListener(new 2(this, c));
        c = (char)this.getCancelButtonMnemonic();
        this.getContent().addKeyListener(new 3(this, c));
        boolean result = super.runDialog();
        EventQueue.invokeLater(new 4());
        return result;
    }

    public boolean runDialog() {
        return this.doInvoke(new 5(this));
    }

    private boolean doInvoke(JEWTDialogInvoker invoker) {
        if (EventQueue.isDispatchThread()) {
            invoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoker.getResponse();
    }

    static void mav$dismissDialog(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.dismissDialog(bl);
    }

    static JButton ra$m_yesButton(BaseMessageDialog baseMessageDialog) {
        return baseMessageDialog.m_yesButton;
    }

    static void wa$m_yesClicked(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.m_yesClicked = bl;
    }

    static JButton ra$m_noButton(BaseMessageDialog baseMessageDialog) {
        return baseMessageDialog.m_noButton;
    }

    static void wa$m_noClicked(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.m_noClicked = bl;
    }

    static void wa$m_yesButton(BaseMessageDialog baseMessageDialog, JButton jButton) {
        baseMessageDialog.m_yesButton = jButton;
    }

    static void wa$m_noButton(BaseMessageDialog baseMessageDialog, JButton jButton) {
        baseMessageDialog.m_noButton = jButton;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            BaseMessageDialog.wa$m_yesClicked(BaseMessageDialog.this, ae.getSource() == BaseMessageDialog.ra$m_yesButton(BaseMessageDialog.this));
            BaseMessageDialog.wa$m_noClicked(BaseMessageDialog.this, ae.getSource() == BaseMessageDialog.ra$m_noButton(BaseMessageDialog.this));
            BaseMessageDialog.ra$m_yesButton(BaseMessageDialog.this).removeActionListener(this);
            BaseMessageDialog.ra$m_noButton(BaseMessageDialog.this).removeActionListener(this);
            BaseMessageDialog.wa$m_yesButton(BaseMessageDialog.this, null);
            BaseMessageDialog.wa$m_noButton(BaseMessageDialog.this, null);
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, false);
        }
    }

    final class 2
    extends SimpleKeyListener {
        public void doAction(KeyEvent ke) {
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, false);
        }

        public 2(BaseMessageDialog baseMessageDialog2, char c) {
            super(c);
        }
    }

    final class 3
    extends SimpleKeyListener {
        public void doAction(KeyEvent ke) {
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, true);
        }

        public 3(BaseMessageDialog baseMessageDialog2, char c) {
            super(c);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            BaseMessageDialog.this.dispose();
        }
    }

    final class 5
    extends JEWTDialogInvoker {
        public boolean doIt() {
            return BaseMessageDialog.this.runActualDialog();
        }

        public 5(BaseMessageDialog baseMessageDialog2) {
            super(null);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();

        private JEWTDialogInvoker() {
        }

        JEWTDialogInvoker(5 var2_2) {
            this();
        }
    }

    private abstract class SimpleKeyListener
    extends KeyAdapter {
        private char m_key;

        SimpleKeyListener(char key) {
            this.m_key = key;
        }

        public void keyPressed(KeyEvent event) {
            if (Character.toUpperCase(this.m_key) == Character.toUpperCase(event.getKeyChar())) {
                this.doAction(event);
            }
        }

        public abstract void doAction(KeyEvent var1);
    }
}

