/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.controls.TextMenuPopupHandler;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.resource.DialogsBundle;

public class ExceptionDialog {
    private JTextArea m_traceArea;
    private JButton m_prevButton;
    private JButton m_nextButton;
    private JLabel m_traceLabel;
    private JScrollPane m_traceScroller;
    private MessagePanel m_messagePanel;
    private JPanel m_detailsPanel;
    private boolean m_detailsShown;
    private Throwable m_throwable;
    private List m_throwableList;
    private int m_currentIndex;
    private DetailDialog m_dialog;
    private static final int TRACE_ROWS = 8;
    private static final List m_traversers = new ArrayList();

    private void $init$() {
        this.m_traceArea = new JTextArea();
        this.m_prevButton = new JButton();
        this.m_nextButton = new JButton();
        this.m_traceLabel = new JLabel();
        this.m_traceScroller = new JScrollPane(this.m_traceArea);
        this.m_messagePanel = new MessagePanel();
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsShown = false;
        this.m_currentIndex = 0;
    }

    static {
        ExceptionDialog.registerThrowableChainTraverser(SQLException.class, new SQLExceptionTraverser(null));
    }

    private ExceptionDialog() {
        this.$init$();
        this.initializePanels();
        ActionController ac = new ActionController(null);
        this.m_prevButton.addActionListener(ac);
        this.m_nextButton.addActionListener(ac);
        this.m_prevButton.setName("ExceptionPrevious");
        this.m_nextButton.setName("ExceptionNext");
        this.m_traceLabel.setName("ExceptionTraceLabel");
        this.m_detailsPanel.setName("ExceptionDetailsPanel");
        this.m_traceScroller.setName("ExceptionTraceScrollPane");
        this.m_traceArea.setName("ExceptionTrace");
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(DialogsBundle.class.getName());
    }

    public static void showExceptionDialog(Component parent, Throwable t) {
        ExceptionDialog.showExceptionDialog(parent, t, null);
    }

    public static void showExceptionDialog(Component parent, Throwable t, String message) {
        ExceptionDialog.showExceptionDialog(parent, t, "", message, null);
    }

    public static void showExceptionDialog(Component parent, Throwable t, String title, String message, String helpTopicID) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ExceptionDialog.reallyShowExceptionDialog(parent, t, title, message, helpTopicID);
        } else {
            try {
                SwingUtilities.invokeAndWait(new 1(parent, t, title, message, helpTopicID));
            }
            catch (InvocationTargetException ite) {
                ite.getTargetException().printStackTrace();
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    private static void reallyShowExceptionDialog(Component parent, Throwable t, String title, String message, String helpTopicID) {
        ExceptionDialog ed = new ExceptionDialog();
        if (t != null) {
            ed.setThrowable(t);
        }
        if (message != null) {
            ed.setMessage(message);
        }
        int buttons = 21;
        if (message != null && helpTopicID == null) {
            buttons -= 4;
        }
        DetailDialog dlg = ed.createDialog(parent, title == null ? "" : title, buttons);
        dlg.setContent(ed.m_messagePanel);
        dlg.setDetailContent(ed.m_detailsPanel);
        dlg.setResizable(true);
        String help = helpTopicID;
        if (helpTopicID == null) {
            help = "f1_idedjdevexception_html";
        }
        HelpUtils.setHelpID((JComponent)ed.m_messagePanel, (String)help);
        dlg.runDialog();
        dlg.dispose();
    }

    public static int showExceptionDialog(Window parent, Exception ex, String title, String message) {
        ExceptionDialog.showExceptionDialog(parent, ex, title, message, null);
        return 0;
    }

    public static int showExceptionDialog(Window parent, Exception ex, String message) {
        return ExceptionDialog.showExceptionDialog(parent, ex, ExceptionDialog.getBundle().getString("ED_DEFAULT_TITLE"), message);
    }

    public static int showExceptionDialog(Window parent, Exception ex) {
        return ExceptionDialog.showExceptionDialog(parent, ex, null);
    }

    public static void registerThrowableChainTraverser(Class exceptionClass, ThrowableChainTraverser tct) {
        Entry e = new Entry(null);
        e.tct = tct;
        e.clazz = exceptionClass;
        m_traversers.add(e);
    }

    public static void unregisterThrowableChainTraverser(ThrowableChainTraverser tct) {
        Iterator i = m_traversers.iterator();
        while (i.hasNext()) {
            Entry item = (Entry)i.next();
            if (item.tct != tct) continue;
            i.remove();
        }
    }

    private DetailDialog createDialog(Component parent, String title, int buttonMask) {
        this.m_dialog = DetailDialog.createDetailDialog(parent, title, buttonMask);
        return this.m_dialog;
    }

    private void initializePanels() {
        this.m_messagePanel.setMessageType(1);
        this.m_messagePanel.setMessageText(ExceptionDialog.getBundle().getString("ED_DEFAULT_MESSAGE"));
        this.m_traceArea.setTabSize(2);
        this.m_traceArea.addMouseListener(new TextMenuPopupHandler(this.m_traceArea));
        String label = ExceptionDialog.getBundle().getString("ED_PREVIOUS");
        this.m_prevButton.setText(StringUtils.stripMnemonic((String)label));
        this.m_prevButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        this.m_prevButton.setDefaultCapable(false);
        label = ExceptionDialog.getBundle().getString("ED_NEXT");
        this.m_nextButton.setText(StringUtils.stripMnemonic((String)label));
        this.m_nextButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        this.m_nextButton.setDefaultCapable(false);
        label = ExceptionDialog.getBundle().getString("ED_TRACE_SINGLE");
        this.m_traceLabel.setText(StringUtils.stripMnemonic((String)label));
        this.m_traceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        this.m_traceLabel.setLabelFor(this.m_traceArea);
        this.m_traceArea.setBackground(this.m_messagePanel.getBackground());
        this.m_detailsPanel.add((Component)this.m_traceScroller, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_prevButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_nextButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_traceLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        int largeWidth = Math.max(this.m_prevButton.getPreferredSize().width, this.m_nextButton.getPreferredSize().width);
        this.m_prevButton.setPreferredSize(new Dimension(largeWidth, this.m_prevButton.getPreferredSize().height));
        this.m_nextButton.setPreferredSize(new Dimension(largeWidth, this.m_nextButton.getPreferredSize().height));
        this.m_traceArea.setEditable(false);
        this.m_traceArea.setRows(8);
    }

    private void setThrowable(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("Throwable for ExceptionDialog must not be null");
        }
        this.m_throwable = t;
        if (this.isChainedThrowable(t)) {
            List l = this.getThrowableChain(t);
            this.m_throwableList = l.size() == 0 ? null : l;
            this.m_currentIndex = 0;
        } else {
            String label = ExceptionDialog.getBundle().getString("ED_TRACE_SINGLE");
            this.m_traceLabel.setText(StringUtils.stripMnemonic((String)label));
            this.m_traceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        }
        this.m_prevButton.setVisible(this.m_detailsShown && this.m_throwableList != null);
        this.m_nextButton.setVisible(this.m_detailsShown && this.m_throwableList != null);
        this.updateNextPrevButtonEnablement();
        this.showCurrentStack();
    }

    private void updateNextPrevButtonEnablement() {
        this.m_prevButton.setEnabled(this.m_throwableList != null && this.m_currentIndex > 0);
        this.m_nextButton.setEnabled(this.m_throwableList != null && this.m_currentIndex < this.m_throwableList.size() - 1);
    }

    private void nextStack() {
        ++this.m_currentIndex;
        this.showCurrentStack();
        this.updateNextPrevButtonEnablement();
    }

    private void previousStack() {
        --this.m_currentIndex;
        this.showCurrentStack();
        this.updateNextPrevButtonEnablement();
    }

    private void showCurrentStack() {
        Throwable theThrowable;
        if (this.m_throwableList != null) {
            theThrowable = (Throwable)this.m_throwableList.get(this.m_currentIndex);
            this.m_traceLabel.setText(MessageFormat.format(ExceptionDialog.getBundle().getString("ED_TRACE_MULTIPLE"), String.valueOf(this.m_currentIndex + 1), String.valueOf(this.m_throwableList.size())));
        } else {
            theThrowable = this.m_throwable;
        }
        this.m_traceArea.setText("");
        if (theThrowable != null) {
            this.m_traceArea.append(ExceptionDialog.getStackTrace(theThrowable));
            this.m_traceArea.setCaretPosition(0);
        }
        this.m_traceScroller.setPreferredSize(new Dimension(0, this.m_traceScroller.getPreferredSize().height));
    }

    private void setMessage(String message) {
        this.m_messagePanel.setMessageText(message);
    }

    private ThrowableChainTraverser getTraverser(Throwable t) {
        for (Entry item : m_traversers) {
            if (!item.clazz.isAssignableFrom(t.getClass())) continue;
            return item.tct;
        }
        return null;
    }

    protected boolean isChainedThrowable(Throwable t) {
        return this.getTraverser(t) != null;
    }

    protected List getThrowableChain(Throwable t) {
        ThrowableChainTraverser tct = this.getTraverser(t);
        if (tct != null) {
            return tct.getThrowableChain(t);
        }
        return null;
    }

    private static final String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter(1024);
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static JButton ra$m_nextButton(ExceptionDialog exceptionDialog) {
        return exceptionDialog.m_nextButton;
    }

    static void mav$nextStack(ExceptionDialog exceptionDialog) {
        exceptionDialog.nextStack();
    }

    static JButton ra$m_prevButton(ExceptionDialog exceptionDialog) {
        return exceptionDialog.m_prevButton;
    }

    static void mav$previousStack(ExceptionDialog exceptionDialog) {
        exceptionDialog.previousStack();
    }

    static void maS$reallyShowExceptionDialog(Component component, Throwable throwable, String string, String string2, String string3) {
        ExceptionDialog.reallyShowExceptionDialog(component, throwable, string, string2, string3);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ Component v$parent;
        private final /* synthetic */ Throwable v$t;
        private final /* synthetic */ String v$title;
        private final /* synthetic */ String v$message;
        private final /* synthetic */ String v$helpTopicID;

        public void run() {
            ExceptionDialog.maS$reallyShowExceptionDialog(this.v$parent, this.v$t, this.v$title, this.v$message, this.v$helpTopicID);
        }

        public 1(Component component, Throwable throwable, String string, String string2, String string3) {
            this.v$helpTopicID = string3;
            this.v$message = string2;
            this.v$title = string;
            this.v$t = throwable;
            this.v$parent = component;
        }
    }

    private class ActionController
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                Object source = ae.getSource();
                if (source == ExceptionDialog.ra$m_nextButton(ExceptionDialog.this)) {
                    ExceptionDialog.mav$nextStack(ExceptionDialog.this);
                } else if (source == ExceptionDialog.ra$m_prevButton(ExceptionDialog.this)) {
                    ExceptionDialog.mav$previousStack(ExceptionDialog.this);
                }
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
        }

        private ActionController() {
        }

        ActionController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static interface ThrowableChainTraverser {
        public List getThrowableChain(Throwable var1);
    }

    private static class SQLExceptionTraverser
    implements ThrowableChainTraverser {
        public List getThrowableChain(Throwable t) {
            ArrayList<SQLException> l = null;
            if (t instanceof SQLException) {
                l = new ArrayList<SQLException>();
                SQLException sqlEx = (SQLException)t;
                l.add(sqlEx);
                while (sqlEx.getNextException() != null) {
                    sqlEx = sqlEx.getNextException();
                    l.add(sqlEx);
                }
            }
            return l;
        }

        private SQLExceptionTraverser() {
        }

        SQLExceptionTraverser(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class Entry {
        ThrowableChainTraverser tct;
        Class clazz;

        private Entry() {
        }

        Entry(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

