/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.RowMap;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.FoldingFader;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.resource.BundleHelper;

public class BasicView
extends View
implements PropertyChangeListener {
    private BasicEditorPane _editor;
    private BasicDocument _document;
    private TextBuffer _textBuffer;
    private LineMap _lineMap;
    private Segment _lineBuffer;
    private CodeFoldingModel _foldingModel;
    private CodeFoldingMargin _foldingMargin;
    private NumberRange _lineRange;
    private Color _editorBackgroundColor;
    private FontHelper _fontHelper;
    private StyleRegistry _styleRegistry;
    private HighlightRegistry _highlightRegistry;
    private Font _font;
    private FontMetrics _metrics;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontDescent;
    private int _fontWidth;
    private int _numberRows;
    private int _tabSize;
    private int _composedStart;
    private int _composedEnd;
    private FoldedRowMap _rowMap;
    private boolean _useAA;
    private boolean _useItalicAA;
    private static final int[] PAINTER_TYPE_ORDER = new int[]{0, 1, 2};
    private FoldingListener _foldingListener;
    private static final int HIGHLIGHT_ARRAY_SIZE = 5;
    private static HighlightFragmentsList[] sharedHighlightArray = new HighlightFragmentsList[5];
    private static char WHITESPACE_CR_REPLACEMENT = (char)171;
    private static char WHITESPACE_LF_REPLACEMENT = (char)182;
    private static char WHITESPACE_TAB_REPLACEMENT = (char)187;
    private static char WHITESPACE_SPACE_REPLACEMENT = (char)183;
    private static char WHITESPACE_NBSP_REPLACEMENT = (char)160;
    protected static final int MINIMUM_INCREMENT = 25;
    protected static final int MAXIMUM_INCREMENT = 500;
    protected static final float INCREMENT_RATE = 0.1f;
    private static final CollapsedInfo[] UNCOLLAPSED_VIEW_INFO = new CollapsedInfo[0];
    public static final String FOLDED_BLOCK_HIGHLIGHT = "folded-block-highlight";
    public static final int DEFAULT_FOLDED_BLOCK_PRIORITY = 99;
    private static final CollapsedBlocks UNCOLLAPSED_VIEW;

    public BasicView(Element elem) {
        super(elem);
        this.$init$();
        this._editor = null;
        this._document = (BasicDocument)this.getDocument();
        this._textBuffer = this._document.getTextBuffer();
        this._lineMap = this._document.getLineMap();
        this._lineBuffer = new Segment();
        this._lineRange = new NumberRange(0, 0);
        this._styleRegistry = null;
        this._highlightRegistry = null;
        this._fontHelper = null;
        this._composedStart = -1;
        this._composedEnd = -1;
        this._rowMap = null;
        this._useAA = false;
        this._useItalicAA = false;
    }

    private DocumentRenderer getDocumentRenderer() {
        return this._document.getDocumentRenderer();
    }

    public void paint(Graphics graphics, Shape viewShape) {
        try {
            this.updateMetrics();
            Rectangle originalViewRect = (Rectangle)viewShape;
            graphics.translate(originalViewRect.x, originalViewRect.y);
            int viewWidth = originalViewRect.width;
            int viewHeight = originalViewRect.height;
            Rectangle viewRect = new Rectangle(0, 0, viewWidth, viewHeight);
            this.attachToRegistries();
            NumberRange composedRange = this._document.getComposedTextRange();
            if (composedRange != null) {
                this._composedStart = composedRange.start;
                this._composedEnd = composedRange.end;
            } else {
                this._composedStart = -1;
                this._composedEnd = -1;
            }
            boolean paintText = true;
            Rectangle clipRect = graphics.getClipBounds();
            if (!clipRect.intersects(viewRect)) {
                paintText = false;
            }
            clipRect = clipRect.intersection(viewRect);
            int clipYTop = clipRect.y;
            int clipYBottom = clipRect.height + clipRect.y;
            int lastRow = this._numberRows - 1;
            int rowStart = clipYTop / this._fontHeight;
            int rowEnd = clipYBottom / this._fontHeight;
            rowStart = Math.min(rowStart, lastRow);
            rowEnd = Math.min(rowEnd, lastRow);
            int lastRowEdge = this._numberRows * this._fontHeight;
            if (lastRowEdge <= clipRect.y) {
                paintText = false;
            }
            if (paintText) {
                Graphics2D graphics2d = this._useAA && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
                int paintStartOffset = this._rowMap.getRowStartOffset(rowStart);
                int paintEndOffset = this._rowMap.getRowEndOffset(rowEnd);
                int paintStartLine = this._lineMap.getLineFromOffset(paintStartOffset);
                int paintEndLine = this._lineMap.getLineFromOffset(paintEndOffset);
                DocumentRenderer documentRenderer = this.getDocumentRenderer();
                StyledFragmentsList fragmentsList = documentRenderer.renderLines(paintStartLine, paintEndLine);
                HighlightFragmentsList textHighlightFragmentsList = this.renderTextHighlights(paintStartOffset, paintEndOffset);
                RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, textHighlightFragmentsList);
                Object oldAATextValue = null;
                if (graphics2d != null) {
                    oldAATextValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                int row = rowStart;
                while (row <= rowEnd) {
                    this.paintRow(graphics, clipRect, row, generator, textHighlightFragmentsList.getSentinelBackground());
                    ++row;
                }
                if (graphics2d != null && oldAATextValue != null) {
                    graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAATextValue);
                }
                this.paintUnderlines(graphics, clipRect, fragmentsList, rowStart, rowEnd + 1);
                if (fragmentsList != null) {
                    documentRenderer.recycleFragmentsList(fragmentsList);
                }
                BasicView.freeHighlightFragmentsList(textHighlightFragmentsList);
            }
            this.paintRightMargin(graphics, clipRect);
            graphics.translate(-originalViewRect.x, -originalViewRect.y);
        }
        catch (ExpiredTextBufferException etbe) {
            // empty catch block
        }
    }

    protected void paintUnderlines(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, int startRow, int endRow) {
        int paintStartOffset = this._rowMap.getRowStartOffset(startRow);
        int paintEndOffset = this._rowMap.getRowEndOffset(endRow - 1);
        this.paintLineUnderlines(graphics, clipRect, paintStartOffset, paintEndOffset);
        if (paintStartOffset == paintEndOffset || styledList == null) {
            return;
        }
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(paintStartOffset, paintEndOffset);
        this.paintRangeUnderlines(graphics, clipRect, styledList, fontHighlightList, paintStartOffset, paintEndOffset);
    }

    protected void paintLineUnderlines(Graphics graphics, Rectangle clipRect, int startOffset, int endOffset) {
        int clipXEnd = clipRect.x + clipRect.width;
        int lastLine = this._lineMap.getLineCount() - 1;
        int t = 0;
        while (t < PAINTER_TYPE_ORDER.length) {
            int underlineType = PAINTER_TYPE_ORDER[t];
            HighlightFragmentsList underlineList = this.renderUnderlineHighlights(underlineType, true, startOffset, endOffset);
            int numUnderlines = underlineList.size();
            int i = 0;
            while (i < numUnderlines) {
                HighlightFragment fragment = underlineList.get(i);
                HighlightStyle highlightStyle = fragment.underlineStyle;
                if (highlightStyle != null) {
                    int line;
                    UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
                    Color underlineColor = highlightStyle.getUnderlineColor();
                    if (underlinePainter != null && underlineColor != null && !this._rowMap.isLineCollapsed(line = this._lineMap.getLineFromOffset(fragment.startOffset))) {
                        int lineEnd = this._lineMap.getLineEndOffset(line);
                        if (line != lastLine) {
                            --lineEnd;
                        }
                        int row = this._rowMap.getRowFromOffset(lineEnd);
                        int yPos = this._fontHeight * row;
                        int yBaseLine = yPos + this._fontAscent;
                        underlinePainter.paintUnderline(graphics, underlineColor, 0, clipXEnd, yPos, yBaseLine, this._fontDescent);
                    }
                }
                ++i;
            }
            HighlightStyle trailingUnderlineStyle = underlineList.getSentinelUnderline();
            if (trailingUnderlineStyle != null && trailingUnderlineStyle.getUseUnderline()) {
                UnderlinePainter underlinePainter = trailingUnderlineStyle.getUnderlinePainter();
                Color underlineColor = trailingUnderlineStyle.getUnderlineColor();
                int lastRow = this._numberRows - 1;
                int yPos = this._fontHeight * lastRow;
                int yBaseLine = yPos + this._fontAscent;
                underlinePainter.paintUnderline(graphics, underlineColor, 0, clipXEnd, yPos, yBaseLine, this._fontDescent);
            }
            BasicView.freeHighlightFragmentsList(underlineList);
            ++t;
        }
    }

    protected void paintRangeUnderlines(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, HighlightFragmentsList fontHighlightList, int startOffset, int endOffset) {
        int t = 0;
        while (t < PAINTER_TYPE_ORDER.length) {
            int underlineType = PAINTER_TYPE_ORDER[t];
            HighlightFragmentsList underlineList = this.renderUnderlineHighlights(underlineType, false, startOffset, endOffset);
            int numUnderlines = underlineList.size();
            int i = 0;
            while (i < numUnderlines) {
                HighlightFragment fragment = underlineList.get(i);
                this.paintUnderlineSegment(graphics, clipRect, styledList, fontHighlightList, fragment, startOffset, endOffset);
                ++i;
            }
            BasicView.freeHighlightFragmentsList(underlineList);
            ++t;
        }
    }

    protected void paintUnderlineSegment(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, HighlightFragmentsList fontHighlightList, HighlightFragment underlineFragment, int startOffset, int endOffset) {
        int underlineEnd;
        HighlightStyle highlightStyle = underlineFragment.underlineStyle;
        if (highlightStyle == null) {
            return;
        }
        UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
        Color underlineColor = highlightStyle.getUnderlineColor();
        if (underlinePainter == null || underlineColor == null) {
            return;
        }
        int underlineStart = Math.max(startOffset, underlineFragment.startOffset);
        if (underlineStart == (underlineEnd = Math.min(endOffset, underlineFragment.endOffset))) {
            return;
        }
        if (this._rowMap.isRangeCollapsed(underlineStart, underlineEnd)) {
            return;
        }
        int startRow = this._rowMap.getRowFromOffset(underlineStart);
        int endRow = this._rowMap.getRowFromOffset(underlineEnd);
        int lastRow = this._numberRows - 1;
        int row = startRow;
        while (row <= endRow) {
            int paintEndOffset;
            int rowStartOffset = this._rowMap.getRowStartOffset(row);
            int rowEndOffset = this._rowMap.getRowEndOffset(row);
            int paintStartOffset = Math.max(rowStartOffset, underlineStart);
            if (paintStartOffset != (paintEndOffset = Math.min(rowEndOffset, underlineEnd))) {
                int width;
                int xStart = this.getXCoordinateForOffset(styledList, fontHighlightList, rowStartOffset, paintStartOffset);
                int xEnd = this.getXCoordinateForOffset(styledList, fontHighlightList, rowStartOffset, paintEndOffset);
                if (row != lastRow && underlineFragment.endOffset >= rowEndOffset && this._rowMap.rowEndIsLineEnd(row)) {
                    xEnd += this._fontWidth;
                }
                if (this.isXRegionInClip(clipRect, xStart, width = xEnd - xStart)) {
                    int yPos = this._fontHeight * row;
                    int yBaseLine = yPos + this._fontAscent;
                    underlinePainter.paintUnderline(graphics, underlineColor, xStart, width, yPos, yBaseLine, this._fontDescent);
                }
            }
            ++row;
        }
    }

    protected void paintRightMargin(Graphics graphics, Rectangle clipRect) {
        boolean displayRightMargin;
        if (this._editor != null && (displayRightMargin = this._editor.getBooleanProperty("right-margin-visible"))) {
            int rightMarginColumn = this._editor.getIntegerProperty("right-margin-column");
            Color marginColor = (Color)this._editor.getProperty("right-margin-color");
            int xColumn = this._fontWidth * rightMarginColumn;
            if (clipRect.x <= xColumn && xColumn <= clipRect.x + clipRect.width) {
                graphics.setColor(marginColor);
                graphics.drawLine(xColumn, clipRect.y, xColumn, clipRect.y + clipRect.height);
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle clipRect, int row, RenderFragmentGenerator generator, HighlightStyle sentinelStyle) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        int lastRow = this._numberRows - 1;
        int y = this._fontHeight * row;
        int x = 0;
        RenderFragment renderFragment = generator.current();
        while (renderFragment != null && renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        if (renderFragment != null) {
            int lastPaintOffset = rowStart;
            while (renderFragment.startOffset < rowEnd) {
                int paintStart = lastPaintOffset;
                int paintEnd = Math.min(renderFragment.endOffset, rowEnd);
                x = this.paintSegment(graphics, clipRect, renderFragment, paintStart, paintEnd, x, y);
                lastPaintOffset = paintEnd;
                if (paintEnd == rowEnd) break;
                renderFragment = generator.next();
            }
        }
        HighlightStyle trailingBackgroundStyle = null;
        if (row == lastRow) {
            trailingBackgroundStyle = sentinelStyle;
        } else if (renderFragment != null && renderFragment.startOffset < rowEnd && renderFragment.endOffset >= rowEnd) {
            trailingBackgroundStyle = renderFragment.backgroundHighlight;
        }
        if (trailingBackgroundStyle != null && trailingBackgroundStyle.getUseBackgroundColor()) {
            Color bgColor = trailingBackgroundStyle.getBackgroundColor();
            graphics.setColor(bgColor);
            int xStart = x;
            int xEnd = clipRect.x + clipRect.width;
            int highlightWidth = xEnd - xStart;
            if (highlightWidth > 0) {
                graphics.fillRect(x, y, highlightWidth, this._fontHeight);
            }
        }
    }

    protected int paintSegment(Graphics graphics, Rectangle clipRect, RenderFragment renderFragment, int startOffset, int endOffset, int x, int y) {
        int underlineEnd;
        int underlineStart;
        int endX;
        boolean isFolded;
        if (startOffset == endOffset) {
            return x;
        }
        Color bgColor = renderFragment.getBackgroundColor();
        Color fgColor = renderFragment.getForegroundColor();
        int fontStyle = renderFragment.getFontStyle();
        Font styleFont = this._fontHelper.getFont(fontStyle);
        FontMetrics paintMetrics = this._fontHelper.getFontMetrics(styleFont, (Component)this._editor);
        graphics.setFont(styleFont);
        String foldedText = renderFragment.textToUse;
        boolean bl = isFolded = foldedText != null;
        if (!this._editorBackgroundColor.equals(bgColor)) {
            int segmentWidth = isFolded ? this.getFoldedTextWidth(paintMetrics, foldedText) : this.getTabbedTextWidth(paintMetrics, startOffset, endOffset, x);
            graphics.setColor(bgColor);
            graphics.fillRect(x, y, segmentWidth, this._fontHeight);
        }
        graphics.setColor(fgColor);
        int n = endX = isFolded ? this.drawFoldedText(graphics, clipRect, paintMetrics, foldedText, x, y) : this.drawTabbedText(graphics, clipRect, paintMetrics, startOffset, endOffset, x, y += this._fontAscent);
        if (!isFolded && this._composedStart != -1 && (underlineStart = Math.max(this._composedStart, startOffset)) < (underlineEnd = Math.min(this._composedEnd, endOffset))) {
            int paintStart = x;
            if (underlineStart > startOffset) {
                paintStart += this.getTabbedTextWidth(paintMetrics, startOffset, underlineStart, x);
            }
            int paintWidth = this.getTabbedTextWidth(paintMetrics, underlineStart, underlineEnd, paintStart);
            graphics.drawLine(paintStart, y += paintMetrics.getDescent() / 2, paintStart + paintWidth, y);
        }
        return endX;
    }

    private void updateMetrics() {
        Font currentFont;
        if (this._editor == null) {
            this._editor = (BasicEditorPane)this.getContainer();
            this._editor.addPropertyChangeListener(this);
            this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
            this._useItalicAA = this._editor.getBooleanProperty("editor-italic-antialiasing");
            this._tabSize = this.calculateTabSize();
            this.updateFolding();
        }
        if ((currentFont = this._editor.getFont()) != this._font) {
            this._font = currentFont;
            this._metrics = this._editor.getFontMetrics(this._font);
            this._fontHeight = this._metrics.getHeight();
            this._fontAscent = this._metrics.getAscent();
            this._fontDescent = this._metrics.getDescent();
            this._fontWidth = this._metrics.charWidth('W');
            this._fontHelper = null;
        }
        if (this._fontHelper == null) {
            this._fontHelper = this._editor.getFontHelper();
        }
        this._editorBackgroundColor = this._editor.getBackground();
        if (this._rowMap == null) {
            this._rowMap = new FoldedRowMap();
            this._rowMap.rebuildFoldedMap();
        }
        this._numberRows = this._rowMap.getRowCount();
        this.attachToRegistries();
    }

    private void $init$() {
        this._foldingListener = new FoldingListener(null);
    }

    private void updateFolding() {
        CodeFoldingModel oldModel = this._foldingModel;
        CodeFoldingModel newModel = null;
        CodeFoldingMargin oldMargin = this._foldingMargin;
        CodeFoldingMargin newMargin = null;
        boolean visibleMargin = this._editor.getBooleanProperty("code-folding-margin-visible");
        if (visibleMargin) {
            newModel = this._foldingModel = (CodeFoldingModel)this._editor.getProperty("code-folding-model");
            newMargin = this._foldingMargin = (CodeFoldingMargin)this._editor.getProperty("code-folding-margin");
        } else {
            this._foldingModel = null;
            newModel = null;
            this._foldingMargin = null;
            newMargin = null;
        }
        if (oldModel != newModel) {
            if (oldModel != null) {
                oldModel.removeCodeFoldingModelListener(this._foldingListener);
            }
            if (newModel != null) {
                newModel.addCodeFoldingModelListener(this._foldingListener);
            }
        }
        if (newMargin != oldMargin) {
            if (oldMargin != null) {
                oldMargin.removeCodeExpansionListener(this._foldingListener);
            }
            if (newMargin != null) {
                newMargin.addCodeExpansionListener(this._foldingListener);
            }
        }
    }

    private void rebuildRowMap() {
        this._rowMap.rebuildRowMap();
        this._rowMap.rebuildFoldedMap();
        this.preferenceChanged(null, true, true);
        this._editor.repaint();
    }

    private void revalidateRowMap() {
        boolean heightChanged;
        int oldRowCount = this._numberRows;
        int oldMaxWidth = this._rowMap.getMaxRowWidth();
        this._rowMap.revalidateRowMap();
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        boolean widthChanged = oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        this._editor.repaint();
    }

    private void rebuildFoldedBlocks() {
        boolean heightChanged;
        if (this._rowMap == null) {
            return;
        }
        int oldRowCount = this._numberRows;
        int oldMaxWidth = this._rowMap.getMaxRowWidth();
        this._rowMap.rebuildFoldedMap();
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        boolean widthChanged = oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        this._editor.repaint();
    }

    private BaseStyle lookupStyle(String styleName) {
        BaseStyle style;
        if (this._styleRegistry == null) {
            this.attachToRegistries();
        }
        if ((style = this._styleRegistry.lookupStyle(styleName)) == null) {
            throw new IllegalStateException("style not found: " + styleName);
        }
        return style;
    }

    private HighlightStyle lookupHighlight(String highlightName) {
        HighlightRegistry registry = this._editor.getHighlightRegistry();
        HighlightStyle style = registry.lookupStyle(highlightName);
        if (style == null) {
            throw new IllegalStateException("highlight not found: " + highlightName);
        }
        return style;
    }

    private void attachToRegistries() {
        if (this._styleRegistry == null) {
            if (this._editor == null) {
                this.updateMetrics();
            }
            this._styleRegistry = this._editor.getStyleRegistry();
            this._styleRegistry.addPropertyChangeListener(this);
        }
        if (this._highlightRegistry == null) {
            this._highlightRegistry = this._editor.getHighlightRegistry();
            this._highlightRegistry.addPropertyChangeListener(this);
        }
    }

    private void detachFromStyleRegistry() {
        this._styleRegistry.removePropertyChangeListener(this);
        this._styleRegistry = null;
    }

    private void detachFromHighlightRegistry() {
        this._highlightRegistry.removePropertyChangeListener(this);
        this._highlightRegistry = null;
    }

    private Rectangle rowToRect(Shape viewShape, int row) {
        if (this._metrics == null) {
            this.updateMetrics();
        }
        Rectangle viewRect = viewShape.getBounds();
        Rectangle rowRect = new Rectangle(viewRect.x, viewRect.y + row * this._fontHeight, viewRect.width, this._fontHeight);
        return rowRect;
    }

    public Shape modelToView(int offset, Shape viewShape, Position.Bias bias) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int bufferLength = this._textBuffer.getLength();
        if (offset < 0 || offset > bufferLength) {
            throw new BadLocationException("m2v(), bad offset", offset);
        }
        int row = this._rowMap.getRowFromOffset(offset);
        Rectangle rowRect = this.rowToRect(viewShape, row);
        int xPos = this.getXCoordinateForOffset(row, offset);
        rowRect.x += xPos;
        rowRect.width = 1;
        rowRect.height = this._fontHeight;
        return rowRect;
    }

    public Shape modelToView(int startOffset, Position.Bias startBias, int endOffset, Position.Bias endBias, Shape viewShape) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int bufferLength = this._textBuffer.getLength();
        if (startOffset < 0 || startOffset > bufferLength) {
            throw new BadLocationException("m2v2(), bad offset", startOffset);
        }
        if (endOffset < 0 || endOffset > bufferLength) {
            throw new BadLocationException("m2v2(), bad offset", endOffset);
        }
        int row1 = this._rowMap.getRowFromOffset(startOffset);
        int row2 = this._rowMap.getRowFromOffset(endOffset);
        Rectangle rowRect1 = this.rowToRect(viewShape, row1);
        Rectangle rowRect2 = this.rowToRect(viewShape, row2);
        rowRect1.add(rowRect2);
        return rowRect1;
    }

    public int viewToModel(float fx, float fy, Shape viewShape, Position.Bias[] biasReturn) {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        biasReturn[0] = Position.Bias.Forward;
        Rectangle viewRect = viewShape.getBounds();
        int x = (int)fx;
        int y = (int)fy;
        int viewX = x - viewRect.x;
        int viewY = y - viewRect.y;
        if (viewY < 0) {
            return this.getStartOffset();
        }
        if (viewY > viewRect.height) {
            return this.getEndOffset();
        }
        int row = viewY / this._fontHeight;
        if ((row = Math.max(row, 0)) >= this._numberRows) {
            return this.getEndOffset();
        }
        return this.getOffsetForXCoordinate(row, viewX);
    }

    protected void updateDamage(DocumentEvent changes, Shape viewShape) {
        boolean heightChanged;
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int oldRowCount = this._numberRows;
        int oldMaxWidth = this._rowMap.getMaxRowWidth();
        this._rowMap.documentChanged(changes);
        if (viewShape == null) {
            return;
        }
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        boolean widthChanged = oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        if (heightChanged) {
            Rectangle visibleRect = this._editor.getVisibleRect();
            if (visibleRect != null) {
                float rowPos = (float)visibleRect.y / (float)this._fontHeight;
                int changeOffset = changes.getOffset();
                int changeRow = this._rowMap.getRowFromOffset(changeOffset);
                if ((float)changeRow < rowPos) {
                    int rowsChanged = newRowCount - oldRowCount;
                    visibleRect.y += rowsChanged * this._fontHeight;
                    visibleRect.y = Math.max(0, visibleRect.y);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this._editor.scrollRectToVisible(visibleRect);
                    } else {
                        SwingUtilities.invokeLater(new 1(this, visibleRect));
                    }
                }
            }
            this._editor.repaint();
        } else {
            DocumentRenderer documentRenderer = this.getDocumentRenderer();
            documentRenderer.calculateDamage(changes, this._lineRange);
            int startLine = this._lineRange.start;
            int endLine = this._lineRange.end;
            int lastLine = this._lineMap.getLineCount() - 1;
            int startOffset = this._lineMap.getLineStartOffset(startLine);
            int endOffset = this._lineMap.getLineEndOffset(endLine);
            if (endLine != lastLine) {
                --endOffset;
            }
            int startRow = this._rowMap.getRowFromOffset(startOffset);
            int endRow = this._rowMap.getRowFromOffset(endOffset);
            int numRows = endRow - startRow + 1;
            Rectangle rowArea = this.rowToRect(viewShape, startRow);
            rowArea.height = numRows * this._fontHeight;
            this._editor.repaint(rowArea.x, rowArea.y, rowArea.width, rowArea.height);
        }
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                int blankColumns = this._editor.getIntegerProperty("trailing-blank-columns");
                int blankWidth = blankColumns * this._fontWidth;
                return this._rowMap.getMaxRowWidth() + blankWidth;
            }
            case 1: {
                int blankLines = this._editor.getIntegerProperty("trailing-blank-rows");
                return (this._numberRows + blankLines) * this._fontHeight;
            }
        }
        throw new IllegalArgumentException("Illegal axis: " + axis);
    }

    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    public int getBreakWeight(int axis, float pos, float len) {
        return 0;
    }

    public int getRowForLine(int line) {
        if (this._rowMap == null) {
            return -1;
        }
        return this._rowMap.getRowForLine(line);
    }

    public int getLineForRow(int row) {
        if (this._rowMap == null) {
            return -1;
        }
        return this._rowMap.getLineForRow(row);
    }

    private boolean isXRegionInClip(Rectangle clipRect, int x, int width) {
        return x + width >= clipRect.x && clipRect.x + clipRect.width >= x;
    }

    private int drawFoldedText(Graphics graphics, Rectangle clipRect, FontMetrics paintMetrics, String textToDraw, int xPos, int yPos) {
        int textWidth = this.getFoldedTextWidth(paintMetrics, textToDraw);
        boolean isItalicFont = paintMetrics.getFont().isItalic();
        boolean doAntiAliasing = isItalicFont && this._useItalicAA && !this._useAA;
        Graphics2D graphics2d = doAntiAliasing && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object oldAntiAliasValue = null;
        if (graphics2d != null) {
            oldAntiAliasValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (textToDraw.length() > 0) {
            if (this.isXRegionInClip(clipRect, xPos, textWidth)) {
                graphics.drawString(textToDraw, xPos, yPos);
            }
            xPos += textWidth;
        }
        if (graphics2d != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAntiAliasValue);
        }
        return xPos;
    }

    private int drawTabbedText(Graphics graphics, Rectangle clipRect, FontMetrics paintMetrics, int startOffset, int endOffset, int xPos, int yPos) {
        int length = endOffset - startOffset;
        this._textBuffer.getText(startOffset, length, this._lineBuffer);
        char[] buffer = this._lineBuffer.array;
        int bufferStart = this._lineBuffer.offset;
        int bufferEnd = this._lineBuffer.offset + length;
        this._lineBuffer.array = null;
        int currentOffset = bufferStart;
        int lastPaintOffset = bufferStart;
        int charsToPaint = 0;
        int charsWidth = 0;
        boolean isItalicFont = paintMetrics.getFont().isItalic();
        boolean doAntiAliasing = isItalicFont && this._useItalicAA && !this._useAA;
        Graphics2D graphics2d = doAntiAliasing && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object oldAntiAliasValue = null;
        if (graphics2d != null) {
            oldAntiAliasValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        boolean showWhitespace = this._editor.getBooleanProperty("show-whitespace-chars");
        boolean spaceSegment = true;
        Color color = graphics.getColor();
        Color fadeColor = showWhitespace ? new Color(color.getRed(), color.getGreen(), color.getBlue(), 128) : null;
        block5: while (currentOffset < bufferEnd) {
            char c = buffer[currentOffset];
            switch (c) {
                case '\t': {
                    if (charsToPaint > 0) {
                        if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                            graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                        }
                        xPos += charsWidth;
                        charsToPaint = 0;
                        charsWidth = 0;
                        spaceSegment = true;
                    }
                    if (showWhitespace) {
                        charsWidth += paintMetrics.charWidth(c);
                        graphics.setColor(fadeColor);
                        graphics.drawChars(new char[]{WHITESPACE_TAB_REPLACEMENT}, 0, 1, xPos, yPos);
                        graphics.setColor(color);
                    }
                    lastPaintOffset = currentOffset + 1;
                    xPos = this.getNextTabStop(xPos);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!showWhitespace) break block5;
                    if (this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                        graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                    }
                    xPos += charsWidth;
                    charsToPaint = 0;
                    charsWidth = 0;
                    spaceSegment = true;
                    graphics.setColor(fadeColor);
                    if (this._textBuffer.getEOLType().equals("\r")) {
                        graphics.drawChars(new char[]{WHITESPACE_CR_REPLACEMENT}, 0, 1, xPos, yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_CR_REPLACEMENT);
                    } else if (this._textBuffer.getEOLType().equals("\n")) {
                        graphics.drawChars(new char[]{WHITESPACE_LF_REPLACEMENT}, 0, 1, xPos, yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_LF_REPLACEMENT);
                    } else if (this._textBuffer.getEOLType().equals("\r\n")) {
                        graphics.drawChars(new char[]{WHITESPACE_CR_REPLACEMENT}, 0, 1, xPos, yPos);
                        graphics.drawChars(new char[]{WHITESPACE_LF_REPLACEMENT}, 0, 1, xPos += paintMetrics.charWidth(WHITESPACE_CR_REPLACEMENT), yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_LF_REPLACEMENT);
                    }
                    graphics.setColor(color);
                    break;
                }
                default: {
                    spaceSegment = false;
                    ++charsToPaint;
                    charsWidth += paintMetrics.charWidth(c);
                    break;
                }
                case ' ': 
                case '\u00a0': {
                    if (showWhitespace) {
                        if (charsToPaint > 0) {
                            if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                                graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                            }
                            xPos += charsWidth;
                            charsToPaint = 0;
                            charsWidth = 0;
                            spaceSegment = true;
                        }
                        char replacement = WHITESPACE_SPACE_REPLACEMENT;
                        if (c == '\u00a0') {
                            replacement = WHITESPACE_NBSP_REPLACEMENT;
                        }
                        graphics.setColor(fadeColor);
                        graphics.drawChars(new char[]{replacement}, 0, 1, xPos, yPos);
                        graphics.setColor(color);
                        lastPaintOffset = currentOffset + 1;
                        xPos += paintMetrics.charWidth(replacement);
                        break;
                    }
                    ++charsToPaint;
                    charsWidth += paintMetrics.charWidth(c);
                }
            }
            ++currentOffset;
        }
        if (charsToPaint > 0) {
            if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
            }
            xPos += charsWidth;
        }
        if (graphics2d != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAntiAliasValue);
        }
        return xPos;
    }

    private int getFoldedTextWidth(FontMetrics paintMetrics, String foldedText) {
        return paintMetrics.stringWidth(foldedText);
    }

    private int getTabbedTextWidth(FontMetrics paintMetrics, int startOffset, int endOffset, int xPos) {
        int currentOffset = startOffset;
        int endX = xPos;
        boolean showWhitespace = this._editor.getBooleanProperty("show-whitespace-chars");
        block4: while (currentOffset < endOffset) {
            char c = this._textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    endX = this.getNextTabStop(endX);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!showWhitespace) break block4;
                    if (this._textBuffer.getEOLType().equals("\r")) {
                        endX += paintMetrics.charWidth('\u00ab');
                        break block4;
                    }
                    if (this._textBuffer.getEOLType().equals("\n")) {
                        endX += paintMetrics.charWidth('\u00b6');
                        break block4;
                    }
                    if (!this._textBuffer.getEOLType().equals("\r\n")) break block4;
                    endX += paintMetrics.charWidth('\u00ab');
                    endX += paintMetrics.charWidth('\u00b6');
                    break block4;
                }
                default: {
                    endX += paintMetrics.charWidth(c);
                    break;
                }
            }
            ++currentOffset;
        }
        int textWidth = endX - xPos;
        return textWidth;
    }

    private int getTabbedTextOffset(FontMetrics paintMetrics, int startOffset, int endOffset, int startX, int xPos, boolean roundAdjustment) {
        int afterX = startX;
        int currentOffset = startOffset;
        block4: while (currentOffset < endOffset) {
            int beforeX = afterX;
            char c = this._textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    afterX = this.getNextTabStop(beforeX);
                    break;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
                default: {
                    afterX = beforeX + paintMetrics.charWidth(c);
                    break;
                }
            }
            if (beforeX <= xPos && xPos < afterX) {
                if (!roundAdjustment || afterX - xPos >= xPos - beforeX) break;
                ++currentOffset;
                break;
            }
            ++currentOffset;
        }
        return currentOffset;
    }

    private int getXCoordinateForOffset(int row, int offset) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        if (offset == rowStart) {
            return 0;
        }
        int renderStartLine = this._lineMap.getLineFromOffset(rowStart);
        int renderEndLine = this._lineMap.getLineFromOffset(rowEnd);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList fragmentsList = documentRenderer.renderLines(renderStartLine, renderEndLine);
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(rowStart, rowEnd);
        int xPos = this.getXCoordinateForOffset(fragmentsList, fontHighlightList, rowStart, offset);
        if (fragmentsList != null) {
            fragmentsList.clear();
            documentRenderer.recycleFragmentsList(fragmentsList);
        }
        BasicView.freeHighlightFragmentsList(fontHighlightList);
        return xPos;
    }

    private int getXCoordinateForOffset(StyledFragmentsList fragmentsList, HighlightFragmentsList fontHighlightList, int rowStart, int offset) {
        RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, fontHighlightList);
        return this.getXCoordinateForOffset(generator, rowStart, offset);
    }

    private int getXCoordinateForOffset(RenderFragmentGenerator generator, int rowStart, int offset) {
        int xPos = 0;
        if (rowStart == offset) {
            return xPos;
        }
        RenderFragment renderFragment = generator.current();
        while (renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        while (renderFragment.startOffset < offset) {
            int fontStyle = renderFragment.getFontStyle();
            FontMetrics paintMetrics = this._fontHelper.getFontMetrics(fontStyle, (Component)this._editor);
            int processStart = Math.max(rowStart, renderFragment.startOffset);
            int processEnd = Math.min(offset, renderFragment.endOffset);
            String foldedText = renderFragment.textToUse;
            int fragmentWidth = foldedText != null ? this.getFoldedTextWidth(paintMetrics, renderFragment.textToUse) : this.getTabbedTextWidth(paintMetrics, processStart, processEnd, xPos);
            xPos += fragmentWidth;
            if (processEnd == offset) break;
            renderFragment = generator.next();
        }
        return xPos;
    }

    private int getOffsetForXCoordinate(int row, int xPos) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        if (xPos <= 0) {
            return rowStart;
        }
        int renderStartLine = this._lineMap.getLineFromOffset(rowStart);
        int renderEndLine = this._lineMap.getLineFromOffset(rowEnd);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList fragmentsList = documentRenderer.renderLines(renderStartLine, renderEndLine);
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(rowStart, rowEnd);
        int lastRow = this._numberRows - 1;
        if (row < lastRow && this._rowMap.rowEndIsLineEnd(row)) {
            --rowEnd;
        }
        int returnOffset = this.getOffsetForXCoordinate(fragmentsList, fontHighlightList, rowStart, rowEnd, xPos);
        if (fragmentsList != null) {
            fragmentsList.clear();
            documentRenderer.recycleFragmentsList(fragmentsList);
        }
        BasicView.freeHighlightFragmentsList(fontHighlightList);
        return returnOffset;
    }

    private int getOffsetForXCoordinate(StyledFragmentsList fragmentsList, HighlightFragmentsList fontHighlightList, int rowStart, int rowEnd, int xPos) {
        if (rowStart == rowEnd) {
            return rowStart;
        }
        RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, fontHighlightList);
        RenderFragment renderFragment = generator.current();
        while (renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        int afterX = 0;
        int currentOffset = rowStart;
        while (renderFragment.startOffset < rowEnd) {
            int beforeX = afterX;
            if (xPos <= beforeX || currentOffset >= rowEnd) break;
            int processStart = Math.max(renderFragment.startOffset, currentOffset);
            int processEnd = Math.min(renderFragment.endOffset, rowEnd);
            int fontStyle = renderFragment.getFontStyle();
            FontMetrics paintMetrics = this._fontHelper.getFontMetrics(fontStyle, (Component)this._editor);
            String foldedText = renderFragment.textToUse;
            int fragmentWidth = foldedText != null ? this.getFoldedTextWidth(paintMetrics, foldedText) : this.getTabbedTextWidth(paintMetrics, processStart, processEnd, beforeX);
            afterX = beforeX + fragmentWidth;
            if (beforeX <= xPos && xPos <= afterX) {
                currentOffset = foldedText != null ? renderFragment.endOffset : this.getTabbedTextOffset(paintMetrics, processStart, processEnd, beforeX, xPos, false);
                break;
            }
            currentOffset = processEnd;
            if (currentOffset >= rowEnd) break;
            renderFragment = generator.next();
        }
        return currentOffset;
    }

    private int getNextTabStop(int xPos) {
        int spaceSize = this._metrics.charWidth(' ');
        int tabPixels = this._tabSize * spaceSize;
        int numTabs = xPos / tabPixels;
        int nextStop = tabPixels * (numTabs + 1);
        return nextStop;
    }

    private int calculateTabSize() {
        int size = this._editor.getIntegerProperty("tab-size");
        return Math.max(1, size);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("language-support")) {
            this.revalidateRowMap();
        } else if (propertyName.equals("tab-size")) {
            this._tabSize = this.calculateTabSize();
            this.rebuildRowMap();
        } else if (propertyName.equals("editor-antialiasing") || propertyName.equals("editor-italic-antialiasing")) {
            this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
            this._useItalicAA = this._editor.getBooleanProperty("editor-italic-antialiasing");
            this._editor.repaint();
        } else if (propertyName.equals("trailing-blank-rows")) {
            this.preferenceChanged(null, false, true);
            this._editor.repaint();
        } else if (propertyName.equals("trailing-blank-columns")) {
            this.preferenceChanged(null, true, false);
            this._editor.repaint();
        } else if (propertyName.equals("right-margin-column") || propertyName.equals("right-margin-color") || propertyName.equals("right-margin-visible")) {
            this._editor.repaint();
        } else if (propertyName.equals("editor-font")) {
            this._fontHelper = null;
            this.updateMetrics();
            this.rebuildRowMap();
        } else if (propertyName.equals("style-registry")) {
            this.detachFromStyleRegistry();
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
        } else if (propertyName.equals("style-changed")) {
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
        } else if (propertyName.equals("highlight-registry")) {
            this.detachFromHighlightRegistry();
            this.revalidateRowMap();
        } else if (propertyName.equals("highlight-changed")) {
            this.revalidateRowMap();
        } else if (propertyName.equals("code-folding-model") || propertyName.equals("code-folding-margin-visible")) {
            this.updateFolding();
            this.rebuildFoldedBlocks();
        }
    }

    private HighlightFragmentsList renderTextHighlights(int startOffset, int endOffset) {
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeTextOnly();
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator.hasNext()) {
                HighlightLayer layer = (HighlightLayer)iterator.next();
                layer.renderHighlights(highlightFragmentsList, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    private HighlightFragmentsList renderFontHighlights(int startOffset, int endOffset) {
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeFontOnly();
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator != null && iterator.hasNext()) {
                HighlightLayer layer = (HighlightLayer)iterator.next();
                layer.renderHighlights(highlightFragmentsList, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    private HighlightFragmentsList renderUnderlineHighlights(int underlineType, boolean lineType, int startOffset, int endOffset) {
        int typeFilter;
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeUnderlineOnly();
        switch (underlineType) {
            case 0: {
                typeFilter = 1;
                break;
            }
            case 1: {
                typeFilter = 2;
                break;
            }
            case 2: {
                typeFilter = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid underline type: " + underlineType);
            }
        }
        highlightFragmentsList.setUnderlineTypeFilter(typeFilter);
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator != null && iterator.hasNext()) {
                int fetchType = lineType ? 2 : 1;
                HighlightLayer layer = (HighlightLayer)iterator.next();
                layer.renderHighlights(highlightFragmentsList, fetchType, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAllFilters();
        return highlightFragmentsList;
    }

    private static synchronized HighlightFragmentsList allocHighlightFragmentsList() {
        int i = 0;
        while (i < 5) {
            HighlightFragmentsList spareList = sharedHighlightArray[i];
            if (spareList != null) {
                BasicView.sharedHighlightArray[i] = null;
                return spareList;
            }
            ++i;
        }
        return new HighlightFragmentsList();
    }

    private static synchronized void freeHighlightFragmentsList(HighlightFragmentsList list) {
        if (list != null) {
            list.clearAttributeFilter();
            list.clear();
            list.setHighlightRegistry(null);
            int i = 0;
            while (i < 5) {
                if (sharedHighlightArray[i] == null) {
                    BasicView.sharedHighlightArray[i] = list;
                    return;
                }
                ++i;
            }
        }
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        registry.createStyle(FOLDED_BLOCK_HIGHLIGHT, resources.getString("FOLDED_BLOCK_HIGHLIGHT"), true, 99, null, null);
        registry.modifyStyleFont(FOLDED_BLOCK_HIGHLIGHT, 2);
        FoldingFader.registerHighlights();
        UNCOLLAPSED_VIEW = new CollapsedBlocks(null);
    }

    static void mav$rebuildFoldedBlocks(BasicView basicView) {
        basicView.rebuildFoldedBlocks();
    }

    static BaseStyle mav$lookupStyle(BasicView basicView, String string) {
        return basicView.lookupStyle(string);
    }

    static LineMap ra$_lineMap(BasicView basicView) {
        return basicView._lineMap;
    }

    static BasicEditorPane ra$_editor(BasicView basicView) {
        return basicView._editor;
    }

    static FontHelper ra$_fontHelper(BasicView basicView) {
        return basicView._fontHelper;
    }

    static int mav$getTabbedTextWidth(BasicView basicView, FontMetrics fontMetrics, int n, int n2, int n3) {
        return basicView.getTabbedTextWidth(fontMetrics, n, n2, n3);
    }

    static int mav$getXCoordinateForOffset(BasicView basicView, RenderFragmentGenerator renderFragmentGenerator, int n, int n2) {
        return basicView.getXCoordinateForOffset(renderFragmentGenerator, n, n2);
    }

    static HighlightFragmentsList mav$renderFontHighlights(BasicView basicView, int n, int n2) {
        return basicView.renderFontHighlights(n, n2);
    }

    static DocumentRenderer mav$getDocumentRenderer(BasicView basicView) {
        return basicView.getDocumentRenderer();
    }

    static void maS$freeHighlightFragmentsList(HighlightFragmentsList highlightFragmentsList) {
        BasicView.freeHighlightFragmentsList(highlightFragmentsList);
    }

    static int mav$getXCoordinateForOffset(BasicView basicView, int n, int n2) {
        return basicView.getXCoordinateForOffset(n, n2);
    }

    static CollapsedBlocks ra$UNCOLLAPSED_VIEW() {
        return UNCOLLAPSED_VIEW;
    }

    static CollapsedInfo[] ra$UNCOLLAPSED_VIEW_INFO() {
        return UNCOLLAPSED_VIEW_INFO;
    }

    static CodeFoldingModel ra$_foldingModel(BasicView basicView) {
        return basicView._foldingModel;
    }

    static HighlightStyle mav$lookupHighlight(BasicView basicView, String string) {
        return basicView.lookupHighlight(string);
    }

    private class FoldingListener
    implements CodeFoldingModelListener,
    CodeExpansionListener {
        public void structureChanged(CodeFoldingModelEvent event) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        public void codeExpanded(CodeExpansionEvent event) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        public void codeCollapsed(CodeExpansionEvent event) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        private FoldingListener() {
        }

        FoldingListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Rectangle v$visibleRect;
        final /* synthetic */ BasicView this$0;

        public void run() {
            BasicView.ra$_editor(this.this$0).scrollRectToVisible(this.v$visibleRect);
        }

        public 1(BasicView basicView, Rectangle rectangle) {
            this.v$visibleRect = rectangle;
            this.this$0 = basicView;
        }
    }

    protected static interface RenderFragmentGenerator {
        public RenderFragment current();

        public RenderFragment next();
    }

    protected class LineRenderFragmentGenerator
    implements RenderFragmentGenerator {
        private int _nextRenderOffset;
        private int _nextSyntaxIndex;
        private StyledFragment _syntaxFragment;
        private int _nextHighlightIndex;
        private HighlightFragment _highlightFragment;
        private StyledFragmentsList _syntaxFragmentsList;
        private HighlightFragmentsList _highlightFragmentsList;
        protected RenderFragment _currentFragment;

        public LineRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList) {
            this.$init$();
            this._syntaxFragmentsList = styledList;
            this._highlightFragmentsList = highlightList;
            if (this._syntaxFragmentsList == null || this._highlightFragmentsList == null || this._syntaxFragmentsList.size() == 0) {
                this._currentFragment = null;
                return;
            }
            this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
            this._nextRenderOffset = this._syntaxFragment.startOffset;
            if (this._nextHighlightIndex < this._highlightFragmentsList.size()) {
                this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
            }
            this.next();
        }

        public RenderFragment current() {
            return this._currentFragment;
        }

        public RenderFragment next() {
            if (this._currentFragment == null) {
                return null;
            }
            try {
                RenderFragment renderFragment = this.nextImpl();
                return renderFragment;
            }
            catch (IndexOutOfBoundsException e) {
                RenderFragment renderFragment = this._currentFragment = null;
                return renderFragment;
            }
        }

        /*
         * Unable to fully structure code
         */
        protected RenderFragment nextImpl() {
            if (this._syntaxFragment.endOffset <= this._nextRenderOffset) {
                this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
            }
            if (this._syntaxFragment.startOffset <= this._nextRenderOffset) ** GOTO lbl9
            throw new IllegalStateException("gap in style fragments");
lbl-1000:
            // 1 sources

            {
                this._highlightFragment = null;
                highlightFragmentsCount = this._highlightFragmentsList.size();
                if (this._nextHighlightIndex >= highlightFragmentsCount) break;
                this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
lbl9:
                // 2 sources

                ** while (this._highlightFragment == null || this._highlightFragment.endOffset <= this._nextRenderOffset)
            }
lbl10:
            // 2 sources

            processStart = Math.max(this._nextRenderOffset, this._syntaxFragment.startOffset);
            processEnd = this._syntaxFragment.endOffset;
            highlightFragmentToInclude = null;
            if (this._highlightFragment != null) {
                highlightStart = this._highlightFragment.startOffset;
                highlightEnd = this._highlightFragment.endOffset;
                if (processStart < highlightStart) {
                    processEnd = Math.min(processEnd, highlightStart);
                } else {
                    processEnd = Math.min(processEnd, highlightEnd);
                    highlightFragmentToInclude = this._highlightFragment;
                }
            }
            if ((syntaxStyle = BasicView.mav$lookupStyle(BasicView.this, syntaxStyleName = this._syntaxFragment.styleName)) == null) {
                throw new IllegalStateException("style not found: " + syntaxStyleName);
            }
            this._currentFragment.syntaxStyle = syntaxStyle;
            if (highlightFragmentToInclude != null) {
                this._currentFragment.backgroundHighlight = highlightFragmentToInclude.backgroundStyle;
                this._currentFragment.foregroundHighlight = highlightFragmentToInclude.foregroundStyle;
                this._currentFragment.fontHighlight = highlightFragmentToInclude.fontStyle;
            } else {
                this._currentFragment.backgroundHighlight = null;
                this._currentFragment.foregroundHighlight = null;
                this._currentFragment.fontHighlight = null;
            }
            this._currentFragment.startOffset = processStart;
            this._currentFragment.endOffset = processEnd;
            this._currentFragment.textToUse = null;
            this._nextRenderOffset = processEnd;
            return this._currentFragment;
        }

        private void $init$() {
            this._currentFragment = new RenderFragment();
        }
    }

    protected static class RenderFragment {
        public BaseStyle syntaxStyle;
        public HighlightStyle backgroundHighlight;
        public HighlightStyle foregroundHighlight;
        public String textToUse;
        public HighlightStyle fontHighlight;
        public int startOffset;
        public int endOffset;

        public Color getForegroundColor() {
            if (this.foregroundHighlight != null && this.foregroundHighlight.getUseForegroundColor()) {
                return this.foregroundHighlight.getForegroundColor();
            }
            return this.syntaxStyle.getForegroundColor();
        }

        public Color getBackgroundColor() {
            if (this.backgroundHighlight != null && this.backgroundHighlight.getUseBackgroundColor()) {
                return this.backgroundHighlight.getBackgroundColor();
            }
            return this.syntaxStyle.getBackgroundColor();
        }

        public int getFontStyle() {
            if (this.fontHighlight != null && this.fontHighlight.getUseFontStyle()) {
                return this.fontHighlight.getFontStyle();
            }
            return this.syntaxStyle.getFontStyle();
        }

        protected RenderFragment() {
        }
    }

    protected class LineRowMap
    implements RowMap {
        protected boolean _sameWidthFaces;
        protected int _rowCount;
        protected int _lineCount;
        protected int[] _rowWidths;
        protected int _maxWidth;
        protected int _maxWidthRow;

        private void $init$() {
            this._sameWidthFaces = true;
            this._rowCount = -1;
            this._lineCount = -1;
            this._rowWidths = null;
            this._maxWidth = -1;
            this._maxWidthRow = -1;
        }

        protected LineRowMap() {
            this.$init$();
            this.rebuildRowMap();
        }

        protected RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList) {
            return new LineRenderFragmentGenerator(styledList, highlightList);
        }

        protected void rebuildRowMap() {
            this.checkFontFaces();
            this._maxWidthRow = -1;
            this._maxWidth = -1;
            this._rowCount = 1;
            this._lineCount = 1;
            this.handleInsert(0);
        }

        protected void revalidateRowMap() {
            this.revalidateRows(0, this._rowCount);
        }

        protected void handleInsert(int offset) {
            int oldLineCount = this._lineCount;
            int newLineCount = BasicView.ra$_lineMap(BasicView.this).getLineCount();
            int linesAdded = newLineCount - oldLineCount;
            int startRow = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(offset);
            int numRows = 1;
            int startLine = startRow;
            int numLines = linesAdded + 1;
            this.recalculateRows(startRow, numRows, startLine, numLines);
            this._lineCount = newLineCount;
        }

        protected void handleRemove(int offset) {
            int oldLineCount = this._lineCount;
            int newLineCount = BasicView.ra$_lineMap(BasicView.this).getLineCount();
            int linesRemoved = newLineCount - oldLineCount;
            int startRow = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(offset);
            int numRows = 1 - linesRemoved;
            int startLine = startRow;
            int numLines = 1;
            this.recalculateRows(startRow, numRows, startLine, numLines);
            this._lineCount = newLineCount;
        }

        protected void invalidateMaxWidthRow(int startRow, int numRows) {
            if (this._maxWidthRow != -1) {
                int endRow = startRow + numRows;
                if (startRow <= this._maxWidthRow && this._maxWidthRow < endRow) {
                    this._maxWidthRow = -1;
                    this._maxWidth = -1;
                }
            }
        }

        protected void recalculateRows(int startRow, int numRows, int startLine, int numLines) {
            try {
                if (startRow != startLine) {
                    throw new IllegalStateException("non-matching row/line");
                }
                this.invalidateMaxWidthRow(startRow, numRows);
                int oldRowCount = this._rowCount;
                int linesChanged = numLines - numRows;
                int rowsToShift = 0;
                int rowSrc = 0;
                int rowDest = 0;
                if (this._rowWidths == null) {
                    this._rowWidths = new int[20];
                }
                int[] rowWidthsSrc = this._rowWidths;
                int[] rowWidthsDest = this._rowWidths;
                if (linesChanged < 0) {
                    int linesRemoved = -linesChanged;
                    rowDest = startRow + 1;
                    rowSrc = rowDest + linesRemoved;
                    rowsToShift = oldRowCount - rowSrc;
                } else if (linesChanged > 0) {
                    int requestedSize;
                    int linesAdded = linesChanged;
                    rowSrc = startRow + 1;
                    rowDest = rowSrc + linesAdded;
                    rowsToShift = oldRowCount - rowSrc;
                    int currentSize = this._rowWidths != null ? this._rowWidths.length : 0;
                    if (currentSize < (requestedSize = BasicView.ra$_lineMap(BasicView.this).getLineCount())) {
                        int increment = (int)((float)requestedSize * 0.1f);
                        increment = Math.min(500, increment);
                        increment = Math.max(25, increment);
                        rowWidthsDest = this._rowWidths = new int[requestedSize += increment];
                        if (rowWidthsSrc != null && startRow > 0) {
                            System.arraycopy(rowWidthsSrc, 0, rowWidthsDest, 0, startRow);
                        }
                    }
                }
                if (rowsToShift > 0) {
                    System.arraycopy(rowWidthsSrc, rowSrc, rowWidthsDest, rowDest, rowsToShift);
                }
                this._rowCount = BasicView.ra$_lineMap(BasicView.this).getLineCount();
                this.recalculateLineWidths(startRow, numLines);
                this.updateMaxRowWidth();
            }
            catch (RuntimeException e) {
                System.out.println("Exception occurred updating RowMap: " + e.getMessage());
                System.out.println("  startRow: " + startRow);
                System.out.println("  numRows: " + numRows);
                System.out.println("  startLine: " + startLine);
                System.out.println("  numLines: " + numLines);
                System.out.println("  _rowCount: " + this._rowCount);
                System.out.println("  lineCount: " + BasicView.ra$_lineMap(BasicView.this).getLineCount());
                System.out.println();
                System.out.println("Stack trace follows");
                e.printStackTrace(System.out);
                System.out.println();
                System.out.println("Forcing RowMap rebuild");
            }
        }

        protected void recalculateLineWidths(int startRow, int numRowsChanged) {
            if (this._sameWidthFaces) {
                FontMetrics biMetrics = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(3, (Component)BasicView.ra$_editor(BasicView.this));
                int rowCount = this._rowWidths.length;
                int endRow = startRow + numRowsChanged;
                if (rowCount < endRow) {
                    new RuntimeException(endRow + " > " + rowCount).printStackTrace();
                    endRow = rowCount;
                }
                int i = startRow;
                while (i < endRow) {
                    int width = this._rowWidths[i] = this.calculateLineWidth(biMetrics, i);
                    if (this._maxWidth != -1 && width > this._maxWidth) {
                        this._maxWidth = width;
                        this._maxWidthRow = i;
                    }
                    ++i;
                }
            } else {
                int LINE_CHUNK = 200;
                int recalcStartLine = startRow;
                int recalcEndLine = startRow + numRowsChanged;
                int recalcStartOffset = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(recalcStartLine);
                int recalcEndOffset = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(recalcEndLine - 1);
                HighlightFragmentsList fontHighlightList = BasicView.mav$renderFontHighlights(BasicView.this, recalcStartOffset, recalcEndOffset);
                int linesRemaining = numRowsChanged;
                int currentLine = startRow;
                DocumentRenderer documentRenderer = BasicView.mav$getDocumentRenderer(BasicView.this);
                while (linesRemaining > 0) {
                    int chunkSize = Math.min(linesRemaining, 200);
                    int chunkStartLine = currentLine;
                    int chunkEndLine = chunkStartLine + chunkSize - 1;
                    StyledFragmentsList fragmentsList = documentRenderer.renderLines(chunkStartLine, chunkEndLine);
                    LineRenderFragmentGenerator generator = new LineRenderFragmentGenerator(fragmentsList, fontHighlightList);
                    int i = chunkStartLine;
                    while (i <= chunkEndLine) {
                        int width = this._rowWidths[i] = this.calculateLineWidth(generator, i);
                        if (this._maxWidth != -1 && width > this._maxWidth) {
                            this._maxWidth = width;
                            this._maxWidthRow = i;
                        }
                        ++i;
                    }
                    if (fragmentsList != null) {
                        fragmentsList.clear();
                        documentRenderer.recycleFragmentsList(fragmentsList);
                    }
                    linesRemaining -= chunkSize;
                    currentLine += chunkSize;
                }
                BasicView.maS$freeHighlightFragmentsList(fontHighlightList);
            }
        }

        protected int calculateLineWidth(RenderFragmentGenerator generator, int line) {
            int lineStart = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(line);
            int lineEnd = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(line);
            int xEnd = BasicView.mav$getXCoordinateForOffset(BasicView.this, generator, lineStart, lineEnd);
            return xEnd;
        }

        protected int calculateLineWidth(FontMetrics metrics, int line) {
            int lineStart = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(line);
            int lineEnd = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(line);
            int width = BasicView.mav$getTabbedTextWidth(BasicView.this, metrics, lineStart, lineEnd, 0);
            return width;
        }

        protected void revalidateRows(int startRow, int numRows) {
            if (this._sameWidthFaces) {
                return;
            }
            this.invalidateMaxWidthRow(startRow, numRows);
            this.recalculateLineWidths(startRow, numRows);
            this.updateMaxRowWidth();
        }

        protected void updateMaxRowWidth() {
            if (this._maxWidth == -1) {
                int maxRow = -1;
                int maxWidth = -1;
                int i = 0;
                while (i < this._rowCount) {
                    int checkWidth = this._rowWidths[i];
                    if (checkWidth > maxWidth) {
                        maxWidth = checkWidth;
                        maxRow = i;
                    }
                    ++i;
                }
                this._maxWidth = maxWidth;
                this._maxWidthRow = maxRow;
            }
        }

        protected int getMaxRowWidth() {
            return this._maxWidth;
        }

        protected void checkFontFaces() {
            boolean checkFaces = BasicView.ra$_editor(BasicView.this).getBooleanProperty("check-same-width-faces");
            if (checkFaces) {
                FontMetrics plainMetrics = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(0, (Component)BasicView.ra$_editor(BasicView.this));
                FontMetrics biMetrics = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(3, (Component)BasicView.ra$_editor(BasicView.this));
                this._sameWidthFaces = plainMetrics.charWidth('i') == biMetrics.charWidth('i') && plainMetrics.charWidth('m') == biMetrics.charWidth('m') && plainMetrics.charWidth('w') == biMetrics.charWidth('w');
            } else {
                this._sameWidthFaces = false;
            }
        }

        private void notYetImplemented() {
            throw new IllegalStateException("implement me");
        }

        protected void documentChanged(DocumentEvent event) {
            int offset = event.getOffset();
            if (event.getType() == DocumentEvent.EventType.INSERT) {
                this.handleInsert(offset);
            } else if (event.getType() == DocumentEvent.EventType.REMOVE) {
                this.handleRemove(offset);
            }
        }

        protected boolean rowEndIsLineEnd(int row) {
            int lastRow = this.getRowCount() - 1;
            if (row == lastRow) {
                return true;
            }
            int rowEndOffset = this.getRowEndOffset(row);
            int lineForNextRow = this.getRowStartLine(row + 1);
            return rowEndOffset == BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(lineForNextRow);
        }

        public BasicEditorPane getEditorPane() {
            return BasicView.ra$_editor(BasicView.this);
        }

        public int getRowCount() {
            return BasicView.ra$_lineMap(BasicView.this).getLineCount();
        }

        public int getRowFromOffset(int offset) {
            return BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(offset);
        }

        public int getRowStartOffset(int row) {
            return BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(row);
        }

        public int getRowEndOffset(int row) {
            return BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(row);
        }

        public int getRowStartLine(int row) {
            return row;
        }
    }

    protected static class CollapsedInfo {
        protected int _row;
        protected int _line;
        protected int _span;
        protected int _width;

        protected CollapsedInfo() {
        }
    }

    protected class FoldedRowMap
    extends LineRowMap {
        protected CollapsedBlocks _collapsedBlocks;
        protected int _collapsedLines;
        protected int _maxFoldedWidth;
        protected CollapsedInfo[] _collapsedInfo;

        private void $init$() {
            this._collapsedBlocks = BasicView.ra$UNCOLLAPSED_VIEW();
            this._collapsedLines = 0;
            this._maxFoldedWidth = 0;
            this._collapsedInfo = BasicView.ra$UNCOLLAPSED_VIEW_INFO();
        }

        protected RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList) {
            return new FoldedRenderFragmentGenerator(styledList, highlightList, this._collapsedBlocks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void rebuildFoldedMap() {
            CollapsedBlocks collapsedBlocks = BasicView.ra$UNCOLLAPSED_VIEW();
            CollapsedInfo[] collapsedInfo = BasicView.ra$UNCOLLAPSED_VIEW_INFO();
            int collapsedLines = 0;
            if (BasicView.ra$_foldingModel(BasicView.this) != null) {
                try {
                    collapsedBlocks = new CollapsedBlocks(BasicView.ra$_foldingModel(BasicView.this));
                    collapsedInfo = this.rebuildCollapsedInfo(collapsedBlocks);
                    collapsedLines = this.getCollapsedLineCount(collapsedInfo);
                }
                catch (RuntimeException e) {
                    System.err.println("Failed to build folding model: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            FoldedRowMap foldedRowMap = this;
            synchronized (foldedRowMap) {
                this._collapsedBlocks = collapsedBlocks;
                this._collapsedInfo = collapsedInfo;
                this._collapsedLines = collapsedLines;
                this._maxFoldedWidth = this.recalculateFoldedWidths();
            }
        }

        protected void revalidateRowMap() {
            super.revalidateRowMap();
        }

        protected int recalculateFoldedWidths() {
            int lastRow = -1;
            int lastWidth = -1;
            int maxWidth = 0;
            int numInfo = this._collapsedInfo.length;
            int i = 0;
            while (i < numInfo) {
                CollapsedInfo info = this._collapsedInfo[i];
                int row = info._row;
                if (row == lastRow) {
                    info._width = lastWidth;
                } else {
                    int rowEnd = this.getRowEndOffset(row);
                    lastWidth = info._width = BasicView.mav$getXCoordinateForOffset(BasicView.this, row, rowEnd);
                    maxWidth = Math.max(maxWidth, lastWidth);
                    lastRow = row;
                }
                ++i;
            }
            return maxWidth;
        }

        protected CollapsedInfo[] rebuildCollapsedInfo(CollapsedBlocks collapsedBlocks) {
            int blockCount = collapsedBlocks._numBlocks;
            ArrayList<CollapsedInfo> infoList = new ArrayList<CollapsedInfo>(blockCount);
            int collapsedLineCount = 0;
            int i = 0;
            while (i < blockCount) {
                int blockStart = collapsedBlocks._blockStarts[i];
                int blockEnd = collapsedBlocks._blockEnds[i];
                int blockStartLine = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(blockStart);
                int blockEndLine = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(blockEnd);
                int span = blockEndLine - blockStartLine + 1;
                CollapsedInfo info = new CollapsedInfo();
                info._line = blockStartLine;
                info._width = -1;
                info._span = span;
                info._row = blockStartLine - collapsedLineCount;
                infoList.add(info);
                collapsedLineCount += span - 1;
                ++i;
            }
            CollapsedInfo[] collapsedInfo = infoList.toArray(new CollapsedInfo[infoList.size()]);
            return collapsedInfo;
        }

        protected int getCollapsedLineCount(CollapsedInfo[] collapsedInfo) {
            int blockCount = collapsedInfo.length;
            if (blockCount == 0) {
                return 0;
            }
            CollapsedInfo lastBlock = collapsedInfo[blockCount - 1];
            int collapsedLineCount = lastBlock._line - lastBlock._row + (lastBlock._span - 1);
            return collapsedLineCount;
        }

        protected int getMaxRowWidth() {
            int unfoldedMaxWidth = super.getMaxRowWidth();
            return Math.max(this._maxFoldedWidth, unfoldedMaxWidth);
        }

        protected synchronized int getRowForLine(int line) {
            int numInfo = this._collapsedInfo.length;
            int collapsedLines = 0;
            int i = 0;
            while (i < numInfo) {
                CollapsedInfo info = this._collapsedInfo[i];
                if (info._line >= line) break;
                collapsedLines = line < info._line + info._span ? (collapsedLines += line - info._line) : (collapsedLines += info._span - 1);
                ++i;
            }
            int row = line - collapsedLines;
            return row;
        }

        protected synchronized int getLineForRow(int row) {
            int numInfo = this._collapsedInfo.length;
            int collapsedLines = 0;
            int i = 0;
            while (i < numInfo) {
                CollapsedInfo info = this._collapsedInfo[i];
                if (info._row >= row) break;
                collapsedLines += info._span - 1;
                ++i;
            }
            int line = row + collapsedLines;
            return line;
        }

        public int getRowCount() {
            int rowCount = super.getRowCount();
            int foldedCount = rowCount - this._collapsedLines;
            return foldedCount;
        }

        public int getRowFromOffset(int offset) {
            int line = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(offset);
            int row = this.getRowForLine(line);
            return row;
        }

        public int getRowStartOffset(int row) {
            int line = this.getRowStartLine(row);
            int offset = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(line);
            return offset;
        }

        public int getRowEndOffset(int row) {
            int lastRow = this.getRowCount() - 1;
            if (row == lastRow) {
                int lastLine = BasicView.ra$_lineMap(BasicView.this).getLineCount() - 1;
                return BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(lastLine);
            }
            int line = this.getRowStartLine(row + 1);
            int offset = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(line);
            return offset;
        }

        public int getRowStartLine(int row) {
            return this.getLineForRow(row);
        }

        public synchronized boolean isLineCollapsed(int line) {
            int numInfo = this._collapsedInfo.length;
            int i = 0;
            while (i < numInfo) {
                CollapsedInfo info = this._collapsedInfo[i];
                if (line <= info._line) {
                    return false;
                }
                if (line < info._line + info._span) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public synchronized boolean isRangeCollapsed(int startOffset, int endOffset) {
            int startLine = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(startOffset);
            int endLine = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(endOffset);
            int numInfo = this._collapsedInfo.length;
            int i = 0;
            while (i < numInfo) {
                CollapsedInfo info = this._collapsedInfo[i];
                if (startLine <= info._line) {
                    return false;
                }
                int boundLine = info._line + info._span;
                if (startLine < boundLine) {
                    return endLine < boundLine;
                }
                ++i;
            }
            return false;
        }

        protected FoldedRowMap() {
            this.$init$();
        }
    }

    protected class FoldedRenderFragmentGenerator
    implements RenderFragmentGenerator {
        private RenderFragmentGenerator _generator;
        private CollapsedBlocks _blocks;
        private int _lastOffset;
        private int _currentBlock;
        private HighlightStyle _foldedStyle;
        protected RenderFragment _currentFragment;

        protected FoldedRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList, CollapsedBlocks collapsedBlocks) {
            this.$init$();
            this._generator = new LineRenderFragmentGenerator(styledList, highlightList);
            this._blocks = collapsedBlocks;
            this._foldedStyle = BasicView.mav$lookupHighlight(BasicView.this, BasicView.FOLDED_BLOCK_HIGHLIGHT);
            RenderFragment unfoldedFragment = this._generator.current();
            if (unfoldedFragment == null) {
                this._currentFragment = null;
                return;
            }
            this._lastOffset = unfoldedFragment.startOffset;
            this._currentBlock = 0;
            this.next();
        }

        public RenderFragment current() {
            return this._currentFragment;
        }

        public RenderFragment next() {
            if (this._currentFragment == null) {
                return null;
            }
            try {
                RenderFragment renderFragment = this.nextImpl();
                return renderFragment;
            }
            catch (IndexOutOfBoundsException e) {
                RenderFragment renderFragment = this._currentFragment = null;
                return renderFragment;
            }
        }

        protected RenderFragment nextImpl() {
            int blockStart = -1;
            int blockEnd = -1;
            String blockText = null;
            while (this._currentBlock < this._blocks._numBlocks) {
                blockStart = this._blocks._blockStarts[this._currentBlock];
                blockEnd = this._blocks._blockEnds[this._currentBlock];
                blockText = this._blocks._blockTexts[this._currentBlock];
                if (blockText == null) {
                    blockText = "<**ERROR in CodeFoldingModel: No replacement text for block**>";
                }
                if (blockEnd > this._lastOffset) break;
                ++this._currentBlock;
                blockEnd = -1;
                blockStart = -1;
                blockText = null;
            }
            RenderFragment unfoldedFragment = this._generator.current();
            while (unfoldedFragment != null && unfoldedFragment.endOffset <= this._lastOffset) {
                unfoldedFragment = this._generator.next();
            }
            if (unfoldedFragment == null) {
                this._currentFragment = null;
                return null;
            }
            int processStart = unfoldedFragment.startOffset;
            processStart = Math.max(processStart, this._lastOffset);
            int processEnd = unfoldedFragment.endOffset;
            if (blockStart == processStart) {
                BaseStyle style;
                this._currentFragment.syntaxStyle = style = BasicView.mav$lookupStyle(BasicView.this, "base-plain-style");
                this._currentFragment.startOffset = blockStart;
                this._currentFragment.endOffset = blockEnd;
                this._currentFragment.textToUse = blockText;
                this._currentFragment.backgroundHighlight = null;
                this._currentFragment.foregroundHighlight = null;
                this._currentFragment.fontHighlight = null;
                HighlightStyle backgroundToUse = unfoldedFragment.backgroundHighlight;
                HighlightStyle foregroundToUse = unfoldedFragment.foregroundHighlight;
                HighlightStyle fontHighlightToUse = unfoldedFragment.fontHighlight;
                while (unfoldedFragment.endOffset < blockEnd) {
                    unfoldedFragment = this._generator.next();
                    if (unfoldedFragment == null) break;
                    if (blockEnd <= unfoldedFragment.startOffset) continue;
                    if (unfoldedFragment.backgroundHighlight != backgroundToUse) {
                        backgroundToUse = null;
                    }
                    if (unfoldedFragment.foregroundHighlight != foregroundToUse) {
                        foregroundToUse = null;
                    }
                    if (unfoldedFragment.fontHighlight == fontHighlightToUse) continue;
                    fontHighlightToUse = null;
                }
                if (this._foldedStyle != null && this._foldedStyle.getEnabled()) {
                    if (this._foldedStyle.getUseBackgroundColor() && (backgroundToUse == null || backgroundToUse.getPriority() < this._foldedStyle.getPriority())) {
                        backgroundToUse = this._foldedStyle;
                    }
                    if (this._foldedStyle.getUseForegroundColor() && (foregroundToUse == null || foregroundToUse.getPriority() < this._foldedStyle.getPriority())) {
                        foregroundToUse = this._foldedStyle;
                    }
                    if (this._foldedStyle.getUseFontStyle() && (fontHighlightToUse == null || fontHighlightToUse.getPriority() < this._foldedStyle.getPriority())) {
                        fontHighlightToUse = this._foldedStyle;
                    }
                }
                this._currentFragment.backgroundHighlight = backgroundToUse;
                this._currentFragment.foregroundHighlight = foregroundToUse;
                this._currentFragment.fontHighlight = fontHighlightToUse;
                ++this._currentBlock;
                this._lastOffset = blockEnd;
                return this._currentFragment;
            }
            if (blockStart != -1 && this._lastOffset < blockStart) {
                processEnd = Math.min(processEnd, blockStart);
            }
            this._currentFragment.syntaxStyle = unfoldedFragment.syntaxStyle;
            this._currentFragment.startOffset = processStart;
            this._currentFragment.endOffset = processEnd;
            this._currentFragment.textToUse = null;
            this._currentFragment.backgroundHighlight = unfoldedFragment.backgroundHighlight;
            this._currentFragment.foregroundHighlight = unfoldedFragment.foregroundHighlight;
            this._currentFragment.fontHighlight = unfoldedFragment.fontHighlight;
            this._lastOffset = processEnd;
            return this._currentFragment;
        }

        private void $init$() {
            this._currentFragment = new RenderFragment();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BlockSorter
    implements Comparator {
        protected final int[] TEMP_SORT_OFFSETS;
        private CodeFoldingModel _model;

        private void $init$() {
            this.TEMP_SORT_OFFSETS = new int[2];
        }

        protected BlockSorter(CodeFoldingModel model) {
            this.$init$();
            this._model = model;
        }

        public int compare(Object obj1, Object obj2) {
            this._model.getTextOffsets(obj1, this.TEMP_SORT_OFFSETS);
            int start1 = this.TEMP_SORT_OFFSETS[0];
            int end1 = this.TEMP_SORT_OFFSETS[1];
            this._model.getTextOffsets(obj2, this.TEMP_SORT_OFFSETS);
            int start2 = this.TEMP_SORT_OFFSETS[0];
            int end2 = this.TEMP_SORT_OFFSETS[1];
            if (start1 <= start2 && start2 < end1 || start1 < end2 && end2 <= end1 || start2 <= start1 && start1 < end2 || start2 < end1 && end1 <= end2) {
                throw new IllegalStateException("nested or overlapping blocks,  s1 = " + start1 + " e1 = " + end1 + " s2 = " + start2 + " e2 = " + end2);
            }
            return start1 - start2;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BlockSorter && this._model == ((BlockSorter)obj)._model;
        }
    }

    protected static class CollapsedBlocks {
        protected int[] _blockStarts;
        protected int[] _blockEnds;
        protected String[] _blockTexts;
        protected Object[] _blocks;
        protected int _numBlocks;
        protected CodeFoldingModel _model;
        protected final int[] TEMP_OFFSETS;

        protected CollapsedBlocks(CodeFoldingModel model) {
            this.$init$();
            this._model = model;
            if (model != null) {
                this.buildList(model);
            }
        }

        private void $init$() {
            this.TEMP_OFFSETS = new int[2];
        }

        protected void buildList(CodeFoldingModel model) {
            model.readLock();
            try {
                Object[] collapsedBlocks = model.getCollapsedBlocks();
                Arrays.sort(collapsedBlocks, new BlockSorter(model));
                int count = collapsedBlocks.length;
                this.initializeCapacity(count);
                int i = 0;
                while (i < count) {
                    Object block = collapsedBlocks[i];
                    this.addBlock(model, block);
                    ++i;
                }
            }
            finally {
                model.readUnlock();
            }
        }

        protected void initializeCapacity(int capacity) {
            this._blockStarts = new int[capacity];
            this._blockEnds = new int[capacity];
            this._blockTexts = new String[capacity];
            this._blocks = new Object[capacity];
        }

        protected void ensureCapacity() {
            int neededCapacity = this._numBlocks + 1;
            int currentCapacity = this._blocks != null ? this._blocks.length : 0;
            if (neededCapacity > currentCapacity) {
                int increment = (int)((float)neededCapacity * 0.1f);
                increment = Math.min(500, increment);
                increment = Math.max(25, increment);
                int newCapacity = increment + neededCapacity;
                int[] newStarts = new int[newCapacity];
                int[] newEnds = new int[newCapacity];
                String[] newTexts = new String[newCapacity];
                Object[] newBlocks = new Object[newCapacity];
                if (this._numBlocks > 0) {
                    System.arraycopy(this._blockStarts, 0, newStarts, 0, this._numBlocks);
                    System.arraycopy(this._blockEnds, 0, newEnds, 0, this._numBlocks);
                    System.arraycopy(this._blockTexts, 0, newTexts, 0, this._numBlocks);
                    System.arraycopy(this._blocks, 0, newBlocks, 0, this._numBlocks);
                }
                this._blockStarts = newStarts;
                this._blockEnds = newEnds;
                this._blockTexts = newTexts;
                this._blocks = newBlocks;
            }
        }

        protected boolean insertUpdate(DocumentEvent event) {
            if (this._model == null) {
                return false;
            }
            int offset = event.getOffset();
            int length = event.getLength();
            this._model.readLock();
            try {
                int i = 0;
                while (i < this._numBlocks) {
                    if (offset <= this._blockStarts[i]) {
                        int n = i;
                        this._blockStarts[n] = this._blockStarts[n] + length;
                    }
                    if (offset < this._blockEnds[i]) {
                        int n = i;
                        this._blockEnds[n] = this._blockEnds[n] + length;
                    }
                    Object originalBlock = this._blocks[i];
                    boolean isExpanded = this._model.isExpanded(originalBlock);
                    this._model.getTextOffsets(originalBlock, this.TEMP_OFFSETS);
                    int startOffset = this.TEMP_OFFSETS[0];
                    int endOffset = this.TEMP_OFFSETS[1];
                    if (isExpanded || startOffset != this._blockStarts[i] || endOffset != this._blockEnds[i]) {
                        boolean bl = false;
                        return bl;
                    }
                    ++i;
                }
            }
            finally {
                this._model.readUnlock();
            }
            return true;
        }

        protected boolean removeUpdate(DocumentEvent event) {
            if (this._model == null) {
                return false;
            }
            int offset = event.getOffset();
            int length = event.getLength();
            int removeEnd = offset + length;
            this._model.readLock();
            try {
                int i = 0;
                while (i < this._numBlocks) {
                    if (this._blockStarts[i] >= removeEnd) {
                        int n = i;
                        this._blockStarts[n] = this._blockStarts[n] - length;
                    } else if (this._blockStarts[i] > offset) {
                        this._blockStarts[i] = offset;
                    }
                    if (this._blockEnds[i] >= removeEnd) {
                        int n = i;
                        this._blockEnds[n] = this._blockEnds[n] - length;
                    } else if (this._blockEnds[i] > offset) {
                        this._blockEnds[i] = offset;
                    }
                    Object originalBlock = this._blocks[i];
                    boolean isExpanded = this._model.isExpanded(originalBlock);
                    this._model.getTextOffsets(originalBlock, this.TEMP_OFFSETS);
                    int startOffset = this.TEMP_OFFSETS[0];
                    int endOffset = this.TEMP_OFFSETS[1];
                    if (isExpanded || startOffset != this._blockStarts[i] || endOffset != this._blockEnds[i]) {
                        boolean bl = false;
                        return bl;
                    }
                    ++i;
                }
            }
            finally {
                this._model.readUnlock();
            }
            return true;
        }

        protected void addBlock(CodeFoldingModel model, Object collapsedBlock) {
            this._model.getTextOffsets(collapsedBlock, this.TEMP_OFFSETS);
            int startOffset = this.TEMP_OFFSETS[0];
            int endOffset = this.TEMP_OFFSETS[1];
            if (startOffset == endOffset) {
                return;
            }
            this.ensureCapacity();
            this._blocks[this._numBlocks] = collapsedBlock;
            this._blockStarts[this._numBlocks] = startOffset;
            this._blockEnds[this._numBlocks] = endOffset;
            this._blockTexts[this._numBlocks] = model.getAbbreviatedText(collapsedBlock);
            ++this._numBlocks;
        }

        public boolean equals(Object object) {
            if (object instanceof CollapsedBlocks) {
                CollapsedBlocks blocks1 = this;
                int count1 = blocks1._numBlocks;
                CollapsedBlocks blocks2 = (CollapsedBlocks)object;
                int count2 = blocks2._numBlocks;
                if (count1 == count2 && this.equals(blocks1._blockStarts, blocks2._blockStarts, count1) && this.equals(blocks1._blockEnds, blocks2._blockEnds, count1) && this.equals(blocks1._blockTexts, blocks2._blockTexts, count1)) {
                    return true;
                }
            }
            return false;
        }

        protected boolean equals(int[] a1, int[] a2, int count) {
            int i = count - 1;
            while (i >= 0) {
                if (a1[i] != a2[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }

        protected boolean equals(String[] s1, String[] s2, int count) {
            int i = count - 1;
            while (i >= 0) {
                if (!s1[i].equals(s2[i])) {
                    return false;
                }
                --i;
            }
            return true;
        }
    }
}

