/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;

public final class FontHelper {
    private static final int FONT_TABLE_SLOTS = 4;
    private Font[] fontTable = new Font[4];
    private FontMetrics[] metricsTable = new FontMetrics[4];

    public FontHelper(String fontFamily, int fontSize) {
        this.setBaseFont(fontFamily, fontSize);
    }

    private void clearFonts() {
        int size = this.fontTable.length;
        int i = 0;
        while (i < size) {
            this.fontTable[i] = null;
            this.metricsTable[i] = null;
            ++i;
        }
    }

    public Font setBaseFont(String fontFamily, int fontSize) {
        Font baseFont;
        this.clearFonts();
        this.fontTable[0] = baseFont = new Font(fontFamily, 0, fontSize);
        return baseFont;
    }

    public Font getBaseFont() {
        return this.getFont(0);
    }

    public Font getFont(int fontStyle) {
        Font derivedFont = this.fontTable[fontStyle];
        if (derivedFont == null) {
            Font baseFont = this.fontTable[0];
            this.fontTable[fontStyle] = derivedFont = baseFont.deriveFont(fontStyle);
        }
        return derivedFont;
    }

    public FontMetrics getFontMetrics(Font font, Component component) {
        int fontStyle = font.getStyle();
        FontMetrics metrics = this.metricsTable[fontStyle];
        if (metrics == null) {
            this.metricsTable[fontStyle] = metrics = component.getFontMetrics(font);
        }
        return metrics;
    }

    public FontMetrics getFontMetrics(int fontStyle, Component component) {
        FontMetrics metrics = this.metricsTable[fontStyle];
        if (metrics == null) {
            Font font = this.getFont(fontStyle);
            this.metricsTable[fontStyle] = metrics = component.getFontMetrics(font);
        }
        return metrics;
    }
}

