/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.resource.BundleHelper;

public final class FoldingFader {
    private static final int TIMER_DELAY = 15;
    private static final int TIMER_INITIAL_DELAY = 150;
    public static final int EXPANSION_HIGHLIGHT_PRIORITY = 100;
    public static final String EXPANSION_HIGHLIGHT_NAME = "folding-fade-highlight";
    private int step;
    private static final int MAX_STEP = 20;
    private HighlightedText highLightedText;
    private HighlightLayer layer;
    private Timer timer;
    private BasicEditorPane editorPane;
    private Object block;
    private CodeFoldingModel model;
    private static boolean _rebuildRequired = false;
    private static HighlightStyle prevStyle;
    private static HashMap<Object, FoldingFader> faderCache;

    private void $init$() {
        this.step = 0;
    }

    public static void registerHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        registry.createStyle(EXPANSION_HIGHLIGHT_NAME, resources.getString("FOLDED_FADE_HIGHLIGHT"), true, 100, null, new Color(222, 222, 255));
    }

    private FoldingFader(CodeFoldingModel model, Object block, int[] offsets, BasicEditorPane editorPane) {
        this.$init$();
        try {
            this.model = model;
            this.block = block;
            this.editorPane = editorPane;
            this.layer = editorPane.createHighlightLayer();
            this.checkForStyleChange();
            HighlightStyle style = this.getFadeStyleForStep(this.step);
            this.highLightedText = this.layer.addHighlight(style, offsets[0], offsets[1]);
            this.timer = new Timer(15, new 1());
            this.timer.setRepeats(true);
            this.timer.setInitialDelay(150);
            this.timer.setCoalesce(false);
            this.timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForStyleChange() {
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle regStyle = highlightRegistry.lookupStyle(EXPANSION_HIGHLIGHT_NAME);
        if (prevStyle == null || !regStyle.equals(prevStyle)) {
            _rebuildRequired = true;
        }
        prevStyle = regStyle;
    }

    private HighlightStyle getFadeStyleForStep(int step) {
        String nameForHue;
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle style = highlightRegistry.lookupStyle(nameForHue = "folding-fade-highlight-" + step);
        if (style == null || _rebuildRequired) {
            Color bg;
            BaseStyle baseStyle = EditorProperties.getProperties().getStyleRegistry().lookupStyle("base-plain-style");
            HighlightStyle fadeStyle = highlightRegistry.lookupStyle(EXPANSION_HIGHLIGHT_NAME);
            float ratioComplete = (float)step / 20.0f;
            Color fg = fadeStyle.getForegroundColor() == null ? null : this._getIntermediateColor(fadeStyle.getForegroundColor(), baseStyle.getForegroundColor(), ratioComplete);
            Color color = bg = fadeStyle.getBackgroundColor() == null ? null : this._getIntermediateColor(fadeStyle.getBackgroundColor(), baseStyle.getBackgroundColor(), ratioComplete);
            if (style == null) {
                style = highlightRegistry.createTransientStyle(nameForHue, true, 100, fg, bg, fadeStyle.getFontStyle(), HighlightRegistry.lookupPredefinedPainter(fadeStyle.getUnderlinePainter()), fadeStyle.getUnderlineColor());
            } else {
                highlightRegistry.modifyStyle(nameForHue, true, 100, fg, bg, fadeStyle.getFontStyle(), HighlightRegistry.lookupPredefinedPainter(fadeStyle.getUnderlinePainter()), fadeStyle.getUnderlineColor());
            }
        }
        return style;
    }

    private Color _getIntermediateColor(Color start, Color end, float ratio) {
        int rDelta = (int)((float)(end.getRed() - start.getRed()) * ratio);
        int gDelta = (int)((float)(end.getGreen() - start.getGreen()) * ratio);
        int bDelta = (int)((float)(end.getBlue() - start.getBlue()) * ratio);
        Color c = new Color(start.getRed() + rDelta, start.getGreen() + gDelta, start.getBlue() + bDelta);
        return c;
    }

    private boolean isAnyParentFolded(Object block) {
        Object parent = this.model.getParent(block);
        if (parent == null) {
            return false;
        }
        if (!this.model.isExpanded(parent)) {
            return true;
        }
        return this.isAnyParentFolded(parent);
    }

    private void disposeFader() {
        this.timer.stop();
        faderCache.remove(this.block);
        this.layer.removeAllHighlights();
        this.editorPane.destroyHighlightLayer(this.layer);
        this.editorPane = null;
        this.layer = null;
        this.highLightedText = null;
        this.timer = null;
        this.model = null;
    }

    public static void fadeBlock(CodeFoldingModel model, Object block, int[] offsets, BasicEditorPane editorPane) {
        if (faderCache.containsKey(block)) {
            FoldingFader cachedFader = faderCache.get(block);
            cachedFader.disposeFader();
            faderCache.remove(block);
        }
        FoldingFader fader = new FoldingFader(model, block, offsets, editorPane);
        faderCache.put(block, fader);
    }

    static {
        faderCache = new HashMap();
    }

    static BasicEditorPane ra$editorPane(FoldingFader foldingFader) {
        return foldingFader.editorPane;
    }

    static Object ra$block(FoldingFader foldingFader) {
        return foldingFader.block;
    }

    static boolean mav$isAnyParentFolded(FoldingFader foldingFader, Object object) {
        return foldingFader.isAnyParentFolded(object);
    }

    static void mav$disposeFader(FoldingFader foldingFader) {
        foldingFader.disposeFader();
    }

    static int ra$step(FoldingFader foldingFader) {
        return foldingFader.step;
    }

    static HighlightStyle mav$getFadeStyleForStep(FoldingFader foldingFader, int n) {
        return foldingFader.getFadeStyleForStep(n);
    }

    static HighlightLayer ra$layer(FoldingFader foldingFader) {
        return foldingFader.layer;
    }

    static HighlightedText ra$highLightedText(FoldingFader foldingFader) {
        return foldingFader.highLightedText;
    }

    static void wa$step(FoldingFader foldingFader, int n) {
        foldingFader.step = n;
    }

    static void wa$_rebuildRequired(boolean bl) {
        _rebuildRequired = bl;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (!FoldingFader.ra$editorPane(FoldingFader.this).isShowing() || FoldingFader.mav$isAnyParentFolded(FoldingFader.this, FoldingFader.ra$block(FoldingFader.this))) {
                FoldingFader.mav$disposeFader(FoldingFader.this);
                return;
            }
            HighlightStyle style = FoldingFader.mav$getFadeStyleForStep(FoldingFader.this, FoldingFader.ra$step(FoldingFader.this));
            FoldingFader.ra$layer(FoldingFader.this).changeHighlight(FoldingFader.ra$highLightedText(FoldingFader.this), style);
            FoldingFader foldingFader = FoldingFader.this;
            FoldingFader.wa$step(foldingFader, FoldingFader.ra$step(foldingFader) + 1);
            if (FoldingFader.ra$step(FoldingFader.this) >= 20) {
                FoldingFader.mav$disposeFader(FoldingFader.this);
                FoldingFader.wa$_rebuildRequired(false);
            }
        }
    }
}

