/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;

public class HighlightFragmentsList {
    private static final int DEFAULT_LIST_SIZE = 32;
    private static final float DEFAULT_PADDING = 0.25f;
    private HighlightStyle[] _bgStyleArray = null;
    private HighlightStyle[] _fgStyleArray = null;
    private HighlightStyle[] _fontStyleArray = null;
    private HighlightStyle[] _underlineStyleArray = null;
    private int[] _startOffsetArray = null;
    private int[] _endOffsetArray = null;
    private int _numFragments = 0;
    private HighlightStyle _sentinelBackgroundStyle;
    private HighlightStyle _sentinelUnderlineStyle;
    private int _preferredSize = 32;
    private HighlightFragment _returnFragment = new HighlightFragment();
    private HighlightRegistry _registry = null;
    public static final int ATTRIBUTE_BACKGROUND = 1;
    public static final int ATTRIBUTE_FOREGROUND = 2;
    public static final int ATTRIBUTE_FONT = 4;
    public static final int ATTRIBUTE_UNDERLINE = 8;
    public static final int ATTRIBUTE_ALL = 15;
    private int _attributeFilter;
    public static final int TYPE_STRIKETHRU = 1;
    public static final int TYPE_UNDERLINE = 2;
    public static final int TYPE_SEPARATOR = 4;
    public static final int TYPE_ALL = 7;
    private int _underlineTypeFilter;

    public HighlightFragmentsList() {
        this.clearAllFilters();
        this.ensureCapacity(this._preferredSize);
    }

    public void setHighlightRegistry(HighlightRegistry registry) {
        this._registry = registry;
    }

    private HighlightStyle getRealStyle(HighlightStyle highlightStyle) {
        if (this._registry == null) {
            throw new IllegalStateException("cannot add style without registry");
        }
        String styleName = highlightStyle.getName();
        HighlightStyle realStyle = this._registry.lookupStyle(styleName);
        return realStyle;
    }

    public void addSentinel(HighlightStyle highlightStyle) {
        HighlightStyle realStyle = this.getRealStyle(highlightStyle);
        if (realStyle == null) {
            System.err.println("Could not find highlight: " + highlightStyle.getName());
            return;
        }
        if (realStyle.getEnabled() && this.filterAllowsBackground(realStyle) && (this._sentinelBackgroundStyle == null || realStyle.getPriority() > this._sentinelBackgroundStyle.getPriority())) {
            this._sentinelBackgroundStyle = realStyle;
        }
        if (realStyle.getEnabled() && this.filterAllowsUnderline(realStyle) && this.getTypeFilterAllows(realStyle) && (this._sentinelUnderlineStyle == null || realStyle.getPriority() > this._sentinelUnderlineStyle.getPriority())) {
            this._sentinelUnderlineStyle = realStyle;
        }
    }

    public HighlightStyle getSentinelBackground() {
        return this._sentinelBackgroundStyle;
    }

    public HighlightStyle getSentinelUnderline() {
        return this._sentinelUnderlineStyle;
    }

    private void ensureCapacity(int newSize) {
        int oldSize;
        int n = oldSize = this._bgStyleArray == null ? 0 : this._bgStyleArray.length;
        if (oldSize >= newSize) {
            return;
        }
        if (this._bgStyleArray != null) {
            int increment = (int)((float)newSize * 0.25f);
            newSize += increment;
        }
        HighlightStyle[] newBGStyleArray = new HighlightStyle[newSize];
        HighlightStyle[] newFGStyleArray = new HighlightStyle[newSize];
        HighlightStyle[] newFontStyleArray = new HighlightStyle[newSize];
        HighlightStyle[] newUnderlineStyleArray = new HighlightStyle[newSize];
        int[] newStartOffsetArray = new int[newSize];
        int[] newEndOffsetArray = new int[newSize];
        if (this._numFragments > 0) {
            System.arraycopy(this._bgStyleArray, 0, newBGStyleArray, 0, this._numFragments);
            System.arraycopy(this._fgStyleArray, 0, newFGStyleArray, 0, this._numFragments);
            System.arraycopy(this._fontStyleArray, 0, newFontStyleArray, 0, this._numFragments);
            System.arraycopy(this._underlineStyleArray, 0, newUnderlineStyleArray, 0, this._numFragments);
            System.arraycopy(this._startOffsetArray, 0, newStartOffsetArray, 0, this._numFragments);
            System.arraycopy(this._endOffsetArray, 0, newEndOffsetArray, 0, this._numFragments);
        }
        this._bgStyleArray = newBGStyleArray;
        this._fgStyleArray = newFGStyleArray;
        this._fontStyleArray = newFontStyleArray;
        this._underlineStyleArray = newUnderlineStyleArray;
        this._startOffsetArray = newStartOffsetArray;
        this._endOffsetArray = newEndOffsetArray;
    }

    private void shiftDownByOne(int index) {
        this.ensureCapacity(this._numFragments + 1);
        int oldPos = index;
        int newPos = index + 1;
        int numToShift = this._numFragments - index;
        System.arraycopy(this._bgStyleArray, oldPos, this._bgStyleArray, newPos, numToShift);
        System.arraycopy(this._fgStyleArray, oldPos, this._fgStyleArray, newPos, numToShift);
        System.arraycopy(this._fontStyleArray, oldPos, this._fontStyleArray, newPos, numToShift);
        System.arraycopy(this._underlineStyleArray, oldPos, this._underlineStyleArray, newPos, numToShift);
        System.arraycopy(this._startOffsetArray, oldPos, this._startOffsetArray, newPos, numToShift);
        System.arraycopy(this._endOffsetArray, oldPos, this._endOffsetArray, newPos, numToShift);
    }

    private void merge(int index) {
        int endOffset = this._endOffsetArray[index + 1];
        int srcPos = index + 1;
        int destPos = index;
        int numToShift = this._numFragments - (index + 1);
        System.arraycopy(this._bgStyleArray, srcPos, this._bgStyleArray, destPos, numToShift);
        System.arraycopy(this._fgStyleArray, srcPos, this._fgStyleArray, destPos, numToShift);
        System.arraycopy(this._fontStyleArray, srcPos, this._fontStyleArray, destPos, numToShift);
        System.arraycopy(this._underlineStyleArray, srcPos, this._underlineStyleArray, destPos, numToShift);
        System.arraycopy(this._startOffsetArray, srcPos, this._startOffsetArray, destPos, numToShift);
        System.arraycopy(this._endOffsetArray, srcPos, this._endOffsetArray, destPos, numToShift);
        this._endOffsetArray[index] = endOffset;
        --this._numFragments;
    }

    private void split(int index, int middleOffset) {
        if (middleOffset <= this._startOffsetArray[index] || this._endOffsetArray[index] <= middleOffset) {
            throw new IllegalStateException("illegal split");
        }
        this.shiftDownByOne(index);
        ++this._numFragments;
        int n = middleOffset;
        this._startOffsetArray[index + 1] = n;
        this._endOffsetArray[index] = n;
    }

    private void store(int index, HighlightStyle style, int startOffset, int endOffset) {
        this._bgStyleArray[index] = this.filterAllowsBackground(style) ? style : null;
        this._fgStyleArray[index] = this.filterAllowsForeground(style) ? style : null;
        this._fontStyleArray[index] = this.filterAllowsFont(style) ? style : null;
        this._underlineStyleArray[index] = this.filterAllowsUnderline(style) ? style : null;
        this._startOffsetArray[index] = startOffset;
        this._endOffsetArray[index] = endOffset;
    }

    private void update(int index, HighlightStyle style) {
        HighlightStyle newBgStyle = this.filterAllowsBackground(style) ? style : null;
        HighlightStyle newFgStyle = this.filterAllowsForeground(style) ? style : null;
        HighlightStyle newFontStyle = this.filterAllowsFont(style) ? style : null;
        HighlightStyle newUnderlineStyle = this.filterAllowsUnderline(style) ? style : null;
        this._bgStyleArray[index] = this.select(this._bgStyleArray[index], newBgStyle);
        this._fgStyleArray[index] = this.select(this._fgStyleArray[index], newFgStyle);
        this._fontStyleArray[index] = this.select(this._fontStyleArray[index], newFontStyle);
        this._underlineStyleArray[index] = this.select(this._underlineStyleArray[index], newUnderlineStyle);
    }

    private HighlightStyle select(HighlightStyle first, HighlightStyle second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return second.getPriority() > first.getPriority() ? second : first;
    }

    public void compact() {
        int i = 0;
        while (i < this._numFragments - 1) {
            if (this._endOffsetArray[i] == this._startOffsetArray[i + 1] && this._bgStyleArray[i] == this._bgStyleArray[i + 1] && this._fgStyleArray[i] == this._fgStyleArray[i + 1] && this._fontStyleArray[i] == this._fontStyleArray[i + 1] && this._underlineStyleArray[i] == this._underlineStyleArray[i + 1]) {
                this.merge(i);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void add(HighlightStyle highlightStyle, int startOffset, int endOffset) {
        realStyle = this.getRealStyle(highlightStyle);
        if (realStyle == null) {
            System.err.println("Could not find highlight: " + highlightStyle.getName());
            return;
        }
        if (!realStyle.getEnabled()) {
            return;
        }
        if (this.isAttributeFilterSet() && !this.getAttributeFilterAllows(highlightStyle)) {
            return;
        }
        if (this.isUnderlineTypeFilterSet() && !this.getTypeFilterAllows(highlightStyle)) {
            return;
        }
        index = 0;
        ** GOTO lbl44
        {
            ++index;
            do {
                if (index < this._numFragments && startOffset >= this._endOffsetArray[index]) continue block0;
                if (index == this._numFragments) {
                    this.ensureCapacity(this._numFragments + 1);
                    ++this._numFragments;
                    this.store(index, realStyle, startOffset, endOffset);
                    return;
                }
                if (endOffset <= this._startOffsetArray[index]) {
                    this.shiftDownByOne(index);
                    ++this._numFragments;
                    this.store(index, realStyle, startOffset, endOffset);
                    return;
                }
                existingStart = this._startOffsetArray[index];
                existingEnd = this._endOffsetArray[index];
                if (existingStart < startOffset) {
                    this.split(index, startOffset);
                    ++index;
                    existingStart = startOffset;
                } else if (existingStart > startOffset) {
                    this.shiftDownByOne(index);
                    ++this._numFragments;
                    this.store(index, realStyle, startOffset, existingStart);
                    ++index;
                    startOffset = existingStart;
                }
                if (existingEnd > endOffset) {
                    this.split(index, endOffset);
                    existingEnd = endOffset;
                }
                this.update(index, realStyle);
                startOffset = existingEnd;
lbl44:
                // 2 sources

            } while (endOffset > startOffset);
        }
    }

    public void clear() {
        this.clearAllFilters();
        int i = 0;
        while (i < this._numFragments) {
            this._underlineStyleArray[i] = null;
            this._fontStyleArray[i] = null;
            this._fgStyleArray[i] = null;
            this._bgStyleArray[i] = null;
            this._endOffsetArray[i] = -1;
            this._startOffsetArray[i] = -1;
            ++i;
        }
        this._sentinelBackgroundStyle = null;
        this._sentinelUnderlineStyle = null;
        this._numFragments = 0;
        this._returnFragment.backgroundStyle = null;
        this._returnFragment.foregroundStyle = null;
        this._returnFragment.fontStyle = null;
        this._returnFragment.underlineStyle = null;
        this._returnFragment.startOffset = -1;
        this._returnFragment.endOffset = -1;
    }

    public int size() {
        return this._numFragments;
    }

    public HighlightFragment get(int index) {
        if (index < 0 || index >= this._numFragments) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        this._returnFragment.backgroundStyle = this._bgStyleArray[index];
        this._returnFragment.foregroundStyle = this._fgStyleArray[index];
        this._returnFragment.fontStyle = this._fontStyleArray[index];
        this._returnFragment.underlineStyle = this._underlineStyleArray[index];
        this._returnFragment.startOffset = this._startOffsetArray[index];
        this._returnFragment.endOffset = this._endOffsetArray[index];
        return this._returnFragment;
    }

    public void clearAllFilters() {
        this.clearAttributeFilter();
        this.clearUnderlineTypeFilter();
    }

    public void clearAttributeFilter() {
        this.setAttributeFilter(15);
    }

    private boolean isAttributeFilterSet() {
        return Utilities.testBit(this._attributeFilter, 15) ^ true;
    }

    public void setAttributeFilter(int attributeFilter) {
        this._attributeFilter = attributeFilter;
    }

    public void setAttributeTextOnly() {
        int filter = 7;
        this.setAttributeFilter(filter);
    }

    public void setAttributeFontOnly() {
        this.setAttributeFilter(4);
    }

    public void setAttributeUnderlineOnly() {
        this.setAttributeFilter(8);
    }

    private boolean getAttributeFilterAllows(HighlightStyle highlightStyle) {
        return this.filterAllowsBackground(highlightStyle) || this.filterAllowsForeground(highlightStyle) || this.filterAllowsFont(highlightStyle) || this.filterAllowsUnderline(highlightStyle);
    }

    private boolean filterAllowsBackground(HighlightStyle highlightStyle) {
        boolean acceptBackground = Utilities.testBit(this._attributeFilter, 1);
        return highlightStyle.getUseBackgroundColor() && acceptBackground;
    }

    private boolean filterAllowsForeground(HighlightStyle highlightStyle) {
        boolean acceptForeground = Utilities.testBit(this._attributeFilter, 2);
        return highlightStyle.getUseForegroundColor() && acceptForeground;
    }

    private boolean filterAllowsFont(HighlightStyle highlightStyle) {
        boolean acceptFont = Utilities.testBit(this._attributeFilter, 4);
        return highlightStyle.getUseFontStyle() && acceptFont;
    }

    private boolean filterAllowsUnderline(HighlightStyle highlightStyle) {
        boolean acceptUnderline = Utilities.testBit(this._attributeFilter, 8);
        return highlightStyle.getUseUnderline() && acceptUnderline;
    }

    public void clearUnderlineTypeFilter() {
        this.setUnderlineTypeFilter(7);
    }

    private boolean isUnderlineTypeFilterSet() {
        return Utilities.testBit(this._underlineTypeFilter, 7) ^ true;
    }

    public void setUnderlineTypeFilter(int underlineTypeFilter) {
        this._underlineTypeFilter = underlineTypeFilter;
    }

    private boolean getTypeFilterAllows(HighlightStyle highlightStyle) {
        return this.typeAllowsStrikethru(highlightStyle) || this.typeAllowsUnderline(highlightStyle) || this.typeAllowsSeparator(highlightStyle);
    }

    private boolean typeAllowsStrikethru(HighlightStyle highlightStyle) {
        boolean acceptStrikethru = Utilities.testBit(this._underlineTypeFilter, 1);
        return acceptStrikethru && this.hasUnderlineType(highlightStyle, 0);
    }

    private boolean typeAllowsUnderline(HighlightStyle highlightStyle) {
        boolean acceptUnderline = Utilities.testBit(this._underlineTypeFilter, 2);
        return acceptUnderline && this.hasUnderlineType(highlightStyle, 1);
    }

    private boolean typeAllowsSeparator(HighlightStyle highlightStyle) {
        boolean acceptSeparator = Utilities.testBit(this._underlineTypeFilter, 4);
        return acceptSeparator && this.hasUnderlineType(highlightStyle, 2);
    }

    private boolean hasUnderlineType(HighlightStyle highlightStyle, int underlineType) {
        if (highlightStyle.getUseUnderline()) {
            UnderlinePainter painter = highlightStyle.getUnderlinePainter();
            return painter.getUnderlineType() == underlineType;
        }
        return false;
    }
}

