/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.highlight.DottedLinePainter;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.SimpleLinePainter;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.highlight.ZigZagLinePainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HighlightRegistry {
    public static final int SINGLE_UNDERLINE = 0;
    public static final int DOUBLE_UNDERLINE = 1;
    public static final int SINGLE_DOTTED_UNDERLINE = 2;
    public static final int DOUBLE_DOTTED_UNDERLINE = 3;
    public static final int ZIGZAG_UNDERLINE = 4;
    public static final int SINGLE_SEPARATOR = 5;
    public static final int DOUBLE_SEPARATOR = 6;
    public static final int SINGLE_DOTTED_SEPARATOR = 7;
    public static final int DOUBLE_DOTTED_SEPARATOR = 8;
    public static final int PERFORATED_SEPARATOR = 9;
    public static final int SINGLE_STRIKETHRU = 10;
    public static final int DOUBLE_STRIKETHRU = 11;
    private static final UnderlinePainter[] PREDEFINED_PAINTERS = new UnderlinePainter[]{new SimpleLinePainter(1, 1), new SimpleLinePainter(2, 1), new DottedLinePainter(1, 1, 3, 3), new DottedLinePainter(2, 1, 3, 3), new ZigZagLinePainter(3, 1), new SimpleLinePainter(1, 2), new SimpleLinePainter(2, 2), new DottedLinePainter(1, 2, 4, 4), new DottedLinePainter(2, 2, 4, 4), new DottedLinePainter(1, 2, 1, 2), new SimpleLinePainter(1, 0), new SimpleLinePainter(2, 0)};
    private transient WeakPropertyChangeSupport changeSupport;
    public static final String PROPERTY_HIGHLIGHT_CHANGED = "highlight-changed";
    private HashMap<String, HighlightStyle> _registryMap = new HashMap(30);
    private ArrayList<HighlightStyle> _registryList = new ArrayList(30);
    private ArrayList<HighlightStyle> _pendingList = new ArrayList();

    public HighlightRegistry() {
        this.changeSupport = new WeakPropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    private void fireStyleChangedEvent() {
        this.changeSupport.firePropertyChange(PROPERTY_HIGHLIGHT_CHANGED, Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized Iterator<HighlightStyle> getStyleIterator() {
        ArrayList<HighlightStyle> listCopy = new ArrayList<HighlightStyle>();
        listCopy.addAll(this._registryList);
        listCopy.addAll(this._pendingList);
        int i = listCopy.size() - 1;
        while (i >= 0) {
            if (((HighlightStyle)listCopy.get(i)).isTransient()) {
                listCopy.remove(i);
            }
            --i;
        }
        return listCopy.iterator();
    }

    public synchronized Object clone() {
        HighlightRegistry registryCopy = new HighlightRegistry();
        for (HighlightStyle style : this._registryList) {
            registryCopy.createStyle(style.getName(), style.getPresentationName(), style.getEnabled(), style.getPriority(), style.getForegroundColor(), style.getBackgroundColor(), style.getFontStyle(), style.getUnderlinePainter(), style.getUnderlineColor(), style.isTransient());
        }
        for (HighlightStyle style : this._pendingList) {
            if (style.isTransient()) continue;
            registryCopy.modifyStyle(style.getName(), style.getEnabled(), style.getPriority(), style.getForegroundColor(), style.getBackgroundColor(), style.getFontStyle(), style.getUnderlinePainter(), style.getUnderlineColor());
        }
        return registryCopy;
    }

    private void addStyle(HighlightStyle style) {
        this._registryMap.put(style.getName(), style);
        this._registryList.add(style);
        HighlightStyle pendingStyle = this.lookupPendingStyle(style.getName());
        if (pendingStyle != null) {
            int index = this._pendingList.indexOf(pendingStyle);
            this._pendingList.remove(index);
            this.modifyStyle(style, pendingStyle.getEnabled(), pendingStyle.getPriority(), pendingStyle.getForegroundColor(), pendingStyle.getBackgroundColor(), pendingStyle.getFontStyle(), pendingStyle.getUnderlinePainter(), pendingStyle.getUnderlineColor());
        }
    }

    public synchronized HighlightStyle createStyle(String styleName, String presentationName, int priority, Color fgColor, Color bgColor) {
        return this.createStyle(styleName, presentationName, true, priority, fgColor, bgColor);
    }

    public synchronized HighlightStyle createStyle(String styleName, String presentationName, boolean enabled, int priority, Color fgColor, Color bgColor) {
        return this.createStyle(styleName, presentationName, enabled, priority, fgColor, bgColor, 0, -1, null);
    }

    public synchronized HighlightStyle createStyle(String styleName, String presentationName, boolean enabled, int priority, int underlinePredefinedPainter, Color underlineColor) {
        return this.createStyle(styleName, presentationName, enabled, priority, null, null, 0, underlinePredefinedPainter, underlineColor);
    }

    public synchronized HighlightStyle createStyle(String styleName, String presentationName, boolean enabled, int priority, int fontStyle) {
        return this.createStyle(styleName, presentationName, enabled, priority, null, null, fontStyle, -1, null);
    }

    public synchronized HighlightStyle createStyle(String styleName, String presentationName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, int underlinePredefinedPainter, Color underlineColor) {
        UnderlinePainter painter = this.lookupPainter(underlinePredefinedPainter);
        return this.createStyle(styleName, presentationName, enabled, priority, fgColor, bgColor, fontStyle &= 3, painter, underlineColor, false);
    }

    private UnderlinePainter lookupPainter(int shapeIndex) {
        if (shapeIndex < 0 || shapeIndex >= PREDEFINED_PAINTERS.length) {
            return null;
        }
        return PREDEFINED_PAINTERS[shapeIndex];
    }

    public static int lookupPredefinedPainter(UnderlinePainter painter) {
        int painterCount = PREDEFINED_PAINTERS.length;
        int i = 0;
        while (i < painterCount) {
            if (painter == PREDEFINED_PAINTERS[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized HighlightStyle createTransientStyle(String styleName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, int underlinePredefinedPainter, Color underlineColor) {
        UnderlinePainter painter = this.lookupPainter(underlinePredefinedPainter);
        return this.createStyle(styleName, null, enabled, priority, fgColor, bgColor, fontStyle &= 3, painter, underlineColor, true);
    }

    private synchronized HighlightStyle createStyle(String styleName, String presentationName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, UnderlinePainter painter, Color underlineColor, boolean isTransient) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style == null) {
            style = new HighlightStyle(styleName, presentationName, enabled, priority, fgColor, bgColor, fontStyle, painter, underlineColor, isTransient);
            this.addStyle(style);
        }
        return style;
    }

    public synchronized HighlightStyle lookupStyle(String styleName) {
        HighlightStyle style = this._registryMap.get(styleName);
        return style;
    }

    private HighlightStyle lookupPendingStyle(String styleName) {
        int numPending = this._pendingList.size();
        int i = 0;
        while (i < numPending) {
            HighlightStyle pendingStyle = this._pendingList.get(i);
            if (pendingStyle.getName().equals(styleName)) {
                return pendingStyle;
            }
            ++i;
        }
        return null;
    }

    public synchronized void modifyStyleEnabled(String styleName, boolean enabled) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setEnabled(enabled);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStylePriority(String styleName, int priority) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setPriority(priority);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleForeground(String styleName, Color fgColor) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setForegroundColor(fgColor);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleBackground(String styleName, Color bgColor) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setBackgroundColor(bgColor);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleFont(String styleName, int fontStyle) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setFontStyle(fontStyle);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleUnderline(String styleName, int underlinePredefinedPainter, Color underlineColor) {
        UnderlinePainter painter = this.lookupPainter(underlinePredefinedPainter);
        this.modifyStyleUnderline(styleName, painter, underlineColor);
    }

    public synchronized void modifyStyleUnderline(String styleName, UnderlinePainter underlinePainter, Color underlineColor) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setUnderlinePainter(underlinePainter);
            style.setUnderlineColor(underlineColor);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyle(String styleName, boolean enabled, int priority, boolean useFG, Color fgColor, boolean useBG, Color bgColor) {
        Color fgColorToUse = useFG ? fgColor : null;
        Color bgColorToUse = useBG ? bgColor : null;
        this.modifyStyle(styleName, enabled, priority, fgColorToUse, bgColorToUse, 0, -1, null);
    }

    public synchronized void modifyStyle(String styleName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, int underlinePredefinedPainter, Color underlineColor) {
        UnderlinePainter underlinePainter = this.lookupPainter(underlinePredefinedPainter);
        this.modifyStyle(styleName, enabled, priority, fgColor, bgColor, fontStyle, underlinePainter, underlineColor);
    }

    private synchronized void modifyStyle(String styleName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, UnderlinePainter underlinePainter, Color underlineColor) {
        HighlightStyle style = this.lookupStyle(styleName);
        if (style != null) {
            this.modifyStyle(style, enabled, priority, fgColor, bgColor, fontStyle, underlinePainter, underlineColor);
            this.fireStyleChangedEvent();
        } else {
            HighlightStyle pendingStyle = this.lookupPendingStyle(styleName);
            if (pendingStyle != null) {
                this.modifyStyle(pendingStyle, enabled, priority, fgColor, bgColor, fontStyle, underlinePainter, underlineColor);
            } else {
                pendingStyle = new HighlightStyle(styleName, "<" + styleName + ">", enabled, priority, fgColor, bgColor, fontStyle, underlinePainter, underlineColor, false);
                this._pendingList.add(pendingStyle);
            }
        }
    }

    private void modifyStyle(HighlightStyle style, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, UnderlinePainter underlinePainter, Color underlineColor) {
        if (style != null) {
            style.setEnabled(enabled);
            style.setPriority(priority);
            style.setForegroundColor(fgColor);
            style.setBackgroundColor(bgColor);
            style.setFontStyle(fontStyle);
            style.setUnderlinePainter(underlinePainter);
            style.setUnderlineColor(underlineColor);
        }
    }
}

